/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.core;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.mlwidgets.MatlabHyperlinkHandler;
import com.mathworks.mlwidgets.dialog.filters.MatlabProductFileExtensionFilter;
import com.mathworks.mlwidgets.explorer.model.MatlabPathModel;
import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.impl.util.StringUtils;
import com.mathworks.toolbox.coder.app.HintPopupFrame;
import com.mathworks.toolbox.coder.model.BuildErrorSeverity;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.core.CommandHistoryModel;
import com.mathworks.toolbox.coder.wfa.core.ListEntryButton;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.ReturnRunnable;
import com.mathworks.widgets.BusyAffordance;
import com.mathworks.widgets.ButtonFactory;
import com.mathworks.widgets.HyperlinkTextLabel;
import com.mathworks.widgets.SyntaxTextPane;
import com.mathworks.widgets.text.mcode.MKit;
import com.mathworks.widgets.text.mcode.MLanguage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;

public abstract class CustomCommandWindow {
    private static final int CARET_WIDTH = CustomCommandWindow.determineCaretWidth();
    private final JComponent fMainComponent;
    private final JComponent fComponent;
    private final JComponent fPromptArea;
    private final JComponent fPromptLabel;
    private final JScrollPane fScrollPane;
    private final SyntaxTextPane fTextPane;
    private final BusyAffordance fBusyAffordance;
    private final DropDownButton fDropDownButton;
    private final CommandHistoryModel fHistory;
    private final MulticastChangeListener fChangeListeners;
    private MJPopupMenu fCurrentPopup;
    private HintPopupFrame fErrorPopup;
    private boolean fUseBusyAffordance;
    private static final int ARROW_WIDTH = 9;
    private static final int ARROW_HEIGHT = 6;

    public CustomCommandWindow(CommandHistoryModel commandHistoryModel) {
        this.fHistory = commandHistoryModel;
        this.fUseBusyAffordance = true;
        this.fChangeListeners = new MulticastChangeListener();
        this.fPromptArea = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        this.fPromptArea.setOpaque(false);
        this.fPromptLabel = new MJLabel(">>");
        this.fPromptArea.add(this.fPromptLabel);
        this.fBusyAffordance = new BusyAffordance(BusyAffordance.AffordanceSize.SIZE_16x16);
        this.fDropDownButton = new DropDownButton();
        this.fDropDownButton.setName("command.window.dropdown.button");
        this.fComponent = new MJPanel((LayoutManager)new BorderLayout(3, 0));
        this.fComponent.setOpaque(false);
        this.fMainComponent = new MJPanel(){

            public void requestFocus() {
                CustomCommandWindow.this.fTextPane.requestFocus();
            }

            public Dimension getPreferredSize() {
                Dimension dimension = CustomCommandWindow.this.fPromptArea.getPreferredSize();
                Dimension dimension2 = CustomCommandWindow.this.fTextPane.getPreferredSize();
                Insets insets = this.getBorder().getBorderInsets((Component)((Object)this));
                return new Dimension(insets.left + insets.right + dimension.width + 3 + dimension2.width, insets.top + insets.bottom + Math.max(dimension.height, dimension2.height));
            }

            public void doLayout() {
                super.doLayout();
                Dimension dimension = CustomCommandWindow.this.fPromptArea.getPreferredSize();
                Dimension dimension2 = CustomCommandWindow.this.fDropDownButton.getPreferredSize();
                int n = 3;
                if (!((Object)((Object)this)).equals(CustomCommandWindow.this.fDropDownButton.getParent())) {
                    dimension2.width = 0;
                    n = 0;
                }
                Insets insets = this.getBorder().getBorderInsets((Component)((Object)this));
                CustomCommandWindow.this.fPromptArea.setBounds(insets.left, insets.top, dimension.width, this.getHeight() - insets.top - insets.bottom);
                CustomCommandWindow.this.fScrollPane.setBounds(dimension.width + 3 + insets.left, insets.top, this.getWidth() - dimension.width - 3 - dimension2.width - n - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
                if (((Object)((Object)this)).equals(CustomCommandWindow.this.fDropDownButton.getParent())) {
                    if (CustomCommandWindow.this.fDropDownButton.isEnabled()) {
                        CustomCommandWindow.this.fDropDownButton.setBounds(CustomCommandWindow.this.fTextPane.getX() + CustomCommandWindow.this.fTextPane.getWidth() + 3, insets.top, dimension2.width, this.getHeight() - insets.top - insets.bottom);
                    } else {
                        CustomCommandWindow.this.fDropDownButton.setBounds(0, 0, 0, 0);
                    }
                }
            }
        };
        this.fMainComponent.setLayout(null);
        this.fMainComponent.setBorder(new LineBorder(new Color(180, 180, 180)));
        this.fMainComponent.add(this.fPromptArea);
        this.fMainComponent.add((Component)((Object)this.fDropDownButton));
        this.updateDropdownButton();
        this.fHistory.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CustomCommandWindow.this.updateDropdownButton();
            }
        });
        ListEntryButton listEntryButton = new ListEntryButton(ListEntryButton.ButtonType.BROWSE);
        listEntryButton.setToolTipText(CoderResources.getString("wfa.browseForScript.tooltip"));
        listEntryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomCommandWindow.this.doBrowse();
            }
        });
        ListEntryButton listEntryButton2 = new ListEntryButton(ListEntryButton.ButtonType.RUN);
        listEntryButton2.setToolTipText(CoderResources.getString("action.testbench.Run"));
        listEntryButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomCommandWindow.this.run();
            }
        });
        CellConstraints cellConstraints = new CellConstraints();
        this.fComponent.setLayout((LayoutManager)new FormLayout(PlatformInfo.isMacintosh() ? "fill:d:grow, 3dlu, fill:d" : "fill:d:grow, 3dlu, fill:d, 3dlu, fill:d", PlatformInfo.isMacintosh() ? "4px, fill:d, 3px" : "0px, fill:d, 0px"));
        this.fComponent.add((Component)this.fMainComponent, cellConstraints.xy(1, 2));
        if (PlatformInfo.isMacintosh()) {
            this.fComponent.add((Component)ButtonFactory.makeComponentUtilityButtonGroup((AbstractButton[])new AbstractButton[]{listEntryButton, listEntryButton2}), cellConstraints.xywh(3, 1, 1, 3));
        } else {
            this.fComponent.add((Component)((Object)listEntryButton), cellConstraints.xy(3, 2));
            this.fComponent.add((Component)((Object)listEntryButton2), cellConstraints.xy(5, 2));
        }
        this.fTextPane = new SyntaxTextPane(){

            public void processKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && keyEvent.getID() == 401) {
                    CustomCommandWindow.this.run();
                    keyEvent.consume();
                } else {
                    super.processKeyEvent(keyEvent);
                }
            }
        };
        this.fScrollPane = new MJScrollPane((Component)this.fTextPane, 21, 31);
        this.fScrollPane.setBorder(null);
        this.fTextPane.setName("command.window");
        this.fMainComponent.setBackground(this.fTextPane.getBackground());
        this.fPromptLabel.setFont(this.fTextPane.getFont());
        this.fTextPane.registerEditorKit(MLanguage.INSTANCE.getMimeType(), (EditorKit)new MKit(){

            public String getContentType() {
                return MLanguage.INSTANCE.getMimeType();
            }
        });
        this.fTextPane.setContentType(MLanguage.INSTANCE.getMimeType());
        this.fTextPane.setContextMenuEnabled(false, true);
        this.fTextPane.setShowRightMargin(false, false);
        this.fMainComponent.add(this.fScrollPane);
        this.fTextPane.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                CustomCommandWindow.this.fChangeListeners.stateChanged(new ChangeEvent(CustomCommandWindow.this));
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                CustomCommandWindow.this.fChangeListeners.stateChanged(new ChangeEvent(CustomCommandWindow.this));
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CustomCommandWindow.this.closeError();
            }
        });
        this.fDropDownButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                CustomCommandWindow.this.showPopupMenu(false);
            }
        });
        this.fTextPane.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 38 && !CustomCommandWindow.this.fHistory.isEmpty()) {
                    CustomCommandWindow.this.showPopupMenu(true);
                }
            }
        });
        if (!this.fHistory.isEmpty()) {
            this.setText(this.fHistory.getLastCommand());
        }
        this.installTextPaneListeners();
    }

    private void updateDropdownButton() {
        if (!this.fHistory.isEmpty() && this.fTextPane != null && this.getText().isEmpty()) {
            this.setText(this.fHistory.getLastCommand());
        }
        this.fDropDownButton.setEnabled(!this.fHistory.isEmpty());
    }

    private void installTextPaneListeners() {
        this.fTextPane.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                CustomCommandWindow.this.ensureCaretIsVisible();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                CustomCommandWindow.this.ensureCaretIsVisible();
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                CustomCommandWindow.this.ensureCaretIsVisible();
            }
        });
    }

    private void ensureCaretIsVisible() {
        int n = this.fTextPane.getCaretPosition();
        if (n != -1) {
            try {
                Point point = this.fTextPane.getPointFromPos(n);
                if (!this.fTextPane.getVisibleRect().contains(point.getX() + (double)CARET_WIDTH, point.getY())) {
                    this.fTextPane.scrollRectToVisible(new Rectangle(point, new Dimension(CARET_WIDTH, 1)));
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private static int determineCaretWidth() {
        Object object = UIManager.get("Caret.width");
        if (object != null && object instanceof Number) {
            return ((Number)object).intValue();
        }
        return 1;
    }

    public void setEnabled(boolean bl) {
        this.fTextPane.setEnabled(bl);
    }

    public void setUseBusyAffordance(boolean bl) {
        this.fUseBusyAffordance = bl;
    }

    public void setText(String string) {
        this.fTextPane.setText(string);
    }

    public String getText() {
        return this.fTextPane.getText();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.removeChangeListener(changeListener);
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public void activate() {
        this.fTextPane.setVisible(true);
        this.fTextPane.requestFocus();
        this.fPromptArea.setVisible(true);
    }

    public void run() {
        String string = this.fTextPane.getText().trim();
        if (!string.isEmpty()) {
            this.enterRunningMode();
            this.run(string, new Runnable(){

                @Override
                public void run() {
                    CustomCommandWindow.this.exitRunningMode();
                }
            });
        }
    }

    protected abstract void run(String var1, Runnable var2);

    private void enterRunningMode() {
        if (this.fUseBusyAffordance) {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    CustomCommandWindow.this.fBusyAffordance.start();
                    CustomCommandWindow.this.fTextPane.setEnabled(false);
                    CustomCommandWindow.this.fPromptArea.removeAll();
                    CustomCommandWindow.this.fPromptArea.add(CustomCommandWindow.this.fBusyAffordance.getComponent());
                    CustomCommandWindow.this.fPromptArea.revalidate();
                    CustomCommandWindow.this.fPromptArea.repaint();
                }
            });
        }
    }

    private void exitRunningMode() {
        if (this.fUseBusyAffordance) {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    CustomCommandWindow.this.fBusyAffordance.stop();
                    CustomCommandWindow.this.fTextPane.setEnabled(true);
                    CustomCommandWindow.this.fPromptArea.removeAll();
                    CustomCommandWindow.this.fPromptArea.add(CustomCommandWindow.this.fPromptLabel);
                    CustomCommandWindow.this.fPromptArea.revalidate();
                    CustomCommandWindow.this.fPromptArea.repaint();
                    CustomCommandWindow.this.fTextPane.requestFocus();
                    CustomCommandWindow.this.fDropDownButton.revalidate();
                    CustomCommandWindow.this.fDropDownButton.repaint();
                }
            });
        }
    }

    public void closeError() {
        if (this.fErrorPopup != null) {
            this.fErrorPopup.close();
            this.fErrorPopup = null;
        }
    }

    public void showError(String string) {
        List<String> list = this.fHistory.getCommands();
        if (!list.isEmpty()) {
            this.fHistory.delete(list.iterator().next());
        }
        if (PlatformInfo.isLinux()) {
            MJOptionPane.showMessageDialog((Component)this.fComponent, (Object)string, (String)CoderResources.getString("wfa.inputTypes.title"), (int)0);
        } else {
            this.closeError();
            this.fErrorPopup = new HintPopupFrame(SwingUtilities.windowForComponent(this.getComponent()), this.getComponent(), StringUtils.stripLinks((String)string), BuildErrorSeverity.ERROR.getIcon(), false, false, HintPopupFrame.ClosePolicy.EXPLICIT, new ReturnRunnable<Point>(){

                public Point run() {
                    Point point = new Point(CustomCommandWindow.this.getComponent().getWidth() / 2, CustomCommandWindow.this.getComponent().getHeight());
                    SwingUtilities.convertPointToScreen(point, CustomCommandWindow.this.getComponent());
                    return point;
                }
            });
            this.fErrorPopup.setHyperlinkHandler((HyperlinkTextLabel.HyperlinkHandler)new MatlabHyperlinkHandler());
        }
    }

    private static int getHoveredIndex(List<? extends JMenuItem> list) {
        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
        if (menuElementArray != null && menuElementArray.length == 2) {
            return list.indexOf(menuElementArray[1]);
        }
        return -1;
    }

    private void showPopupMenu(final boolean bl) {
        if (this.fCurrentPopup != null) {
            this.fCurrentPopup.setVisible(false);
            this.fCurrentPopup.dispose();
            this.fCurrentPopup = null;
            if (!bl) {
                return;
            }
        }
        final ArrayList<MJMenuItem> arrayList = new ArrayList<MJMenuItem>();
        final MJPopupMenu mJPopupMenu = new MJPopupMenu(){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                return new Dimension(CustomCommandWindow.this.fTextPane.getWidth() + 3 + CustomCommandWindow.this.fDropDownButton.getWidth(), dimension.height);
            }
        };
        mJPopupMenu.setName("command.window.testBenches.menu");
        this.fCurrentPopup = mJPopupMenu;
        final KeyEventDispatcher keyEventDispatcher = new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.getID() == 401 && keyEvent.getKeyChar() == '\u007f') {
                    int n = CustomCommandWindow.getHoveredIndex(arrayList);
                    if (n >= 0 && n <= arrayList.size()) {
                        String string = ((MJMenuItem)arrayList.get(n)).getText();
                        CustomCommandWindow.this.fHistory.delete(string);
                        arrayList.remove(n);
                        mJPopupMenu.setVisible(false);
                        mJPopupMenu.dispose();
                        if (!arrayList.isEmpty()) {
                            CustomCommandWindow.this.showPopupMenu(bl);
                        } else {
                            CustomCommandWindow.this.fDropDownButton.revalidate();
                            CustomCommandWindow.this.fDropDownButton.repaint();
                        }
                    }
                    return true;
                }
                return false;
            }
        };
        for (final String string : this.fHistory.getCommands()) {
            MJMenuItem mJMenuItem = new MJMenuItem(string);
            mJMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CustomCommandWindow.this.fTextPane.setText(string);
                    CustomCommandWindow.this.fTextPane.requestFocus();
                }
            });
            arrayList.add(mJMenuItem);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        if (bl) {
            Collections.reverse(arrayList);
        }
        for (MJMenuItem mJMenuItem : arrayList) {
            mJPopupMenu.add((JMenuItem)mJMenuItem);
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(keyEventDispatcher);
        mJPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(keyEventDispatcher);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                this.popupMenuWillBecomeInvisible(popupMenuEvent);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MenuSelectionManager.defaultManager().setSelectedPath(new MenuElement[]{mJPopupMenu, (MenuElement)arrayList.get(arrayList.size() - 1)});
            }
        });
        if (bl) {
            mJPopupMenu.show((Component)this.fTextPane, 0, -mJPopupMenu.getPreferredSize().height);
        } else {
            mJPopupMenu.show((Component)this.fTextPane, 0, this.fTextPane.getHeight());
        }
    }

    private void doBrowse() {
        MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform(MatlabPathModel.getInstance().getCurrentFolder().toFile());
        mJFileChooserPerPlatform.addChoosableFileFilter((FilePatternFilter)MatlabProductFileExtensionFilter.getMFileFilter());
        mJFileChooserPerPlatform.showOpenDialog((Component)this.fTextPane);
        if (mJFileChooserPerPlatform.getState() == 0) {
            File file = mJFileChooserPerPlatform.getSelectedFile();
            this.fTextPane.setText(new FileLocation(file).getNameBeforeDot());
            this.fTextPane.requestFocus();
        }
    }

    private class DropDownButton
    extends MJButton {
        DropDownButton() {
            this.setBorder(null);
        }

        public void paintComponent(Graphics graphics) {
            if (!this.isEnabled()) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(CustomCommandWindow.this.fTextPane.getBackground());
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (CustomCommandWindow.this.fHistory.isEmpty()) {
                return;
            }
            GeneralPath generalPath = new GeneralPath();
            generalPath.append(new Line2D.Double(this.getWidth() / 2 - 4, this.getHeight() / 2 - 3, this.getWidth() / 2 + 4, this.getHeight() / 2 - 3), true);
            generalPath.append(new Line2D.Double(this.getWidth() / 2 + 4, this.getHeight() / 2 - 3, this.getWidth() / 2, this.getHeight() / 2 + 3), true);
            generalPath.append(new Line2D.Double(this.getWidth() / 2, this.getHeight() / 2 + 3, this.getWidth() / 2 - 4, this.getHeight() / 2 - 3), true);
            graphics2D.setColor(Color.BLACK);
            graphics2D.fill(generalPath);
            graphics2D.draw(generalPath);
            graphics2D.dispose();
        }

        public Dimension getPreferredSize() {
            return new Dimension(18, 9);
        }
    }
}

