/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.core;

import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.mwswing.MJButton;
import com.mathworks.util.PlatformInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public final class ListEntryButton
extends MJButton {
    private static final int LINE_CUSHION = 6;
    private final ButtonType fType;
    private boolean fGrouped;

    public ListEntryButton(ButtonType buttonType) {
        this.fType = buttonType;
        this.fGrouped = true;
        if (PlatformInfo.isMacintosh()) {
            this.putClientProperty("JButton.buttonType", "gradient");
            this.setFocusPainted(false);
            if (this.fType == ButtonType.ADD) {
                this.setIcon(MiscellaneousIcon.ADD_ENTRY.getIcon());
            } else if (this.fType == ButtonType.REMOVE) {
                this.setIcon(MiscellaneousIcon.REMOVE_ENTRY.getIcon());
            } else if (this.fType == ButtonType.RUN) {
                this.setIcon(ListEntryButton.createRunIcon(true));
            } else {
                this.setText("...");
            }
        } else {
            this.setCursor(Cursor.getPredefinedCursor(12));
            if (this.fType == ButtonType.RUN) {
                this.setIcon(ListEntryButton.createRunIcon(false));
            }
        }
    }

    public void setGrouped(boolean bl) {
        this.fGrouped = bl;
    }

    public void paintComponent(Graphics graphics) {
        if (PlatformInfo.isMacintosh()) {
            super.paintComponent(graphics);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (!PlatformInfo.isMacintosh()) {
            if (this.getModel().isRollover()) {
                graphics2D.setColor(Color.WHITE);
            } else {
                graphics2D.setColor(UIManager.getColor("control"));
            }
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setColor(new Color(180, 180, 180));
            graphics2D.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        graphics2D.setStroke(new BasicStroke(1.4f));
        graphics2D.setColor(new Color(100, 100, 100));
        int n = this.getWidth() / 2;
        int n2 = this.getHeight() / 2;
        if (this.fType == ButtonType.RUN) {
            this.getIcon().paintIcon((Component)((Object)this), graphics2D, this.getWidth() / 2 - this.getIcon().getIconWidth() / 2, this.getHeight() / 2 - this.getIcon().getIconHeight() / 2);
        } else if (this.fType != ButtonType.BROWSE) {
            graphics2D.drawLine(6, n2, this.getWidth() - 6, n2);
        } else {
            graphics2D.drawRect(this.getWidth() / 5, this.getHeight() / 2, 1, 1);
            graphics2D.drawRect(this.getWidth() / 2 - 1, this.getHeight() / 2, 1, 1);
            graphics2D.drawRect(this.getWidth() * 4 / 5 - 1, this.getHeight() / 2, 1, 1);
        }
        if (this.fType == ButtonType.ADD) {
            graphics2D.drawLine(n, 6, n, this.getHeight() - 6);
        }
        graphics2D.dispose();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        if (!PlatformInfo.isMacintosh()) {
            return new Dimension(20, 17);
        }
        return this.fGrouped ? new Dimension(24, 24) : new Dimension(32, 30);
    }

    private static Icon createRunIcon(boolean bl) {
        BufferedImage bufferedImage = new BufferedImage(bl ? 16 : 14, bl ? 16 : 14, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath generalPath = new GeneralPath();
        generalPath.append(new Line2D.Double(0.0, 0.0, bufferedImage.getWidth() - 1, bufferedImage.getHeight() / 2), true);
        generalPath.append(new Line2D.Double(bufferedImage.getWidth() - 1, bufferedImage.getHeight() / 2, 0.0, bufferedImage.getHeight() - 1), true);
        generalPath.append(new Line2D.Double(0.0, bufferedImage.getHeight() - 1, 0.0, 0.0), true);
        if (bl) {
            graphics2D.setColor(Color.BLACK);
            graphics2D.fill(generalPath);
        } else {
            graphics2D.setColor(new Color(100, 100, 100));
            graphics2D.draw(generalPath);
        }
        return new ImageIcon(bufferedImage);
    }

    public static enum ButtonType {
        ADD,
        REMOVE,
        BROWSE,
        RUN;

    }
}

