/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.core;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.toolbox.coder.app.PopupBarContent;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;

public abstract class PopupBarOptionPanel
implements PopupBarContent {
    private final MJToggleButton fButton;
    private final MJPanel fComponent;
    private final MJPanel fContentPane;
    private boolean fInitialized;

    protected PopupBarOptionPanel(MJToggleButton mJToggleButton) {
        this.fButton = mJToggleButton;
        this.fContentPane = new MJPanel();
        this.fContentPane.setOpaque(false);
        this.fComponent = new MJPanel();
        this.fComponent.setOpaque(false);
    }

    protected MJPanel getContentPane() {
        return this.fContentPane;
    }

    @Override
    public void close() {
        this.fButton.setSelected(false);
    }

    @Override
    public JComponent createComponent(MJButton mJButton) {
        if (!this.fInitialized) {
            MJButton mJButton2;
            if (PlatformInfo.isMacintosh()) {
                mJButton2 = mJButton;
            } else {
                MJToolBar mJToolBar = new MJToolBar();
                mJToolBar.setFloatable(false);
                mJToolBar.setOpaque(false);
                mJToolBar.add((Component)mJButton);
                mJButton2 = mJToolBar;
            }
            this.layoutComponent((JComponent)this.fComponent, (JComponent)mJButton2);
            this.fInitialized = true;
        }
        return this.fComponent;
    }

    protected void layoutComponent(JComponent jComponent, JComponent jComponent2) {
        jComponent.setLayout((LayoutManager)new FormLayout((this.shouldStretch() ? "fill:d:grow" : "fill:d") + ", 3dlu, fill:d, 3dlu", "0dlu, center:d, 0dlu:grow"));
        CellConstraints cellConstraints = new CellConstraints();
        this.fComponent.add((Component)this.fContentPane, (Object)cellConstraints.xy(1, 2));
        jComponent.add((Component)jComponent2, cellConstraints.xy(3, 2));
    }

    protected MJButton createRunButton() {
        MJButton mJButton;
        if (PlatformInfo.isMacintosh()) {
            mJButton = new MJButton(BuiltInResources.getString((String)"button.run"));
            mJButton.putClientProperty((Object)"JButton.buttonType", (Object)"roundRect");
        } else {
            mJButton = new MJButton(BuiltInResources.getString((String)"button.run"));
        }
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopupBarOptionPanel.this.runAction();
            }
        });
        return mJButton;
    }

    protected abstract void runAction();

    protected boolean shouldStretch() {
        return false;
    }
}

