/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.core;

import com.mathworks.toolbox.coder.wfa.core.Step;
import com.mathworks.toolbox.coder.wfa.core.StepModel;
import com.mathworks.toolbox.coder.wfa.core.StepSummaryView;
import com.mathworks.toolbox.coder.wfa.core.StepView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public abstract class StepViewFactory {
    private final Map<Step, StepView> fViews = new HashMap<Step, StepView>();
    private final Map<Step, StepSummaryView> fSummaryViews = new HashMap<Step, StepSummaryView>();

    protected StepViewFactory() {
    }

    public final StepView getView(Step step, StepModel stepModel) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException();
        }
        StepView stepView = this.fViews.get(step);
        if (stepView == null) {
            stepView = this.createView(step, stepModel);
            this.fViews.put(step, stepView);
        }
        return stepView;
    }

    public final StepSummaryView getSummaryView(Step step, StepModel stepModel) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException();
        }
        StepSummaryView stepSummaryView = this.fSummaryViews.get(step);
        if (stepSummaryView == null) {
            stepSummaryView = this.createSummaryView(step, stepModel);
            this.fSummaryViews.put(step, stepSummaryView);
        }
        return stepSummaryView;
    }

    public final List<StepSummaryView> getSummaryViews(StepModel stepModel) {
        ArrayList<StepSummaryView> arrayList = new ArrayList<StepSummaryView>();
        for (Step step : stepModel.getSteps()) {
            arrayList.add(this.getSummaryView(step, stepModel));
        }
        return arrayList;
    }

    protected abstract StepView createView(Step var1, StepModel var2);

    protected abstract StepSummaryView createSummaryView(Step var1, StepModel var2);

    public void dispose() {
        for (StepView stepView : this.fViews.values()) {
            stepView.dispose();
        }
    }
}

