/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.files;

import com.mathworks.toolbox.coder.app.ide.FileSelectionEvent;
import com.mathworks.toolbox.coder.app.ide.FunctionSelectionEvent;
import com.mathworks.toolbox.coder.app.ide.SelectionEvent;
import com.mathworks.toolbox.coder.app.ide.SelectionListener;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.util.ProxyEventDispatcher;
import com.mathworks.toolbox.coder.wfa.files.FileSetView;
import java.io.File;

abstract class AbstractFileSetView
implements FileSetView {
    private final ProxyEventDispatcher<SelectionListener> fSelectionListeners = new ProxyEventDispatcher<SelectionListener>(SelectionListener.class);
    private boolean fIgnoreChanges;

    @Override
    public void removeSelectionListener(SelectionListener selectionListener) {
        this.fSelectionListeners.removeObserver(selectionListener);
    }

    @Override
    public void addSelectionListener(SelectionListener selectionListener) {
        this.fSelectionListeners.addObserver(selectionListener);
    }

    @Override
    public boolean select(Function function) {
        return this.select(function != null ? function.getFile() : (File)null);
    }

    @Override
    public void select(SelectionEvent selectionEvent) {
        if (selectionEvent.getFunction() != null) {
            this.select(selectionEvent.getFunction());
        } else if (selectionEvent.getFile() != null) {
            this.select(selectionEvent.getFile());
        }
    }

    protected void fireSelectionEvent(SelectionEvent selectionEvent) {
        if (!this.fIgnoreChanges) {
            this.fSelectionListeners.getProxyDispatcher().selectionChanged(selectionEvent);
        }
    }

    protected void fireSelectionEvent(Function function) {
        this.fireSelectionEvent(new FunctionSelectionEvent(this, function));
    }

    protected void fireSelectionEvent(File file) {
        this.fireSelectionEvent(new FileSelectionEvent(this, file));
    }

    protected void runSilently(Runnable runnable) {
        this.fIgnoreChanges = true;
        runnable.run();
        this.fIgnoreChanges = false;
    }

    @Override
    public String getViewName() {
        return null;
    }

    @Override
    public Function getSelectedFunction() {
        return null;
    }
}

