/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.files;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.services.ColorPrefs;
import com.mathworks.toolbox.coder.app.GlassPaneManager;
import com.mathworks.toolbox.coder.app.ide.CallSiteSelectionEvent;
import com.mathworks.toolbox.coder.app.ide.EditorView;
import com.mathworks.toolbox.coder.app.ide.FileSelectionEvent;
import com.mathworks.toolbox.coder.app.ide.FunctionSelectionEvent;
import com.mathworks.toolbox.coder.model.BuildError;
import com.mathworks.toolbox.coder.model.BuildErrorSeverity;
import com.mathworks.toolbox.coder.model.CallTree;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.UnifiedModel;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.files.FileScopedNode;
import com.mathworks.toolbox.coder.wfa.files.FileScopedTree;
import com.mathworks.toolbox.coder.wfa.files.FileScopedTreeModel;
import com.mathworks.toolbox.coder.wfa.files.FileSetExpansionProviders;
import com.mathworks.toolbox.coder.wfa.files.FileSetIntegrationContext;
import com.mathworks.toolbox.coder.widgets.GlassPaneCloseButton;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.Converter;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.widgets.grouptable.ExpansionContext;
import com.mathworks.widgets.grouptable.ExpansionProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.swing.DefaultLookup;

public final class CallTreeFileSetView
extends FileScopedTree {
    private static final String CALL_TREE_LABEL = "wfa.sidebar.inputCallTreeViewLabel";
    private static final Color LINE_NUMBER_COLOR = new Color(0, 112, 45);
    private final FileSetIntegrationContext fContext;
    private final CallTreeCellRenderer fRenderer;
    private final GlassPaneManager fGlassPane;
    private CaretListener fCaretListener;
    private CallTreeDisplayMode fMode;
    private HierarchyContext fHierarchyContext;
    private CallTree fCallTree;
    private Function fSelectedFunctionOverride;
    private boolean fIgnoreSpecializations;

    public CallTreeFileSetView(GlassPaneManager glassPaneManager, FileSetIntegrationContext fileSetIntegrationContext) {
        super(fileSetIntegrationContext, new FileScopedTreeModel(fileSetIntegrationContext), CoderResources.getString(CALL_TREE_LABEL));
        this.fGlassPane = glassPaneManager;
        this.fContext = fileSetIntegrationContext;
        this.setNodeProvider();
        this.fRenderer = new CallTreeCellRenderer(fileSetIntegrationContext, this.createCallTreeConverter());
        fileSetIntegrationContext.getEditorView().addFileLoadedCallback(new ParameterRunnable<EditorView>(){

            public void run(EditorView editorView) {
                if (editorView.getTextPane() != null) {
                    if (CallTreeFileSetView.this.fCaretListener == null) {
                        editorView.getTextPane().addCaretListener(CallTreeFileSetView.this.fCaretListener = new CaretListener(){

                            @Override
                            public void caretUpdate(CaretEvent caretEvent) {
                                CallTreeFileSetView.this.getComponent().repaint();
                            }
                        });
                    }
                    CallTreeFileSetView.this.getComponent().repaint();
                }
            }
        }, false);
        fileSetIntegrationContext.getEditorView().addFileLoadedCallback(new ParameterRunnable<EditorView>(){

            public void run(EditorView editorView) {
                if (CallTreeFileSetView.this.fHierarchyContext == null || editorView.getCurrentFunction() == null || !editorView.getCurrentFunction().getFile().equals(CallTreeFileSetView.this.fHierarchyContext.getEnclosing().getFile())) {
                    CallTreeFileSetView.this.closeCallHierarchy();
                }
            }
        }, false);
        this.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (treeSelectionEvent.getPath().getPathCount() == 2) {
                    CallTreeFileSetView.this.fireSelectionEvent();
                }
            }
        });
        this.setTreeCellRenderer(this.fRenderer);
    }

    @Override
    public boolean select(File file) {
        FileScopedNode fileScopedNode = this.getSelectedNode();
        if (fileScopedNode == null || fileScopedNode.getAssociatedFile() == null || !fileScopedNode.getAssociatedFile().equals(file)) {
            return super.select(file);
        }
        return true;
    }

    @Override
    public String getViewName() {
        return "wfa.sidebar.callTreeView";
    }

    public void setIgnoreSpecializations(boolean bl) {
        this.fIgnoreSpecializations = bl;
        this.update();
    }

    public void setErrors(Collection<BuildError> collection) {
        this.fRenderer.setBuildErrors(collection);
        this.update();
    }

    public void setCallTree(CallTree callTree) {
        this.fCallTree = callTree;
        this.closeCallHierarchy();
        this.fRenderer.reset();
        this.update();
    }

    public CallTree.CallSite getSelectedCallSite() {
        if (this.fSelectedFunctionOverride != null) {
            return null;
        }
        FileScopedNode fileScopedNode = this.getSelectedNode();
        if (fileScopedNode != null && fileScopedNode.getNodeType() == FileScopedNode.NodeType.VALUE_NODE && fileScopedNode.getValueType().equals(CallTree.CallSite.class)) {
            return (CallTree.CallSite)fileScopedNode.getValue();
        }
        return null;
    }

    @Override
    public void update() {
        this.runSilently(new Runnable(){

            @Override
            public void run() {
                CallTreeFileSetView.this.setNodeProvider();
                CallTreeFileSetView.super.update();
                CallTreeFileSetView.this.expandAll(null);
            }
        });
    }

    public void showCallHierarchy(CallTree.CallSite callSite) {
        assert (this.fCallTree != null) : "A call should first be made to setCallTree before using this method";
        this.closeCallHierarchy();
        this.fHierarchyContext = new HierarchyContext(this.fCallTree.getCallHierarchy(callSite.getTarget()), callSite, new GlassPaneCloseButton(this.fGlassPane, this.getComponent(), new Runnable(){

            @Override
            public void run() {
                CallTreeFileSetView.this.closeCallHierarchy();
            }
        }, CoderResources.getString("wfa.sidebar.callTree.hierarchyCloseTooltip"), new Dimension(-12, 15)));
        this.update();
    }

    public void showCallHierarchy(Function function) {
        this.showCallHierarchy(new CallTree.CallSite(-1, function, function));
    }

    public void closeCallHierarchy() {
        if (this.fHierarchyContext != null) {
            this.fHierarchyContext.getCloseButton().dispose();
            this.fHierarchyContext = null;
            this.update();
        }
    }

    @Override
    public Function getSelectedFunction() {
        if (this.fSelectedFunctionOverride != null) {
            return this.fSelectedFunctionOverride;
        }
        if (this.getSelectedNode() == null) {
            return null;
        }
        Function function = super.getSelectedFunction();
        if (function != null) {
            return function;
        }
        function = this.resolveFunctionToFocus(this.getSelectedCallSite(), this.getSelectedNode());
        return function;
    }

    private void fireSelectionEvent() {
        if (this.getSelectedCallSite() != null) {
            this.fireSelectionEvent(new CallSiteSelectionEvent(this, this.getSelectedCallSite()));
        } else if (this.getSelectedFunction() != null) {
            this.fireSelectionEvent(new FunctionSelectionEvent(this, this.getSelectedFunction()));
        } else {
            this.fireSelectionEvent(new FileSelectionEvent(this, this.getSelectedFile()));
        }
    }

    @Override
    protected void fireSelectionEvent(Function function) {
    }

    @Override
    protected void fireSelectionEvent(File file) {
    }

    @Override
    @Nullable
    protected FileScopedTree.RowSpanningTreeUI createTreeUI() {
        return new CallTreeUI(5, 2);
    }

    private void setNodeProvider() {
        if (this.fHierarchyContext != null) {
            this.fMode = new HierarchyDisplayMode(this.fIgnoreSpecializations);
            this.setNodeProvider(this.fHierarchyContext.getCallHierarchy(), this.fMode);
        } else {
            this.fMode = new NormalDisplayMode(this.fIgnoreSpecializations);
            this.setNodeProvider(this.fCallTree, this.fMode);
        }
    }

    private void setNodeProvider(CallTree callTree, CallTreeDisplayMode callTreeDisplayMode) {
        this.getTreeModel().setNodeProvider(CallTreeFileSetView.createExpansionProviderConverter(FileSetExpansionProviders.createCallTreeExpansionProvider(callTree, callTreeDisplayMode)));
    }

    private Converter<Function, Collection<Function>> createCallTreeConverter() {
        return new Converter<Function, Collection<Function>>(){

            public Collection<Function> convert(Function function) {
                HashSet<Function> hashSet = new HashSet<Function>();
                if (CallTreeFileSetView.this.fCallTree != null) {
                    LinkedList<Function> linkedList = new LinkedList<Function>();
                    linkedList.offer(function);
                    while (!linkedList.isEmpty()) {
                        Function function2 = (Function)linkedList.poll();
                        for (Function function3 : CallTreeFileSetView.this.fCallTree.getFunctionsInvoked(function2)) {
                            if (!hashSet.add(function3)) continue;
                            linkedList.add(function3);
                        }
                    }
                }
                return hashSet;
            }
        };
    }

    private Function resolveFunctionToFocus(CallTree.CallSite callSite, @NotNull FileScopedNode fileScopedNode) {
        if (callSite != null) {
            return callSite.getEnclosingFunction();
        }
        return this.fContext.getSourceModel().getEntryPointFunction(fileScopedNode.getAssociatedFile());
    }

    public static Converter<FileScopedNode, Collection<FileScopedNode>> createExpansionProviderConverter(final ExpansionProvider<FileScopedNode> expansionProvider) {
        return new Converter<FileScopedNode, Collection<FileScopedNode>>(){

            public Collection<FileScopedNode> convert(FileScopedNode fileScopedNode) {
                ExpansionContext expansionContext = expansionProvider.openContext((Object)fileScopedNode);
                final ArrayList<FileScopedNode> arrayList = new ArrayList<FileScopedNode>();
                if (expansionContext != null) {
                    expansionContext.getChildrenAsynchronously((AsyncReceiver)new AsyncReceiver<FileScopedNode>(){

                        public boolean receive(FileScopedNode fileScopedNode) {
                            arrayList.add(fileScopedNode);
                            return true;
                        }
                    });
                }
                if (fileScopedNode.getNodeType() == FileScopedNode.NodeType.INTERNAL_ROOT) {
                    Collections.sort(arrayList, CallTreeFileSetView.createFilenameComparator());
                } else if (fileScopedNode.getNodeType() == FileScopedNode.NodeType.FILE_NODE) {
                    Collections.sort(arrayList, CallTreeFileSetView.createCallSiteNodeComparator());
                }
                return arrayList;
            }
        };
    }

    private static Comparator<FileScopedNode> createFilenameComparator() {
        return new Comparator<FileScopedNode>(){

            @Override
            public int compare(FileScopedNode fileScopedNode, FileScopedNode fileScopedNode2) {
                return fileScopedNode.getAssociatedFile().getName().compareTo(fileScopedNode2.getAssociatedFile().getName());
            }
        };
    }

    private static Comparator<FileScopedNode> createCallSiteNodeComparator() {
        return new Comparator<FileScopedNode>(){

            @Override
            public int compare(FileScopedNode fileScopedNode, FileScopedNode fileScopedNode2) {
                if (fileScopedNode.getValueType().equals(CallTree.CallSite.class) && fileScopedNode2.getValueType().equals(CallTree.CallSite.class)) {
                    int n = ((CallTree.CallSite)fileScopedNode.getValue()).getPosition();
                    int n2 = ((CallTree.CallSite)fileScopedNode2.getValue()).getPosition();
                    return Integer.valueOf(n).compareTo(n2);
                }
                return 0;
            }
        };
    }

    static String createSpecializationDisplayString(Function function, Color color, UnifiedModel unifiedModel, boolean bl, boolean bl2, @Nullable String string) {
        Object object;
        String string2 = String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
        String string3 = bl ? string2 : "blue";
        String string4 = function.getName();
        if (bl2 && (object = unifiedModel.getEntryPointFunction(function.getFile())) != null && !((Function)object).getName().equals(function.getName())) {
            string4 = ((Function)object).getName() + " > " + string4;
        }
        object = "";
        if (function.isSpecialized()) {
            object = " > </font><font color=" + string3 + ">" + function.getSpecializationId() + "</font>";
        }
        String string5 = string != null ? "<font color=" + string2 + ">" + string + "</font>" : "";
        return "<html><font color=" + string2 + ">" + string4 + (String)object + string5 + "</html>";
    }

    static abstract class CallTreeDisplayMode {
        private final boolean fIgnoreSpecializations;

        CallTreeDisplayMode(boolean bl) {
            this.fIgnoreSpecializations = bl;
        }

        boolean isIgnoreSpecializations() {
            return this.fIgnoreSpecializations;
        }

        @Nullable
        Collection<FileScopedNode> createRootOverrideNodes(@NotNull FileScopedNode fileScopedNode) {
            return null;
        }

        @Nullable
        List<CallTree.CallSite> createLeafValueAppendages(@NotNull FileScopedNode fileScopedNode) {
            return null;
        }

        abstract Function getLabelFunction(CallTree.CallSite var1);

        abstract Function extractFunction(CallTree.CallSite var1);

        abstract Function getRootFunction(FileScopedNode var1);
    }

    private class NormalDisplayMode
    extends CallTreeDisplayMode {
        NormalDisplayMode(boolean bl) {
            super(bl);
        }

        @Override
        Function extractFunction(CallTree.CallSite callSite) {
            return callSite.getTarget();
        }

        @Override
        Function getRootFunction(FileScopedNode fileScopedNode) {
            return CallTreeFileSetView.this.fContext.getSourceModel().getEntryPointFunction(fileScopedNode.getAssociatedFile());
        }

        @Override
        @Nullable
        Collection<FileScopedNode> createRootOverrideNodes(@NotNull FileScopedNode fileScopedNode) {
            LinkedList<FileScopedNode> linkedList = new LinkedList<FileScopedNode>();
            if (CallTreeFileSetView.this.fCallTree != null) {
                Set set = CallTreeFileSetView.this.fContext.getApp().getModel().getEntryPointFileSet().getFiles();
                for (Function function : CallTreeFileSetView.this.fContext.getSourceModel().getEntryPointFunctions()) {
                    if (!set.contains(function.getFile())) continue;
                    linkedList.add(new FileScopedNode(fileScopedNode, function, function.getFile()));
                }
            }
            return linkedList;
        }

        @Override
        Function getLabelFunction(CallTree.CallSite callSite) {
            return callSite.getTarget();
        }
    }

    private class HierarchyDisplayMode
    extends CallTreeDisplayMode {
        HierarchyDisplayMode(boolean bl) {
            super(bl);
        }

        @Override
        Function extractFunction(CallTree.CallSite callSite) {
            return callSite.getEnclosingFunction();
        }

        @Override
        Function getRootFunction(FileScopedNode fileScopedNode) {
            return CallTreeFileSetView.this.fHierarchyContext.getTarget();
        }

        @Override
        @Nullable
        Collection<FileScopedNode> createRootOverrideNodes(@NotNull FileScopedNode fileScopedNode) {
            return Arrays.asList(new FileScopedNode(fileScopedNode, CallTreeFileSetView.this.fHierarchyContext.getTarget()));
        }

        @Override
        @Nullable
        List<CallTree.CallSite> createLeafValueAppendages(@NotNull FileScopedNode fileScopedNode) {
            if (fileScopedNode.getNodeType() == FileScopedNode.NodeType.VALUE_NODE && fileScopedNode.getValueType().equals(CallTree.CallSite.class)) {
                CallTree.CallSite callSite = (CallTree.CallSite)fileScopedNode.getValue();
                return Arrays.asList(new CallTree.CallSite(callSite.getPosition(), callSite.getEnclosingFunction(), callSite.getEnclosingFunction()));
            }
            return null;
        }

        @Override
        Function getLabelFunction(CallTree.CallSite callSite) {
            return callSite.getEnclosingFunction();
        }
    }

    private static class HierarchyContext {
        private final CallTree fCallHierarchy;
        private final Function fEnclosing;
        private final Function fTarget;
        private final GlassPaneCloseButton fCloseButton;
        private final int fPosition;

        HierarchyContext(CallTree callTree, Function function, Function function2, GlassPaneCloseButton glassPaneCloseButton, int n) {
            this.fCallHierarchy = callTree;
            this.fEnclosing = function;
            this.fTarget = function2;
            this.fCloseButton = glassPaneCloseButton;
            this.fPosition = n;
        }

        HierarchyContext(CallTree callTree, Function function, Function function2, GlassPaneCloseButton glassPaneCloseButton) {
            this(callTree, function, function2, glassPaneCloseButton, -1);
        }

        HierarchyContext(CallTree callTree, CallTree.CallSite callSite, GlassPaneCloseButton glassPaneCloseButton) {
            this(callTree, callSite.getEnclosingFunction(), callSite.getTarget(), glassPaneCloseButton, callSite.getPosition());
        }

        CallTree getCallHierarchy() {
            return this.fCallHierarchy;
        }

        Function getTarget() {
            return this.fTarget;
        }

        GlassPaneCloseButton getCloseButton() {
            return this.fCloseButton;
        }

        Function getEnclosing() {
            return this.fEnclosing;
        }

        int getPosition() {
            return this.fPosition;
        }
    }

    private class CallTreeUI
    extends FileScopedTree.RowSpanningTreeUI {
        private final int fArrowHeadLen;
        private final int fArrowHeadNormal;
        private boolean fRoot;
        private int fLevel;

        CallTreeUI(int n, int n2) {
            this.fArrowHeadLen = n;
            this.fArrowHeadNormal = n2;
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            super.paint(graphics2D, jComponent);
            graphics2D.dispose();
        }

        @Override
        protected void paintHorizontalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
            this.fRoot = n == 0 || treePath.getLastPathComponent() != null && ((FileScopedNode)treePath.getLastPathComponent()).getNodeType() != FileScopedNode.NodeType.VALUE_NODE;
            this.fLevel = n;
            super.paintHorizontalPartOfLeg(graphics, rectangle, insets, rectangle2, treePath, n, bl, bl2, bl3);
        }

        @Override
        protected void paintVerticalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, TreePath treePath) {
            this.fRoot = treePath.getPathCount() <= 1;
            this.fLevel = treePath.getPathCount();
            super.paintVerticalPartOfLeg(graphics, rectangle, insets, treePath);
        }

        @Override
        protected void paintHorizontalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
            super.paintHorizontalLine(graphics, jComponent, n, n2, n3);
            if (CallTreeFileSetView.this.fHierarchyContext == null && !this.fRoot && this.fLevel >= 1) {
                graphics.drawLine(n3 + 1, n, n3 - this.fArrowHeadLen, n - this.fArrowHeadNormal);
                graphics.drawLine(n3 + 1, n, n3 - this.fArrowHeadLen, n + this.fArrowHeadNormal);
            }
        }

        @Override
        protected void paintVerticalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
            super.paintVerticalLine(graphics, jComponent, n, n2, n3);
            if (CallTreeFileSetView.this.fHierarchyContext != null && !this.fRoot) {
                graphics.drawLine(n, n2, n + this.fArrowHeadNormal, n2 + this.fArrowHeadLen);
                graphics.drawLine(n, n2, n - this.fArrowHeadNormal, n2 + this.fArrowHeadLen);
            }
        }
    }

    private static class SimpleHyperlinkLabel
    extends MJLabel {
        private final Runnable fAction;
        private Color fNormalForegroundColor;
        private String fStrippedText;
        private boolean fShowAsHyperlink;

        SimpleHyperlinkLabel(Runnable runnable) {
            this.fAction = runnable;
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    SimpleHyperlinkLabel.this.fire();
                }
            });
        }

        void fire() {
            if (this.fAction != null) {
                this.fAction.run();
            }
        }

        void setShowAsHyperlink(boolean bl) {
            this.fShowAsHyperlink = bl;
            Map<TextAttribute, ?> map = this.getFont().getAttributes();
            if (bl) {
                map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                this.setFont(this.getFont().deriveFont(map));
                super.setForeground(ColorPrefs.getHyperlinkColor());
                super.setText(this.fStrippedText);
            } else if (this.fNormalForegroundColor != null) {
                map.put(TextAttribute.UNDERLINE, -1);
                this.setCursor(Cursor.getDefaultCursor());
                this.setFont(this.getFont().deriveFont(map));
                super.setForeground(this.fNormalForegroundColor);
            }
        }

        public void setForeground(Color color) {
            this.fNormalForegroundColor = color;
            super.setForeground(this.fNormalForegroundColor);
        }

        public void setText(String string) {
            super.setText(string);
            this.fStrippedText = string.replaceAll("<[^>]*>", "");
        }

        public String getText() {
            return super.getText();
        }
    }

    private class CallTreeCellRenderer
    extends FileScopedCellRendererPanel {
        private final SimpleHyperlinkLabel fMainLabel;
        private final SimpleHyperlinkLabel fPositionLabel;
        private final Map<CallTree.CallSite, Integer> fPositionCache;
        private CallTree.CallSite fHoverSite;
        private Point fMousePoint;
        private int fHoverRow;

        CallTreeCellRenderer(FileSetIntegrationContext fileSetIntegrationContext, Converter<Function, Collection<Function>> converter) {
            super(fileSetIntegrationContext, converter);
            this.fMainLabel = new SimpleHyperlinkLabel(new Runnable(){

                @Override
                public void run() {
                    CallTreeFileSetView.this.fSelectedFunctionOverride = CallTreeCellRenderer.this.fHoverSite != null ? CallTreeCellRenderer.this.fHoverSite.getTarget() : null;
                    if (CallTreeFileSetView.this.fSelectedFunctionOverride != null) {
                        CallTreeFileSetView.this.fireSelectionEvent();
                    }
                }
            });
            this.fPositionLabel = new SimpleHyperlinkLabel(new Runnable(){

                @Override
                public void run() {
                    CallTreeFileSetView.this.fireSelectionEvent();
                }
            });
            this.fPositionLabel.setHorizontalAlignment(4);
            this.fPositionLabel.setBorder(new EmptyBorder(0, 0, 0, 3));
            this.fPositionCache = new HashMap<CallTree.CallSite, Integer>();
            this.add((Component)((Object)this.fMainLabel), "Center");
            this.add((Component)((Object)this.fPositionLabel), "East");
            CallTreeFileSetView.this.getTree().addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    CallTreeCellRenderer.this.handleMouseMovement(mouseEvent);
                }
            });
            CallTreeFileSetView.this.getTree().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    CallTreeCellRenderer.this.handleClick(mouseEvent);
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    CallTreeCellRenderer.this.handleMouseMovement(mouseEvent);
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    CallTreeCellRenderer.this.handleMouseMovement(mouseEvent);
                }
            });
        }

        private void handleMouseMovement(MouseEvent mouseEvent) {
            CallTreeFileSetView.this.fSelectedFunctionOverride = null;
            this.fMousePoint = null;
            this.fHoverRow = -1;
            Cursor cursor = Cursor.getDefaultCursor();
            int n = CallTreeFileSetView.this.getTree().getClosestRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n >= 0) {
                Rectangle rectangle = CallTreeFileSetView.this.getTree().getRowBounds(n);
                Rectangle rectangle2 = CallTreeFileSetView.this.getTree().getVisibleRect();
                rectangle.setSize((int)((double)rectangle.width + rectangle2.getMaxX() - rectangle.getMaxX()), (int)((double)rectangle.height + rectangle2.getMaxX() - rectangle.getMaxX()));
                if (rectangle.contains(mouseEvent.getPoint())) {
                    this.fHoverRow = n;
                    this.fMousePoint = mouseEvent.getPoint();
                    cursor = Cursor.getPredefinedCursor(12);
                }
            }
            CallTreeFileSetView.this.getTree().setCursor(cursor);
            CallTreeFileSetView.this.getTree().repaint();
        }

        private void handleClick(MouseEvent mouseEvent) {
            if (this.isOverPosLabel()) {
                this.fPositionLabel.fire();
            } else {
                this.fMainLabel.fire();
            }
        }

        private boolean isOverPosLabel() {
            if (this.fHoverRow == -1 || this.fMousePoint == null) {
                return false;
            }
            Rectangle rectangle = CallTreeFileSetView.this.getTree().getRowBounds(this.fHoverRow);
            return this.fMousePoint != null && rectangle != null && this.fMousePoint.getX() >= rectangle.getMaxX();
        }

        void clearAll() {
            this.fMainLabel.setIcon(null);
            this.fMainLabel.setText("");
            this.fMainLabel.setForeground(null);
            this.fPositionLabel.setIcon(null);
            this.fPositionLabel.setText("");
        }

        void reset() {
            this.fPositionCache.clear();
        }

        private int getLineFromPosition(Function function, CallTree.CallSite callSite) {
            try {
                EditorView editorView = this.getContext().getApp().getIDEView().getCodeInfoView().getEditorView();
                if (editorView.getTextPane() != null && editorView.getCurrentFunction() != null && editorView.getCurrentFunction().getFile().equals(function.getFile())) {
                    int n = editorView.getTextPane().getLineFromPos(callSite.getPosition());
                    this.fPositionCache.put(callSite, n);
                    return n;
                }
                return -1;
            }
            catch (BadLocationException badLocationException) {
                return 0;
            }
        }

        private void postProcessRenderer(int n, CallTree.CallSite callSite) {
            boolean bl = false;
            boolean bl2 = false;
            if (this.fHoverRow != -1 && this.fHoverRow == n) {
                this.fHoverSite = callSite;
                bl2 = this.isOverPosLabel();
                bl = !bl2;
            }
            this.fMainLabel.setShowAsHyperlink(n != 0 && bl);
            this.fPositionLabel.setShowAsHyperlink(n != 0 && bl2);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.clearAll();
            FileScopedNode fileScopedNode = (FileScopedNode)object;
            Function function = CallTreeFileSetView.this.fContext.getSourceModel().getEntryPointFunction(fileScopedNode.getAssociatedFile());
            BuildErrorSeverity buildErrorSeverity = null;
            CallTree.CallSite callSite = null;
            switch (fileScopedNode.getNodeType()) {
                case FILE_NODE: {
                    if (function != null) {
                        buildErrorSeverity = this.getSeverity(function);
                        this.fMainLabel.setText(function.getName());
                        if (!bl2) break;
                        this.fPositionLabel.setForeground(Color.LIGHT_GRAY);
                        this.fPositionLabel.setText(CoderResources.getString("wfa.sidebar.lineNumberLabel"));
                        break;
                    }
                    this.fMainLabel.setIcon(this.getDefaultsSource().getDefaultClosedIcon());
                    this.fMainLabel.setText(fileScopedNode.getAssociatedFile().getName());
                    break;
                }
                case VALUE_NODE: {
                    int n2;
                    Function function2;
                    Function function3;
                    if (fileScopedNode.getValueType().equals(CallTree.CallSite.class)) {
                        callSite = (CallTree.CallSite)fileScopedNode.getValue();
                        function3 = callSite.getTarget();
                        function2 = CallTreeFileSetView.this.fMode.getLabelFunction(callSite);
                    } else {
                        function2 = function3 = (Function)fileScopedNode.getValue();
                    }
                    this.fMainLabel.setText(CallTreeFileSetView.createSpecializationDisplayString(function2, this.getForeground(), CallTreeFileSetView.this.fContext.getSourceModel(), bl, false, null));
                    int n3 = n2 = function != null && callSite != null ? this.getLineFromPosition(function, callSite) : -1;
                    if (fileScopedNode.getValueType().equals(CallTree.CallSite.class)) {
                        this.fPositionLabel.setText(n2 >= 0 ? Integer.toString(n2 + 1) : "");
                        this.fPositionLabel.setForeground(bl ? this.getForeground() : LINE_NUMBER_COLOR);
                    } else if (bl2) {
                        this.fPositionLabel.setForeground(Color.LIGHT_GRAY);
                        this.fPositionLabel.setText(CoderResources.getString("wfa.sidebar.lineNumberLabel"));
                    }
                    buildErrorSeverity = this.getSeverity(function3);
                }
            }
            this.fMainLabel.setIcon(buildErrorSeverity != null ? buildErrorSeverity.getIcon() : this.getPassedIcon());
            this.postProcessRenderer(n, callSite);
            return this;
        }
    }

    public static class FileScopedCellRendererPanel
    extends MJPanel
    implements TreeCellRenderer {
        private final FileSetIntegrationContext fContext;
        private final UnifiedModel fModel;
        private final Icon fPassedIcon;
        private final Icon fFailedIcon;
        private final Icon fFolderPassedIcon;
        private final Icon fFolderFailedIcon;
        private final Map<Function, BuildErrorSeverity> fSeverities;
        private final Map<Function, BuildErrorSeverity> fResolvedSeverities;
        private final Converter<Function, Collection<Function>> fHiearchyResolver;
        private final DefaultTreeCellRenderer fDefaultsSource;

        public FileScopedCellRendererPanel(FileSetIntegrationContext fileSetIntegrationContext, Converter<Function, Collection<Function>> converter) {
            super((LayoutManager)new BorderLayout());
            this.fModel = fileSetIntegrationContext.getSourceModel();
            this.fContext = fileSetIntegrationContext;
            this.fSeverities = new HashMap<Function, BuildErrorSeverity>();
            this.fResolvedSeverities = new HashMap<Function, BuildErrorSeverity>();
            this.fHiearchyResolver = converter;
            this.fPassedIcon = CoderResources.getIcon("calltree.statusPassed.png");
            this.fFailedIcon = CoderResources.getIcon("calltree.statusFailed.png");
            this.fFolderFailedIcon = CoderResources.getIcon("calltree.folderFailed.png");
            this.fFolderPassedIcon = CoderResources.getIcon("calltree.folderPassed.png");
            this.fDefaultsSource = new DefaultTreeCellRenderer();
            this.setBuildErrors(new LinkedList<BuildError>());
        }

        protected DefaultTreeCellRenderer getDefaultsSource() {
            return this.fDefaultsSource;
        }

        public void setBuildErrors(Collection<BuildError> collection) {
            this.fSeverities.clear();
            this.fResolvedSeverities.clear();
            for (BuildError buildError : collection) {
                BuildErrorSeverity buildErrorSeverity;
                Function function = buildError.getFunction();
                if (this.fSeverities.containsKey(function) && (buildErrorSeverity = this.fSeverities.get(function)) != null && buildError.getSeverity().compareTo(buildErrorSeverity) != 1) continue;
                this.fSeverities.put(function, buildError.getSeverity());
            }
        }

        public FileSetIntegrationContext getContext() {
            return this.fContext;
        }

        public UnifiedModel getModel() {
            return this.fModel;
        }

        public BuildErrorSeverity getSeverity(Function function) {
            BuildErrorSeverity buildErrorSeverity = this.fResolvedSeverities.get(function);
            if (!this.fResolvedSeverities.containsKey(function)) {
                Collection collection = (Collection)this.fHiearchyResolver.convert((Object)function);
                if (collection != null) {
                    buildErrorSeverity = this.fSeverities.get(function);
                    for (Function function2 : collection) {
                        BuildErrorSeverity buildErrorSeverity2 = this.fSeverities.get(function2);
                        if (buildErrorSeverity2 == null || buildErrorSeverity != null && buildErrorSeverity2.compareTo(buildErrorSeverity) != 1) continue;
                        buildErrorSeverity = buildErrorSeverity2;
                    }
                }
                this.fResolvedSeverities.put(function, buildErrorSeverity);
            }
            return buildErrorSeverity;
        }

        public int getNumberOfFunctionsWithErrors() {
            return this.fSeverities.size();
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Insets insets = DefaultLookup.getInsets((JComponent)((Object)this), this.ui, "Tree.rendererMargins");
            if (insets != null) {
                this.setBorder(new EmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
            }
            this.setBackground(bl ? this.getDefaultsSource().getBackgroundSelectionColor() : this.getDefaultsSource().getBackgroundNonSelectionColor());
            this.setForeground(bl ? this.getDefaultsSource().getTextSelectionColor() : this.getDefaultsSource().getTextNonSelectionColor());
            return this;
        }

        public Icon getFailedIcon() {
            return this.fFailedIcon;
        }

        public Icon getFolderFailedIcon() {
            return this.fFolderFailedIcon;
        }

        public Icon getFolderPassedIcon() {
            return this.fFolderPassedIcon;
        }

        public Icon getPassedIcon() {
            return this.fPassedIcon;
        }
    }
}

