/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.files;

import com.mathworks.toolbox.coder.wfa.files.FileScopedNode;
import com.mathworks.toolbox.coder.wfa.files.FileSetFilter;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.widgets.grouptable.ExpansionChangeListener;
import com.mathworks.widgets.grouptable.ExpansionContext;
import com.mathworks.widgets.grouptable.ExpansionProvider;
import com.mathworks.widgets.grouptable.GroupingTable;
import com.mathworks.widgets.grouptable.GroupingTableColumn;
import com.mathworks.widgets.grouptable.GroupingTableConfiguration;
import com.mathworks.widgets.grouptable.GroupingTablePair;
import com.mathworks.widgets.grouptable.TableConfigurationSerializer;
import com.mathworks.widgets.grouptable.VerticalAttribute;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.table.TableCellRenderer;

public final class FileSetGroupingConfiguration
extends GroupingTableConfiguration<FileScopedNode> {
    private final Map<ExpansionProvider<FileScopedNode>, ExpansionProvider<FileScopedNode>> fImplToProxies;
    private final Map<String, TableCellRenderer> fRenderers = new HashMap<String, TableCellRenderer>();
    private final ParameterRunnable<GroupingTable<FileScopedNode>> fTableModifier;
    private FileSetFilter fFilter;
    private FileSetFilter.FilterContext fFilterContext;

    public FileSetGroupingConfiguration(List<GroupingTableColumn<FileScopedNode>> list, GroupingTableColumn<FileScopedNode> groupingTableColumn, List<? extends VerticalAttribute<FileScopedNode>> list2, List<GroupingTablePair<FileScopedNode>> list3, TableConfigurationSerializer<FileScopedNode> tableConfigurationSerializer, int n, ParameterRunnable<GroupingTable<FileScopedNode>> parameterRunnable) {
        super(list, groupingTableColumn, list2, list3, tableConfigurationSerializer, n);
        this.fTableModifier = parameterRunnable;
        this.fImplToProxies = new HashMap<ExpansionProvider<FileScopedNode>, ExpansionProvider<FileScopedNode>>();
        this.setFilter(null, null);
    }

    public ParameterRunnable<GroupingTable<FileScopedNode>> getTableModifier() {
        return this.fTableModifier != null ? this.fTableModifier : new ParameterRunnable<GroupingTable<FileScopedNode>>(){

            public void run(GroupingTable<FileScopedNode> groupingTable) {
            }
        };
    }

    public void setRendererOverrides(Map<GroupingTableColumn<FileScopedNode>, TableCellRenderer> map) {
        this.fRenderers.clear();
        for (Map.Entry<GroupingTableColumn<FileScopedNode>, TableCellRenderer> entry : map.entrySet()) {
            this.fRenderers.put(entry.getKey().getKey(), entry.getValue());
        }
    }

    public Map<String, TableCellRenderer> getRendererOverrides() {
        return new HashMap<String, TableCellRenderer>(this.fRenderers);
    }

    public void setFilter(FileSetFilter fileSetFilter, FileSetFilter.FilterContext filterContext) {
        this.fFilterContext = filterContext != null ? filterContext : new FileSetFilter.FilterContext(){};
        this.fFilter = fileSetFilter != null ? fileSetFilter : new FileSetFilter(){

            @Override
            public boolean acceptNode(FileScopedNode fileScopedNode, FileSetFilter.FilterContext filterContext) {
                return true;
            }
        };
    }

    private List<FileScopedNode> doFilter(List<FileScopedNode> list) {
        LinkedList<FileScopedNode> linkedList = new LinkedList<FileScopedNode>();
        for (FileScopedNode fileScopedNode : list) {
            if (!this.fFilter.acceptNode(fileScopedNode, this.fFilterContext)) continue;
            linkedList.add(fileScopedNode);
        }
        return linkedList;
    }

    public void addExpansionProvider(ExpansionProvider<FileScopedNode> expansionProvider) {
        ProxyExpansionProvider proxyExpansionProvider = new ProxyExpansionProvider(expansionProvider);
        this.fImplToProxies.put(expansionProvider, proxyExpansionProvider);
        super.addExpansionProvider((ExpansionProvider)proxyExpansionProvider);
    }

    public void removeExpansionProvider(ExpansionProvider<FileScopedNode> expansionProvider) {
        ExpansionProvider<FileScopedNode> expansionProvider2 = this.fImplToProxies.remove(expansionProvider);
        if (expansionProvider2 != null) {
            super.removeExpansionProvider(expansionProvider2);
        }
    }

    private class FilteringExpansionContext
    implements ExpansionContext<FileScopedNode> {
        private final ExpansionContext<FileScopedNode> fImpl;
        private final Object fMutex;
        private boolean fHasChildren;

        FilteringExpansionContext(ExpansionContext<FileScopedNode> expansionContext) {
            this.fImpl = expansionContext;
            this.fMutex = new Object();
        }

        public FileScopedNode getItem() {
            return (FileScopedNode)this.fImpl.getItem();
        }

        public FileScopedNode createChildPlaceholder() {
            return (FileScopedNode)this.fImpl.createChildPlaceholder();
        }

        public Icon getOpenIcon(FileScopedNode fileScopedNode) {
            return this.fImpl.getOpenIcon((Object)fileScopedNode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasChildren() {
            Object object = this.fMutex;
            synchronized (object) {
                return this.fHasChildren;
            }
        }

        public void getChildrenAsynchronously(final AsyncReceiver<FileScopedNode> asyncReceiver) {
            this.fImpl.getChildrenAsynchronously((AsyncReceiver)new AsyncReceiver<FileScopedNode>(){
                private final List<FileScopedNode> fChildren = new LinkedList<FileScopedNode>();

                public boolean receive(FileScopedNode fileScopedNode) {
                    this.fChildren.add(fileScopedNode);
                    return true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void finished() {
                    List list = FileSetGroupingConfiguration.this.doFilter(this.fChildren);
                    Iterator iterator = FilteringExpansionContext.this.fMutex;
                    synchronized (iterator) {
                        FilteringExpansionContext.this.fHasChildren = !list.isEmpty();
                    }
                    for (FileScopedNode fileScopedNode : list) {
                        asyncReceiver.receive((Object)fileScopedNode);
                    }
                    asyncReceiver.finished();
                }
            });
        }

        public void addListener(ExpansionChangeListener<FileScopedNode> expansionChangeListener) {
            this.fImpl.addListener(expansionChangeListener);
        }

        public void removeListener(ExpansionChangeListener<FileScopedNode> expansionChangeListener) {
            this.fImpl.removeListener(expansionChangeListener);
        }

        public void close() {
            this.fImpl.close();
        }

        public void refresh() {
            this.fImpl.refresh();
        }
    }

    private class ProxyExpansionProvider
    implements ExpansionProvider<FileScopedNode> {
        private final ExpansionProvider<FileScopedNode> fImpl;

        ProxyExpansionProvider(ExpansionProvider<FileScopedNode> expansionProvider) {
            this.fImpl = expansionProvider;
        }

        public ExpansionContext<FileScopedNode> openContext(FileScopedNode fileScopedNode) {
            ExpansionContext expansionContext = this.fImpl.openContext((Object)fileScopedNode);
            return expansionContext != null ? new FilteringExpansionContext((ExpansionContext<FileScopedNode>)expansionContext) : null;
        }

        public boolean equals(Object object) {
            return this.fImpl.equals(object);
        }

        public int hashCode() {
            return this.fImpl.hashCode();
        }
    }
}

