/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.files;

import com.mathworks.toolbox.coder.app.ide.SelectionEvent;
import com.mathworks.toolbox.coder.app.ide.SelectionListener;
import com.mathworks.toolbox.coder.fixedpoint.FunctionSelector;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.wfa.files.FileSetView;
import com.mathworks.toolbox.coder.wfa.files.MultiViewUtils;
import com.mathworks.util.MulticastChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FileSetViewGroup
implements FunctionSelector {
    private final List<FileSetView> fPanels = new ArrayList<FileSetView>();
    private final Map<FileSetView, SelectionListener> fChangeListenerMap;
    private final MulticastChangeListener fSelectionListeners = new MulticastChangeListener();

    public FileSetViewGroup() {
        this.fChangeListenerMap = new HashMap<FileSetView, SelectionListener>();
    }

    public void add(final FileSetView fileSetView) {
        this.fPanels.add(fileSetView);
        SelectionListener selectionListener = new SelectionListener(){

            @Override
            public void selectionChanged(SelectionEvent selectionEvent) {
                if (fileSetView.getSelectedFile() != null) {
                    for (FileSetView fileSetView2 : FileSetViewGroup.this.fPanels) {
                        if (fileSetView2.equals(fileSetView)) continue;
                        fileSetView2.clearSelection();
                    }
                }
                FileSetViewGroup.this.fSelectionListeners.stateChanged(new ChangeEvent(FileSetViewGroup.this));
            }
        };
        fileSetView.addSelectionListener(selectionListener);
        this.fChangeListenerMap.put(fileSetView, selectionListener);
    }

    public void remove(FileSetView fileSetView) {
        this.fPanels.remove(fileSetView);
        fileSetView.removeSelectionListener(this.fChangeListenerMap.remove(fileSetView));
    }

    @Override
    public void select(Function function) {
        this.select(function, new MultiViewUtils.FunctionSelectionPolicy());
    }

    public void select(File file) {
        this.select(file, new MultiViewUtils.FileSelectionPolicy());
    }

    private <T> void select(T t, MultiViewUtils.SelectionPolicy<T> selectionPolicy) {
        boolean bl = false;
        for (FileSetView fileSetView : this.fPanels) {
            if (!bl) {
                bl = selectionPolicy.select(fileSetView, t);
                if (bl) continue;
                fileSetView.clearSelection();
                continue;
            }
            fileSetView.clearSelection();
        }
    }

    public void addSelectionListener(ChangeListener changeListener) {
        this.fSelectionListeners.addChangeListener(changeListener);
    }

    public void removeChangeListeners(ChangeListener changeListener) {
        this.fSelectionListeners.removeChangeListener(changeListener);
    }

    public File getSelectedFile() {
        for (FileSetView fileSetView : this.fPanels) {
            File file = fileSetView.getSelectedFile();
            if (file == null) continue;
            return file;
        }
        return null;
    }

    public Function getSelectedFunction() {
        for (FileSetView fileSetView : this.fPanels) {
            Function function = fileSetView.getSelectedFunction();
            if (function == null) continue;
            return function;
        }
        return null;
    }
}

