/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.fixedpoint;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.CoderAppFacet;
import com.mathworks.toolbox.coder.app.EntryPointWatchService;
import com.mathworks.toolbox.coder.app.FacetAttribute;
import com.mathworks.toolbox.coder.app.GenericArtifact;
import com.mathworks.toolbox.coder.fixedpoint.ConversionModel;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapter;
import com.mathworks.toolbox.coder.model.CoderFileSupport;
import com.mathworks.toolbox.coder.wfa.CoderStepModel;
import com.mathworks.toolbox.coder.wfa.fixedpoint.FixedPointView;
import java.io.File;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.Nullable;

public final class FixedPointAppFacet
extends CoderAppFacet {
    private static final Map<FacetAttribute, Object> ATTRIBUTES = new EnumMap<FacetAttribute, Object>(FacetAttribute.class);
    private final Set<File> fOutputFiles = new TreeSet<File>();
    private ConversionModel fConversionModel;
    private FixedPointDataAdapter fDataAdapter;
    private FixedPointView fView;

    public FixedPointAppFacet() {
        super(GenericArtifact.FIXED_POINT, ATTRIBUTES);
    }

    @Override
    protected void init(CoderApp coderApp) {
        super.init(coderApp);
        coderApp.getModel().getEntryPointWatcher().addEntryPointObserver(new EntryPointWatchService.EntryPointObserverAdapter(){

            @Override
            public void entryPointAddedOrRemoved(File file, boolean bl) {
                FixedPointAppFacet.this.processEntryPointChange();
            }

            @Override
            public void entryPointInputsChanged(File file, List<String> list, List<String> list2) {
                FixedPointAppFacet.this.processEntryPointChange();
            }
        });
    }

    void bind(FixedPointView fixedPointView, FixedPointDataAdapter fixedPointDataAdapter) {
        this.fView = fixedPointView;
        this.fDataAdapter = fixedPointDataAdapter;
    }

    void updateFixedPointSourceSet() {
        assert (MJUtilities.isEventDispatchThread());
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        HashSet<String> hashSet = new HashSet<String>();
        String string = this.fDataAdapter.getGeneratedFileSuffix();
        for (File file : this.getAppModel().getInputFiles()) {
            hashSet.add(new FileLocation(file).getNameBeforeDot() + string);
        }
        for (File file : this.getAppModel().getOutputFiles()) {
            if (!CoderFileSupport.isMatlabSourceFile(file) || !hashSet.contains(new FileLocation(file).getNameBeforeDot())) continue;
            linkedHashSet.add(file);
        }
        this.getAppModel().registerFixedPointSourceSet();
        this.getAppModel().getFixedPointSourceSet().setFiles(linkedHashSet);
    }

    void setFixedPointOutput(@Nullable Set<File> set) {
        this.fOutputFiles.clear();
        if (set != null) {
            this.fOutputFiles.addAll(set);
        }
        if (this.fView != null && this.fView.isActive()) {
            this.getAppModel().setOutputFiles(this.fOutputFiles);
        }
    }

    void viewActivated() {
        this.getAppModel().setOutputFiles(this.fOutputFiles);
        this.fView.setGlobalDisable(false);
    }

    void viewDeactivated() {
        this.getAppModel().setOutputFiles(null);
    }

    private void processEntryPointChange() {
        if (this.fView == null || !this.getApp().getAdvisor().getModel().getCurrentStep().equals(CoderStepModel.CONVERT_TO_FIXED_POINT_STEP)) {
            return;
        }
        this.fView.setGlobalDisable(true);
        this.fView.showEntryPointAlteredDialog();
        this.getApp().getAdvisor().getModel().setCurrentStep(CoderStepModel.DEFINE_INPUT_TYPES_STEP, false);
    }

    static {
        ATTRIBUTES.put(FacetAttribute.SUPPORTS_GLOBALS, false);
        ATTRIBUTES.put(FacetAttribute.SUPPORTS_MULTIPLE_ENTRYPOINTS, false);
    }
}

