/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.fixedpoint;

import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.core.DropDownButton;
import com.mathworks.toolbox.coder.wfa.toolbar.ToolbarUtils;
import com.mathworks.util.ReturnRunnable;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;

public final class RunSimulationButton
extends DropDownButton {
    private final String fText;
    private final double fTextWidth;
    private final CoderApp fApp;

    public RunSimulationButton(CoderApp coderApp, Runnable runnable, ReturnRunnable<Boolean> returnRunnable) {
        this.fApp = coderApp;
        this.setShortcutAction(runnable);
        this.setReady(returnRunnable);
        this.setName("wfa.button.runSimulation");
        this.fText = CoderResources.getString("wfa.fixedpoint.runSimulation");
        this.fTextWidth = ToolbarUtils.getTextWidth(this.fText);
    }

    @Override
    public void paintMainContent(Graphics2D graphics2D) {
        graphics2D.setStroke(new BasicStroke(1.5f));
        GeneralPath generalPath = new GeneralPath();
        int n = 16;
        int n2 = 16;
        generalPath.append(new Line2D.Double(n / 3, this.getHeight() / 2 - n2 / 2, n / 3, this.getHeight() / 2 + n2 / 2), true);
        generalPath.append(new Line2D.Double(n / 3, this.getHeight() / 2 + n2 / 2, n / 3 + n, this.getHeight() / 2), true);
        generalPath.append(new Line2D.Double(n / 3 + n, this.getHeight() / 2, n / 3, this.getHeight() / 2 - n2 / 2), true);
        graphics2D.fill(generalPath);
        ToolbarUtils.drawString((Component)((Object)this), graphics2D, this.fText, n + 2 * n / 3);
    }

    @Override
    public Dimension getMainPreferredSize() {
        return new Dimension((int)(this.fTextWidth + 32.0), 24);
    }

    public String getToolTipText() {
        return ToolbarUtils.getTestButtonToolTip(this.fApp);
    }
}

