/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.fixedpoint;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.PopupBarContent;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointController;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.core.PopupBarOptionPanel;
import com.mathworks.util.ParameterRunnable;
import java.awt.Component;
import java.awt.LayoutManager;
import org.jetbrains.annotations.Nullable;

public class StaticAnalysisOptionPanel
extends PopupBarOptionPanel
implements PopupBarContent {
    private final FixedPointController fController;
    private final ParameterRunnable<Boolean> fResultHandler;

    public StaticAnalysisOptionPanel(CoderApp coderApp, FixedPointController fixedPointController, MJToggleButton mJToggleButton, @Nullable ParameterRunnable<Boolean> parameterRunnable) {
        super(mJToggleButton);
        this.fResultHandler = parameterRunnable;
        this.fController = fixedPointController;
        this.getContentPane().setLayout((LayoutManager)new FormLayout("3dlu, fill:d, 3dlu, fill:d, 6dlu, fill:d", "0dlu:grow, center:d, 0dlu:grow"));
        CellConstraints cellConstraints = new CellConstraints();
        this.getContentPane().add((Component)coderApp.createLabel(fixedPointController.getData().getStaticAnalysisTimeoutKey()), (Object)cellConstraints.xy(2, 2));
        this.getContentPane().add(coderApp.createWidget(fixedPointController.getData().getStaticAnalysisTimeoutKey()), (Object)cellConstraints.xy(4, 2));
        this.getContentPane().add(coderApp.createWidget(fixedPointController.getData().getQuickStaticAnalysisKey()), (Object)cellConstraints.xy(6, 2));
    }

    @Override
    public boolean shouldStretch() {
        return true;
    }

    @Override
    public void activate() {
        this.fController.prepareForStaticAnalysis(false);
    }

    @Override
    public String getCloseButtonText() {
        return CoderResources.getString("f2f.find.done");
    }

    @Override
    protected void runAction() {
        this.fController.runStaticAnalysis(this.fResultHandler);
    }

    @Override
    public void close() {
        super.close();
        this.fController.cancelStaticAnalysis();
    }
}

