/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.widgets;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.coder.wfa.core.Animation;
import com.mathworks.toolbox.coder.wfa.core.AnimationTrack;
import com.mathworks.toolbox.coder.wfa.core.AnimationUtils;
import com.mathworks.toolbox.coder.wfa.core.Animator;
import com.mathworks.toolbox.coder.widgets.Transitions;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.ReturnRunnable;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.plaf.LayerUI;
import org.jetbrains.annotations.Nullable;

public final class BlurPanel {
    private static final float SHRINK_RATIO = 0.4f;
    private final JLayer<EffectPanel> fLayer;
    private final EffectUI fPanelUI;
    private final EffectPanel fEffectPanel;
    private final Animator fAnimator;
    private final Collection<EventHandler> fEventHandlers;
    private boolean fEffectOngoing;
    private boolean fBlurred;

    public BlurPanel(Component component, Animator animator) {
        this.fAnimator = animator;
        this.fEffectPanel = new EffectPanel(component);
        this.fPanelUI = new ShadeEffectUI(new Color(175, 175, 175, 100));
        this.fLayer = new JLayer<EffectPanel>(this.fEffectPanel, this.fPanelUI);
        this.fEventHandlers = new LinkedList<EventHandler>();
    }

    public JComponent getComponent() {
        return this.fLayer;
    }

    public void startBlurEffect(boolean bl, @Nullable Runnable runnable, boolean bl2) {
        this.fBlurred = bl;
        this.fPanelUI.startEffect(runnable, bl, bl2);
    }

    public void startBlurEffect(boolean bl, @Nullable Runnable runnable) {
        this.startBlurEffect(bl, runnable, true);
    }

    public void startBlurEffect(boolean bl) {
        this.startBlurEffect(bl, null);
    }

    public void addEventHandler(EventHandler eventHandler) {
        this.fEventHandlers.add(eventHandler);
    }

    public void removeEventHandler(EventHandler eventHandler) {
        this.fEventHandlers.remove(eventHandler);
    }

    public void dispose() {
        this.fPanelUI.dispose();
    }

    public static abstract class EventHandler {
        public void handleMouseEvent(MouseEvent mouseEvent) {
        }

        public void handleMouseMotionEvent(MouseEvent mouseEvent) {
        }

        public void handleMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        }

        public void handleKeyEvent(KeyEvent keyEvent) {
        }
    }

    private class EffectPanel
    extends MJPanel {
        private boolean fSnapshotMode;

        EffectPanel(Component component) {
            super((LayoutManager)new BorderLayout());
            this.add(component);
        }

        void paintIntoSnapshot(Graphics graphics) {
            this.fSnapshotMode = true;
            this.paint(graphics);
            this.fSnapshotMode = false;
        }

        protected void paintComponent(Graphics graphics) {
            if (this.isPaintPanel()) {
                super.paintComponent(graphics);
            }
        }

        protected void paintChildren(Graphics graphics) {
            if (this.isPaintPanel()) {
                super.paintChildren(graphics);
            }
        }

        private boolean isPaintPanel() {
            return this.fSnapshotMode || BlurPanel.this.fPanelUI.shouldPaint();
        }
    }

    private class ShadeEffectUI
    extends EffectUI {
        private final Color fShadeColor;
        private boolean fDoShade;

        ShadeEffectUI(Color color) {
            this.fShadeColor = color;
        }

        @Override
        void onComponentChange() {
        }

        @Override
        void startEffect(Runnable runnable, boolean bl, boolean bl2) {
            this.fDoShade = bl;
            BlurPanel.this.getComponent().repaint();
            if (runnable != null) {
                runnable.run();
            }
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            super.paint(graphics, jComponent);
            if (this.fDoShade) {
                graphics.setColor(this.fShadeColor);
                graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            }
        }

        @Override
        void dispose() {
        }
    }

    private class BlurredPanelUI
    extends EffectUI {
        private BufferedImage fBlurredSnapshot;
        private BufferedImage fSnapshot;
        private BufferedImage fDrawBuffer;
        private BlurAnimation fCurrentAnimation;
        private AnimationUtils.ImageUpdater fImageUpdater;

        private BlurredPanelUI() {
        }

        @Override
        void onComponentChange() {
            if (BlurPanel.this.fEffectOngoing || BlurPanel.this.fBlurred) {
                this.createSnapshots();
            }
            if (BlurPanel.this.fBlurred) {
                this.refresh(BlurPanel.this.fBlurred, 1.0, BlurPanel.this.fEffectOngoing);
                if (!BlurPanel.this.fEffectOngoing) {
                    BlurPanel.this.fLayer.repaint();
                }
            }
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            BufferedImage bufferedImage;
            assert (BlurPanel.this.fLayer == jComponent) : "A BlurredPanelUI instance should only be used with one JLayer.";
            super.paint(graphics, jComponent);
            if (!BlurPanel.this.fEffectOngoing && BlurPanel.this.fBlurred) {
                this.createSnapshots();
                this.refresh(BlurPanel.this.fBlurred, 1.0, false);
            }
            if ((BlurPanel.this.fEffectOngoing || BlurPanel.this.fBlurred) && this.fImageUpdater != null && (bufferedImage = this.fImageUpdater.getImageBuffer()) != null) {
                graphics.drawImage(bufferedImage, 0, 0, jComponent.getWidth(), jComponent.getHeight(), null);
            }
        }

        @Override
        void startEffect(Runnable runnable, boolean bl, boolean bl2) {
            BlurPanel.this.fEffectOngoing = true;
            this.fDrawBuffer = null;
            this.fBlurredSnapshot = null;
            this.fSnapshot = null;
            this.fCurrentAnimation = new BlurAnimation(runnable, bl);
            if (bl2) {
                this.setEventInterceptionEnabled(bl);
                this.createSnapshots();
                this.refresh(bl, 0.0, false);
                BlurPanel.this.fAnimator.animate(AnimationTrack.FAST_ACCELERATING, this.fCurrentAnimation);
            } else {
                this.fCurrentAnimation.finish();
            }
        }

        private void createSnapshots() {
            this.fSnapshot = this.createSnapshot();
            this.fBlurredSnapshot = this.createBlurredSnapshot(this.fSnapshot);
            this.fDrawBuffer = new BufferedImage(this.fSnapshot.getWidth(), this.fSnapshot.getHeight(), 2);
        }

        private BufferedImage createBlurredSnapshot(BufferedImage bufferedImage) {
            BufferedImage bufferedImage2 = new BufferedImage(Math.round((float)bufferedImage.getWidth() * 0.4f), Math.round((float)bufferedImage.getHeight() * 0.4f), 2);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(bufferedImage, 0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight(), null);
            graphics2D.dispose();
            Kernel kernel = Transitions.createGaussianKernel(4, 1.1);
            ConvolveOp convolveOp = new ConvolveOp(kernel, 1, null);
            bufferedImage2 = convolveOp.filter(bufferedImage2, null);
            BufferedImage bufferedImage3 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
            graphics2D = bufferedImage3.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(bufferedImage2, 0, 0, bufferedImage3.getWidth(), bufferedImage3.getHeight(), null);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.6f));
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, bufferedImage3.getWidth(), bufferedImage3.getHeight());
            graphics2D.dispose();
            return bufferedImage3;
        }

        private void refresh(final boolean bl, final double d, boolean bl2) {
            if (bl2) {
                if (this.fImageUpdater == null) {
                    this.fImageUpdater = new AnimationUtils.ImageUpdater(new ParameterRunnable<BufferedImage>(){

                        public void run(final BufferedImage bufferedImage) {
                            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    BlurredPanelUI.this.fDrawBuffer = bufferedImage;
                                    BlurPanel.this.fLayer.repaint();
                                }
                            });
                        }
                    });
                }
                this.fImageUpdater.requestUpdate(new ReturnRunnable<BufferedImage>(){

                    public BufferedImage run() {
                        return BlurredPanelUI.this.performRefresh(bl, d);
                    }
                });
            } else {
                this.fDrawBuffer = this.performRefresh(bl, d);
            }
        }

        private BufferedImage performRefresh(boolean bl, double d) {
            BufferedImage bufferedImage = new BufferedImage(this.fSnapshot.getWidth(), this.fSnapshot.getHeight(), 2);
            Graphics2D graphics2D = AnimationUtils.configureForSpeed(bufferedImage.createGraphics());
            float f = (float)(bl ? 1.0 - d : d);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            graphics2D.drawImage((Image)this.fSnapshot, 0, 0, null);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f - f));
            graphics2D.drawImage((Image)this.fBlurredSnapshot, 0, 0, null);
            graphics2D.dispose();
            return bufferedImage;
        }

        @Override
        void dispose() {
            this.stopImageUpdaterIfNecessary();
        }

        @Override
        boolean shouldPaint() {
            return !BlurPanel.this.fEffectOngoing && !BlurPanel.this.fBlurred;
        }

        private void stopImageUpdaterIfNecessary() {
            if (!BlurPanel.this.fBlurred && !BlurPanel.this.fEffectOngoing && this.fImageUpdater != null) {
                this.fImageUpdater.stop();
                this.fImageUpdater = null;
            }
        }

        private class BlurAnimation
        implements Animation {
            private final boolean fMakeBlurry;
            private final Runnable fContinuation;

            BlurAnimation(Runnable runnable, boolean bl) {
                this.fContinuation = runnable;
                this.fMakeBlurry = bl;
            }

            @Override
            public void step(double d) {
                if (BlurredPanelUI.this.fCurrentAnimation != this) {
                    BlurredPanelUI.this.fSnapshot = null;
                    return;
                }
                if (BlurredPanelUI.this.fSnapshot == null || BlurredPanelUI.this.fSnapshot.getWidth() != BlurPanel.this.fLayer.getWidth() || BlurredPanelUI.this.fSnapshot.getHeight() != BlurPanel.this.fLayer.getHeight()) {
                    BlurredPanelUI.this.createSnapshots();
                }
                BlurredPanelUI.this.refresh(this.fMakeBlurry, d, true);
                if (d >= 1.0) {
                    this.finish();
                }
            }

            void finish() {
                BlurPanel.this.fEffectOngoing = false;
                BlurPanel.this.fLayer.getParent().revalidate();
                BlurPanel.this.fLayer.repaint();
                if (!this.fMakeBlurry) {
                    BlurredPanelUI.this.setEventInterceptionEnabled(false);
                }
                if (this.fContinuation != null) {
                    this.fContinuation.run();
                }
                BlurredPanelUI.this.fCurrentAnimation = null;
                BlurredPanelUI.this.stopImageUpdaterIfNecessary();
            }
        }
    }

    private abstract class EffectUI
    extends LayerUI<EffectPanel> {
        private final ComponentListener fComponentListener;

        EffectUI() {
            this.fComponentListener = new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent componentEvent) {
                    EffectUI.this.onComponentChange();
                }

                @Override
                public void componentMoved(ComponentEvent componentEvent) {
                    EffectUI.this.onComponentChange();
                }

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    EffectUI.this.onComponentChange();
                }

                @Override
                public void componentShown(ComponentEvent componentEvent) {
                    EffectUI.this.onComponentChange();
                }
            };
        }

        @Override
        public void installUI(JComponent jComponent) {
            super.installUI(jComponent);
            jComponent.addComponentListener(this.fComponentListener);
        }

        @Override
        public void uninstallUI(JComponent jComponent) {
            super.uninstallUI(jComponent);
            jComponent.removeComponentListener(this.fComponentListener);
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent, JLayer<? extends EffectPanel> jLayer) {
            for (EventHandler eventHandler : new LinkedList(BlurPanel.this.fEventHandlers)) {
                eventHandler.handleMouseEvent(mouseEvent);
            }
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent mouseEvent, JLayer<? extends EffectPanel> jLayer) {
            for (EventHandler eventHandler : new LinkedList(BlurPanel.this.fEventHandlers)) {
                eventHandler.handleMouseMotionEvent(mouseEvent);
            }
        }

        @Override
        protected void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent, JLayer<? extends EffectPanel> jLayer) {
            for (EventHandler eventHandler : new LinkedList(BlurPanel.this.fEventHandlers)) {
                eventHandler.handleMouseWheelEvent(mouseWheelEvent);
            }
        }

        @Override
        protected void processKeyEvent(KeyEvent keyEvent, JLayer<? extends EffectPanel> jLayer) {
            for (EventHandler eventHandler : new LinkedList(BlurPanel.this.fEventHandlers)) {
                eventHandler.handleKeyEvent(keyEvent);
            }
        }

        void setEventInterceptionEnabled(boolean bl) {
            if (bl) {
                BlurPanel.this.fLayer.setLayerEventMask(131128L);
            } else {
                BlurPanel.this.fLayer.setLayerEventMask(0L);
            }
        }

        BufferedImage createSnapshot() {
            BufferedImage bufferedImage = new BufferedImage(BlurPanel.this.fEffectPanel.getWidth(), BlurPanel.this.fEffectPanel.getHeight(), 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            BlurPanel.this.fEffectPanel.paintIntoSnapshot(graphics2D);
            graphics2D.dispose();
            return bufferedImage;
        }

        boolean shouldPaint() {
            return true;
        }

        abstract void startEffect(Runnable var1, boolean var2, boolean var3);

        abstract void dispose();

        abstract void onComponentChange();
    }
}

