/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.widgets;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.coder.widgets.CustomComboModelContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;

public final class CustomComboRenderer
extends DefaultListCellRenderer {
    private final MJPanel fPanel;
    private final MJLabel fMainLabel;
    private final MJLabel fDescriptionLabel;
    private final DefaultListCellRenderer fDelegate;
    private final JComboBox<?> fComboBox;
    private final CustomComboModelContext fModelContext;

    public CustomComboRenderer(JComboBox<?> jComboBox, CustomComboModelContext customComboModelContext) {
        this.fComboBox = jComboBox;
        this.fModelContext = customComboModelContext;
        this.fDelegate = new DefaultListCellRenderer();
        this.fMainLabel = new MJLabel();
        this.fMainLabel.setOpaque(true);
        this.fDescriptionLabel = new MJLabel();
        this.fDescriptionLabel.setOpaque(true);
        this.fDescriptionLabel.setForeground(new Color(115, 115, 115));
        this.fPanel = new MJPanel((LayoutManager)new FormLayout("3dlu, fill:p, 6dlu:grow, fill:p, 4dlu", "1dlu, fill:p, 1dlu")){

            public void paintComponent(Graphics graphics) {
                graphics.setColor(CustomComboRenderer.this.fDelegate.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }

            public Dimension getPreferredSize() {
                Dimension dimension = CustomComboRenderer.this.fMainLabel.getPreferredSize();
                Dimension dimension2 = CustomComboRenderer.this.fDescriptionLabel.getPreferredSize();
                Dimension dimension3 = new Dimension(24 + dimension.width + dimension2.width, 2 + Math.max(dimension.height, dimension2.height));
                return dimension3;
            }
        };
        CellConstraints cellConstraints = new CellConstraints();
        this.fPanel.add((Component)this.fMainLabel, (Object)cellConstraints.xy(2, 2));
        this.fPanel.add((Component)this.fDescriptionLabel, (Object)cellConstraints.xy(4, 2));
    }

    @Override
    public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
        return this.getListCellRendererComponent(jList, object, n, bl, bl2, false);
    }

    public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2, boolean bl3) {
        String string = this.fModelContext.getDescription(object);
        if (!bl3 && !this.fComboBox.isPopupVisible()) {
            Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
            this.setText(this.fModelContext.getName(object));
            this.setIcon(this.fModelContext.getIcon(object));
            return component;
        }
        this.fDelegate.getListCellRendererComponent(jList, object, n, bl, bl2);
        if (n != -1) {
            this.fMainLabel.setText(this.fModelContext.getName(object));
            this.fDescriptionLabel.setText(string != null ? string : "");
            this.fMainLabel.setOpaque(true);
            this.fPanel.setOpaque(true);
        } else {
            this.fMainLabel.setText(this.fModelContext.getShortName(object));
            this.fDescriptionLabel.setText("");
            this.fMainLabel.setOpaque(false);
            this.fPanel.setOpaque(false);
        }
        bl = bl && this.fComboBox.isPopupVisible();
        this.fMainLabel.setIcon(this.fModelContext.getIcon(object));
        this.fMainLabel.setBackground(this.fDelegate.getBackground());
        this.fMainLabel.setForeground(this.fDelegate.getForeground());
        this.fDescriptionLabel.setBackground(this.fDelegate.getBackground());
        this.fDescriptionLabel.setForeground(bl ? Color.WHITE : new Color(115, 115, 115));
        this.fPanel.setBackground(this.lock(this.fDelegate.getBackground()));
        return this.fPanel;
    }

    private Color lock(Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue());
    }
}

