/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.widgets;

import com.mathworks.mwswing.MJButton;
import com.mathworks.util.ReturnRunnable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;

public class MinimalDropDownButton
extends MJButton {
    private static final int ARROW_WIDTH = 9;
    private static final int ARROW_HEIGHT = 6;
    private final Component fHost;
    private final ReturnRunnable<Boolean> fPaintApprover;

    public MinimalDropDownButton(Component component, ReturnRunnable<Boolean> returnRunnable) {
        this.fHost = component;
        this.fPaintApprover = returnRunnable;
        this.setBorder(null);
    }

    public MinimalDropDownButton(Component component) {
        this(component, new ReturnRunnable<Boolean>(){

            public Boolean run() {
                return true;
            }
        });
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.fHost.getBackground());
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (!((Boolean)this.fPaintApprover.run()).booleanValue()) {
            return;
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.append(new Line2D.Double(this.getWidth() / 2 - 4, this.getHeight() / 2 - 3, this.getWidth() / 2 + 4, this.getHeight() / 2 - 3), true);
        generalPath.append(new Line2D.Double(this.getWidth() / 2 + 4, this.getHeight() / 2 - 3, this.getWidth() / 2, this.getHeight() / 2 + 3), true);
        generalPath.append(new Line2D.Double(this.getWidth() / 2, this.getHeight() / 2 + 3, this.getWidth() / 2 - 4, this.getHeight() / 2 - 3), true);
        graphics2D.setColor(Color.BLACK);
        graphics2D.fill(generalPath);
        graphics2D.draw(generalPath);
        graphics2D.dispose();
    }

    public Dimension getPreferredSize() {
        return new Dimension(18, 9);
    }
}

