/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.sun.jini.landlord.ConstrainableLandlordLease;
import com.sun.jini.landlord.Landlord;
import com.sun.jini.landlord.LandlordProxyVerifier;
import com.sun.jini.mahalo.TxnManager;
import com.sun.jini.mahalo.TxnMgrAdminProxy;
import com.sun.jini.mahalo.TxnMgrProxy;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.id.ReferentUuid;
import net.jini.id.Uuid;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.TrustEquivalence;

final class ProxyVerifier
implements TrustVerifier,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger("net.jini.security.trust");
    private final RemoteMethodControl serverProxy;
    private final Uuid proxyID;

    ProxyVerifier(TxnManager txnManager, Uuid uuid) {
        if (!(txnManager instanceof RemoteMethodControl)) {
            throw new UnsupportedOperationException("No verifier available for non-constrainable service");
        }
        if (!(txnManager instanceof TrustEquivalence)) {
            throw new UnsupportedOperationException("Verifier requires service proxy to implement TrustEquivalence");
        }
        if (uuid == null) {
            throw new IllegalArgumentException("Proxy id cannot be null");
        }
        this.serverProxy = (RemoteMethodControl)txnManager;
        this.proxyID = uuid;
    }

    public boolean isTrustedObject(Object object, TrustVerifier.Context context) throws RemoteException {
        RemoteMethodControl remoteMethodControl;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ProxyVerifier.class.getName(), "isTrustedObject", new Object[]{object, context});
        }
        if (object == null || context == null) {
            throw new NullPointerException("Arguments must not be null");
        }
        Uuid uuid = null;
        if (object instanceof TxnMgrProxy.ConstrainableTxnMgrProxy) {
            remoteMethodControl = (RemoteMethodControl)((TxnMgrProxy)object).backend;
            uuid = ((ReferentUuid)object).getReferentUuid();
        } else {
            if (object instanceof ConstrainableLandlordLease) {
                LandlordProxyVerifier landlordProxyVerifier = new LandlordProxyVerifier((Landlord)this.serverProxy, this.proxyID);
                return landlordProxyVerifier.isTrustedObject(object, context);
            }
            if (object instanceof TxnMgrAdminProxy.ConstrainableTxnMgrAdminProxy) {
                remoteMethodControl = (RemoteMethodControl)((TxnMgrAdminProxy)object).server;
                uuid = ((ReferentUuid)object).getReferentUuid();
            } else if (object instanceof TxnManager && object instanceof RemoteMethodControl) {
                remoteMethodControl = (RemoteMethodControl)object;
                uuid = this.proxyID;
            } else {
                logger.log(Level.FINEST, "Object {0} is not a supported type", object);
                return false;
            }
        }
        if (uuid != null && !this.proxyID.equals((Object)uuid)) {
            return false;
        }
        MethodConstraints methodConstraints = remoteMethodControl.getConstraints();
        TrustEquivalence trustEquivalence = (TrustEquivalence)this.serverProxy.setConstraints(methodConstraints);
        boolean bl = trustEquivalence.checkTrustEquivalence((Object)remoteMethodControl);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ProxyVerifier.class.getName(), "isTrustedObject", new Boolean(bl));
        }
        return bl;
    }
}

