/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.Sink;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;

public class SchemaValidator
implements Destination {
    private Configuration config;
    private boolean lax;
    private ErrorListener errorListener;
    private Destination destination;
    private QName documentElementName;
    private SchemaType documentElementType;
    private boolean expandAttributeDefaults = true;

    protected SchemaValidator(Configuration config) {
        this.config = config;
    }

    public void setLax(boolean lax) {
        this.lax = lax;
    }

    public boolean isLax() {
        return this.lax;
    }

    public void setErrorListener(ErrorListener listener) {
        this.errorListener = listener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDocumentElementName(QName name) {
        this.documentElementName = name;
    }

    public QName getDocumentElementName() {
        return this.documentElementName;
    }

    public void setDocumentElementTypeName(QName name) throws SaxonApiException {
        int fp = this.config.getNamePool().allocate("", name.getNamespaceURI(), name.getLocalName());
        this.documentElementType = this.config.getSchemaType(fp);
        if (this.documentElementType == null) {
            throw new SaxonApiException("Unknown type " + name.getClarkName());
        }
    }

    public QName getDocumentElementTypeName() {
        if (this.documentElementType == null) {
            return null;
        }
        int fp = this.documentElementType.getFingerprint();
        return new QName(new StructuredQName(this.config.getNamePool(), fp));
    }

    protected SchemaType getDocumentElementType() {
        return this.documentElementType;
    }

    public void setExpandAttributeDefaults(boolean expand) {
        this.expandAttributeDefaults = expand;
    }

    public boolean isExpandAttributeDefaults() {
        return this.expandAttributeDefaults;
    }

    public void validate(Source source) throws SaxonApiException {
        Receiver receiver = this.getReceiver(this.config, source.getSystemId());
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        try {
            new Sender(pipe).send(source, receiver, true);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public Receiver getReceiver(Configuration config) throws SaxonApiException {
        return this.getReceiver(config, null);
    }

    private Receiver getReceiver(Configuration config, String systemId) throws SaxonApiException {
        PipelineConfiguration pipe = config.makePipelineConfiguration();
        pipe.setExpandAttributeDefaults(this.expandAttributeDefaults);
        Sink output = this.destination == null ? new Sink() : this.destination.getReceiver(config);
        output.setPipelineConfiguration(pipe);
        int topLevelElement = -1;
        if (this.documentElementName != null) {
            topLevelElement = config.getNamePool().allocate("", this.documentElementName.getNamespaceURI(), this.documentElementName.getLocalName());
        }
        Receiver receiver = config.getDocumentValidator((Receiver)output, systemId, (this.lax ? 2 : 1) | 0x10000, 0, this.documentElementType, topLevelElement);
        if (this.errorListener != null) {
            pipe.setErrorListener(this.errorListener);
        }
        return receiver;
    }
}

