/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.archive.zip.commonscompress;

import com.google.inject.Inject;
import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.archive.zip.commonscompress.ZipArchiveEntryExtractor;
import com.mathworks.install.status.IOObserverAdapter;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.IOObserver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;

final class ZipArchiveEntryExtractorImpl
implements ZipArchiveEntryExtractor {
    private static final int BUF_SIZE = 2048;
    private final IO myIO;

    @Inject
    ZipArchiveEntryExtractorImpl(IO iO) {
        this.myIO = iO;
    }

    @Override
    public void extract(InputStream inputStream, ZipArchiveEntry zipArchiveEntry, File file, InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        if (!zipArchiveEntry.isDirectory()) {
            File file2 = new File(file, ZipArchiveEntryExtractorImpl.fixSlashes(zipArchiveEntry.getName()));
            for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
                installStatusObserver.addFile(file2);
            }
            if (ZipArchiveEntryExtractorImpl.isSymlink(zipArchiveEntry)) {
                byte[] byArray = new byte[2048];
                int n = inputStream.read(byArray, 0, 2048);
                if (n < 0) {
                    throw new IOException(zipArchiveEntry.getName() + ": Zip archive entry is specified as a symbolic link but does not contain a target.");
                }
                String string = new String(byArray, 0, n);
                this.myIO.createSymLink(string, file2.getAbsolutePath());
            } else {
                this.myIO.createFileFromStream(inputStream, file2, zipArchiveEntry.getTime(), ZipArchiveEntryExtractorImpl.getPermissions(zipArchiveEntry), new IOObserver[]{new IOObserverAdapter(installFlowControlHandler, installStatusObserverArray)});
            }
        }
    }

    private static int getPermissions(ZipArchiveEntry zipArchiveEntry) {
        int n = zipArchiveEntry.getUnixMode();
        return n & 0xFFF;
    }

    private static boolean isSymlink(ZipArchiveEntry zipArchiveEntry) {
        int n = zipArchiveEntry.getUnixMode();
        return (n & 0xA000) == 40960;
    }

    private static String fixSlashes(String string) {
        return string.replace('/', File.separatorChar);
    }
}

