/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.InstallOption;
import com.mathworks.install.command.Command;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.IOException;

final class LinuxSymbolicLinkCommand
implements Command {
    private final IO io;
    private final String name;
    private final InstallOption option;
    private final AppLogger logger;

    LinuxSymbolicLinkCommand(IO iO, String string, InstallOption installOption, AppLogger appLogger) {
        this.io = iO;
        this.name = string;
        this.option = installOption;
        this.logger = appLogger;
    }

    @Override
    public void execute(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        String string2 = new File(new File(file, "bin"), this.name).getAbsolutePath();
        String string3 = LinuxSymbolicLinkCommand.getLink(this.option, this.name).getAbsolutePath();
        this.logger.logMsg("Creating symbolic link: (Target: " + string2 + " Link: " + string3 + ")");
        this.createSymbolicLink(string2, string3);
    }

    @Override
    public void undo(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        File file2 = LinuxSymbolicLinkCommand.getLink(this.option, this.name);
        if (!file2.isDirectory()) {
            this.io.deleteFile(file2);
        }
    }

    private static File getLink(InstallOption installOption, String string) {
        return new File(installOption.getContext(), string);
    }

    private void createSymbolicLink(String string, String string2) throws IOException {
        this.io.createSymLink(string, string2);
    }
}

