/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.input;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.XMLParseException;
import com.mathworks.install.input.ComponentSource;
import com.mathworks.install.status.IOObserverAdapter;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.IOObserver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

final class ManifestComponentSource
implements ComponentSource {
    private final InputStream in;
    private final IO io;
    private final String installationRoot;

    ManifestComponentSource(InputStream inputStream, IO iO, String string) {
        this.in = inputStream;
        this.io = iO;
        this.installationRoot = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extract(File file, InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        try {
            Element element = ManifestComponentSource.getRootElement(this.in);
            if ("componentManifest".equalsIgnoreCase(element.getName())) {
                for (Object e : element.getChildren("file")) {
                    Element element2 = (Element)e;
                    File file2 = new File(this.installationRoot, element2.getText());
                    File file3 = new File(file, element2.getText());
                    for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
                        installStatusObserver.addFile(file3);
                    }
                    this.io.copyFile(file2, file3, new IOObserver[]{new IOObserverAdapter(installFlowControlHandler, installStatusObserverArray)});
                }
            }
        }
        catch (XMLParseException xMLParseException) {
        }
        finally {
            IOUtils.closeQuietly((InputStream)this.in);
        }
    }

    private static Element getRootElement(InputStream inputStream) throws IOException, XMLParseException {
        Document document;
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            document = sAXBuilder.build(inputStream);
        }
        catch (JDOMException jDOMException) {
            throw new XMLParseException(jDOMException);
        }
        return document.getRootElement();
    }
}

