/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.udc;

import com.google.inject.Inject;
import com.mathworks.install.udc.UdcClientTask;
import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install.udc.UsageDataCollectorKey;
import com.mathworks.instutil.FileIO;
import com.mathworks.instutil.FilePermissions;
import com.mathworks.instutil.FilePermissionsUtil;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.mlwebservices.WSEndPoints;
import com.mathworks.webservices.udc.client.UDCClient;
import com.mathworks.webservices.udc.client.installer.InstallerUdcData;
import com.mathworks.webservices.udc.client.installer.ObjectFactory;
import com.mathworks.webservices.udc.client.installer.PanelData;
import com.mathworks.webservices.udc.client.installer.ProductData;
import com.mathworks.webservices.udc.client.installer.Utils;
import com.mathworks.webservices.udc.model.Event;
import com.mathworks.webservices.udc.model.Events;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.bind.JAXBException;

public class InstallerUsageDataCollectorImpl
implements UsageDataCollector {
    private static final Class<ProductData> PRODUCT_DATA_CLASS = ProductData.class;
    private static final String DEFAULT_TOKEN = "8d12fc5b-5fe5-4643-9b52-10faf10df251";
    private static final String APPLICATION_NAME = "installer";
    private static final String APPLICATION_VERSION = "1.0";
    private static final String INSTALL_XML_DATA = "INSTALL_XML_DATA";
    private static final String CHARACTER_ENCODING = StandardCharsets.UTF_8.name();
    private static final int LOG_EVENTS_TIMEOUT = 15;
    private final Map<UsageDataCollectorKey, Object> keyValueMap = new EnumMap<UsageDataCollectorKey, Object>(UsageDataCollectorKey.class);
    private final ObjectFactory xsdObjectFactory;
    private final AppLogger appLogger;
    private final UDCClient udcClient;
    private final InstallerUdcData installerUdcDataType;
    private final List<ProductData> productDataList;
    private final List<PanelData> panelDataList;
    private final List<Event> eventList = new ArrayList<Event>();
    private boolean disableEvents;
    private String logFileFullPath;

    @Inject
    public InstallerUsageDataCollectorImpl(AppLogger appLogger, Properties properties, UDCClient uDCClient) {
        String string;
        boolean bl;
        this.appLogger = appLogger;
        this.udcClient = uDCClient;
        this.xsdObjectFactory = new ObjectFactory();
        this.installerUdcDataType = this.xsdObjectFactory.createInstallerUdcData();
        this.productDataList = this.installerUdcDataType.getProductData();
        this.panelDataList = this.installerUdcDataType.getPanelData();
        boolean bl2 = properties.getProperty("disableEvents") != null;
        Boolean bl3 = Boolean.valueOf(properties.getProperty("bat", "false"));
        if (bl2 || bl3.booleanValue()) {
            this.disableEvents = true;
        }
        boolean bl4 = bl = (string = properties.getProperty("udcLogFile")) != null && !string.isEmpty();
        if (bl && !bl2) {
            this.logFileFullPath = string;
        }
    }

    @Override
    public void addData(UsageDataCollectorKey usageDataCollectorKey, Object object) {
        if (UsageDataCollectorKey.ADD_PRODUCT_DATA == usageDataCollectorKey) {
            this.addProduct((Map)object);
        } else {
            this.keyValueMap.put(usageDataCollectorKey, object);
        }
    }

    private void addProduct(Map<UsageDataCollectorKey, Object> map) {
        ProductData productData = this.xsdObjectFactory.createProductData();
        Set<Map.Entry<UsageDataCollectorKey, Object>> set = map.entrySet();
        for (Map.Entry<UsageDataCollectorKey, Object> entry : set) {
            String string = entry.getKey().getText();
            Object object = entry.getValue();
            try {
                Method method = PRODUCT_DATA_CLASS.getMethod(string, object.getClass());
                method.invoke((Object)productData, object);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                this.logInvokeException(string, object);
            }
        }
        this.productDataList.add(productData);
    }

    private void logInvokeException(String string, Object object) {
        this.logUdcMessage("Error: Could not find method '" + string + "(" + object.getClass().getCanonicalName() + ")'");
    }

    @Override
    public void removeData(UsageDataCollectorKey usageDataCollectorKey) {
        if (UsageDataCollectorKey.CLEAR_PRODUCT_DATA == usageDataCollectorKey) {
            this.productDataList.clear();
        } else if (UsageDataCollectorKey.CLEAR_PANEL_DATA == usageDataCollectorKey) {
            this.panelDataList.clear();
        } else {
            this.keyValueMap.remove((Object)usageDataCollectorKey);
        }
    }

    @Override
    public void prepareDataForTransmission(String string) {
        this.populateXsdObject();
        this.addKeyValueEventsToList(string);
        this.addXsdEventToList(string);
    }

    private void populateXsdObject() {
        Set<UsageDataCollectorKey> set = this.keyValueMap.keySet();
        for (UsageDataCollectorKey usageDataCollectorKey : set) {
            String string = usageDataCollectorKey.getText();
            if (!string.startsWith("SessionData")) continue;
            String string2 = string.substring(string.lastIndexOf(58) + 1);
            Object object = this.keyValueMap.get((Object)usageDataCollectorKey);
            try {
                Method method = InstallerUdcData.class.getMethod(string2, object.getClass());
                method.invoke((Object)this.installerUdcDataType, object);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                this.logInvokeException(string2, object);
            }
        }
    }

    private void addKeyValueEventsToList(String string) {
        Set<UsageDataCollectorKey> set = this.keyValueMap.keySet();
        Date date = new Date();
        for (UsageDataCollectorKey usageDataCollectorKey : set) {
            String string2 = usageDataCollectorKey.getText();
            if (string2.startsWith("SessionData") || usageDataCollectorKey == UsageDataCollectorKey.TOKEN) continue;
            Event event = new Event();
            event.setEventKey(string2);
            event.setEventData(this.keyValueMap.get((Object)usageDataCollectorKey).toString());
            event.setSessionKey(string);
            event.setEventDate(date);
            event.setApplicationComponent("");
            this.eventList.add(event);
        }
    }

    private void addXsdEventToList(String string) {
        try {
            String string2 = this.marshallXsdObject(false);
            Event event = new Event();
            event.setEventKey(INSTALL_XML_DATA);
            event.setEventData(string2);
            event.setSessionKey(string);
            event.setEventDate(new Date());
            event.setApplicationComponent("");
            this.eventList.add(event);
        }
        catch (JAXBException jAXBException) {
            this.logUdcMessage("Error: " + jAXBException.getMessage());
        }
    }

    @Override
    public void transmitData() {
        this.udcClient.setApplicationName(APPLICATION_NAME);
        this.udcClient.setApplicationVersion(APPLICATION_VERSION);
        this.udcClient.setClientString("installer_1.0");
        this.udcClient.setLocale(Locale.getDefault().toString());
        this.udcClient.setEndPoint(WSEndPoints.getInstallerUDCEndPoint());
        Object object = this.keyValueMap.get((Object)UsageDataCollectorKey.TOKEN);
        String string = object == null ? DEFAULT_TOKEN : object.toString();
        this.udcClient.setToken(string);
        if (this.disableEvents) {
            this.appLogger.logMsg("Events service disabled.");
        } else {
            this.logEvents();
        }
        if (this.logFileFullPath != null) {
            this.writeUdcLogFile();
        }
    }

    @Override
    public void ping() {
        if (!this.disableEvents) {
            this.udcClient.setClientString("installer_1.0");
            this.udcClient.setEndPoint(WSEndPoints.getInstallerUDCPingEndPoint());
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().setName("UDC Ping");
                    InstallerUsageDataCollectorImpl.this.udcClient.ping();
                }
            });
        }
    }

    private String marshallXsdObject(boolean bl) throws JAXBException {
        Utils utils = new Utils();
        String string = utils.convertInstallerUdcObjToString(this.installerUdcDataType, bl);
        return string;
    }

    private void logEvents() {
        Events events = new Events();
        List list = events.getEvent();
        list.addAll(this.eventList);
        UdcClientTask udcClientTask = new UdcClientTask(this.udcClient, events);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            Exception exception = executorService.submit(udcClientTask).get(15L, TimeUnit.SECONDS);
            if (exception != null) {
                this.logUdcMessage("Events exception: " + exception);
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.logUdcMessage("Events exception: " + exception);
        }
    }

    private void writeUdcLogFile() {
        FileIO fileIO = new FileIO((FilePermissions)new FilePermissionsUtil());
        File file = new File(this.logFileFullPath);
        fileIO.createParentIfNecessary(file);
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));){
            String string = this.marshallXsdObject(true);
            bufferedOutputStream.write(string.getBytes(CHARACTER_ENCODING));
            this.writeKeyValuePairs(bufferedOutputStream);
            bufferedOutputStream.flush();
        }
        catch (IOException | JAXBException throwable) {
            this.logUdcMessage("Error: " + throwable.getMessage());
        }
    }

    private void writeKeyValuePairs(OutputStream outputStream) throws IOException {
        Set<UsageDataCollectorKey> set = this.keyValueMap.keySet();
        for (UsageDataCollectorKey usageDataCollectorKey : set) {
            String string = usageDataCollectorKey.getText();
            if (string.startsWith("SessionData")) continue;
            String string2 = usageDataCollectorKey.getText() + ":" + this.keyValueMap.get((Object)usageDataCollectorKey) + "\n";
            outputStream.write(string2.getBytes(CHARACTER_ENCODING));
        }
        if (!this.eventList.isEmpty()) {
            String string = "sessionKey:" + this.eventList.get(0).getSessionKey();
            outputStream.write(string.getBytes(CHARACTER_ENCODING));
        }
    }

    private void logUdcMessage(String string) {
        if (this.logFileFullPath != null) {
            this.appLogger.logMsg(string);
        }
    }
}

