/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma;

import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.IAppConstants;
import com.vladium.util.ClassLoaderResolver;
import com.vladium.util.IConstants;
import com.vladium.util.Property;
import com.vladium.util.Strings;
import com.vladium.util.XProperties;
import com.vladium.util.args.IOptsParser;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.util.Properties;

public abstract class Command {
    protected final String m_usageCommandName;
    protected final String[] m_args;
    protected final PrintWriter m_out;
    protected File m_propertyFile;
    protected Properties m_propertyOverrides;
    protected boolean m_exit;
    protected static final String COMMA_DELIMITERS = ", \t\r\n";
    protected static final String PATH_DELIMITERS = ",".concat(File.pathSeparator);
    protected static final String[] USAGE_OPT_NAMES = new String[]{"h", "help"};
    protected static final int STDOUT_WIDTH = 80;
    protected static final int RC_OK = 0;
    protected static final int RC_USAGE = 1;
    protected static final int RC_UNEXPECTED = 2;
    private static final Class[] PARAMETER_TYPES = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Command.class$("java.lang.String")) : class$java$lang$String, array$Ljava$lang$String == null ? (array$Ljava$lang$String = Command.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
    static /* synthetic */ Class class$com$vladium$emma$Command;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;

    public static Command create(String name, String usageName, String[] args) {
        ClassLoader loader;
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("null/empty input: name");
        }
        if (usageName == null || usageName.length() == 0) {
            throw new IllegalArgumentException("null/empty input: usageName");
        }
        try {
            loader = ClassLoaderResolver.getClassLoader();
        }
        catch (Throwable t) {
            loader = (class$com$vladium$emma$Command == null ? (class$com$vladium$emma$Command = Command.class$("com.vladium.emma.Command")) : class$com$vladium$emma$Command).getClassLoader();
        }
        return Command.instantiate(name, usageName, args, loader);
    }

    public abstract void run();

    protected Command(String usageName, String[] args) {
        this.m_usageCommandName = usageName;
        this.m_args = args != null ? (String[])args.clone() : IConstants.EMPTY_STRING_ARRAY;
        this.m_out = new PrintWriter(System.out, true);
    }

    protected abstract String usageArgsMsg();

    protected final String getCanonicalCommandName() {
        String clsName = this.getClass().getName();
        int lastDot = clsName.lastIndexOf(46);
        return clsName.substring(lastDot + 1, clsName.length() - 7);
    }

    protected final String usageMsgPrefix() {
        return this.m_usageCommandName + " usage: ";
    }

    protected final IOptsParser getOptParser(ClassLoader loader) {
        String canonicalToolName = this.getCanonicalCommandName();
        String usageResourceName = IAppConstants.APP_PACKAGE.replace('.', '/') + "/" + canonicalToolName + "/" + canonicalToolName + "_usage.res";
        return IOptsParser.Factory.create(usageResourceName, loader, this.usageMsgPrefix(), USAGE_OPT_NAMES);
    }

    protected final boolean processOpt(IOptsParser.IOpt opt) {
        String on = opt.getCanonicalName();
        if ("exit".equals(on)) {
            this.m_exit = Command.getOptionalBooleanOptValue(opt);
            return true;
        }
        if ("p".equals(on)) {
            this.m_propertyFile = new File(opt.getFirstValue());
            return true;
        }
        if ("verbose".equals(on)) {
            this.setPropertyOverride("verbosity.level", "verbose");
            return true;
        }
        if ("quiet".equals(on)) {
            this.setPropertyOverride("verbosity.level", "warning");
            return true;
        }
        if ("silent".equals(on)) {
            this.setPropertyOverride("verbosity.level", "severe");
            return true;
        }
        if ("debug".equals(on)) {
            if (opt.getValueCount() == 0) {
                this.setPropertyOverride("verbosity.level", "trace1");
            } else {
                this.setPropertyOverride("verbosity.level", opt.getFirstValue());
            }
            return true;
        }
        if ("debugcls".equals(on)) {
            this.setPropertyOverride("verbosity.filter", Strings.toListForm(Strings.merge(opt.getValues(), COMMA_DELIMITERS, true), ','));
            return true;
        }
        return false;
    }

    protected final void processCmdPropertyOverrides(IOptsParser.IOpts parsedopts) {
        IOptsParser.IOpt[] popts = parsedopts.getOpts("D");
        if (popts != null && popts.length != 0) {
            XProperties cmdOverrides = new XProperties();
            for (int o = 0; o < popts.length; ++o) {
                IOptsParser.IOpt opt = popts[o];
                String on = opt.getName().substring(opt.getPatternPrefix().length());
                cmdOverrides.setProperty(on, opt.getFirstValue());
            }
            this.m_propertyOverrides = Property.combine(this.m_propertyOverrides, cmdOverrides);
        }
    }

    protected final boolean processFilePropertyOverrides() {
        if (this.m_propertyFile != null) {
            Properties fileOverrides;
            try {
                fileOverrides = Property.getPropertiesFromFile(this.m_propertyFile);
            }
            catch (IOException ioe) {
                this.exit(true, "property override file [" + this.m_propertyFile.getAbsolutePath() + "] could not be read", ioe, 1);
                return false;
            }
            this.m_propertyOverrides = Property.combine(this.m_propertyOverrides, fileOverrides);
        }
        return true;
    }

    protected final void usageexit(String msg, IOptsParser parser, int level) {
        if (msg != null) {
            this.m_out.print(this.usageMsgPrefix());
            this.m_out.println(msg);
        }
        if (parser != null) {
            this.m_out.println();
            this.m_out.print(this.usageMsgPrefix());
            this.m_out.println(this.m_usageCommandName + " " + this.usageArgsMsg() + ",");
            this.m_out.println("  where options include:");
            this.m_out.println();
            parser.usage(this.m_out, level, 80);
        }
        this.m_out.println();
        this.exit(true, null, null, 1);
    }

    protected final void exit(boolean showBuildID, String msg, Throwable t, int rc) throws EMMARuntimeException {
        if (showBuildID) {
            this.m_out.println("[EMMA v2.1, build 13730 (unsupported private build)]");
        }
        if (msg != null) {
            this.m_out.print(this.m_usageCommandName + ": ");
            this.m_out.println(msg);
        }
        if (rc != 0) {
            if (this.m_exit) {
                if (t != null) {
                    t.printStackTrace(this.m_out);
                }
                System.exit(rc);
            } else {
                if (t instanceof EMMARuntimeException) {
                    throw (EMMARuntimeException)t;
                }
                if (t != null) {
                    throw msg != null ? new EMMARuntimeException(msg, t) : new EMMARuntimeException("unexpected failure: ", t);
                }
            }
        } else if (this.m_exit) {
            System.exit(0);
        }
    }

    protected static boolean getOptionalBooleanOptValue(IOptsParser.IOpt opt) {
        if (opt.getValueCount() == 0) {
            return true;
        }
        String v = opt.getFirstValue().toLowerCase();
        return Property.toBoolean(v);
    }

    protected static String[] getListOptValue(IOptsParser.IOpt opt, String delimiters, boolean processAtFiles) throws IOException {
        return Strings.mergeAT(opt.getValues(), delimiters, processAtFiles);
    }

    private void setPropertyOverride(String key, String value) {
        Properties propertyOverrides = this.m_propertyOverrides;
        if (propertyOverrides == null) {
            this.m_propertyOverrides = propertyOverrides = new XProperties();
        }
        propertyOverrides.setProperty(key, value);
    }

    private static Command instantiate(String name, String usageName, String[] args, ClassLoader loader) throws EMMARuntimeException {
        String clsName = IAppConstants.APP_PACKAGE + "." + name + "." + name + "Command";
        try {
            Class<?> cls = Class.forName(clsName, true, loader);
            Constructor<?> constructor = cls.getConstructor(PARAMETER_TYPES);
            Object _command = constructor.newInstance(usageName, args);
            return (Command)_command;
        }
        catch (Exception e) {
            throw new EMMARuntimeException("INVALID_COMMAND_NAME", new String[]{"EMMA", name}, e);
        }
        catch (ExceptionInInitializerError eiie) {
            throw new EMMARuntimeException("INVALID_COMMAND_NAME", new String[]{"EMMA", name}, eiie);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

