/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report.html;

import com.vladium.emma.EMMAProperties;
import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.IAppErrorCodes;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.report.AbstractReportGenerator;
import com.vladium.emma.report.AllItem;
import com.vladium.emma.report.ClassItem;
import com.vladium.emma.report.IItem;
import com.vladium.emma.report.IItemAttribute;
import com.vladium.emma.report.IItemMetadata;
import com.vladium.emma.report.ItemComparator;
import com.vladium.emma.report.MethodItem;
import com.vladium.emma.report.PackageItem;
import com.vladium.emma.report.SourcePathCache;
import com.vladium.emma.report.SrcFileItem;
import com.vladium.emma.report.html.doc.Attribute;
import com.vladium.emma.report.html.doc.ElementList;
import com.vladium.emma.report.html.doc.HTMLDocument;
import com.vladium.emma.report.html.doc.HTMLTable;
import com.vladium.emma.report.html.doc.HTMLWriter;
import com.vladium.emma.report.html.doc.HyperRef;
import com.vladium.emma.report.html.doc.IContent;
import com.vladium.emma.report.html.doc.IElement;
import com.vladium.emma.report.html.doc.Tag;
import com.vladium.emma.report.html.doc.Text;
import com.vladium.util.Descriptors;
import com.vladium.util.Files;
import com.vladium.util.IProperties;
import com.vladium.util.IntObjectMap;
import com.vladium.util.IntVector;
import com.vladium.util.ObjectIntMap;
import com.vladium.util.Property;
import com.vladium.util.asserts.$assert;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;

public final class ReportGenerator
extends AbstractReportGenerator
implements IAppErrorCodes {
    private final DecimalFormat m_format = (DecimalFormat)NumberFormat.getPercentInstance();
    private final FieldPosition m_fieldPosition = new FieldPosition(0);
    private LinkedList m_queue;
    private IDGenerator m_reportIDNamespace;
    private IContent m_pageTitle;
    private IContent m_footerBottom;
    private static final boolean USE_LINE_COVERAGE_TOOLTIPS = true;
    private static final String TYPE = "html";
    private static final String REPORT_HEADER_TITLE = "EMMA Coverage Report";
    private static final IContent LEFT_BRACKET = new Text("[", false);
    private static final IContent RIGHT_BRACKET = new Text("]", false);
    private static final int MAX_DISPLAY_NAME_LENGTH = 80;
    private static final int SRC_LINE_OFFSET = 4;
    private static final String CSS_HEADER_FOOTER = "hdft";
    private static final String CSS_TITLE = "tl";
    private static final String CSS_NAV = "nv";
    private static final String CSS_COVERAGE_ZERO = "z";
    private static final String CSS_COVERAGE_PARTIAL = "p";
    private static final String CSS_COVERAGE_COMPLETE = "c";
    private static final String DARKER_BACKGROUND = "#F0F0F0";
    private static final String TITLE_BACKGROUND = "#6699CC";
    private static final String NAV_BACKGROUND = "#6633DD";
    private static final String CSS_INVISIBLE_TABLE = "it";
    private static final String CSS_ITEM_NAME = "in";
    private static final String CSS_CLASS_ITEM_SPECIAL = "cis";
    private static final String CSS_SOURCE = "s";
    private static final String CSS_LINENUM = "l";
    private static final String CSS_BOTTOM = "bt";
    private static final String CSS_ODDROW = "o";
    private static final String CSS_BLANK = "b";
    private static final String CSS_DATA = "";
    private static final String CSS_DATA_HIGHLIGHT = "h";
    private static final String CSS_DATA_FIRST = "f";
    private static final String CSS_DATA_HIGHLIGHT_FIRST = "hf";
    private static final String CSS_HEADER = "";
    private static final String CSS_HEADER_FIRST = "f";
    private static final String CSS_CLS_NOLEFT = "cn";
    private static final String CSS = " TABLE,TD,TH {border-style:solid; border-color:black;} TD,TH {background:white;margin:0;line-height:100%;padding-left:0.5em;padding-right:0.5em;} TD {border-width:0 1px 0 0;} TH {border-width:1px 1px 1px 0;} TR TD.h {color:red;} TABLE {border-spacing:0; border-collapse:collapse;border-width:0 0 1px 1px;} P,H1,H2,H3,TH {font-family:verdana,arial,sans-serif;font-size:10pt;} TD {font-family:courier,monospace;font-size:10pt;} TABLE.hdft {border-spacing:0;border-collapse:collapse;border-style:none;} TABLE.hdft TH,TABLE.hdft TD {border-style:none;line-height:normal;} TABLE.hdft TH.tl,TABLE.hdft TD.tl {background:#6699CC;color:white;} TABLE.hdft TD.nv {background:#6633DD;color:white;} .nv A:link {color:white;} .nv A:visited {color:white;} .nv A:active {color:yellow;} TABLE.hdft A:link {color:white;} TABLE.hdft A:visited {color:white;} TABLE.hdft A:active {color:yellow;} .in {color:#356085;} TABLE.s TD {padding-left:0.25em;padding-right:0.25em;} TABLE.s TD.l {padding-left:0.25em;padding-right:0.25em;text-align:right;background:#F0F0F0;} TABLE.s TR.z TD {background:#FF9999;} TABLE.s TR.p TD {background:#FFFF88;} TABLE.s TR.c TD {background:#CCFFCC;} A:link {color:#0000EE;text-decoration:none;} A:visited {color:#0000EE;text-decoration:none;} A:hover {color:#0000EE;text-decoration:underline;} TABLE.cn {border-width:0 0 1px 0;} TABLE.s {border-width:1px 0 1px 1px;} TD.h {color:red;border-width:0 1px 0 0;} TD.f {border-width:0 1px 0 1px;} TD.hf {color:red;border-width:0 1px 0 1px;} TH.f {border-width:1px 1px 1px 1px;} TR.cis TD {background:#F0F0F0;} TR.cis TD {border-width:1px 1px 1px 0;} TR.cis TD.h {color:red;border-width:1px 1px 1px 0;} TR.cis TD.f {border-width:1px 1px 1px 1px;} TR.cis TD.hf {color:red;border-width:1px 1px 1px 1px;} TD.b {border-style:none;background:transparent;line-height:50%;}  TD.bt {border-width:1px 0 0 0;background:transparent;line-height:50%;} TR.o TD {background:#F0F0F0;}TABLE.it {border-style:none;}TABLE.it TD,TABLE.it TH {border-style:none;}";
    private static final String NESTED_ITEMS_PARENT_DIRNAME = "_files";
    private static final File NESTED_ITEMS_PARENT_DIR = new File("_files");
    private static final int[][] NESTING;
    private static final String FILE_EXTENSION = ".html";
    private static final int IO_BUF_SIZE = 32768;
    private static final long[] ATTRIBUTE_SETS;

    public ReportGenerator() {
        this.m_format.setMaximumFractionDigits(0);
    }

    public final String getType() {
        return TYPE;
    }

    public void process(IMetaData mdata, ICoverageData cdata, SourcePathCache cache, IProperties properties) throws EMMARuntimeException {
        this.initialize(mdata, cdata, cache, properties);
        this.m_pageTitle = null;
        this.m_footerBottom = null;
        File outDir = this.m_settings.getOutDir();
        if (outDir == null || outDir.equals(new File(Property.getSystemProperty("user.dir", "")))) {
            outDir = new File("coverage");
            this.m_settings.setOutDir(outDir);
        }
        long start = 0L;
        boolean trace1 = this.m_log.atTRACE1();
        if (trace1) {
            start = System.currentTimeMillis();
        }
        this.m_queue = new LinkedList();
        this.m_reportIDNamespace = new IDGenerator(mdata.size());
        this.m_queue.add(this.m_view.getRoot());
        while (!this.m_queue.isEmpty()) {
            IItem head = (IItem)this.m_queue.removeFirst();
            head.accept(this, null);
        }
        this.m_reportIDNamespace = null;
        if (trace1) {
            long end = System.currentTimeMillis();
            this.m_log.trace1("process", "[" + this.getType() + "] report generated in " + (end - start) + " ms");
        }
    }

    public void cleanup() {
        this.m_queue = null;
        this.m_reportIDNamespace = null;
        super.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(AllItem item, Object ctx) {
        HTMLWriter out = null;
        try {
            File outFile = this.m_settings.getOutFile();
            if (outFile == null) {
                outFile = new File("index".concat(FILE_EXTENSION));
                this.m_settings.setOutFile(outFile);
            }
            File fullOutFile = Files.newFile(this.m_settings.getOutDir(), outFile);
            this.m_log.info("writing [" + this.getType() + "] report to [" + fullOutFile.getAbsolutePath() + "] ...");
            out = ReportGenerator.openOutFile(fullOutFile, this.m_settings.getOutEncoding(), true);
            int[] columns = this.m_settings.getColumnOrder();
            StringBuffer buf = new StringBuffer();
            StringBuffer _title = new StringBuffer(REPORT_HEADER_TITLE);
            _title.append(" (generated ");
            _title.append(new Date(EMMAProperties.getTimeStamp()));
            _title.append(')');
            String title = _title.toString();
            HTMLDocument page = this.createPage(title);
            IItem[] path = this.getParentPath(item);
            this.addPageHeader(page, item, path);
            this.addPageFooter(page, item, path);
            page.addH(1, "OVERALL COVERAGE SUMMARY", null);
            HTMLTable summaryTable = new HTMLTable("100%", null, null, "0");
            HTMLTable.IRow header = summaryTable.newTitleRow();
            HTMLTable.IRow coverage = summaryTable.newRow();
            for (int c = 0; c < columns.length; ++c) {
                int attrID = columns[c];
                IItemAttribute attr = item.getAttribute(attrID, this.m_settings.getUnitsType());
                HTMLTable.ICell headercell = header.newCell();
                headercell.setText(attr.getName(), true);
                if (attr == null) continue;
                boolean fail = this.m_metrics[attrID] > 0 && !attr.passes(item, this.m_metrics[attrID]);
                buf.setLength(0);
                attr.format(item, buf);
                HTMLTable.ICell cell = coverage.newCell();
                cell.setText(buf.toString(), true);
                if (!fail) continue;
                cell.setClass(CSS_DATA_HIGHLIGHT);
            }
            page.add(summaryTable);
            page.addH(2, "OVERALL STATS SUMMARY", null);
            HTMLTable statsTable = new HTMLTable(null, null, null, "0");
            statsTable.setClass(CSS_INVISIBLE_TABLE);
            HTMLTable.IRow row = statsTable.newRow();
            row.newCell().setText("total packages:", true);
            row.newCell().setText("" + item.getChildCount(), false);
            if (this.m_srcView && this.m_hasSrcFileInfo) {
                row = statsTable.newRow();
                row.newCell().setText("total executable files:", true);
                row.newCell().setText("" + item.getAggregate(12), false);
            }
            row = statsTable.newRow();
            row.newCell().setText("total classes:", true);
            row.newCell().setText("" + item.getAggregate(11), true);
            row = statsTable.newRow();
            row.newCell().setText("total methods:", true);
            row.newCell().setText("" + item.getAggregate(10), true);
            if (this.m_srcView && this.m_hasSrcFileInfo && this.m_hasLineNumberInfo) {
                row = statsTable.newRow();
                row.newCell().setText("total executable lines:", true);
                row.newCell().setText("" + item.getAggregate(7), true);
            }
            page.add(statsTable);
            boolean deeper = this.m_settings.getDepth() > item.getMetadata().getTypeID();
            page.addH(2, "COVERAGE BREAKDOWN BY PACKAGE", null);
            HTMLTable childSummaryTable = new HTMLTable("100%", null, null, "0");
            int[] headerColumns = null;
            boolean odd = true;
            ItemComparator order = this.m_typeSortComparators[PackageItem.getTypeMetadata().getTypeID()];
            Iterator packages = item.getChildren(order);
            while (packages.hasNext()) {
                IItem pkg = (IItem)packages.next();
                if (headerColumns == null) {
                    headerColumns = this.addHeaderRow(pkg, childSummaryTable, columns);
                }
                String childHREF = null;
                if (deeper) {
                    childHREF = this.getItemHREF(item, pkg);
                }
                this.addItemRow(pkg, odd, childSummaryTable, headerColumns, childHREF, false);
                if (deeper) {
                    this.m_queue.addLast(pkg);
                }
                odd = !odd;
            }
            page.add(childSummaryTable);
            page.emit(out);
            out.flush();
            Object var21_25 = null;
            if (out != null) {
                out.close();
            }
            out = null;
        }
        catch (Throwable throwable) {
            Object var21_26 = null;
            if (out != null) {
                out.close();
            }
            out = null;
            throw throwable;
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(PackageItem item, Object ctx) {
        HTMLWriter out = null;
        try {
            if (this.m_verbose) {
                this.m_log.verbose("  report: processing package [" + item.getName() + "] ...");
            }
            File outFile = ReportGenerator.getItemFile(NESTED_ITEMS_PARENT_DIR, this.m_reportIDNamespace.getID(ReportGenerator.getItemKey(item)));
            out = ReportGenerator.openOutFile(Files.newFile(this.m_settings.getOutDir(), outFile), this.m_settings.getOutEncoding(), true);
            int[] columns = this.m_settings.getColumnOrder();
            StringBuffer buf = new StringBuffer();
            HTMLDocument page = this.createPage(REPORT_HEADER_TITLE);
            IItem[] path = this.getParentPath(item);
            this.addPageHeader(page, item, path);
            this.addPageFooter(page, item, path);
            IElement itemname = IElement.Factory.create(Tag.SPAN);
            itemname.setText(item.getName(), true);
            itemname.setClass(CSS_ITEM_NAME);
            ElementList title = new ElementList();
            title.add(new Text("COVERAGE SUMMARY FOR PACKAGE [", true));
            title.add(itemname);
            title.add(new Text("]", true));
            page.addH(1, title, null);
            HTMLTable summaryTable = new HTMLTable("100%", null, null, "0");
            HTMLTable.IRow header = summaryTable.newTitleRow();
            HTMLTable.IRow coverage = summaryTable.newRow();
            for (int c = 0; c < columns.length; ++c) {
                int attrID = columns[c];
                IItemAttribute attr = item.getAttribute(attrID, this.m_settings.getUnitsType());
                HTMLTable.ICell headercell = header.newCell();
                headercell.setText(attr.getName(), true);
                if (attr == null) continue;
                boolean fail = this.m_metrics[attrID] > 0 && !attr.passes(item, this.m_metrics[attrID]);
                buf.setLength(0);
                attr.format(item, buf);
                HTMLTable.ICell cell = coverage.newCell();
                cell.setText(buf.toString(), true);
                if (!fail) continue;
                cell.setClass(CSS_DATA_HIGHLIGHT);
            }
            page.add(summaryTable);
            boolean deeper = this.m_settings.getDepth() > item.getMetadata().getTypeID();
            String summaryTitle = this.m_srcView ? "COVERAGE BREAKDOWN BY SOURCE FILE" : "COVERAGE BREAKDOWN BY CLASS";
            page.addH(2, summaryTitle, null);
            HTMLTable childSummaryTable = new HTMLTable("100%", null, null, "0");
            int[] headerColumns = null;
            boolean odd = true;
            ItemComparator order = this.m_typeSortComparators[this.m_srcView ? SrcFileItem.getTypeMetadata().getTypeID() : ClassItem.getTypeMetadata().getTypeID()];
            Iterator srcORclsFiles = item.getChildren(order);
            while (srcORclsFiles.hasNext()) {
                IItem srcORcls = (IItem)srcORclsFiles.next();
                if (headerColumns == null) {
                    headerColumns = this.addHeaderRow(srcORcls, childSummaryTable, columns);
                }
                String childHREF = null;
                if (deeper) {
                    childHREF = this.getItemHREF(item, srcORcls);
                }
                this.addItemRow(srcORcls, odd, childSummaryTable, headerColumns, childHREF, false);
                if (deeper) {
                    this.m_queue.addLast(srcORcls);
                }
                odd = !odd;
            }
            page.add(childSummaryTable);
            page.emit(out);
            out.flush();
            Object var19_23 = null;
            if (out != null) {
                out.close();
            }
            out = null;
        }
        catch (Throwable throwable) {
            Object var19_24 = null;
            if (out != null) {
                out.close();
            }
            out = null;
            throw throwable;
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(SrcFileItem item, Object ctx) {
        HTMLWriter out = null;
        try {
            File outFile = ReportGenerator.getItemFile(NESTED_ITEMS_PARENT_DIR, this.m_reportIDNamespace.getID(ReportGenerator.getItemKey(item)));
            out = ReportGenerator.openOutFile(Files.newFile(this.m_settings.getOutDir(), outFile), this.m_settings.getOutEncoding(), true);
            int[] columns = this.m_settings.getColumnOrder();
            StringBuffer buf = new StringBuffer();
            HTMLDocument page = this.createPage(REPORT_HEADER_TITLE);
            IItem[] path = this.getParentPath(item);
            this.addPageHeader(page, item, path);
            this.addPageFooter(page, item, path);
            IElement itemname = IElement.Factory.create(Tag.SPAN);
            itemname.setText(item.getName(), true);
            itemname.setClass(CSS_ITEM_NAME);
            ElementList title = new ElementList();
            title.add(new Text("COVERAGE SUMMARY FOR SOURCE FILE [", true));
            title.add(itemname);
            title.add(new Text("]", true));
            page.addH(1, title, null);
            HTMLTable summaryTable = new HTMLTable("100%", null, null, "0");
            HTMLTable.IRow header = summaryTable.newTitleRow();
            HTMLTable.IRow coverage = summaryTable.newRow();
            for (int c = 0; c < columns.length; ++c) {
                int attrID = columns[c];
                IItemAttribute attr = item.getAttribute(attrID, this.m_settings.getUnitsType());
                HTMLTable.ICell headercell = header.newCell();
                headercell.setText(attr.getName(), true);
                if (attr == null) continue;
                boolean fail = this.m_metrics[attrID] > 0 && !attr.passes(item, this.m_metrics[attrID]);
                buf.setLength(0);
                attr.format(item, buf);
                HTMLTable.ICell cell = coverage.newCell();
                cell.setText(buf.toString(), true);
                if (!fail) continue;
                cell.setClass(CSS_DATA_HIGHLIGHT);
            }
            page.add(summaryTable);
            boolean deeper = this.m_settings.getDepth() > ClassItem.getTypeMetadata().getTypeID();
            boolean embedSrcFile = deeper && this.srcFileAvailable(item, this.m_cache);
            boolean createAnchors = embedSrcFile && this.m_hasLineNumberInfo;
            IDGenerator pageIDNamespace = createAnchors ? new IDGenerator() : null;
            page.addH(2, "COVERAGE BREAKDOWN BY CLASS AND METHOD", null);
            IntObjectMap lineAnchorIDMap = embedSrcFile ? new IntObjectMap() : null;
            HTMLTable childSummaryTable = new HTMLTable("100%", null, null, "0");
            childSummaryTable.setClass(CSS_CLS_NOLEFT);
            int[] headerColumns = null;
            ItemComparator order = this.m_typeSortComparators[ClassItem.getTypeMetadata().getTypeID()];
            int clsIndex = 0;
            Iterator classes = item.getChildren(order);
            while (classes.hasNext()) {
                ClassItem cls = (ClassItem)classes.next();
                if (headerColumns == null) {
                    headerColumns = this.addHeaderRow(cls, childSummaryTable, columns);
                }
                String HREFname = null;
                if (createAnchors) {
                    String childKey = ReportGenerator.getItemKey(cls);
                    HREFname = ReportGenerator.addLineAnchorID(cls.getFirstLine(), pageIDNamespace.getID(childKey), lineAnchorIDMap);
                }
                this.addClassRow(cls, clsIndex, childSummaryTable, headerColumns, HREFname, createAnchors);
                boolean odd = false;
                ItemComparator order2 = this.m_typeSortComparators[MethodItem.getTypeMetadata().getTypeID()];
                Iterator methods = cls.getChildren(order2);
                while (methods.hasNext()) {
                    MethodItem method = (MethodItem)methods.next();
                    HREFname = null;
                    if (createAnchors) {
                        String child2Key = ReportGenerator.getItemKey(method);
                        HREFname = ReportGenerator.addLineAnchorID(method.getFirstLine(), pageIDNamespace.getID(child2Key), lineAnchorIDMap);
                    }
                    this.addClassItemRow(method, odd, childSummaryTable, headerColumns, HREFname, createAnchors);
                    odd = !odd;
                }
                ++clsIndex;
            }
            page.add(childSummaryTable);
            if (deeper) {
                page.addEmptyP();
                this.embedSrcFile(item, page, lineAnchorIDMap, this.m_cache);
            }
            page.emit(out);
            out.flush();
            Object var27_31 = null;
            if (out != null) {
                out.close();
            }
            out = null;
        }
        catch (Throwable throwable) {
            Object var27_32 = null;
            if (out != null) {
                out.close();
            }
            out = null;
            throw throwable;
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(ClassItem item, Object ctx) {
        HTMLWriter out = null;
        try {
            File outFile = ReportGenerator.getItemFile(NESTED_ITEMS_PARENT_DIR, this.m_reportIDNamespace.getID(ReportGenerator.getItemKey(item)));
            out = ReportGenerator.openOutFile(Files.newFile(this.m_settings.getOutDir(), outFile), this.m_settings.getOutEncoding(), true);
            int[] columns = this.m_settings.getColumnOrder();
            StringBuffer buf = new StringBuffer();
            HTMLDocument page = this.createPage(REPORT_HEADER_TITLE);
            IItem[] path = this.getParentPath(item);
            this.addPageHeader(page, item, path);
            this.addPageFooter(page, item, path);
            IElement itemname = IElement.Factory.create(Tag.SPAN);
            itemname.setText(item.getName(), true);
            itemname.setClass(CSS_ITEM_NAME);
            ElementList title = new ElementList();
            title.add(new Text("COVERAGE SUMMARY FOR CLASS [", true));
            title.add(itemname);
            title.add(new Text("]", true));
            page.addH(1, title, null);
            HTMLTable summaryTable = new HTMLTable("100%", null, null, "0");
            HTMLTable.IRow header = summaryTable.newTitleRow();
            HTMLTable.IRow coverage = summaryTable.newRow();
            for (int c = 0; c < columns.length; ++c) {
                int attrID = columns[c];
                IItemAttribute attr = item.getAttribute(attrID, this.m_settings.getUnitsType());
                HTMLTable.ICell headercell = header.newCell();
                headercell.setText(attr.getName(), true);
                if (attr == null) continue;
                boolean fail = this.m_metrics[attrID] > 0 && !attr.passes(item, this.m_metrics[attrID]);
                buf.setLength(0);
                attr.format(item, buf);
                HTMLTable.ICell cell = coverage.newCell();
                cell.setText(buf.toString(), true);
                if (!fail) continue;
                cell.setClass(CSS_DATA_HIGHLIGHT);
            }
            page.add(summaryTable);
            page.addH(2, "COVERAGE BREAKDOWN BY METHOD", null);
            HTMLTable childSummaryTable = new HTMLTable("100%", null, null, "0");
            int[] headerColumns = null;
            boolean odd = true;
            ItemComparator order = this.m_typeSortComparators[MethodItem.getTypeMetadata().getTypeID()];
            Iterator methods = item.getChildren(order);
            while (methods.hasNext()) {
                MethodItem method = (MethodItem)methods.next();
                if (headerColumns == null) {
                    headerColumns = this.addHeaderRow(method, childSummaryTable, columns);
                }
                this.addItemRow(method, odd, childSummaryTable, headerColumns, null, false);
                odd = !odd;
            }
            page.add(childSummaryTable);
            page.emit(out);
            out.flush();
            Object var18_18 = null;
            if (out != null) {
                out.close();
            }
            out = null;
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            if (out != null) {
                out.close();
            }
            out = null;
            throw throwable;
        }
        return ctx;
    }

    private HTMLDocument createPage(String title) {
        HTMLDocument page = new HTMLDocument(title, this.m_settings.getOutEncoding());
        page.addStyle(CSS);
        return page;
    }

    private IElement addPageHeader(HTMLDocument page, IItem item, IItem[] path) {
        HTMLTable header = new HTMLTable("100%", null, null, "0");
        header.setClass(CSS_HEADER_FOOTER);
        this.addPageHeaderTitleRow(header);
        HTMLTable.IRow navRow = header.newRow();
        HTMLTable.ICell cell = navRow.newCell();
        cell.setClass(CSS_NAV);
        int lLimit = path.length > 1 ? path.length - 1 : path.length;
        for (int l = 0; l < lLimit; ++l) {
            cell.add(LEFT_BRACKET);
            String name = path[l].getName();
            String HREF = this.getItemHREF(item, path[l]);
            cell.add(new HyperRef(HREF, name, true));
            cell.add(RIGHT_BRACKET);
        }
        page.setHeader(header);
        return header;
    }

    private IElement addPageFooter(HTMLDocument page, IItem item, IItem[] path) {
        HTMLTable footerTable = new HTMLTable("100%", null, null, "0");
        footerTable.setClass(CSS_HEADER_FOOTER);
        HTMLTable.IRow navRow = footerTable.newRow();
        HTMLTable.ICell cell = navRow.newCell();
        cell.setClass(CSS_NAV);
        int lLimit = path.length > 1 ? path.length - 1 : path.length;
        for (int l = 0; l < lLimit; ++l) {
            cell.add(LEFT_BRACKET);
            String name = path[l].getName();
            String HREF = this.getItemHREF(item, path[l]);
            cell.add(new HyperRef(HREF, name, true));
            cell.add(RIGHT_BRACKET);
        }
        HTMLTable.IRow titleRow = footerTable.newRow();
        cell = titleRow.newCell();
        cell.setClass(CSS_TITLE);
        cell.add(this.getFooterBottom());
        ElementList footer = new ElementList();
        footer.add(IElement.Factory.create(Tag.P));
        footer.add(footerTable);
        page.setFooter(footer);
        return footerTable;
    }

    private int[] addHeaderRow(IItem item, HTMLTable table, int[] columns) {
        HTMLTable.IRow header = table.newTitleRow();
        IntVector headerColumns = new IntVector(columns.length);
        for (int c = 0; c < columns.length; ++c) {
            int attrID = columns[c];
            IItemAttribute attr = item.getAttribute(attrID, this.m_settings.getUnitsType());
            if (attr == null) continue;
            HTMLTable.ICell cell = header.newCell();
            cell.setText(attr.getName(), true);
            cell.setClass(ReportGenerator.headerCellStyle(c));
            headerColumns.add(attrID);
        }
        return headerColumns.values();
    }

    private void addItemRow(IItem item, boolean odd, HTMLTable table, int[] columns, String nameHREF, boolean anchor) {
        HTMLTable.IRow row = table.newRow();
        if (odd) {
            row.setClass(CSS_ODDROW);
        }
        StringBuffer buf = new StringBuffer(11);
        for (int c = 0; c < columns.length; ++c) {
            HTMLTable.ICell cell;
            int attrID = columns[c];
            IItemAttribute attr = item.getAttribute(attrID, this.m_settings.getUnitsType());
            if (attr != null) {
                cell = row.newCell();
                if (nameHREF != null && attrID == 0) {
                    buf.setLength(0);
                    attr.format(item, buf);
                    ReportGenerator.trimForDisplay(buf);
                    String fullHREFName = anchor ? "#".concat(nameHREF) : nameHREF;
                    cell.add(new HyperRef(fullHREFName, buf.toString(), true));
                    continue;
                }
                boolean fail = this.m_metrics[attrID] > 0 && !attr.passes(item, this.m_metrics[attrID]);
                buf.setLength(0);
                attr.format(item, buf);
                ReportGenerator.trimForDisplay(buf);
                cell.setText(buf.toString(), true);
                if (!fail) continue;
                cell.setClass(CSS_DATA_HIGHLIGHT);
                continue;
            }
            cell = row.newCell();
            cell.setText(" ", true);
        }
    }

    private void addClassRow(ClassItem item, int clsIndex, HTMLTable table, int[] columns, String itemHREF, boolean isAnchor) {
        HTMLTable.IRow blank = table.newRow();
        HTMLTable.IRow row = table.newRow();
        row.setClass(CSS_CLASS_ITEM_SPECIAL);
        StringBuffer buf = new StringBuffer(11);
        for (int c = 0; c < columns.length; ++c) {
            int attrID = columns[c];
            IItemAttribute attr = item.getAttribute(attrID, this.m_settings.getUnitsType());
            if (attr != null) {
                buf.setLength(0);
                attr.format(item, buf);
                HTMLTable.ICell blankcell = blank.newCell();
                blankcell.setClass(clsIndex == 0 ? CSS_BLANK : CSS_BOTTOM);
                blankcell.setText(" ", true);
                HTMLTable.ICell cell = row.newCell();
                boolean fail = false;
                if (attrID == 0) {
                    if (itemHREF != null) {
                        String fullItemHREF = isAnchor ? "#".concat(itemHREF) : itemHREF;
                        cell.add(new Text("class ", true));
                        cell.add(new HyperRef(fullItemHREF, buf.toString(), true));
                    } else {
                        cell.setText("class " + buf.toString(), true);
                    }
                } else {
                    fail = this.m_metrics[attrID] > 0 && !attr.passes(item, this.m_metrics[attrID]);
                    cell.setText(buf.toString(), true);
                }
                cell.setClass(ReportGenerator.dataCellStyle(c, fail));
                continue;
            }
            HTMLTable.ICell cell = row.newCell();
            cell.setText(" ", true);
            cell.setClass(ReportGenerator.dataCellStyle(c, false));
        }
    }

    private void addClassItemRow(IItem item, boolean odd, HTMLTable table, int[] columns, String nameHREF, boolean anchor) {
        HTMLTable.IRow row = table.newRow();
        if (odd) {
            row.setClass(CSS_ODDROW);
        }
        StringBuffer buf = new StringBuffer(11);
        for (int c = 0; c < columns.length; ++c) {
            HTMLTable.ICell cell;
            int attrID = columns[c];
            IItemAttribute attr = item.getAttribute(attrID, this.m_settings.getUnitsType());
            if (attr != null) {
                cell = row.newCell();
                boolean fail = false;
                if (nameHREF != null && attrID == 0) {
                    buf.setLength(0);
                    attr.format(item, buf);
                    ReportGenerator.trimForDisplay(buf);
                    String fullHREFName = anchor ? "#".concat(nameHREF) : nameHREF;
                    cell.add(new HyperRef(fullHREFName, buf.toString(), true));
                } else {
                    fail = this.m_metrics[attrID] > 0 && !attr.passes(item, this.m_metrics[attrID]);
                    buf.setLength(0);
                    attr.format(item, buf);
                    ReportGenerator.trimForDisplay(buf);
                    cell.setText(buf.toString(), true);
                }
                cell.setClass(ReportGenerator.dataCellStyle(c, fail));
                continue;
            }
            cell = row.newCell();
            cell.setText(" ", true);
            cell.setClass(ReportGenerator.dataCellStyle(c, false));
        }
    }

    private boolean srcFileAvailable(SrcFileItem item, SourcePathCache cache) {
        if (cache == null) {
            return false;
        }
        String fileName = item.getName();
        String packageVMName = ((PackageItem)item.getParent()).getVMName();
        return cache.find(packageVMName, fileName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void embedSrcFile(SrcFileItem item, HTMLDocument page, IntObjectMap anchorMap, SourcePathCache cache) {
        HTMLTable srcTable;
        boolean success;
        String packageVMName;
        String fileName;
        block30: {
            fileName = item.getName();
            packageVMName = ((PackageItem)item.getParent()).getVMName();
            success = false;
            srcTable = new HTMLTable("100%", null, null, "0");
            if (cache != null) {
                srcTable.setClass(CSS_SOURCE);
                File srcFile = cache.find(packageVMName, fileName);
                if (srcFile != null) {
                    BufferedReader in;
                    block29: {
                        String line;
                        in = null;
                        in = new BufferedReader(new FileReader(srcFile), 32768);
                        boolean markupCoverage = this.m_hasLineNumberInfo;
                        int unitsType = this.m_settings.getUnitsType();
                        IntObjectMap lineCoverageMap = null;
                        StringBuffer tooltipBuffer = null;
                        if (markupCoverage) {
                            lineCoverageMap = item.getLineCoverage();
                            $assert.ASSERT(lineCoverageMap != null, "null: lineCoverageMap");
                            tooltipBuffer = new StringBuffer(64);
                        }
                        int l = 1;
                        while ((line = in.readLine()) != null) {
                            SrcFileItem.LineCoverageData lCoverageData;
                            HTMLTable.IRow srcline = srcTable.newRow();
                            HTMLTable.ICell lineNumCell = srcline.newCell();
                            lineNumCell.setClass(CSS_LINENUM);
                            if (anchorMap != null) {
                                int adjustedl = l < 4 ? l : l + 4;
                                String anchor = (String)anchorMap.get(adjustedl);
                                if (anchor != null) {
                                    IElement a = IElement.Factory.create(Tag.A);
                                    a.getAttributes().set(Attribute.NAME, anchor);
                                    a.setText(Integer.toString(l), true);
                                    lineNumCell.add(a);
                                } else {
                                    lineNumCell.setText(Integer.toString(l), true);
                                }
                            } else {
                                lineNumCell.setText(Integer.toString(l), true);
                            }
                            HTMLTable.ICell lineTxtCell = srcline.newCell();
                            lineTxtCell.setText(line.length() > 0 ? line : " ", true);
                            if (markupCoverage && (lCoverageData = (SrcFileItem.LineCoverageData)lineCoverageMap.get(l)) != null) {
                                switch (lCoverageData.m_coverageStatus) {
                                    case 0: {
                                        srcline.setClass(CSS_COVERAGE_ZERO);
                                        break;
                                    }
                                    case 1: {
                                        srcline.setClass(CSS_COVERAGE_PARTIAL);
                                        tooltipBuffer.setLength(0);
                                        int[] coverageRatio = lCoverageData.m_coverageRatio[unitsType];
                                        int d = coverageRatio[0];
                                        int n = coverageRatio[1];
                                        this.m_format.format((double)n / (double)d, tooltipBuffer, this.m_fieldPosition);
                                        tooltipBuffer.append(" line coverage (");
                                        tooltipBuffer.append(n);
                                        tooltipBuffer.append(" out of ");
                                        tooltipBuffer.append(d);
                                        switch (unitsType) {
                                            case 0: {
                                                tooltipBuffer.append(" basic blocks)");
                                                break;
                                            }
                                            case 1: {
                                                tooltipBuffer.append(" instructions)");
                                            }
                                        }
                                        lineNumCell.getAttributes().set(Attribute.TITLE, tooltipBuffer.toString());
                                        lineTxtCell.getAttributes().set(Attribute.TITLE, tooltipBuffer.toString());
                                        break;
                                    }
                                    case 2: {
                                        srcline.setClass(CSS_COVERAGE_COMPLETE);
                                        break;
                                    }
                                    default: {
                                        $assert.ASSERT(false, "invalid line coverage status: " + lCoverageData.m_coverageStatus);
                                    }
                                }
                            }
                            ++l;
                        }
                        success = true;
                        Object var25_26 = null;
                        if (in == null) break block29;
                        try {
                            in.close();
                        }
                        catch (Throwable ignore) {
                            // empty catch block
                        }
                    }
                    in = null;
                    {
                        break block30;
                        catch (Throwable t) {
                            t.printStackTrace(System.out);
                            success = false;
                            Object var25_27 = null;
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable ignore) {
                                    // empty catch block
                                }
                            }
                            in = null;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var25_28 = null;
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable ignore) {
                                // empty catch block
                            }
                        }
                        in = null;
                        throw throwable;
                    }
                }
            }
        }
        if (!success) {
            srcTable.setClass(CSS_INVISIBLE_TABLE);
            HTMLTable.IRow row = srcTable.newTitleRow();
            row.newCell().setText("[source file '" + Descriptors.combineVMName(packageVMName, fileName) + "' not found in sourcepath]", false);
        }
        page.add(srcTable);
    }

    private static String addLineAnchorID(int line, String anchorID, IntObjectMap lineAnchorIDMap) {
        if (line > 0) {
            String _anchorID = (String)lineAnchorIDMap.get(line);
            if (_anchorID != null) {
                return _anchorID;
            }
            lineAnchorIDMap.put(line, anchorID);
            return anchorID;
        }
        return null;
    }

    private IItem[] getParentPath(IItem item) {
        LinkedList<IItem> _result = new LinkedList<IItem>();
        while (item != null) {
            _result.add(item);
            item = item.getParent();
        }
        IItem[] result = new IItem[_result.size()];
        int j = result.length - 1;
        Iterator i = _result.iterator();
        while (i.hasNext()) {
            result[j] = (IItem)i.next();
            --j;
        }
        return result;
    }

    private String getItemHREF(IItem base, IItem item) {
        int nesting;
        String itemHREF = item instanceof AllItem ? this.m_settings.getOutFile().getName() : this.m_reportIDNamespace.getID(ReportGenerator.getItemKey(item)).concat(FILE_EXTENSION);
        String fullHREF = base == null ? itemHREF : ((nesting = NESTING[base.getMetadata().getTypeID()][item.getMetadata().getTypeID()]) == 1 ? NESTED_ITEMS_PARENT_DIRNAME.concat("/").concat(itemHREF) : (nesting == -1 ? "../".concat(itemHREF) : itemHREF));
        return fullHREF;
    }

    private IContent getPageTitle() {
        IContent title = this.m_pageTitle;
        if (title == null) {
            ElementList _title = new ElementList();
            _title.add(new HyperRef("http://emma.sourceforge.net/", "EMMA", true));
            StringBuffer s = new StringBuffer(" Coverage Report (generated ");
            s.append(new Date(EMMAProperties.getTimeStamp()));
            s.append(')');
            _title.add(new Text(s.toString(), true));
            this.m_pageTitle = title = _title;
        }
        return title;
    }

    private IContent getFooterBottom() {
        IContent bottom = this.m_footerBottom;
        if (bottom == null) {
            ElementList _bottom = new ElementList();
            _bottom.add(new HyperRef("http://sourceforge.net/projects/emma", "EMMA 2.1.13730 (unsupported private build)", true));
            _bottom.add(new Text(" (C) Vladimir Roubtsov", true));
            this.m_footerBottom = bottom = _bottom;
        }
        return bottom;
    }

    private void addPageHeaderTitleRow(HTMLTable header) {
        HTMLTable.IRow titleRow = header.newTitleRow();
        HTMLTable.ICell cell = titleRow.newCell();
        cell.setClass(CSS_TITLE);
        cell.add(this.getPageTitle());
    }

    private static void trimForDisplay(StringBuffer buf) {
        if (buf.length() > 80) {
            buf.setLength(77);
            buf.append("...");
        }
    }

    private static File getItemFile(File parentDir, String itemKey) {
        if (parentDir == null) {
            return new File(itemKey.concat(FILE_EXTENSION));
        }
        return new File(parentDir, itemKey.concat(FILE_EXTENSION));
    }

    private static String getItemKey(IItem item) {
        StringBuffer result = new StringBuffer();
        while (item != null) {
            result.append(item.getName());
            result.append(':');
            item = item.getParent();
        }
        return result.toString();
    }

    private static HTMLWriter openOutFile(File file, String encoding, boolean mkdirs) {
        BufferedWriter out = null;
        try {
            File parent;
            if (mkdirs && (parent = file.getParentFile()) != null) {
                parent.mkdirs();
            }
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding), 32768);
        }
        catch (UnsupportedEncodingException uee) {
            throw new EMMARuntimeException(uee);
        }
        catch (IOException fnfe) {
            throw new EMMARuntimeException(fnfe);
        }
        return new HTMLWriter(out);
    }

    private static String dataCellStyle(int column, boolean highlight) {
        if (column == 0) {
            return highlight ? CSS_DATA_HIGHLIGHT_FIRST : "f";
        }
        return highlight ? CSS_DATA_HIGHLIGHT : "";
    }

    private static String headerCellStyle(int column) {
        return column == 0 ? "f" : "";
    }

    static {
        IItemMetadata[] allTypes = IItemMetadata.Factory.getAllTypes();
        ATTRIBUTE_SETS = new long[allTypes.length];
        for (int t = 0; t < allTypes.length; ++t) {
            ReportGenerator.ATTRIBUTE_SETS[allTypes[t].getTypeID()] = allTypes[t].getAttributeIDs();
        }
        NESTING = new int[4][4];
        int base = AllItem.getTypeMetadata().getTypeID();
        ReportGenerator.NESTING[base][PackageItem.getTypeMetadata().getTypeID()] = 1;
        ReportGenerator.NESTING[base][SrcFileItem.getTypeMetadata().getTypeID()] = 1;
        ReportGenerator.NESTING[base][ClassItem.getTypeMetadata().getTypeID()] = 1;
        base = PackageItem.getTypeMetadata().getTypeID();
        ReportGenerator.NESTING[base][AllItem.getTypeMetadata().getTypeID()] = -1;
        base = SrcFileItem.getTypeMetadata().getTypeID();
        ReportGenerator.NESTING[base][AllItem.getTypeMetadata().getTypeID()] = -1;
        base = ClassItem.getTypeMetadata().getTypeID();
        ReportGenerator.NESTING[base][AllItem.getTypeMetadata().getTypeID()] = -1;
    }

    private static final class IDGenerator {
        private final ObjectIntMap m_namespace;
        private final int[] m_out;

        IDGenerator() {
            this.m_namespace = new ObjectIntMap(101);
            this.m_out = new int[1];
        }

        IDGenerator(int initialCapacity) {
            this.m_namespace = new ObjectIntMap(initialCapacity);
            this.m_out = new int[1];
        }

        String getID(String key) {
            int ID;
            int[] out = this.m_out;
            if (this.m_namespace.get(key, out)) {
                ID = out[0];
            } else {
                ID = this.m_namespace.size();
                this.m_namespace.put(key, ID);
            }
            return Integer.toHexString(ID);
        }
    }
}

