/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.rt;

import com.vladium.emma.EMMAProperties;
import com.vladium.emma.IAppConstants;
import com.vladium.emma.data.DataFactory;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.rt.RTController;
import com.vladium.emma.rt.RTCoverageDataPersister;
import com.vladium.emma.rt.RTExitHook;
import com.vladium.emma.rt.RTSettings;
import com.vladium.logging.Logger;
import com.vladium.util.IFileLock;
import com.vladium.util.IProperties;
import com.vladium.util.Property;
import com.vladium.util.exit.ExitHookManager;
import java.io.File;

public abstract class RT
implements IAppConstants {
    public static final String PROPERTY_RT_FILELOCK_FLAG = "rt.filelock";
    public static final String PREFIX_RT_FILELOCK = "rt.filelock.";
    public static final String PROPERTY_RT_FILELOCK_PORTBASE = "rt.filelock.portbase";
    public static final String PROPERTY_RT_FILELOCK_MAX_TIME = "rt.filelock.maxtime";
    public static final String PROPERTY_RT_FILELOCK_RETRIES = "rt.filelock.retries";
    public static final int DEFAULT_RT_FILELOCK_PORTBASE = 59141;
    public static final long DEFAULT_RT_FILELOCK_MAX_TIME = 120000L;
    public static final int DEFAULT_RT_FILELOCK_RETRIES = 11;
    public static final String PROPERTY_RT_CONTROL_FLAG = "rt.control";
    public static final String PREFIX_RT_CONTROL = "rt.control.";
    public static final String PROPERTY_RT_CONTROL_HOST = "rt.control.host";
    public static final String PROPERTY_RT_CONTROL_PORT = "rt.control.port";
    public static final String DEFAULT_RT_CONTROL_HOST = "localhost";
    public static final int DEFAULT_RT_CONTROL_PORT = 47653;
    private static ICoverageData s_cdata;
    private static RTController s_controller;
    private static Runnable s_exitHook;
    private static IProperties s_appProperties;
    private static final ExitHookManager EXIT_HOOK_MANAGER;
    private static final boolean DEBUG = false;
    static /* synthetic */ Class class$com$vladium$emma$rt$RT;

    public static synchronized void reset(RTSettings.SetActions actions) {
        RTController controller;
        boolean[] steps = RTSettings.SetActions.mapSetAction(actions.m_appPropertiesAction);
        if (steps[0]) {
            s_appProperties = null;
        }
        if (steps[1] && s_appProperties == null) {
            ClassLoader loader = (class$com$vladium$emma$rt$RT == null ? (class$com$vladium$emma$rt$RT = RT.class$("com.vladium.emma.rt.RT")) : class$com$vladium$emma$rt$RT).getClassLoader();
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            IProperties appProperties = null;
            try {
                appProperties = EMMAProperties.getAppProperties(loader);
                if (appProperties == null || appProperties.isEmpty()) {
                    System.err.println("EMMA: could not read any application properties");
                }
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
            s_appProperties = appProperties;
        }
        if ((steps = RTSettings.SetActions.mapSetAction(actions.m_coverageDataAction))[0]) {
            s_cdata = null;
        }
        if (steps[1] && s_cdata == null) {
            s_cdata = DataFactory.newCoverageData();
            Logger log = Logger.getLogger();
            if (log.atINFO()) {
                log.info("collecting runtime coverage data ...");
            }
        }
        if (EXIT_HOOK_MANAGER != null) {
            steps = RTSettings.SetActions.mapSetAction(actions.m_exitHookAction);
            if (steps[0] && s_exitHook != null) {
                EXIT_HOOK_MANAGER.removeExitHook(s_exitHook);
                s_exitHook = null;
            }
            if (steps[1] && s_exitHook == null) {
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    try {
                        sm.checkPropertyAccess("user.dir");
                        sm.checkPropertyAccess("file.encoding");
                    }
                    catch (SecurityException se) {
                        throw new Error("EMMA: current security permissions are too restrictive for file I/O, aborting");
                    }
                }
                File outFile = RT.getCoverageOutFile();
                RTExitHook exitHook = new RTExitHook(class$com$vladium$emma$rt$RT == null ? (class$com$vladium$emma$rt$RT = RT.class$("com.vladium.emma.rt.RT")) : class$com$vladium$emma$rt$RT, s_cdata, outFile, RT.getCoverageOutMerge(), RT.getCoverageOutFileLock(outFile));
                RTExitHook.createClassLoaderClosure();
                if (EXIT_HOOK_MANAGER.addExitHook(exitHook)) {
                    s_exitHook = exitHook;
                }
            }
        }
        if ((steps = RTSettings.SetActions.mapSetAction(actions.m_controllerAction))[0] && s_controller != null) {
            s_controller.shutdown();
            s_controller = null;
        }
        if (steps[1] && s_controller == null && (controller = RT.getRTController()) != null) {
            Error failure = null;
            Exception cause = null;
            try {
                controller.start();
                s_controller = controller;
            }
            catch (SecurityException se) {
                cause = se;
                failure = new Error("EMMA: current security permissions are too restrictive for socket I/O, aborting");
            }
            catch (Exception e) {
                cause = e;
                failure = new Error("EMMA: runtime controller could not be started, aborting");
            }
            if (failure != null) {
                cause.printStackTrace(System.err);
                if (EXIT_HOOK_MANAGER != null && s_exitHook != null) {
                    EXIT_HOOK_MANAGER.removeExitHook(s_exitHook);
                    s_exitHook = null;
                }
                throw failure;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void r(boolean[][] coverage, String classVMName, long stamp) {
        ICoverageData cdata = RT.getCoverageData();
        if (cdata != null) {
            Object object = cdata.lock();
            synchronized (object) {
                cdata.addClass(coverage, classVMName, stamp);
            }
        }
    }

    public static synchronized ICoverageData getCoverageData() {
        return s_cdata;
    }

    public static synchronized IProperties getAppProperties() {
        return s_appProperties;
    }

    public static synchronized void dumpCoverageData(File outFile, boolean merge, boolean stopDataCollection) {
        outFile = outFile != null ? outFile : RT.getCoverageOutFile();
        ICoverageData cdata = s_cdata;
        if (stopDataCollection) {
            s_cdata = null;
        }
        RTCoverageDataPersister.dumpCoverageData(cdata, !stopDataCollection, outFile, merge, RT.getCoverageOutFileLock(outFile));
    }

    public static synchronized void dumpCoverageData(File outFile, boolean stopDataCollection) {
        outFile = outFile != null ? outFile : RT.getCoverageOutFile();
        ICoverageData cdata = s_cdata;
        if (stopDataCollection) {
            s_cdata = null;
        }
        RTCoverageDataPersister.dumpCoverageData(cdata, !stopDataCollection, outFile, RT.getCoverageOutMerge(), RT.getCoverageOutFileLock(outFile));
    }

    static File getCoverageOutFile() {
        IProperties appProperties = RT.getAppProperties();
        if (appProperties != null) {
            String property = appProperties.getProperty("coverage.out.file", "coverage.ec");
            return new File(property);
        }
        return new File("coverage.ec");
    }

    static boolean getCoverageOutMerge() {
        IProperties appProperties = RT.getAppProperties();
        if (appProperties != null) {
            String property = appProperties.getProperty("coverage.out.merge", EMMAProperties.DEFAULT_COVERAGE_DATA_OUT_MERGE.toString());
            return Property.toBoolean(property);
        }
        return EMMAProperties.DEFAULT_COVERAGE_DATA_OUT_MERGE;
    }

    static IFileLock getCoverageOutFileLock(File outFile) {
        boolean enableLocking = true;
        IProperties appProperties = RT.getAppProperties();
        if (appProperties != null) {
            String property = appProperties.getProperty(PROPERTY_RT_FILELOCK_FLAG, "true");
            enableLocking = Property.toBoolean(property);
        }
        if (enableLocking) {
            long timeout = 120000L;
            int retries = 11;
            int portbase = 59141;
            if (appProperties != null) {
                String property = appProperties.getProperty(PROPERTY_RT_FILELOCK_MAX_TIME);
                if (property != null) {
                    try {
                        timeout = Long.parseLong(property);
                    }
                    catch (NumberFormatException ignore) {
                        System.err.println("ignoring malformed [rt.filelock.maxtime] value: " + property);
                    }
                }
                if ((property = appProperties.getProperty(PROPERTY_RT_FILELOCK_RETRIES)) != null) {
                    try {
                        retries = Integer.parseInt(property);
                    }
                    catch (NumberFormatException ignore) {
                        System.err.println("ignoring malformed [rt.filelock.retries] value: " + property);
                    }
                }
                if ((property = appProperties.getProperty(PROPERTY_RT_FILELOCK_PORTBASE)) != null) {
                    try {
                        portbase = Integer.parseInt(property);
                    }
                    catch (NumberFormatException ignore) {
                        System.err.println("ignoring malformed [rt.filelock.portbase] value: " + property);
                    }
                }
            }
            return IFileLock.Factory.create(outFile, portbase, timeout, retries);
        }
        return null;
    }

    private RT() {
    }

    private static RTController getRTController() {
        boolean enableController = true;
        IProperties appProperties = RT.getAppProperties();
        if (appProperties != null) {
            String property = appProperties.getProperty(PROPERTY_RT_CONTROL_FLAG, "false");
            enableController = Property.toBoolean(property);
        }
        if (enableController) {
            String property;
            int port = 47653;
            if (appProperties != null && (property = appProperties.getProperty(PROPERTY_RT_CONTROL_PORT)) != null) {
                try {
                    port = Integer.parseInt(property);
                }
                catch (NumberFormatException ignore) {
                    System.err.println("ignoring malformed [rt.control.port] value: " + property);
                }
            }
            return new RTController(port);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ExitHookManager temp = null;
        try {
            temp = ExitHookManager.getSingleton();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        EXIT_HOOK_MANAGER = temp;
        if (RTSettings.isStandaloneMode()) {
            RT.reset(new RTSettings.SetActions(1, 1, 1, 1));
        } else {
            RT.reset(new RTSettings.SetActions(1, 2, 2, 2));
        }
    }
}

