/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwebservices;

import com.mathworks.internal.mwaws.client.v5.ArrayOfString;
import com.mathworks.internal.mwaws.client.v5.MWAEntitlement;
import java.util.ArrayList;
import java.util.Arrays;

public final class EntitlementUtility {
    private static final String LOGIN_NAMED_USER_AVAILABLE = "LoginNamedUserAvailable";
    private static final String ACTIVATABLE = "Activatable";

    private EntitlementUtility() {
    }

    public static boolean isAdmin(MWAEntitlement[] mWAEntitlementArray) {
        return EntitlementUtility.containsPermission(mWAEntitlementArray, "ActivateForOthers");
    }

    private static boolean containsPermission(MWAEntitlement[] mWAEntitlementArray, String string) {
        if (mWAEntitlementArray == null) {
            return false;
        }
        boolean bl = false;
        for (MWAEntitlement mWAEntitlement : mWAEntitlementArray) {
            ArrayOfString arrayOfString = mWAEntitlement.getPermissions();
            if (arrayOfString == null) continue;
            String[] stringArray = arrayOfString.getItem();
            if (stringArray != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.addAll(Arrays.asList(stringArray));
                if (!arrayList.contains(string)) continue;
                bl = true;
                break;
            }
            bl = false;
        }
        return bl;
    }

    public static boolean isA2AK(MWAEntitlement[] mWAEntitlementArray) {
        return EntitlementUtility.containsPermission(mWAEntitlementArray, "ActivationKeyAvailable");
    }

    public static boolean isStudent(MWAEntitlement[] mWAEntitlementArray) {
        return EntitlementUtility.containsPermission(mWAEntitlementArray, "DisplayStudentReminder");
    }

    public static boolean isDownloadOnlyPermissionAvailable(MWAEntitlement[] mWAEntitlementArray) {
        return EntitlementUtility.containsPermission(mWAEntitlementArray, "DownloadOnlyAvailable");
    }

    public static boolean isLNUOnly(MWAEntitlement[] mWAEntitlementArray) {
        return EntitlementUtility.containsPermission(mWAEntitlementArray, LOGIN_NAMED_USER_AVAILABLE) && !EntitlementUtility.containsPermission(mWAEntitlementArray, ACTIVATABLE);
    }

    public static boolean isSNULNU(MWAEntitlement[] mWAEntitlementArray) {
        return EntitlementUtility.containsPermission(mWAEntitlementArray, LOGIN_NAMED_USER_AVAILABLE) && EntitlementUtility.containsPermission(mWAEntitlementArray, ACTIVATABLE);
    }
}

