/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlwidgets.array.AbstractDatasetTable;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.GroupHeaderUI;
import com.mathworks.mlwidgets.array.TabularObjectColumnModel;
import com.mathworks.mlwidgets.array.TabularObjectTableModel;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCornerGrip;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextArea;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyBindingManagerRegistrant;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.Pair;
import com.mathworks.widgets.KeyEventPreprocessor;
import com.mathworks.widgets.PromptingTextField;
import com.mathworks.widgets.WidgetUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class DatasetPopupPanel
extends MJPanel {
    private DescriptionSectionPanel fDescriptionPanel;
    private UnitsSectionPanel fUnitsPanel;
    private int fVariableIndex = -1;
    private ActionListener fDismissAction;
    private MetadataTable fDatasetTable;
    private MJLabel fVariableSummaryLabel;
    private MJButton fAscendingButton;
    private MJButton fDescendingButton;

    DatasetPopupPanel(AbstractDatasetTable abstractDatasetTable, int n) {
        this(new DatasetTableWrapper(abstractDatasetTable), n);
    }

    private DatasetPopupPanel(MetadataTable metadataTable, int n) {
        super((LayoutManager)new BorderLayout());
        this.setOpaque(true);
        this.setName("DatasetHeaderPopupPanel");
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridLayout(2, 1));
        mJPanel.setOpaque(false);
        this.fDatasetTable = metadataTable;
        this.fVariableIndex = n;
        this.fAscendingButton = new MJButton(ArrayUtils.getResource("dataset.ascend"), (Icon)new ImageIcon(GroupHeaderUI.class.getResource("/com/mathworks/common/icons/resources/sort_az_ascending.png")));
        this.fAscendingButton.setName("AscendingButton");
        DatasetPopupPanel.customizeButton(this.fAscendingButton);
        this.fAscendingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatasetPopupPanel.this.sortAscending(actionEvent);
            }
        });
        mJPanel.add((Component)this.fAscendingButton);
        this.fDescendingButton = new MJButton(ArrayUtils.getResource("dataset.descend"), (Icon)new ImageIcon(GroupHeaderUI.class.getResource("/com/mathworks/common/icons/resources/sort_az_descending.png")));
        this.fDescendingButton.setName("DescendingButton");
        DatasetPopupPanel.customizeButton(this.fDescendingButton);
        this.fDescendingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatasetPopupPanel.this.sortDescending(actionEvent);
            }
        });
        mJPanel.add((Component)this.fDescendingButton);
        this.add((Component)mJPanel, "North");
        this.fDescriptionPanel = new DescriptionSectionPanel();
        this.fUnitsPanel = new UnitsSectionPanel();
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel2.add((Component)((Object)this.fUnitsPanel), (Object)"North");
        mJPanel2.add((Component)((Object)this.fDescriptionPanel), (Object)"Center");
        this.add((Component)mJPanel2, "Center");
        this.fDescriptionPanel.addTextFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!DatasetPopupPanel.this.fDescriptionPanel.getText().equals(DatasetPopupPanel.this.fDescriptionPanel.getCurrentText())) {
                    DatasetPopupPanel.this.fDatasetTable.setVariableDescription(DatasetPopupPanel.this.fDescriptionPanel.getText(), DatasetPopupPanel.this.fVariableIndex);
                    DatasetPopupPanel.this.fDescriptionPanel.setCurrentText(DatasetPopupPanel.this.fDescriptionPanel.getText());
                }
            }
        });
        this.fDescriptionPanel.addTextActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DatasetPopupPanel.this.fDismissAction != null) {
                    DatasetPopupPanel.this.fDismissAction.actionPerformed(actionEvent);
                }
            }
        });
        this.fUnitsPanel.addTextFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!DatasetPopupPanel.this.fUnitsPanel.getText().equals(DatasetPopupPanel.this.fUnitsPanel.getCurrentText())) {
                    DatasetPopupPanel.this.fDatasetTable.setVariableUnits(DatasetPopupPanel.this.fUnitsPanel.getText(), DatasetPopupPanel.this.fVariableIndex);
                    DatasetPopupPanel.this.fUnitsPanel.setCurrentText(DatasetPopupPanel.this.fUnitsPanel.getText());
                }
            }
        });
        this.fUnitsPanel.addTextActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DatasetPopupPanel.this.fDismissAction != null) {
                    DatasetPopupPanel.this.fDismissAction.actionPerformed(actionEvent);
                }
            }
        });
        MJCornerGrip mJCornerGrip = MJCornerGrip.createAlwaysVisibleCornerGrip();
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new BorderLayout());
        int[] nArray = new int[]{0, 0};
        if (this.fDatasetTable.getModel() instanceof TabularObjectTableModel) {
            nArray = ((TabularObjectTableModel)((Object)this.fDatasetTable.getModel())).getVariableGridSize();
        }
        this.fVariableSummaryLabel = new MJLabel();
        if (this.fDatasetTable.getColumnModel() instanceof TabularObjectColumnModel) {
            this.fVariableSummaryLabel = new MJLabel(((TabularObjectColumnModel)this.fDatasetTable.getColumnModel()).getVariableSummary(this.fVariableIndex, nArray[0]));
        }
        this.fVariableSummaryLabel.setHorizontalTextPosition(0);
        this.fVariableSummaryLabel.setHorizontalAlignment(0);
        this.fVariableSummaryLabel.setName("VariableSummaryLabel");
        mJPanel3.add((Component)mJCornerGrip, (Object)"East");
        mJPanel3.add((Component)this.fVariableSummaryLabel, (Object)"Center");
        this.add((Component)mJPanel3, "South");
    }

    private static void customizeButton(MJButton mJButton) {
        mJButton.setBorderPainted(true);
        mJButton.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(1, 2, 1, 2)));
        mJButton.setOpaque(false);
        mJButton.setHorizontalAlignment(2);
        mJButton.setHorizontalTextPosition(4);
        mJButton.setContentAreaFilled(true);
        mJButton.setRolloverEnabled(true);
        mJButton.setFlyOverAppearance(true);
        mJButton.setIconTextGap(10);
    }

    void populateMetadataFields(final Runnable runnable) {
        MatlabWorker<Pair<String, String>> matlabWorker = new MatlabWorker<Pair<String, String>>(){

            public Pair<String, String> runOnMatlabThread() {
                return new Pair((Object)DatasetPopupPanel.this.fDatasetTable.getVariableUnits(DatasetPopupPanel.this.fVariableIndex), (Object)DatasetPopupPanel.this.fDatasetTable.getVariableDescription(DatasetPopupPanel.this.fVariableIndex));
            }

            public void runOnAWTEventDispatchThread(Pair<String, String> pair) {
                DatasetPopupPanel.this.setUnitsAndDescription((Pair<String, String>)pair);
                if (runnable != null) {
                    runnable.run();
                }
            }
        };
        if (Matlab.isMatlabAvailable()) {
            matlabWorker.start();
        }
    }

    void setSortEnabled(boolean bl) {
        this.fAscendingButton.setEnabled(bl);
        this.fDescendingButton.setEnabled(bl);
        if (!bl) {
            this.fAscendingButton.setToolTipText(ArrayUtils.getResource("dataset.NoSortCells"));
            this.fDescendingButton.setToolTipText(ArrayUtils.getResource("dataset.NoSortCells"));
        } else {
            this.fAscendingButton.setToolTipText(null);
            this.fDescendingButton.setToolTipText(null);
        }
    }

    private void setUnitsAndDescription(Pair<String, String> pair) {
        String string;
        if (pair == null) {
            return;
        }
        String string2 = (String)pair.getFirst();
        if (string2.length() > 0) {
            this.fUnitsPanel.setText(string2);
        }
        if ((string = (String)pair.getSecond()).length() > 0) {
            this.fDescriptionPanel.setText(string);
            ((JTextArea)this.fDescriptionPanel.getContentTextField()).setRows(string.length() / 30);
        }
    }

    int getVariableIndex() {
        return this.fVariableIndex;
    }

    void setDismissAction(ActionListener actionListener) {
        this.fDismissAction = actionListener;
    }

    private void sortAscending(ActionEvent actionEvent) {
        if (this.fDismissAction != null) {
            this.fDismissAction.actionPerformed(actionEvent);
        }
        this.fDatasetTable.sortAscending();
    }

    private void sortDescending(ActionEvent actionEvent) {
        if (this.fDismissAction != null) {
            this.fDismissAction.actionPerformed(actionEvent);
        }
        this.fDatasetTable.sortDescending();
    }

    protected static class DatasetTableWrapper
    implements MetadataTable {
        private AbstractDatasetTable iDatasetTable;

        DatasetTableWrapper(AbstractDatasetTable abstractDatasetTable) {
            this.iDatasetTable = abstractDatasetTable;
        }

        @Override
        public void setVariableDescription(String string, int n) {
            this.iDatasetTable.setVariableDescription(string, n);
        }

        @Override
        public void setVariableUnits(String string, int n) {
            this.iDatasetTable.setVariableUnits(string, n);
        }

        @Override
        public TableModel getModel() {
            return this.iDatasetTable.getModel();
        }

        @Override
        public String getVariableUnits(int n) {
            return this.iDatasetTable.getVariableUnits(n);
        }

        @Override
        public String getVariableDescription(int n) {
            return this.iDatasetTable.getVariableDescription(n);
        }

        @Override
        public TableColumnModel getColumnModel() {
            return this.iDatasetTable.getColumnModel();
        }

        @Override
        public void sortAscending() {
            this.iDatasetTable.sortAscending();
        }

        @Override
        public void sortDescending() {
            this.iDatasetTable.sortDescending();
        }
    }

    public static interface MetadataTable {
        public void setVariableDescription(String var1, int var2);

        public void setVariableUnits(String var1, int var2);

        public TableModel getModel();

        public String getVariableUnits(int var1);

        public String getVariableDescription(int var1);

        public TableColumnModel getColumnModel();

        public void sortAscending();

        public void sortDescending();
    }

    private static class PromptingTextArea
    extends MJTextArea {
        private String fPromptText = "";
        private final KeyEventPreprocessor fPreprocessor;
        private List<ActionListener> fActionListeners = new ArrayList<ActionListener>();

        private PromptingTextArea(String string) {
            this(string, (KeyEventPreprocessor)null);
        }

        private PromptingTextArea(String string, KeyEventPreprocessor keyEventPreprocessor) {
            PromptingTextArea.checkPromptText(string);
            this.fPromptText = string;
            this.setName("PromptingTextField");
            this.addFocusListener(this.createFocusListener());
            this.fPreprocessor = keyEventPreprocessor;
            MJUtilities.registerWithKeyBindingManager((KeyBindingManagerRegistrant)this, (KeyBindingManager)MatlabKeyBindings.getManager(), (String)"MATLABDesktop");
        }

        public void paint(Graphics graphics) {
            block4: {
                super.paint(graphics);
                if (!this.hasFocus() && this.getText().length() == 0) {
                    try {
                        Rectangle rectangle = this.modelToView(0);
                        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                        int n = 0;
                        int n2 = 0;
                        if (rectangle != null) {
                            n = rectangle.x;
                            n2 = rectangle.y + rectangle.height - fontMetrics.getDescent();
                        }
                        Graphics graphics2 = graphics.create();
                        graphics2.setClip(0, 0, this.getWidth() - this.getInsets().right, this.getHeight());
                        graphics2.setColor(UIManager.getColor("TextField.inactiveForeground"));
                        graphics2.drawString(this.fPromptText, n, n2);
                        graphics2.dispose();
                    }
                    catch (BadLocationException badLocationException) {
                        if ($assertionsDisabled) break block4;
                        throw new AssertionError();
                    }
                }
            }
        }

        public static String getDefaultPromptText() {
            return WidgetUtils.lookup((String)"PromptingTextField.defaultPromptingText");
        }

        public void addActionListener(ActionListener actionListener) {
            this.fActionListeners.remove(actionListener);
            this.fActionListeners.add(actionListener);
        }

        private FocusListener createFocusListener() {
            return new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    PromptingTextArea.this.repaint();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    PromptingTextArea.this.repaint();
                }
            };
        }

        private static void checkPromptText(String string) {
            if (string == null) {
                throw new IllegalArgumentException("Prompt text cannot be null.");
            }
        }

        public String getPromptText() {
            return this.fPromptText;
        }

        public void setPromptText(String string) {
            PromptingTextArea.checkPromptText(string);
            this.fPromptText = string;
            this.repaint();
        }

        public void processComponentKeyEvent(KeyEvent keyEvent) {
            if (this.fPreprocessor != null) {
                this.fPreprocessor.processComponentKeyEvent(keyEvent, (JTextComponent)((Object)this));
            } else if (keyEvent.getKeyCode() == 10) {
                for (ActionListener actionListener : this.fActionListeners) {
                    actionListener.actionPerformed(new ActionEvent((Object)this, 1001, "enter"));
                }
                keyEvent.consume();
            } else {
                super.processComponentKeyEvent(keyEvent);
            }
        }
    }

    private static class DescriptionSectionPanel
    extends SectionPanel {
        DescriptionSectionPanel() {
            super(ArrayUtils.getResource("dataset.description"));
        }

        @Override
        protected void createTextField() {
            this.iContentTextField = new PromptingTextArea(ArrayUtils.getResource("dataset.descriptionprompt"));
            this.iContentTextField.setName("DescriptionTextField");
            this.iContentTextField.setFont(this.getFont());
            ((JTextArea)this.iContentTextField).setLineWrap(true);
            ((JTextArea)this.iContentTextField).setWrapStyleWord(true);
            this.iContentTextField.setOpaque(false);
        }

        @Override
        void addTextActionListener(ActionListener actionListener) {
            ((PromptingTextArea)((Object)this.iContentTextField)).addActionListener(actionListener);
        }
    }

    private static class UnitsSectionPanel
    extends SectionPanel {
        UnitsSectionPanel() {
            super(ArrayUtils.getResource("dataset.units"));
        }

        @Override
        protected void createTextField() {
            this.iContentTextField = new PromptingTextField(ArrayUtils.getResource("dataset.unitsprompt"));
            this.iContentTextField.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.iContentTextField.setName("UnitsTextField");
            this.iContentTextField.setFont(this.getFont());
            this.iContentTextField.setOpaque(false);
        }

        @Override
        void addTextActionListener(ActionListener actionListener) {
            ((JTextField)this.iContentTextField).addActionListener(actionListener);
        }
    }

    private static abstract class SectionPanel
    extends MJPanel {
        private MJPanel iHeadingPanel = new MJPanel((LayoutManager)new BorderLayout());
        private MJPanel iContentPanel = new MJPanel((LayoutManager)new BorderLayout());
        protected JTextComponent iContentTextField;
        protected FocusListener iTextFocusListener;
        private String iCurrentText = "";

        SectionPanel(String string) {
            super((LayoutManager)new BorderLayout());
            this.setOpaque(true);
            this.setBackground(Color.white);
            this.iContentPanel.setOpaque(true);
            this.iContentPanel.setBackground(Color.white);
            this.iHeadingPanel.setOpaque(true);
            this.iHeadingPanel.setBackground(Color.lightGray);
            MJLabel mJLabel = new MJLabel(string);
            mJLabel.setForeground(Color.white);
            this.iHeadingPanel.add((Component)mJLabel, (Object)"West");
            this.createTextField();
            this.iContentPanel.add((Component)this.iContentTextField, (Object)"Center");
            this.add((Component)this.iHeadingPanel, "North");
            this.add((Component)this.iContentPanel, "Center");
        }

        protected abstract void createTextField();

        void setText(String string) {
            this.iContentTextField.setText(string);
            this.iCurrentText = string;
            this.revalidate();
            this.repaint();
        }

        abstract void addTextActionListener(ActionListener var1);

        void addTextFocusListener(FocusListener focusListener) {
            this.iContentTextField.addFocusListener(focusListener);
        }

        String getText() {
            return this.iContentTextField.getText();
        }

        void setCurrentText(String string) {
            this.iCurrentText = string;
        }

        String getCurrentText() {
            return this.iCurrentText;
        }

        JTextComponent getContentTextField() {
            return this.iContentTextField;
        }
    }
}

