/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlwidgets.array.AbstractFormatToolsetSupplier;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.FormatToolsetSupplierFactory;
import com.mathworks.mlwidgets.array.VariableFormatSpecifier;
import com.mathworks.mlwidgets.workspace.MatlabWorkspaceListener;
import com.mathworks.mlwidgets.workspace.WhosInformation;
import com.mathworks.mlwidgets.workspace.WorkspaceChange;
import com.mathworks.mlwidgets.workspace.WorkspaceObserver;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.toolstrip.components.popups.ListActionEvent;
import com.mathworks.toolstrip.components.popups.ListActionListener;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.toolstrip.plaf.ToolstripIcons;
import com.mathworks.util.Disposable;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;

public class DatetimeFormatToolsetSupplier
extends AbstractFormatToolsetSupplier
implements TSToolSet.ToolSupplier,
PopupListener,
ListActionListener {
    private VariableFormatSpecifier fActionProvider = null;
    private String fCurrentFormat = "MM/dd/yyyy HH:mm:ss";
    private final List<String> fIDs = new Vector<String>();
    private static String sDefaultFormat = null;
    private static String sDefaultDateFormat = null;
    private String[] fDatetimeFormats = new String[]{"MM/dd/yyyy HH:mm:ss", "dd-MMM-yyyy HH:mm:ss", "yyyy-MM-dd HH:mm:ss", "MM/dd/yyyy", "dd-MMM-yyyy", "yyyy-MM-dd", "HH:mm:ss"};
    private String fTempDisplayFormat = null;
    private String fVariableName = null;
    private static String[] sMonthsForSample = null;
    private static GregorianCalendar sCurrentDay = null;
    private DatetimeFormatDropDownButton fDropDown = null;
    private PopupList fPopupList = null;

    public DatetimeFormatToolsetSupplier(VariableFormatSpecifier variableFormatSpecifier, String string) {
        this.fActionProvider = variableFormatSpecifier;
        this.fVariableName = string;
        String string2 = Locale.getDefault().toLanguageTag();
        sMonthsForSample = string2.startsWith("en") ? new DateFormatSymbols().getShortMonths() : new DateFormatSymbols().getMonths();
    }

    public JComponent createTool(TSToolSet.ToolLocation toolLocation) {
        String string = ArrayUtils.getResource("datetimeFormat.tooltip");
        final DatetimeFormatDropDownButton datetimeFormatDropDownButton = new DatetimeFormatDropDownButton(string);
        string = string.replaceAll("&", "");
        datetimeFormatDropDownButton.setToolTipText(string);
        datetimeFormatDropDownButton.setPopupListener(this);
        datetimeFormatDropDownButton.setPreferredSize(this.fPreferredSize);
        datetimeFormatDropDownButton.setBorder(BorderFactory.createBevelBorder(1));
        datetimeFormatDropDownButton.setEnabled(true);
        if (Matlab.isMatlabAvailable()) {
            new MatlabWorker<Boolean>(){

                public Boolean runOnMatlabThread() {
                    boolean bl = true;
                    try {
                        String string = DatetimeFormatToolsetSupplier.this.fActionProvider.getFormat(DatetimeFormatToolsetSupplier.this.fVariableName);
                        if (string != null && !string.isEmpty()) {
                            DatetimeFormatToolsetSupplier.this.fCurrentFormat = string;
                        } else {
                            bl = false;
                        }
                        String[] stringArray = (String[])Matlab.mtEval((String)"{datetime('now').Format, datetime('today').Format}", (int)1);
                        sDefaultFormat = stringArray[0];
                        sDefaultDateFormat = stringArray[1];
                        int n = DatetimeFormatToolsetSupplier.this.fDatetimeFormats.length;
                        DatetimeFormatToolsetSupplier.access$502(DatetimeFormatToolsetSupplier.this, Arrays.copyOf(DatetimeFormatToolsetSupplier.this.fDatetimeFormats, n + 2));
                        ((DatetimeFormatToolsetSupplier)DatetimeFormatToolsetSupplier.this).fDatetimeFormats[n] = sDefaultFormat;
                        ((DatetimeFormatToolsetSupplier)DatetimeFormatToolsetSupplier.this).fDatetimeFormats[n + 1] = sDefaultDateFormat;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return bl;
                }

                public void runOnAWTEventDispatchThread(Boolean bl) {
                    datetimeFormatDropDownButton.setEnabled(bl);
                }
            }.start();
        }
        this.fDropDown = datetimeFormatDropDownButton;
        return datetimeFormatDropDownButton;
    }

    @Override
    void showMousedOverFormat(MouseEvent mouseEvent) {
        PopupList popupList = (PopupList)mouseEvent.getSource();
        int n = popupList.locationToIndex(mouseEvent.getPoint());
        if (n < this.fIDs.size()) {
            if (!this.fTempDisplayFormat.equals(this.fIDs.get(n))) {
                this.fTempDisplayFormat = this.fIDs.get(n);
                this.applyDatetimeFormat(this.fTempDisplayFormat);
            }
        } else {
            this.revertToCurrentFormat();
        }
    }

    private void applyDatetimeFormat(String string) {
        this.fActionProvider.setFormat(FormatToolsetSupplierFactory.FormatSupported.DATETIME, string);
    }

    @Override
    void revertToCurrentFormat() {
        this.applyDatetimeFormat(this.fCurrentFormat);
        this.fTempDisplayFormat = this.fCurrentFormat;
    }

    @Override
    void handleKeyPress(boolean bl) {
        int n = bl ? 1 : -1;
        int n2 = this.fIDs.indexOf(this.fTempDisplayFormat) + n;
        if (bl && n2 == this.fIDs.size()) {
            n2 = 0;
        } else if (!bl && n2 < 0) {
            n2 = this.fIDs.size() - 1;
        }
        this.fTempDisplayFormat = this.fIDs.get(n2);
        this.applyDatetimeFormat(this.fTempDisplayFormat);
    }

    protected void performUpdate() {
        new MatlabWorker<Boolean>(){

            public Boolean runOnMatlabThread() {
                boolean bl = true;
                try {
                    String string = DatetimeFormatToolsetSupplier.this.fActionProvider.getFormat(DatetimeFormatToolsetSupplier.this.fVariableName);
                    if (string != null && !string.isEmpty()) {
                        DatetimeFormatToolsetSupplier.this.fCurrentFormat = string;
                    } else {
                        bl = false;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return bl;
            }

            public void runOnAWTEventDispatchThread(Boolean bl) {
                DatetimeFormatToolsetSupplier.this.fDropDown.setEnabled(bl);
                DatetimeFormatToolsetSupplier.this.fDropDown.repaint();
            }
        }.start();
    }

    public void onPopupEvent(JComponent jComponent, PopupListener.PopupCallback popupCallback) {
        popupCallback.show((JComponent)this.createList());
    }

    private PopupList createList() {
        sCurrentDay = new GregorianCalendar();
        ArrayList<ListItem> arrayList = new ArrayList<ListItem>();
        this.fIDs.clear();
        this.fTempDisplayFormat = this.fCurrentFormat;
        boolean bl = false;
        for (String string : this.fDatetimeFormats) {
            if (sDefaultFormat != null && string.equals(sDefaultFormat)) {
                this.addFormatItemToList(arrayList, sDefaultFormat, ArrayUtils.getResource("datetimeFormat.defaultFormat"));
            } else if (sDefaultDateFormat != null && string.equals(sDefaultDateFormat)) {
                this.addFormatItemToList(arrayList, sDefaultDateFormat, ArrayUtils.getResource("datetimeFormat.defaultDateFormat"));
            } else {
                this.addFormatItemToList(arrayList, string, DatetimeFormatToolsetSupplier.getSampleForFormat(string));
            }
            if (!string.equals(this.fCurrentFormat)) continue;
            bl = true;
        }
        if (!bl) {
            this.addFormatItemToList(arrayList, this.fCurrentFormat, ArrayUtils.getResource("datetimeFormat.customFormat"));
        }
        this.fPopupList = new PopupList(arrayList.toArray(new ListItem[arrayList.size()]));
        this.fPopupList.setName("datetimeFormat");
        this.fPopupList.setListStyle(ListStyle.SINGLE_LINE_DESCRIPTION);
        this.fPopupList.addListActionListener((ListActionListener)this);
        this.fPopupList.addMouseListener((MouseListener)this);
        this.fPopupList.addMouseMotionListener((MouseMotionListener)this);
        this.fPopupList.addKeyListener((KeyListener)this);
        return this.fPopupList;
    }

    private void addFormatItemToList(Collection<ListItem> collection, String string, String string2) {
        boolean bl = string.equals(this.fCurrentFormat);
        ListItem listItem = ListItem.newItem((String)string, (String)string2, (String)string, (Icon)(bl ? ToolstripIcons.CHECKBOX_CHECKED_POPUPLIST.getIcon() : this.fSpacerIcon));
        collection.add(listItem);
        this.fIDs.add(string);
    }

    public void listItemSelected(ListActionEvent listActionEvent) {
        String string;
        this.fCurrentFormat = string = listActionEvent.getListItem().getName();
        int n = 0;
        for (String string2 : this.fIDs) {
            if (string2.equals(string)) {
                this.fCurrentFormat = this.fIDs.get(n);
                this.applyDatetimeFormat(this.fCurrentFormat);
                break;
            }
            ++n;
        }
    }

    private static String getSampleFromDateFormat(Calendar calendar, String string) {
        String string2 = string;
        string2 = string2.replace("MMM", sMonthsForSample[calendar.get(2)]);
        string2 = string2.replace("MM", String.format("%1$02d", calendar.get(2) + 1));
        string2 = string2.replace("dd", String.format("%1$02d", calendar.get(5)));
        string2 = string2.replace("yyyy", Integer.toString(calendar.get(1)));
        string2 = string2.replace("HH", String.format("%1$02d", calendar.get(10)));
        string2 = string2.replace("mm", String.format("%1$02d", calendar.get(12)));
        string2 = string2.replace("ss", String.format("%1$02d", calendar.get(13)));
        return string2;
    }

    private static String getSampleForFormat(String string) {
        return DatetimeFormatToolsetSupplier.getSampleFromDateFormat(sCurrentDay, string);
    }

    static /* synthetic */ String[] access$502(DatetimeFormatToolsetSupplier datetimeFormatToolsetSupplier, String[] stringArray) {
        datetimeFormatToolsetSupplier.fDatetimeFormats = stringArray;
        return stringArray;
    }

    private class DatetimeFormatDropDownButton
    extends AbstractFormatToolsetSupplier.FormatDropDownButton
    implements Disposable,
    WorkspaceObserver {
        DatetimeFormatDropDownButton(String string) {
            super(string);
            if (Matlab.isMatlabAvailable()) {
                MatlabWorkspaceListener.addWorkspaceChangeObserver(this);
            }
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.drawString(DatetimeFormatToolsetSupplier.this.fCurrentFormat, 5, 15);
        }

        public void dispose() {
            if (Matlab.isMatlabAvailable()) {
                MatlabWorkspaceListener.removeWorkspaceChangeObserver(this);
            }
        }

        @Override
        public void workspaceUpdate(WorkspaceChange workspaceChange, WhosInformation whosInformation) {
            if (DatetimeFormatToolsetSupplier.this.fPopupList == null || !DatetimeFormatToolsetSupplier.this.fPopupList.isShowing()) {
                DatetimeFormatToolsetSupplier.this.performUpdate();
            }
        }
    }
}

