/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.configeditor.plugin;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.grid.Property;
import com.mathworks.mlwidgets.configeditor.ConfigurationJideUtils;
import com.mathworks.mlwidgets.configeditor.data.RunConfiguration;
import com.mathworks.util.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class PersistenceUtils {
    private static final String IN_MEMORY_LINE_SEPARATOR = "\n";
    private static final String CODE_TO_EVALUATE_START = "=[ ...";
    private static final String CODE_TO_EVALUATE_END = "]";
    private static final String CODE_TO_EVALUATE_LINE_BREAK = " char(10) ...";

    public static void readOverFileHeader(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        while (string != null && !string.equals("")) {
            string = bufferedReader.readLine();
        }
    }

    public static Map<Annotation, String> readConfigurationHeader(BufferedReader bufferedReader) throws IOException, NoSuchElementException {
        HashMap<Annotation, String> hashMap = new HashMap<Annotation, String>();
        String string = bufferedReader.readLine();
        while (string != null && !string.equals("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = string.replaceFirst(string2, "");
            string4 = string4.replaceFirst(string3, "");
            string4 = string4.trim();
            Annotation annotation = Annotation.reverseLookup(string3);
            if (annotation == null) {
                throw new NoSuchElementException("There are no annotations in this string.");
            }
            hashMap.put(annotation, string4);
            string = bufferedReader.readLine();
        }
        return hashMap;
    }

    public static void readUntilStartOfConfiguration(BufferedReader bufferedReader) {
        try {
            boolean bl = false;
            while (!bl) {
                bufferedReader.mark(1024);
                String string = bufferedReader.readLine();
                if (string != null && !string.contains(Annotation.NAME.toString())) continue;
                bl = true;
                bufferedReader.reset();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String readInMatlabExpression(BufferedReader bufferedReader) {
        String string = "";
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            boolean bl = false;
            while (!bl) {
                bufferedReader.mark(1024);
                String string2 = bufferedReader.readLine();
                if (string2 == null || string2.contains(Annotation.NAME.toString())) {
                    bl = true;
                    if (string2 == null) continue;
                    bufferedReader.reset();
                    continue;
                }
                arrayList.add(string2);
            }
            if (arrayList.size() > 0) {
                arrayList.remove(arrayList.size() - 1);
                for (int i = 0; i < arrayList.size(); ++i) {
                    string = string + (String)arrayList.get(i);
                    if (i >= arrayList.size() - 1) continue;
                    string = string + System.getProperty("line.separator");
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public static Map<String, String> readPublishSettings(String string, BufferedReader bufferedReader) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = bufferedReader.readLine();
        while (string2 != null && !string2.equals("")) {
            String string3 = string2.replaceFirst(string + ".", "");
            String[] stringArray = string3.split("=");
            if (stringArray[0].equals("codeToEvaluate")) {
                hashMap.put(stringArray[0], PersistenceUtils.readInCodeToEvaluate(bufferedReader));
            } else {
                String string4 = PersistenceUtils.removeTrailingSemiColon(stringArray[1]);
                string4 = string4.trim();
                string4 = "".equals(string4 = PersistenceUtils.removeEnclosingSingleQuotes(string4)) ? null : string4;
                hashMap.put(stringArray[0], string4);
            }
            string2 = bufferedReader.readLine();
        }
        return hashMap;
    }

    public static String readInCodeToEvaluate(BufferedReader bufferedReader) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        String string = bufferedReader.readLine();
        while (string != null && !string.equals(CODE_TO_EVALUATE_END)) {
            String string2 = string.replaceFirst("\\Q char(10) ...\\E$", "");
            string2 = PersistenceUtils.removeEnclosingSingleQuotes(string2);
            string2 = string2.replaceAll("''", "'");
            stringBuilder.append(string2);
            string = bufferedReader.readLine();
            if (string == null || string.equals(CODE_TO_EVALUATE_END)) continue;
            stringBuilder.append(IN_MEMORY_LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    public static void writePlainCommentAndNewLine(BufferedWriter bufferedWriter, String string) throws IOException {
        bufferedWriter.write(Comment.PLAIN.toString());
        bufferedWriter.write(string);
        bufferedWriter.newLine();
    }

    public static void writeCommentAndAnnotationAndNewline(BufferedWriter bufferedWriter, Comment comment, Annotation annotation, String string) throws IOException {
        bufferedWriter.write((Object)((Object)comment) + " ");
        bufferedWriter.write((Object)((Object)annotation) + " ");
        bufferedWriter.write(string);
        bufferedWriter.newLine();
    }

    public static void writeOutRunConfigurationHeader(BufferedWriter bufferedWriter, RunConfiguration runConfiguration, Boolean bl) throws IOException {
        PersistenceUtils.writeCommentAndAnnotationAndNewline(bufferedWriter, Comment.CELL, Annotation.NAME, runConfiguration.getName());
        PersistenceUtils.writeCommentAndAnnotationAndNewline(bufferedWriter, Comment.PLAIN, Annotation.ASSOCIATED_FILE, runConfiguration.getAssociatedFile().getAbsolutePath());
        PersistenceUtils.writeCommentAndAnnotationAndNewline(bufferedWriter, Comment.PLAIN, Annotation.MOST_RECENTLY_ACTIONED_ANNOTATION, bl.toString());
        PersistenceUtils.writeCommentAndAnnotationAndNewline(bufferedWriter, Comment.PLAIN, Annotation.UNIQUE_ID, runConfiguration.getUniqueID());
    }

    public static void writeOutMatlabExpressionAsVariableAndNewLine(BufferedWriter bufferedWriter, String string, String string2) throws IOException {
        String[] stringArray = string2.split(IN_MEMORY_LINE_SEPARATOR);
        bufferedWriter.write(string + CODE_TO_EVALUATE_START);
        bufferedWriter.newLine();
        if (stringArray != null) {
            for (String string3 : stringArray) {
                String string4 = StringUtils.quoteSingleQuotes((String)string3);
                bufferedWriter.write("'" + string4 + "'");
                bufferedWriter.write(CODE_TO_EVALUATE_LINE_BREAK);
                bufferedWriter.newLine();
            }
        }
        bufferedWriter.write(CODE_TO_EVALUATE_END);
        bufferedWriter.newLine();
    }

    public static String convertPropertyToMatlabString(Property property) {
        ConfigurationJideUtils.initConverters();
        ConverterContext converterContext = property.getConverterContext() == null ? ConverterContext.DEFAULT_CONTEXT : property.getConverterContext();
        String string = ObjectConverterManager.toString((Object)property.getValue(), (Class)property.getType(), (ConverterContext)converterContext);
        String string2 = string = string == null ? "" : string;
        if (property.getType().equals(String.class) || property.getType().equals(File.class) || property.getValue() instanceof Enum) {
            string = "'" + string + "'";
        }
        return string;
    }

    private static String removeEnclosingSingleQuotes(String string) {
        if (string != null && string.length() > 1 && string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'') {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    private static String removeTrailingSemiColon(String string) {
        if (string != null && string.length() > 0 && string.charAt(string.length() - 1) == ';') {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static enum Annotation {
        VERSION("version"),
        NAME("name"),
        ASSOCIATED_FILE("associatedFile"),
        UNIQUE_ID("uniqueId"),
        MATLAB_EXPRESSION("matlabExpression"),
        MOST_RECENTLY_ACTIONED_ANNOTATION("mostRecentlyActioned"),
        PUBLISH_OPTIONS_BASED_ON("publishOptionsBasedOn");

        private static Map<String, Annotation> reverseMap;
        private final String fAnnotationText;

        private Annotation(String string2) {
            this.fAnnotationText = "@" + string2;
        }

        public String toString() {
            return this.fAnnotationText;
        }

        public static String prepareAnnotationValueForValueOf(String string) {
            return string.replace("@", "").toUpperCase();
        }

        public static Annotation reverseLookup(String string) {
            if (reverseMap.isEmpty()) {
                for (Annotation annotation : Annotation.values()) {
                    reverseMap.put(annotation.fAnnotationText, annotation);
                }
            }
            return reverseMap.get(string);
        }

        static {
            reverseMap = new HashMap<String, Annotation>();
        }
    }

    public static enum Comment {
        PLAIN("% "),
        CELL("%%");

        private final String fCommentString;

        private Comment(String string2) {
            this.fCommentString = string2;
        }

        public String toString() {
            return this.fCommentString;
        }
    }
}

