/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.configeditor.ui;

import ca.odell.glazedlists.swing.EventComboBoxModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mlwidgets.configeditor.ConfigurationUtils;
import com.mathworks.mlwidgets.configeditor.data.BasePublishOptions;
import com.mathworks.mlwidgets.configeditor.data.DerivedPublishOptions;
import com.mathworks.mlwidgets.configeditor.data.PublishConfiguration;
import com.mathworks.mlwidgets.configeditor.plugin.ConfigurationPluginUtils;
import com.mathworks.mlwidgets.configeditor.plugin.PublishConfigurationPlugin;
import com.mathworks.mlwidgets.configeditor.ui.AbstractRunConfigurationDetailsEditor;
import com.mathworks.mlwidgets.configeditor.ui.PublishOptionsPanel;
import com.mathworks.mlwidgets.configeditor.ui.PublishOptionsSaveDialog;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJSplitPane;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class PublishConfigurationDetailsEditor
extends AbstractRunConfigurationDetailsEditor<PublishConfiguration> {
    private PublishOptionsPanel fPublishOptionsPanel;
    private EventComboBoxModel<BasePublishOptions> fComboBoxModel;
    private MJComboBox fComboBox;
    private MJButton fSaveAsButton;
    private PropertyChangeListener fPropertyChangeListener;
    private ActionListener fSaveAsListener;
    private ActionListener fComboboxListener;
    private PublishOptionsSaveDialog.SaveAsListener fSaveAsCompletedListener;
    private boolean fPropogateComboBoxSelection = true;

    @Override
    protected void init() {
        this.fPublishOptionsPanel = new PublishOptionsPanel();
        PublishConfigurationPlugin publishConfigurationPlugin = (PublishConfigurationPlugin)ConfigurationPluginUtils.getPluginManager().getPlugin(PublishConfiguration.TYPE);
        this.fComboBoxModel = new EventComboBoxModel(publishConfigurationPlugin.getBasePublishOptions());
        this.fComboBox = new CustomMJComboBox((ComboBoxModel)this.fComboBoxModel);
        this.fComboBox.setRenderer((ListCellRenderer)new WrappedListCellRenderer(this.fComboBox.getRenderer()));
        this.updateComboboxWidth();
        this.fSaveAsButton = new MJButton(ConfigurationUtils.lookup("saveas.button"));
        this.fPropertyChangeListener = this.createPropertyChangeListener();
        this.initListeners();
        this.initNames();
        super.init();
    }

    @Override
    protected void initLayout() {
        MJLabel mJLabel = new MJLabel(ConfigurationUtils.lookup("publishConfiguration.name.label"));
        FormLayout formLayout = new FormLayout("d, 3dlu, d:grow, 2dlu, d, " + this.getMLintBarWidthIncludingSpacer_px() + "px", "2dlu, d, 10dlu, d:grow");
        CellConstraints cellConstraints = new CellConstraints();
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)this.fEditorComponent);
        panelBuilder.add((Component)mJLabel, cellConstraints.xywh(1, 2, 1, 1, "left, center"));
        panelBuilder.add((Component)this.fName, cellConstraints.xywh(3, 2, 2, 1, "fill, center"));
        panelBuilder.add((Component)this.buildSplitPane(), cellConstraints.xywh(1, 4, 6, 1, "fill, fill"));
    }

    private void initListeners() {
        this.fSaveAsCompletedListener = new PublishOptionsSaveDialog.SaveAsListener(){

            @Override
            public void saveAsCompleted() {
                PublishConfigurationDetailsEditor.this.getEditorComponent().repaint();
            }
        };
        this.fSaveAsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PublishOptionsSaveDialog publishOptionsSaveDialog = new PublishOptionsSaveDialog((Frame)MJFrame.getFrame((Component)PublishConfigurationDetailsEditor.this.getEditorComponent()), PublishConfigurationDetailsEditor.this.fSaveAsCompletedListener, PublishConfigurationDetailsEditor.this.fPublishOptionsPanel.getPublishOptions());
                publishOptionsSaveDialog.showDialog();
            }
        };
        this.fSaveAsButton.addActionListener(this.fSaveAsListener);
        this.fComboboxListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PublishConfigurationDetailsEditor.this.fPropogateComboBoxSelection) {
                    PublishConfigurationDetailsEditor.this.doChangeBasePublishOptions();
                }
            }
        };
        this.fComboBox.addActionListener(this.fComboboxListener);
    }

    private void initNames() {
        this.fSaveAsButton.setName("PublishConfigurationDetailsEditor.SaveAsButton");
        this.fComboBox.setName("PublishConfigurationDetailsEditor.ComboBox");
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.fComboBoxModel.dispose();
        this.fComboBox.removeActionListener(this.fComboboxListener);
        this.fSaveAsButton.removeActionListener(this.fSaveAsListener);
        this.unregisterPropertyChangeListener();
        this.fPublishOptionsPanel.cleanup();
    }

    private void updateComboboxWidth() {
        Dimension dimension = this.fComboBox.getUI().getPreferredSize((JComponent)this.fComboBox);
        int n = this.fComboBox.getFontMetrics(this.fComboBox.getFont()).stringWidth(ConfigurationUtils.lookup("publish.options.modifed"));
        dimension.width = dimension.width + n + 5;
        this.fComboBox.setPreferredSize(dimension);
    }

    private void unregisterPropertyChangeListener() {
        DerivedPublishOptions derivedPublishOptions = this.fPublishOptionsPanel.getPublishOptions();
        if (derivedPublishOptions != null) {
            derivedPublishOptions.removePropertyChangeListener(this.fPropertyChangeListener);
        }
    }

    private PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PublishConfigurationDetailsEditor.this.fComboBox.repaint();
                if (propertyChangeEvent.getPropertyName().equals("basePublishOptions")) {
                    PublishConfigurationDetailsEditor.this.fComboBox.setSelectedItem((Object)PublishConfigurationDetailsEditor.this.fPublishOptionsPanel.getPublishOptions().getBasePublishOptions());
                }
            }
        };
    }

    private void doChangeBasePublishOptions() {
        BasePublishOptions basePublishOptions = (BasePublishOptions)this.fComboBox.getSelectedItem();
        DerivedPublishOptions derivedPublishOptions = this.fPublishOptionsPanel.getPublishOptions();
        derivedPublishOptions.setBasePublishOptions(basePublishOptions);
        derivedPublishOptions.setBeanProperties(basePublishOptions);
    }

    private MJSplitPane buildSplitPane() {
        MJSplitPane mJSplitPane = new MJSplitPane(0, true, (Component)this.buildMatlabExpressionPanel(), (Component)this.buildPublishOptionsPanel());
        double d = PlatformInfo.isMacintosh() ? 0.27 : 0.34;
        mJSplitPane.setDividerLocation(d);
        mJSplitPane.setResizeWeight(0.5);
        mJSplitPane.setBorder(null);
        if (!PlatformInfo.isMacintosh()) {
            mJSplitPane.setDividerSize(8);
            ((BasicSplitPaneUI)mJSplitPane.getUI()).getDivider().setBorder(BorderFactory.createEmptyBorder());
        }
        return mJSplitPane;
    }

    private MJPanel buildPublishOptionsPanel() {
        MJPanel mJPanel = new MJPanel();
        MJLabel mJLabel = new MJLabel(ConfigurationUtils.lookup("details.publishOptions.label"));
        FormLayout formLayout = new FormLayout("d, 3dlu, d, 2dlu, d, d:grow, " + this.getMLintBarWidthIncludingSpacer_px() + "px", "d, 3dlu, d:grow");
        CellConstraints cellConstraints = new CellConstraints();
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)mJPanel);
        String string = PlatformInfo.isMacintosh() ? "bottom" : "center";
        panelBuilder.add((Component)mJLabel, cellConstraints.xywh(1, 1, 1, 1, "left, center"));
        panelBuilder.add((Component)this.fComboBox, cellConstraints.xywh(3, 1, 1, 1, "left, " + string));
        panelBuilder.add((Component)this.fSaveAsButton, cellConstraints.xywh(5, 1, 1, 1, "left, " + string));
        panelBuilder.add(this.fPublishOptionsPanel.getComponent(), cellConstraints.xywh(1, 3, 6, 1, "fill, fill"));
        return mJPanel;
    }

    private MJPanel buildMatlabExpressionPanel() {
        MJPanel mJPanel = new MJPanel();
        MJLabel mJLabel = new MJLabel(ConfigurationUtils.lookup("details.matlabExpression.label"));
        FormLayout formLayout = new FormLayout("d, 3dlu, d:grow, 2dlu, d, " + this.getMLintBarWidthIncludingSpacer_px() + "px", "d, 3dlu, d:grow");
        CellConstraints cellConstraints = new CellConstraints();
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)mJPanel);
        panelBuilder.add((Component)mJLabel, cellConstraints.xywh(1, 1, 2, 1, "left, center"));
        panelBuilder.add(this.fMatlabExpression.getDisplayComponent(), cellConstraints.xywh(1, 3, 6, 1, "fill, fill"));
        return mJPanel;
    }

    @Override
    public void edit(PublishConfiguration publishConfiguration) {
        this.unregisterPropertyChangeListener();
        super.edit(publishConfiguration);
        this.fPublishOptionsPanel.setPublishOptions(publishConfiguration);
        this.fPropogateComboBoxSelection = false;
        this.fComboBoxModel.setSelectedItem((Object)publishConfiguration.getPublishOptions().getBasePublishOptions());
        this.fPropogateComboBoxSelection = true;
        publishConfiguration.getPublishOptions().addPropertyChangeListener(this.fPropertyChangeListener);
    }

    private class WrappedListCellRenderer
    extends BasicComboBoxRenderer {
        private ListCellRenderer fRealRenderer;

        public WrappedListCellRenderer(ListCellRenderer listCellRenderer) {
            this.fRealRenderer = listCellRenderer;
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = object.toString();
            if (n == -1 && PublishConfigurationDetailsEditor.this.fPublishOptionsPanel.getPublishOptions() != null && PublishConfigurationDetailsEditor.this.fPublishOptionsPanel.getPublishOptions().haveAnyPropertiesBeenModified()) {
                string = string + " " + ConfigurationUtils.lookup("publish.options.modifed");
            }
            return this.fRealRenderer.getListCellRendererComponent(jList, string, n, bl, bl2);
        }
    }

    private class CustomMJComboBox
    extends MJComboBox {
        public CustomMJComboBox(ComboBoxModel comboBoxModel) {
            super(comboBoxModel);
        }

        public int getSelectedIndex() {
            return PublishConfigurationDetailsEditor.this.fPublishOptionsPanel.getPublishOptions() != null && PublishConfigurationDetailsEditor.this.fPublishOptionsPanel.getPublishOptions().haveAnyPropertiesBeenModified() ? -1 : super.getSelectedIndex();
        }

        public void setSelectedIndex(int n) {
            if (PublishConfigurationDetailsEditor.this.fPublishOptionsPanel.getPublishOptions().haveAnyPropertiesBeenModified()) {
                BasePublishOptions basePublishOptions = (BasePublishOptions)this.getItemAt(n);
                String string = MessageFormat.format(ConfigurationUtils.lookup("publish.options.loss.change.button"), basePublishOptions.getName());
                String string2 = ConfigurationUtils.lookup("publish.options.loss.dontchange.button");
                String string3 = MessageFormat.format(ConfigurationUtils.lookup("publish.options.loss.message"), PublishConfigurationDetailsEditor.this.fPublishOptionsPanel.getPublishOptions().getBasePublishOptions().getName(), basePublishOptions.getName());
                String string4 = ConfigurationUtils.lookup("publish.options.loss.dialog.title");
                Object[] objectArray = new String[]{string, string2};
                int n2 = MJOptionPane.showOptionDialog((Component)PublishConfigurationDetailsEditor.this.getEditorComponent(), (Object)string3, (String)string4, (int)0, (int)3, null, (Object[])objectArray, (Object)objectArray[0]);
                if (n2 == 0) {
                    super.setSelectedIndex(n);
                }
            } else {
                super.setSelectedIndex(n);
            }
        }
    }
}

