/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.configeditor.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.combobox.ListExComboBox;
import com.jidesoft.converter.EnumConverter;
import com.jidesoft.grid.CellEditorFactory;
import com.jidesoft.grid.CellEditorManager;
import com.jidesoft.grid.CellRendererManager;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.EnumCellEditor;
import com.jidesoft.grid.Property;
import com.jidesoft.grid.PropertyTableCellRenderer;
import com.jidesoft.grid.PropertyTableModel;
import com.jidesoft.grid.StyleModel;
import com.jidesoft.grid.TableUtils;
import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.configeditor.ConfigurationJideUtils;
import com.mathworks.mlwidgets.configeditor.ConfigurationUtils;
import com.mathworks.mlwidgets.configeditor.data.DerivedPublishOptions;
import com.mathworks.mlwidgets.configeditor.data.PublishConfiguration;
import com.mathworks.mlwidgets.configeditor.data.PublishOptions;
import com.mathworks.mlwidgets.configeditor.ui.ConfigurationEditor;
import com.mathworks.mlwidgets.configeditor.ui.FileOrFolderCellRendererAndEditor;
import com.mathworks.mwswing.MJEditorPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.table.ListColorUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.jidesoft.grid.MWPropertyTable;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.CellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class PublishOptionsPanel {
    private final MJPanel fPanel = new MJPanel();
    private PublishConfiguration fConfiguration;
    private final PropertyTableModel<Property> fModel = new StylePropertyTableModel();
    private final MWPropertyTable fTable = this.createCustomPropertyTable();
    private final MJScrollPane fScrollPane = new MJScrollPane((Component)this.fTable, 20, 30);
    private final MJEditorPane fDescriptionPane = new MJEditorPane();
    private final MJScrollPane fDescriptionScrollPane = new MJScrollPane((Component)this.fDescriptionPane, 20, 31);
    private PropertyChangeListener fPropertyChangeListener;
    private ListSelectionListener fSelectionListener;
    private HyperlinkListener fHyperlinkListener;

    public PublishOptionsPanel() {
        this.init();
    }

    private void init() {
        ConfigurationJideUtils.initConverters();
        FormLayout formLayout = new FormLayout("d:grow", "d:grow, 2dlu, " + ConfigurationEditor.getSubPanelHeight() + "px");
        CellConstraints cellConstraints = new CellConstraints();
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)this.fPanel);
        panelBuilder.add((Component)this.fScrollPane, cellConstraints.xywh(1, 1, 1, 1, "fill, fill"));
        panelBuilder.add((Component)this.fDescriptionScrollPane, cellConstraints.xywh(1, 3, 1, 1, "fill, fill"));
        this.fTable.setTableHeader(null);
        this.fTable.setShowGrid(true);
        this.fTable.setPaintMarginBackground(false);
        this.fTable.setSelectionBackground(ListColorUtils.getListBackgroundColor((JTable)this.fTable, (int)0, (boolean)true, (boolean)true));
        this.fTable.setSelectionForeground(ListColorUtils.getListForegroundColor((JTable)this.fTable, (boolean)true, (boolean)true));
        this.fScrollPane.getViewport().setBackground(this.fTable.getBackground());
        this.fDescriptionPane.setContentType(new HTMLEditorKit().getContentType());
        this.fDescriptionPane.setOpaque(false);
        this.fDescriptionPane.setEditable(false);
        Font font = UIManager.getFont("Label.font");
        String string = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; }";
        ((HTMLDocument)this.fDescriptionPane.getDocument()).getStyleSheet().addRule(string);
        this.fDescriptionPane.setMargin(new Insets(0, 5, 0, 0));
        this.fDescriptionScrollPane.setOpaque(false);
        this.fDescriptionScrollPane.getViewport().setOpaque(false);
        this.fDescriptionScrollPane.setBorder(null);
        this.fPropertyChangeListener = this.createPropertyChangeListener();
        CellRendererManager.initDefaultRenderer();
        CellEditorManager.initDefaultEditor();
        this.initEditors();
        this.initRenderers();
        this.fTable.setRowHeight(Math.max(19, this.fTable.getRowHeight()));
        this.fTable.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        this.updateDescription(null);
        this.initNames();
        this.initListeners();
    }

    private void initRenderers() {
        CellRendererManager.registerRenderer(PublishOptions.ImageFormat.class, (TableCellRenderer)new ImageFormatRenderer());
        CellRendererManager.registerRenderer(File.class, (TableCellRenderer)new OutputLocationRendererAndEditor(), (EditorContext)new EditorContext("outputLocation"));
    }

    private void initEditors() {
        CellEditorManager.registerEditor(File.class, (CellEditorFactory)new CellEditorFactory(){

            public CellEditor create() {
                return new OutputLocationRendererAndEditor();
            }
        }, (EditorContext)new EditorContext("outputLocation"));
        CellEditorManager.registerEditor(File.class, (CellEditorFactory)new CellEditorFactory(){

            public CellEditor create() {
                return new FileCellRendererAndEditor();
            }
        }, (EditorContext)new EditorContext("file"));
        CellEditorManager.registerEditor(PublishOptions.FileFormat.class, (CellEditorFactory)new CellEditorFactory(){

            public CellEditor create() {
                return new EnumCellEditor((EnumConverter)new ConfigurationJideUtils.FileFormatConverter());
            }
        });
        CellEditorManager.registerEditor(PublishOptions.FigureCaptureMethod.class, (CellEditorFactory)new CellEditorFactory(){

            public CellEditor create() {
                return new EnumCellEditor((EnumConverter)new ConfigurationJideUtils.FigureCaptureMethodConverter());
            }
        });
        CellEditorManager.registerEditor(PublishOptions.ImageFormat.class, (CellEditorFactory)new CellEditorFactory(){

            public CellEditor create() {
                PublishOptions.ImageFormat[] imageFormatArray = ConfigurationUtils.getDefaultImageFormat(PublishOptionsPanel.this.fConfiguration.getPublishOptions().getFigureCaptureMethod(), PublishOptionsPanel.this.fConfiguration.getPublishOptions().getOutputFileFormat());
                PublishOptions.ImageFormat[] imageFormatArray2 = PublishOptionsPanel.this.fConfiguration.getPublishOptions().getSupportedImageFormats();
                return new EnumCellEditor((EnumConverter)new ConfigurationJideUtils.ImageFormatWithDefaultSupportConverter(imageFormatArray, imageFormatArray2));
            }
        });
    }

    private void initListeners() {
        this.fSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                PropertyTableModel propertyTableModel = (PropertyTableModel)PublishOptionsPanel.this.fTable.getModel();
                Property property = propertyTableModel.getPropertyAt(PublishOptionsPanel.this.fTable.getSelectedRow());
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    PublishOptionsPanel.this.updateDescription(property == null ? null : property.getDescription());
                }
            }
        };
        this.fTable.getSelectionModel().addListSelectionListener(this.fSelectionListener);
        this.fHyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    MLHelpServices.showReferencePage((String)hyperlinkEvent.getDescription());
                }
            }
        };
        this.fDescriptionPane.addHyperlinkListener(this.fHyperlinkListener);
    }

    private void initNames() {
        this.fTable.setName("PublishOptionsPanel.Table");
        this.fScrollPane.setName("PublishOptionsPanel.ScrollPane");
    }

    private CustomPropertyTable createCustomPropertyTable() {
        return new CustomPropertyTable((TableModel)this.fModel){

            public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
                Component component = super.prepareEditor(tableCellEditor, n, n2);
                if (PlatformInfo.isMacintosh() && component instanceof ListExComboBox) {
                    ((ListExComboBox)component).setUI((ComboBoxUI)new BasicComboBoxUI());
                }
                return component;
            }
        };
    }

    public void cleanup() {
        this.unregisterPropertyChangeListener();
        this.fTable.getSelectionModel().removeListSelectionListener(this.fSelectionListener);
        this.fDescriptionPane.removeHyperlinkListener(this.fHyperlinkListener);
        this.fConfiguration = null;
        this.fModel.setOriginalProperties(new ArrayList());
        CellRendererManager.unregisterRenderer(PublishOptions.ImageFormat.class);
        CellRendererManager.unregisterRenderer(File.class, (EditorContext)new EditorContext("outputLocation"));
        CellEditorManager.unregisterEditor(File.class, (EditorContext)new EditorContext("outputLocation"));
        CellEditorManager.unregisterEditor(File.class, (EditorContext)new EditorContext("file"));
        CellEditorManager.unregisterEditor(PublishOptions.FileFormat.class);
        CellEditorManager.unregisterEditor(PublishOptions.FigureCaptureMethod.class);
        CellEditorManager.unregisterEditor(PublishOptions.ImageFormat.class);
    }

    public Component getComponent() {
        return this.fPanel;
    }

    public DerivedPublishOptions getPublishOptions() {
        return this.fConfiguration == null ? null : this.fConfiguration.getPublishOptions();
    }

    public void setPublishOptions(PublishConfiguration publishConfiguration) {
        this.unregisterPropertyChangeListener();
        this.fConfiguration = publishConfiguration;
        this.fModel.setOriginalProperties(new ArrayList<Property>(this.fConfiguration.getPublishOptions().getBeanProperties()));
        this.fConfiguration.getPublishOptions().addPropertyChangeListener(this.fPropertyChangeListener);
        this.fTable.expandFirstLevel();
        this.resizeColumns();
    }

    private void updateDescription(String string) {
        this.fDescriptionPane.setText(string);
    }

    private void resizeColumns() {
        int[] nArray = TableUtils.autoResizeAllColumns((JTable)this.fTable, (boolean)false);
        this.fTable.getColumnModel().getColumn(0).setMaxWidth(nArray[0]);
    }

    private void unregisterPropertyChangeListener() {
        if (this.fConfiguration != null) {
            this.fConfiguration.getPublishOptions().removePropertyChangeListener(this.fPropertyChangeListener);
        }
    }

    private PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PublishOptionsPanel.this.fTable.repaint();
            }
        };
    }

    private static class FileCellRendererAndEditor
    extends FileOrFolderCellRendererAndEditor {
        public static final String CONTEXT = "file";

        private FileCellRendererAndEditor() {
            super(FileOrFolderCellRendererAndEditor.Type.FILE);
        }
    }

    private class OutputLocationRendererAndEditor
    extends FileOrFolderCellRendererAndEditor {
        public static final String CONTEXT = "outputLocation";

        private OutputLocationRendererAndEditor() {
            super(FileOrFolderCellRendererAndEditor.Type.FOLDER);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            object = object == null ? ConfigurationUtils.getDefaultPublishOuputLocation(PublishOptionsPanel.this.fConfiguration) : object;
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            object = object == null ? ConfigurationUtils.getDefaultPublishOuputLocation(PublishOptionsPanel.this.fConfiguration) : object;
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return this.getTextField();
        }

        @Override
        public Object getCellEditorValue() {
            Object object = super.getCellEditorValue();
            File file = PublishOptionsPanel.this.fConfiguration.getPublishOptions().getBasePublishOptions().getOutputLocation();
            if ((object == null || object.equals("")) && file != null) {
                object = file;
            } else if (object == null || object.equals("") || object.equals(ConfigurationUtils.getDefaultPublishOuputLocation(PublishOptionsPanel.this.fConfiguration))) {
                object = null;
            }
            return object;
        }
    }

    private class ImageFormatRenderer
    extends DefaultTableCellRenderer {
        private ImageFormatRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == PublishOptions.ImageFormat.DEFAULT) {
                object = PublishOptions.ImageFormat.getDefaultImageDisplayText(ConfigurationUtils.getDefaultImageFormat(PublishOptionsPanel.this.fConfiguration.getPublishOptions().getFigureCaptureMethod(), PublishOptionsPanel.this.fConfiguration.getPublishOptions().getOutputFileFormat()));
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    private class StylePropertyTableModel
    extends PropertyTableModel<Property>
    implements StyleModel {
        private final CellStyle fStyle = new CellStyle();
        private final Icon fEmptyIcon;

        private StylePropertyTableModel() {
            this.fEmptyIcon = new ImageIcon(){

                @Override
                public int getIconWidth() {
                    return MiscellaneousIcon.DIRTY_MARKER.getIcon().getIconWidth();
                }

                @Override
                public int getIconHeight() {
                    return MiscellaneousIcon.DIRTY_MARKER.getIcon().getIconHeight();
                }
            };
        }

        public CellStyle getCellStyleAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    boolean bl = PublishOptionsPanel.this.fConfiguration.getPublishOptions().hasPropertyBeenModified(this.getPropertyAt(n));
                    Icon icon = this.fEmptyIcon;
                    if (bl && PublishOptionsPanel.this.fTable.isCellSelected(n, n2)) {
                        icon = MiscellaneousIcon.DIRTY_MARKER_INVERTED.getIcon();
                    } else if (bl) {
                        icon = MiscellaneousIcon.DIRTY_MARKER.getIcon();
                    }
                    this.fStyle.setIcon(icon);
                    this.fStyle.setHorizontalAlignment(2);
                    this.fStyle.setVerticalAlignment(0);
                    this.fStyle.setBorder(null);
                    break;
                }
                case 1: {
                    this.fStyle.setIcon(null);
                    this.fStyle.setHorizontalAlignment(2);
                    this.fStyle.setVerticalAlignment(0);
                    this.fStyle.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
                }
            }
            return this.fStyle;
        }

        public boolean isCellStyleOn() {
            return true;
        }
    }

    private static class CustomPropertyTableCellRenderer
    extends PropertyTableCellRenderer {
        private CustomPropertyTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
        }
    }

    private static class CustomPropertyTable
    extends MWPropertyTable {
        private CustomPropertyTable(TableModel tableModel) {
            super(tableModel);
        }

        protected TableCellRenderer createPropertyCellRenderer() {
            return new CustomPropertyTableCellRenderer();
        }
    }
}

