/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.archive;

import com.mathworks.matlab.api.explorer.ActionConfiguration;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.CoreActionID;
import com.mathworks.matlab.api.explorer.CoreFileDecoration;
import com.mathworks.matlab.api.explorer.FileDecoration;
import com.mathworks.matlab.api.explorer.FileDecorations;
import com.mathworks.matlab.api.explorer.FileDecorators;
import com.mathworks.matlab.api.explorer.FileInfoProvider;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.FileDecorationModel;
import com.mathworks.mlwidgets.explorer.model.actions.ActionPredicates;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.model.vfs.VirtualFileSystem;
import com.mathworks.mlwidgets.explorer.util.FileSystemUtils;
import com.mathworks.util.DeferrableRetriever;
import com.mathworks.util.Holder;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import com.mathworks.util.RequestQueue;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;

public final class ZipFileContentInfoProvider
implements FileInfoProvider,
ActionProvider {
    private final RequestQueue fRequestQueue = new RequestQueue("Zip content decoration request queue");

    public boolean isApplicable(FileSystemEntry fileSystemEntry) {
        return ZipFileContentInfoProvider.isInZip(fileSystemEntry);
    }

    public void configureDecorations(final FileSystemEntry fileSystemEntry, FileDecorators fileDecorators, FileDecorations fileDecorations) {
        this.addTempDecorationRetrieverIfNecessary(fileSystemEntry, fileDecorators, CoreFileDecoration.TYPE_NAME);
        this.addTempDecorationRetrieverIfNecessary(fileSystemEntry, fileDecorators, CoreFileDecoration.ICON);
        fileDecorators.set(CoreFileDecoration.SPECIAL_PATH_TOOLTIP_TEXT, (DeferrableRetriever)new DeferrableRetriever<String>(){

            public void run(ParameterRunnable<String> parameterRunnable, Runnable runnable) {
                File file = FileSystemUtils.getClosestRealAncestor(fileSystemEntry, true);
                if (file == null) {
                    runnable.run();
                } else {
                    parameterRunnable.run((Object)MessageFormat.format(ExplorerResources.getString("tooltip.notOnPath.zip"), file.getName()));
                }
            }
        });
    }

    public void configureActions(ActionRegistry actionRegistry) {
        actionRegistry.getAction(CoreActionID.RUN).setEnabled(ActionConfiguration.NEVER);
        actionRegistry.getAction(CoreActionID.ADD_SELECTED_FOLDERS_RECURSIVE).setEnabled(ActionConfiguration.NEVER);
        actionRegistry.getAction(CoreActionID.ADD_SELECTED_FOLDERS_TO_PATH).setEnabled(ActionConfiguration.NEVER);
        actionRegistry.getAction(CoreActionID.LOCATE_ON_DISK).setEnabled(ActionConfiguration.NEVER);
        actionRegistry.getAction(CoreActionID.SHOW_FOLDER_IN_FILESYSTEM).setEnabled(ActionConfiguration.NEVER);
        actionRegistry.getAction(CoreActionID.OPEN).setEnabled((Predicate)ActionPredicates.NOT_ALL_DIRECTORIES_SELECTED);
        actionRegistry.getAction(CoreActionID.NEW_FILE_MENU).setVisibleOnContextMenu(ActionConfiguration.NEVER);
        actionRegistry.getAction(CoreActionID.NEW_FILE_MENU).setEnabled(ActionConfiguration.NEVER);
        actionRegistry.getAction(CoreActionID.NEW_FOLDER).setVisibleOnContextMenu(ActionConfiguration.NEVER);
        actionRegistry.getAction(CoreActionID.NEW_FOLDER).setEnabled(ActionConfiguration.NEVER);
    }

    private static boolean isInZip(FileSystemEntry fileSystemEntry) {
        if (!(fileSystemEntry.getSystem() instanceof VirtualFileSystem)) {
            return false;
        }
        if (fileSystemEntry.isReal()) {
            return false;
        }
        VirtualFileSystem virtualFileSystem = (VirtualFileSystem)fileSystemEntry.getSystem();
        for (FileLocation fileLocation = fileSystemEntry.getLocation().getParent(); fileLocation != null; fileLocation = fileLocation.getParent()) {
            if (!fileLocation.checkExtension(new String[]{"zip"}) || !virtualFileSystem.isMountPoint(fileLocation)) continue;
            return true;
        }
        return false;
    }

    private <T> void addTempDecorationRetrieverIfNecessary(final FileSystemEntry fileSystemEntry, final FileDecorators fileDecorators, final FileDecoration<T> fileDecoration) {
        if (PlatformInfo.isMacintosh() && ZipFileContentInfoProvider.isInZip(fileSystemEntry)) {
            fileDecorators.set(fileDecoration, new DeferrableRetriever<T>(){

                public void run(final ParameterRunnable<T> parameterRunnable, Runnable runnable) {
                    block3: {
                        final Holder holder = new Holder();
                        try {
                            holder.set((Object)File.createTempFile("temp", "." + fileSystemEntry.getLocation().getExtension()));
                            if (fileSystemEntry.isFolder()) {
                                ((File)holder.get()).delete();
                                ((File)holder.get()).mkdirs();
                            }
                            FileDecorationModel fileDecorationModel = new FileDecorationModel(fileDecorators.getExtensions(), ZipFileContentInfoProvider.this.fRequestQueue, RealFileSystem.getInstance().getEntry(new FileLocation((File)holder.get())));
                            fileDecorationModel.getDecorations().get(fileDecoration, false, new ParameterRunnable<T>(){

                                public void run(T t) {
                                    parameterRunnable.run(t);
                                    ((File)holder.get()).delete();
                                }
                            });
                        }
                        catch (IOException iOException) {
                            runnable.run();
                            if (holder.get() == null) break block3;
                            ((File)holder.get()).delete();
                        }
                    }
                }
            });
        }
    }
}

