/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.basic;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.matlab.api.explorer.ActionConfiguration;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.CoreActionID;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.SelectionMode;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.matlab.api.explorer.StatusRunnable;
import com.mathworks.mlwidgets.explorer.extensions.basic.CoreActionProvider;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.actions.ActionPredicates;
import com.mathworks.mlwidgets.explorer.util.FileSystemUtils;
import com.mathworks.mlwidgets.explorer.util.MLFileSystemUtils;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.util.Converter;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CoreExternalActionProvider
implements ActionProvider {
    private static final Matlab sMatlab = new Matlab();

    public boolean isApplicable(FileSystemEntry fileSystemEntry) {
        return true;
    }

    public void configureActions(ActionRegistry actionRegistry) {
        Predicate predicate;
        Predicate predicate2;
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
            predicate2 = ActionPredicates.NO_DIRECTORIES;
            predicate = ActionConfiguration.ALWAYS;
        } else {
            predicate = ActionConfiguration.NEVER;
            predicate2 = ActionConfiguration.NEVER;
        }
        actionRegistry.getAction(CoreActionID.OPEN_OUTSIDE_MATLAB).setVisibleOnContextMenu(predicate2);
        actionRegistry.getAction(CoreActionID.OPEN_OUTSIDE_MATLAB).setEnabled(predicate);
        actionRegistry.getAction(CoreActionID.OPEN_OUTSIDE_MATLAB).setCode(SelectionMode.EXPLICIT_MULTIPLE_SELECTION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                return CoreExternalActionProvider.openOutsideMatlab(actionInput);
            }
        });
        actionRegistry.getAction(CoreActionID.OPEN_OUTSIDE_MATLAB).setLabel((Converter)new Converter<ActionInput, String>(){

            public String convert(ActionInput actionInput) {
                return ExplorerResources.getString("context.openOutsideMatlab");
            }
        });
        actionRegistry.getAction(CoreActionID.SHOW_FOLDER_IN_FILESYSTEM).setVisibleOnContextMenu(predicate2);
        actionRegistry.getAction(CoreActionID.SHOW_FOLDER_IN_FILESYSTEM).setEnabled(predicate);
        actionRegistry.getAction(CoreActionID.SHOW_FOLDER_IN_FILESYSTEM).setCode(SelectionMode.CURRENT_LOCATION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                return CoreExternalActionProvider.locateOnDisk(actionInput);
            }
        });
        actionRegistry.getAction(CoreActionID.LOCATE_ON_DISK).setEnabled((Predicate)ActionPredicates.NOT_X_WINDOWS);
        actionRegistry.getAction(CoreActionID.LOCATE_ON_DISK).setCode(SelectionMode.EXPLICIT_MULTIPLE_SELECTION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                return CoreExternalActionProvider.locateOnDisk(actionInput);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Status openOutsideMatlab(ActionInput actionInput) {
        ArrayList<Status> arrayList = new ArrayList<Status>();
        List<FileSystemEntry> list = CoreExternalActionProvider.getSelectionOrCurrentLocation(actionInput);
        String string = CoreActionProvider.formatLabel("progress.open", "progress.open.multiple", list);
        for (FileSystemEntry fileSystemEntry : FileSystemUtils.getUnderlyingEntries(list)) {
            Status status = new Status(string, true);
            arrayList.add(status);
            try {
                fileSystemEntry = fileSystemEntry.getSystem().followShortcutOrLink(fileSystemEntry);
                fileSystemEntry = MLFileSystemUtils.getMatlabAccessibleEntry(fileSystemEntry);
                CoreExternalActionProvider.openSelectionOrCurrentLocationOutsideMatlab(status, fileSystemEntry);
            }
            catch (IOException iOException) {
                MJOptionPane.showMessageDialog((Component)actionInput.getComponent(), (Object)MessageFormat.format(ExplorerResources.getString("open.outside.error"), fileSystemEntry.getName()), (String)ExplorerResources.getString("open.outside.error.title"), (int)0);
            }
            finally {
                status.markCompleted();
            }
        }
        return new Status(arrayList);
    }

    private static void open(File file) throws IOException {
        Desktop desktop = Desktop.getDesktop();
        desktop.open(file);
    }

    private static Status locateOnDisk(ActionInput actionInput) {
        ArrayList arrayList = new ArrayList();
        List<FileSystemEntry> list = CoreExternalActionProvider.getSelectionOrCurrentLocation(actionInput);
        String string = CoreActionProvider.formatLabel("progress.locating", "progress.locating.multiple", list);
        for (FileSystemEntry fileSystemEntry : FileSystemUtils.getUnderlyingEntries(list)) {
            Status status = new Status(string, true);
            if (!fileSystemEntry.isReal()) continue;
            try {
                CoreExternalActionProvider.locateAndOpenFilePathOnDisk(status, actionInput, fileSystemEntry);
            }
            catch (IOException iOException) {
                MJOptionPane.showMessageDialog((Component)actionInput.getComponent(), (Object)ExplorerResources.getString("open.selectioninfilesystem.platform.error"), (String)ExplorerResources.getString("open.selectioninfilesystem.platform.error.title"), (int)0);
            }
        }
        return new Status(arrayList);
    }

    public static void locateAndOpenFilePathOnDisk(Status status, ActionInput actionInput, FileSystemEntry fileSystemEntry) throws IOException {
        if (actionInput.getSelection().isEmpty()) {
            CoreExternalActionProvider.openSelectionOrCurrentLocationOutsideMatlab(status, fileSystemEntry);
        } else {
            CoreExternalActionProvider.showSelectionInNativeFileBrowser(status, fileSystemEntry);
        }
    }

    private static void showSelectionInNativeFileBrowser(Status status, FileSystemEntry fileSystemEntry) {
        if (PlatformInfo.isMacintosh()) {
            CoreExternalActionProvider.showInFinder(fileSystemEntry, status);
        } else if (PlatformInfo.isWindows()) {
            NativeJava.shellExecuteExplore((String)fileSystemEntry.getLocation().toString());
            status.markCompleted();
        } else {
            throw new IllegalStateException("locate on disk is not supported on this platform.");
        }
    }

    public static void openSelectionOrCurrentLocationOutsideMatlab(Status status, FileSystemEntry fileSystemEntry) throws IOException {
        File file = new File(fileSystemEntry.getLocation().toString());
        if (!file.exists()) {
            status.markCompleted();
            return;
        }
        CoreExternalActionProvider.open(file);
        status.markCompleted();
    }

    private static List<FileSystemEntry> getSelectionOrCurrentLocation(ActionInput actionInput) {
        List<FileSystemEntry> list = actionInput.getSelection();
        if (list.isEmpty()) {
            list = Arrays.asList(actionInput.getLocation());
        }
        return list;
    }

    private static void showInFinder(FileSystemEntry fileSystemEntry, final Status status) {
        assert (PlatformInfo.isMacintosh());
        assert (fileSystemEntry.isReal());
        String string = "unix 'osascript -e ''tell app \"Finder\" to select file \"" + fileSystemEntry.getLocation().toString() + "\" as POSIX file'''";
        sMatlab.eval(string, new CompletionObserver(){

            public void completed(int n, Object object) {
                String string = "unix 'osascript -e ''tell app \"Finder\" to activate'''";
                sMatlab.evalNoOutput(string, new CompletionObserver(){

                    public void completed(int n, Object object) {
                        status.markCompleted();
                    }
                });
            }
        });
    }
}

