/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.matlab;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.MLFileUtils;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorApplication;
import com.mathworks.matlab.api.explorer.ActionConfiguration;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.CoreActionID;
import com.mathworks.matlab.api.explorer.FileDecorations;
import com.mathworks.matlab.api.explorer.FileDecorators;
import com.mathworks.matlab.api.explorer.FileInfoProvider;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.SelectionMode;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.matlab.api.explorer.StatusRunnable;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mlwidgets.dialog.PathChange;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.editorfs.EditorFileSystem;
import com.mathworks.mlwidgets.explorer.util.MLFileSystemUtils;
import com.mathworks.util.Converter;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public final class RunnableFileInfoProvider
implements FileInfoProvider,
ActionProvider {
    public static final String I18N_NAME = ExplorerResources.getString("title");

    public boolean isApplicable(FileSystemEntry fileSystemEntry) {
        return !fileSystemEntry.isFolder() && MLFileUtils.isMatlabRunnableFile((String)fileSystemEntry.getLocation().toString());
    }

    public void configureDecorations(FileSystemEntry fileSystemEntry, FileDecorators fileDecorators, FileDecorations fileDecorations) {
    }

    public void configureActions(ActionRegistry actionRegistry) {
        actionRegistry.getAction(CoreActionID.RUN).setLabel((Converter)new Converter<ActionInput, String>(){

            public String convert(ActionInput actionInput) {
                if (RunnableFileInfoProvider.isAnyFileDirty(actionInput)) {
                    return ExplorerResources.getString("context.saveAndRun");
                }
                return null;
            }
        });
        ActionConfiguration actionConfiguration = actionRegistry.getAction(CoreActionID.RUN);
        actionConfiguration.setCode(SelectionMode.EXPLICIT_MULTIPLE_SELECTION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                ArrayList<Status> arrayList = new ArrayList<Status>();
                for (FileSystemEntry fileSystemEntry : actionInput.getSelection()) {
                    final Status status = new Status();
                    arrayList.add(status);
                    try {
                        FileSystemEntry fileSystemEntry2 = MLFileSystemUtils.getMatlabAccessibleEntry(fileSystemEntry);
                        final FileLocation fileLocation = fileSystemEntry2.getLocation();
                        final File file = new File(fileLocation.toString());
                        new PathChange((Frame)SwingUtilities.windowForComponent(actionInput.getComponent()), I18N_NAME, ExplorerResources.getString("msg.ToRun"), file.getAbsolutePath(), file, new CompletionObserver(){

                            public void completed(int n, Object object) {
                                String string;
                                if (RunnableFileInfoProvider.isFileDirty(fileLocation)) {
                                    string = new FileStorageLocation(file);
                                    EditorApplication editorApplication = MLEditorServices.getEditorApplication();
                                    Editor editor = editorApplication.getEditor((StorageLocation)string);
                                    editor.negotiateSave();
                                }
                                string = MatlabPath.getQualifiedFunctionOrMethodName((File)file);
                                MLExecuteServices.executeCommand((String)string);
                                status.markCompleted();
                            }
                        }, "matlab_env_csh", true);
                    }
                    catch (IOException iOException) {
                        status.markCompleted();
                    }
                }
                return new Status(arrayList);
            }
        });
    }

    public static boolean isAnyFileDirty(ActionInput actionInput) {
        for (FileSystemEntry fileSystemEntry : actionInput.getSelection()) {
            if (!fileSystemEntry.isReal() || !RunnableFileInfoProvider.isFileDirty(fileSystemEntry.getLocation())) continue;
            return true;
        }
        return false;
    }

    public static boolean isFileDirty(FileLocation fileLocation) {
        EditorFileSystem editorFileSystem = EditorFileSystem.getInstance();
        return editorFileSystem.isDirty(fileLocation);
    }
}

