/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model;

import com.mathworks.matlab.api.explorer.ExtensionRegistry;
import com.mathworks.matlab.api.explorer.FileDecoration;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.table.FileSystemExpansionProvider;
import com.mathworks.mlwidgets.explorer.util.UiFileSystemUtils;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.ReturnRunnable;
import com.mathworks.widgets.ClosableToolTipData;
import com.mathworks.widgets.grouptable.Affordance;
import com.mathworks.widgets.grouptable.ColorStyle;
import com.mathworks.widgets.grouptable.DisplayEffects;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DecorationToolTip<T>
implements Affordance<FileSystemEntry> {
    private final FileDecoration<T> fDecoration;
    private final ExtensionRegistry fExtensions;
    private final FileSystemExpansionProvider fExpansionProvider;
    private final String fColumnKey;
    private final MulticastChangeListener fChangeListeners;

    public DecorationToolTip(ExtensionRegistry extensionRegistry, FileDecoration<T> fileDecoration) {
        this(null, fileDecoration, null, extensionRegistry);
    }

    public DecorationToolTip(FileDecoration<T> fileDecoration, FileSystemExpansionProvider fileSystemExpansionProvider) {
        this(null, fileDecoration, fileSystemExpansionProvider, null);
    }

    public DecorationToolTip(ExtensionRegistry extensionRegistry, String string, FileDecoration<T> fileDecoration) {
        this(string, fileDecoration, null, extensionRegistry);
    }

    public DecorationToolTip(String string, FileDecoration<T> fileDecoration, FileSystemExpansionProvider fileSystemExpansionProvider) {
        this(string, fileDecoration, fileSystemExpansionProvider, null);
    }

    private DecorationToolTip(String string, FileDecoration<T> fileDecoration, FileSystemExpansionProvider fileSystemExpansionProvider, ExtensionRegistry extensionRegistry) {
        assert (extensionRegistry != null ^ fileSystemExpansionProvider != null);
        this.fExtensions = extensionRegistry;
        this.fColumnKey = string;
        this.fDecoration = fileDecoration;
        this.fExpansionProvider = fileSystemExpansionProvider;
        this.fChangeListeners = new MulticastChangeListener();
    }

    public Map<FileSystemEntry, DisplayEffects> getDisplayEffects(List<FileSystemEntry> list) {
        HashMap<FileSystemEntry, DisplayEffects> hashMap = new HashMap<FileSystemEntry, DisplayEffects>();
        for (FileSystemEntry fileSystemEntry : list) {
            hashMap.put(fileSystemEntry, new DisplayEffects(this.fColumnKey, (ReturnRunnable)new DecorationRetriever(fileSystemEntry), ColorStyle.NORMAL));
        }
        return hashMap;
    }

    public void notifyDataChanged() {
        this.fChangeListeners.stateChanged(new ChangeEvent(this));
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.removeChangeListener(changeListener);
    }

    private class DecorationRetriever
    implements ReturnRunnable<ClosableToolTipData> {
        private final FileSystemEntry iFile;

        DecorationRetriever(FileSystemEntry fileSystemEntry) {
            this.iFile = fileSystemEntry;
        }

        public ClosableToolTipData run() {
            Object t = DecorationToolTip.this.fExpansionProvider != null ? DecorationToolTip.this.fExpansionProvider.getDecoration(this.iFile, DecorationToolTip.this.fDecoration) : UiFileSystemUtils.getDecorationSynchronously(this.iFile, DecorationToolTip.this.fDecoration, DecorationToolTip.this.fExtensions);
            return t == null ? null : new ClosableToolTipData(t.toString());
        }
    }
}

