/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.actions;

import com.mathworks.matlab.api.explorer.ActionDefinition;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.ActionInputSource;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.CoreActionID;
import com.mathworks.matlab.api.explorer.CoreMenuSectionID;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.MenuSection;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.mlwidgets.explorer.model.actions.ActionConfigurationImpl;
import com.mathworks.mlwidgets.explorer.model.actions.ActionRegistryImpl;
import com.mathworks.mlwidgets.explorer.model.actions.ApplicableChecker;
import com.mathworks.mlwidgets.explorer.model.actions.CoreActionDefinition;
import com.mathworks.mlwidgets.explorer.model.actions.DynamicMenuContext;
import com.mathworks.mlwidgets.explorer.model.actions.DynamicMenuContributor;
import com.mathworks.mlwidgets.explorer.model.actions.DynamicMenuUtils;
import com.mathworks.mwswing.ComponentUtils;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.MInputMap;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.PopupListener;
import com.mathworks.services.binding.MatlabKeyBindings;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class ActionManager {
    private final ActionRegistryImpl fRegistry;
    private final ActionInputSource fSource;
    private final List<WeakReference<Component>> fBoundComponents;
    private final Map<ActionDefinition, MJAbstractAction> fActions;
    private final ActionList fBoundActionList;
    private final List<Runnable> fInputMapDisposers;
    private final ChangeListener fChangeListener;
    private final String fContextId;

    public ActionManager(String string, ActionInputSource actionInputSource, List<ActionProvider> list, Object ... objectArray) {
        this(string, actionInputSource, list, true, true, objectArray);
    }

    public ActionManager(String string, ActionInputSource actionInputSource, List<ActionProvider> list, Boolean bl, Boolean bl2, Object ... objectArray) {
        assert (SwingUtilities.isEventDispatchThread());
        this.fInputMapDisposers = new LinkedList<Runnable>();
        this.fBoundActionList = new ActionList(objectArray);
        this.fSource = actionInputSource;
        this.fContextId = string;
        this.fBoundComponents = new ArrayList<WeakReference<Component>>();
        this.fChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ActionManager.this.refreshActions();
            }
        };
        this.fRegistry = new ActionRegistryImpl(this.fSource);
        this.fActions = new HashMap<ActionDefinition, MJAbstractAction>();
        for (ActionProvider actionProvider : list) {
            actionProvider.configureActions(this.fRegistry.getBinding(actionProvider));
        }
        this.instantiateActions(bl);
        JComponent jComponent = this.fSource.getDefaultComponent();
        if (jComponent != null && bl.booleanValue()) {
            this.installKeyBindings(jComponent, false);
            this.installKeyBindings(jComponent, true);
        }
        if (jComponent != null && bl2.booleanValue()) {
            this.installContextMenu();
        }
        this.refreshActions();
        this.fSource.addInputChangeListener(this.fChangeListener);
    }

    public ActionRegistry getBinding(ActionProvider actionProvider) {
        return this.fRegistry.getBinding(actionProvider);
    }

    public MenuSection getMenuSection(CoreMenuSectionID coreMenuSectionID) {
        return this.fRegistry.getMenuSection(coreMenuSectionID);
    }

    public MenuSection getMenuSection(String string) {
        return this.fRegistry.getMenuSection(string);
    }

    public List<ActionDefinition> getActions() {
        return this.fRegistry.getActions();
    }

    public List<MJAbstractAction> getActions(CoreMenuSectionID coreMenuSectionID) {
        ArrayList<MJAbstractAction> arrayList = new ArrayList<MJAbstractAction>();
        for (ActionDefinition actionDefinition : this.fRegistry.getActions()) {
            if (actionDefinition.getMenuSection() == null || !actionDefinition.getMenuSection().getId().equals(coreMenuSectionID.toString())) continue;
            arrayList.add(this.fActions.get(actionDefinition));
        }
        return arrayList;
    }

    public Map<String, MJAbstractAction> getActionsAllowedOnToolbar() {
        LinkedHashMap<String, MJAbstractAction> linkedHashMap = new LinkedHashMap<String, MJAbstractAction>();
        for (ActionDefinition actionDefinition : this.fRegistry.getActions()) {
            MJAbstractAction mJAbstractAction = this.fActions.get(actionDefinition);
            if (mJAbstractAction.getButtonOnlyIcon() == null) continue;
            linkedHashMap.put(actionDefinition.getToolbarId(), mJAbstractAction);
        }
        return linkedHashMap;
    }

    public boolean isVisibleOnContextMenu(CoreActionID coreActionID, List<FileSystemEntry> list) {
        ActionInput actionInput = this.fSource.createInput(list);
        return this.fRegistry.getAction(coreActionID).isVisibleOnContextMenu(new ApplicableChecker(), actionInput);
    }

    public boolean isVisibleOnContextMenu(ActionDefinition actionDefinition, List<FileSystemEntry> list) {
        ActionInput actionInput = this.fSource.createInput(list);
        return this.fRegistry.getAction(actionDefinition.getId()).isVisibleOnContextMenu(new ApplicableChecker(), actionInput);
    }

    public Status run(CoreActionID coreActionID, List<FileSystemEntry> list) {
        ActionInput actionInput = this.fSource.createInput(list);
        return this.fRegistry.getAction(coreActionID).run(actionInput);
    }

    public MJAbstractAction getAction(String string) {
        ActionDefinition actionDefinition = this.fRegistry.getAction(string).getDefinition();
        return this.fActions.get(actionDefinition);
    }

    public MJAbstractAction getAction(CoreActionID coreActionID) {
        ActionDefinition actionDefinition = this.getActionDefinition(coreActionID);
        return this.fActions.get(actionDefinition);
    }

    public ActionDefinition getActionDefinition(CoreActionID coreActionID) {
        return this.fRegistry.getAction(coreActionID).getDefinition();
    }

    public void installKeyBindings(JComponent jComponent) {
        JComponent jComponent2 = this.fSource.getDefaultComponent();
        if (jComponent2 == null || !jComponent.equals(jComponent2)) {
            this.installKeyBindings(jComponent, true);
        }
    }

    private void instantiateActions(boolean bl) {
        ApplicableChecker applicableChecker = new ApplicableChecker();
        for (ActionDefinition actionDefinition : this.fRegistry.getActions()) {
            final ActionConfigurationImpl actionConfigurationImpl = this.fRegistry.getConfiguration(actionDefinition);
            String string = actionDefinition.getLabel() == null ? "" : actionDefinition.getLabel();
            MJAbstractAction mJAbstractAction = new MJAbstractAction(string){

                public void actionPerformed(ActionEvent actionEvent) {
                    actionConfigurationImpl.run(ActionManager.this.fSource.getCurrentInput());
                }
            };
            if (this.hasBinding(actionDefinition) && bl) {
                MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(this.fContextId, actionDefinition.getId(), (ExtendedAction)mJAbstractAction);
            }
            if (actionDefinition.getIcon() != null) {
                mJAbstractAction.setButtonOnlyIcon(actionDefinition.getIcon());
            } else {
                mJAbstractAction.setButtonOnlyIcon(null);
            }
            if (actionDefinition.getLabel() != null) {
                mJAbstractAction.setName(actionDefinition.getLabel());
            }
            if (!actionDefinition.supportsKeyBinding()) {
                mJAbstractAction.setComponentName("action." + actionDefinition.getId());
            }
            this.fActions.put(actionDefinition, mJAbstractAction);
            actionConfigurationImpl.getStateChangeNotifier().install(this.fChangeListener);
            mJAbstractAction.setEnabled(actionConfigurationImpl.isEnabled(applicableChecker, this.fSource.getCurrentInput()));
        }
    }

    private boolean focusedComponentIsBound(ActionDefinition actionDefinition) {
        if (actionDefinition.isGloballyBound()) {
            return true;
        }
        for (WeakReference<Component> weakReference : this.fBoundComponents) {
            Component component = (Component)weakReference.get();
            if (component == null || !ComponentUtils.isChild((Component)component, (Component)KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner())) continue;
            return true;
        }
        return false;
    }

    private boolean hasBinding(ActionDefinition actionDefinition) {
        return actionDefinition.getId() != null && this.fContextId != null && actionDefinition.supportsKeyBinding() && this.fBoundActionList.contains(actionDefinition) && MatlabKeyBindings.getManager().isActionSupportedByContext(this.fContextId, actionDefinition.getId());
    }

    private void installKeyBindings(final JComponent jComponent, boolean bl) {
        this.fBoundComponents.add(new WeakReference<JComponent>(jComponent));
        final int n = bl ? 1 : 0;
        final InputMap inputMap = jComponent.getInputMap(n);
        MInputMap mInputMap = new MInputMap();
        mInputMap.setParent(inputMap);
        for (ActionDefinition actionDefinition : this.fRegistry.getActions()) {
            String string = actionDefinition.getId();
            boolean bl2 = this.hasBinding(actionDefinition);
            if (!bl2 || bl && !actionDefinition.isGloballyBound()) continue;
            jComponent.getActionMap().put(string, (Action)this.fActions.get(actionDefinition));
            MatlabKeyBindings.getManager().addKeyBindings(this.fContextId, string, (ExtendedInputMap)mInputMap);
        }
        jComponent.setInputMap(n, (InputMap)mInputMap);
        this.fInputMapDisposers.add(new Runnable(){

            @Override
            public void run() {
                jComponent.setInputMap(n, inputMap);
            }
        });
    }

    public void dispose() {
        this.fSource.removeInputChangeListener(this.fChangeListener);
        for (ActionDefinition object : this.fRegistry.getActions()) {
            ActionConfigurationImpl actionConfigurationImpl = this.fRegistry.getConfiguration(object);
            actionConfigurationImpl.getStateChangeNotifier().uninstall();
        }
        for (Runnable runnable : this.fInputMapDisposers) {
            runnable.run();
        }
        this.fInputMapDisposers.clear();
    }

    private void refreshActions() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ActionInput actionInput = ActionManager.this.fSource.getCurrentInput();
                ApplicableChecker applicableChecker = new ApplicableChecker();
                for (ActionDefinition actionDefinition : ActionManager.this.fRegistry.getActions()) {
                    ActionConfigurationImpl actionConfigurationImpl = ActionManager.this.fRegistry.getConfiguration(actionDefinition);
                    boolean bl = actionConfigurationImpl.isEnabled(applicableChecker, actionInput);
                    MJAbstractAction mJAbstractAction = (MJAbstractAction)ActionManager.this.fActions.get(actionDefinition);
                    if (mJAbstractAction == null) continue;
                    mJAbstractAction.setEnabled(bl);
                    String string = actionConfigurationImpl.getLabel(actionInput);
                    if (string != null) {
                        mJAbstractAction.setName(string);
                        continue;
                    }
                    mJAbstractAction.setName(actionDefinition.getLabel());
                }
            }
        });
    }

    private void installContextMenu() {
        final JComponent jComponent = this.fSource.getDefaultComponent();
        if (jComponent != null) {
            final ArrayList<MainContributor> arrayList = new ArrayList<MainContributor>();
            arrayList.addAll(Arrays.asList(new MainContributor()));
            jComponent.addMouseListener((MouseListener)new PopupListener(){

                public void showPopup(MouseEvent mouseEvent) {
                    if (ActionManager.this.fSource.prepareToShowContextMenu(jComponent, mouseEvent)) {
                        final List list = ActionManager.this.getMenuSectionIds();
                        ActionInput actionInput = ActionManager.this.fSource.getCurrentInput();
                        DynamicMenuUtils.showPopupMenu(jComponent, mouseEvent.getPoint(), arrayList, actionInput.getSelectionArray(), new Comparator<MenuSection>(){

                            @Override
                            public int compare(MenuSection menuSection, MenuSection menuSection2) {
                                int n = list.indexOf(menuSection.getId());
                                int n2 = list.indexOf(menuSection2.getId());
                                return n - n2;
                            }
                        }, new MenuSection[0]);
                    }
                }
            });
        }
    }

    private List<String> getMenuSectionIds() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (CoreMenuSectionID coreMenuSectionID : CoreMenuSectionID.values()) {
            if (coreMenuSectionID == CoreMenuSectionID.REFRESH) continue;
            linkedHashSet.add(coreMenuSectionID.toString());
        }
        for (ActionDefinition actionDefinition : this.fRegistry.getActions()) {
            if (actionDefinition.getMenuSection() == null) continue;
            linkedHashSet.add(actionDefinition.getMenuSection().getId());
        }
        return new ArrayList<String>(linkedHashSet);
    }

    private static class ActionList {
        private final Object[] fActionIdentifiers;

        ActionList(Object[] objectArray) {
            for (Object object : objectArray) {
                if (object instanceof CoreActionID || object instanceof String || object instanceof ActionDefinition) continue;
                throw new IllegalStateException("Invalid type of object in action list: " + object.getClass().getName());
            }
            this.fActionIdentifiers = (Object[])objectArray.clone();
        }

        boolean contains(ActionDefinition actionDefinition) {
            if (this.fActionIdentifiers.length == 0) {
                return true;
            }
            for (Object object : this.fActionIdentifiers) {
                if (object instanceof CoreActionID && CoreActionDefinition.valueOf(object.toString()).getDefinition().getId().equals(actionDefinition.getId())) {
                    return true;
                }
                if (object instanceof String && object.equals(actionDefinition.getId())) {
                    return true;
                }
                if (!(object instanceof ActionDefinition) || !((ActionDefinition)object).getId().equals(actionDefinition.getId())) continue;
                return true;
            }
            return false;
        }
    }

    private class MainContributor
    implements DynamicMenuContributor<FileSystemEntry> {
        private MainContributor() {
        }

        @Override
        public void contribute(DynamicMenuContext<FileSystemEntry> dynamicMenuContext) {
            HashSet<MenuSection> hashSet = new HashSet<MenuSection>();
            ActionInput actionInput = ActionManager.this.fSource.getCurrentInput();
            ApplicableChecker applicableChecker = new ApplicableChecker();
            for (ActionDefinition actionDefinition : ActionManager.this.fRegistry.getActions()) {
                MenuSection menuSection = ActionManager.this.fRegistry.getConfiguration(actionDefinition).getMenuSection(actionInput);
                if (menuSection == null) {
                    menuSection = actionDefinition.getMenuSection();
                }
                if (menuSection != null && dynamicMenuContext != null && menuSection.isSubMenuAllowed() && !hashSet.contains(menuSection)) {
                    hashSet.add(menuSection);
                    dynamicMenuContext.addSection(menuSection);
                }
                Action action = (Action)ActionManager.this.fActions.get(actionDefinition);
                ActionConfigurationImpl actionConfigurationImpl = ActionManager.this.fRegistry.getConfiguration(actionDefinition);
                if (dynamicMenuContext == null || menuSection == null || !actionConfigurationImpl.isVisibleOnContextMenu(applicableChecker, actionInput)) continue;
                JComponent jComponent = actionConfigurationImpl.getMenuComponentFromProvider(actionInput);
                if (jComponent != null) {
                    dynamicMenuContext.addComponent(menuSection, jComponent);
                    continue;
                }
                dynamicMenuContext.addAction(menuSection, action);
            }
        }
    }
}

