/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.navigation;

import com.mathworks.matlab.api.explorer.CoreFileDecoration;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.SearchCriteria;
import com.mathworks.mlwidgets.explorer.model.navigation.InvalidLocationException;
import com.mathworks.mlwidgets.explorer.model.navigation.NavigationContext;
import com.mathworks.mlwidgets.explorer.model.navigation.NavigationListener;
import com.mathworks.mlwidgets.explorer.util.FileSystemUtils;
import com.mathworks.mlwidgets.explorer.util.UiFileSystemUtils;
import com.mathworks.services.settings.Setting;
import com.mathworks.services.settings.SettingAdapter;
import com.mathworks.services.settings.SettingChangeEvent;
import com.mathworks.services.settings.SettingException;
import com.mathworks.services.settings.SettingListener;
import com.mathworks.util.MRUList;
import com.mathworks.util.Predicate;
import java.io.IOException;
import java.util.Comparator;

public final class NavigationHistory {
    private final Setting<String[]> fElementPreference;
    private final Setting<Integer> fSizePreference;
    private final NavigationContext fContext;
    private final int fStaticSize;
    private MRUList<HistoryItem> fItems;
    private Predicate<FileLocation> fFilter;

    public NavigationHistory(NavigationContext navigationContext, int n) {
        this(navigationContext, null, null, n);
    }

    public NavigationHistory(NavigationContext navigationContext, Setting<String[]> setting, Setting<Integer> setting2) {
        this(navigationContext, setting, setting2, 0);
    }

    private NavigationHistory(NavigationContext navigationContext, Setting<String[]> setting, Setting<Integer> setting2, int n) {
        this.fContext = navigationContext;
        this.fElementPreference = setting;
        this.fSizePreference = setting2;
        this.fStaticSize = n;
        this.refreshFromPreferences();
        if (this.fElementPreference != null && this.fSizePreference != null) {
            try {
                this.fElementPreference.addListener((SettingListener)new SettingAdapter(){

                    public void settingChanged(SettingChangeEvent settingChangeEvent) throws RuntimeException {
                        try {
                            if (((String[])NavigationHistory.this.fElementPreference.get()).length == 0 && NavigationHistory.this.fItems.size() != 0) {
                                NavigationHistory.this.refreshFromPreferences();
                            }
                        }
                        catch (SettingException settingException) {
                            throw new RuntimeException(settingException);
                        }
                    }
                });
            }
            catch (SettingException settingException) {
                throw new RuntimeException(settingException);
            }
            try {
                this.fSizePreference.addListener((SettingListener)new SettingAdapter(){

                    public void settingChanged(SettingChangeEvent settingChangeEvent) {
                        NavigationHistory.this.refreshFromPreferences();
                    }
                });
            }
            catch (SettingException settingException) {
                throw new RuntimeException(settingException);
            }
        }
        this.fContext.addNavigationListener(new NavigationListener(){

            @Override
            public void navigationChange(FileLocation fileLocation, FileLocation fileLocation2) {
                if (NavigationHistory.this.fFilter == null || NavigationHistory.this.fFilter.accept((Object)fileLocation2)) {
                    NavigationHistory.this.addCurrentPath();
                }
            }

            @Override
            public void searchStarted(SearchCriteria searchCriteria) {
            }

            @Override
            public void searchEnded() {
            }
        });
    }

    public void setFilter(Predicate<FileLocation> predicate) {
        this.fFilter = predicate;
    }

    private void refreshFromPreferences() {
        if (this.fSizePreference != null && this.fElementPreference != null) {
            try {
                this.fItems = new MRUList(((Integer)this.fSizePreference.get()).intValue(), (Comparator)new Comparator<HistoryItem>(){

                    @Override
                    public int compare(HistoryItem historyItem, HistoryItem historyItem2) {
                        return historyItem.equals(historyItem2) ? 0 : -1;
                    }
                }, (Object[])this.convertToHistoryItemArray((String[])this.fElementPreference.get()));
            }
            catch (SettingException settingException) {
                throw new RuntimeException(settingException);
            }
        } else {
            this.fItems = new MRUList(this.fStaticSize);
        }
    }

    public String[] getElements() {
        return this.convertToStringArray(this.getRestorableItems());
    }

    public HistoryItem[] getRestorableItems() {
        return (HistoryItem[])this.fItems.toArray((Object[])new HistoryItem[this.fItems.size()]);
    }

    public void addCurrentPath() {
        FileLocation fileLocation = this.fContext.getLocation();
        HistoryItem historyItem = new HistoryItem(fileLocation);
        this.fItems.add((Object)historyItem);
        if (this.fElementPreference != null) {
            try {
                this.fElementPreference.set((Object)this.getElements());
            }
            catch (RuntimeException runtimeException) {
            }
            catch (SettingException settingException) {
                throw new RuntimeException(settingException);
            }
        }
    }

    public void removePath(String string) {
        HistoryItem historyItem = new HistoryItem(new FileLocation(string));
        if (this.fItems.contains((Object)historyItem)) {
            this.fItems.remove((Object)historyItem);
        }
    }

    private String[] convertToStringArray(HistoryItem[] historyItemArray) {
        String[] stringArray = new String[historyItemArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = historyItemArray[i].toString();
        }
        return stringArray;
    }

    private HistoryItem[] convertToHistoryItemArray(String[] stringArray) {
        HistoryItem[] historyItemArray = new HistoryItem[stringArray.length];
        for (int i = 0; i < historyItemArray.length; ++i) {
            historyItemArray[i] = new HistoryItem(new FileLocation(stringArray[i]));
        }
        return historyItemArray;
    }

    public class HistoryItem {
        private final FileLocation fLocation;

        private HistoryItem(FileLocation fileLocation) {
            this.fLocation = fileLocation;
        }

        public boolean equals(Object object) {
            if (!(object instanceof HistoryItem)) {
                return false;
            }
            HistoryItem historyItem = (HistoryItem)object;
            return this.fLocation.equals((Object)historyItem.fLocation);
        }

        public int hashCode() {
            return this.fLocation.hashCode();
        }

        public String toString() {
            if (this.fLocation.isUrl()) {
                String string = null;
                try {
                    string = (String)UiFileSystemUtils.getDecorationSynchronously(NavigationHistory.this.fContext.getSystem().getEntry(this.fLocation), CoreFileDecoration.DISPLAY_NAME, NavigationHistory.this.fContext.getExtensions());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return string != null ? string : this.fLocation.toString();
            }
            return FileSystemUtils.decodeLocation(NavigationHistory.this.fContext.getSystem(), this.fLocation);
        }

        public void restore() throws InvalidLocationException {
            NavigationHistory.this.fContext.setLocation(this.fLocation);
        }
    }
}

