/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.realfs;

import com.mathworks.jmi.MLFileUtils;
import com.mathworks.matlab.api.explorer.FileList;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.FileSystemTransaction;
import com.mathworks.matlab.api.explorer.SearchCriteria;
import com.mathworks.mlwidgets.explorer.model.DefaultNonRecursiveSearchList;
import com.mathworks.mlwidgets.explorer.model.DefaultRecursiveSearchList;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileList;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystemTransaction;
import com.mathworks.mlwidgets.explorer.model.realfs.WindowsNonRecursiveSearchList;
import com.mathworks.mlwidgets.explorer.model.realfs.WindowsRootList;
import com.mathworks.mlwidgets.explorer.util.FileSystemUtils;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import com.mathworks.util.ThrowableClosure;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import sun.awt.shell.ShellFolder;

public final class RealFileSystem
implements FileSystem {
    private static final RealFileSystem sInstance = new RealFileSystem();

    public static FileSystem getInstance() {
        return sInstance;
    }

    private RealFileSystem() {
    }

    public FileSystemEntry getEntry(FileLocation fileLocation) throws IOException {
        NativeJava.StatEntry statEntry;
        if (fileLocation.equals((Object)FileLocation.ROOT)) {
            if (PlatformInfo.isWindows()) {
                return new FileSystemEntry((FileSystem)this, fileLocation, false, true, 0L, 0L, 0L);
            }
            fileLocation = new FileLocation("/");
        }
        String string = fileLocation.toString();
        if (PlatformInfo.isWindows() && (string.length() == 2 || string.startsWith("\\\\") && fileLocation.getParent().equals((Object)FileLocation.ROOT))) {
            string = string + File.separator;
        }
        if ((statEntry = NativeJava.getStat((String)string)) == null) {
            throw new IOException("Could not find entry: " + fileLocation.toString());
        }
        return new FileSystemEntry((FileSystem)this, fileLocation, statEntry, true);
    }

    public InputStream getInputStream(FileLocation fileLocation) throws IOException {
        return MLFileUtils.getNonLockingInputStream((File)fileLocation.toFile());
    }

    public boolean exists(FileLocation fileLocation) {
        try {
            this.getEntry(fileLocation);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public FileSystemEntry followShortcutOrLink(FileSystemEntry fileSystemEntry) throws IOException {
        String string;
        if (PlatformInfo.isWindows() && fileSystemEntry.getLocation().checkExtension(new String[]{"lnk"})) {
            try {
                File file = fileSystemEntry.getLocation().toFile();
                ShellFolder shellFolder = ShellFolder.getShellFolder(file).getLinkLocation();
                if (shellFolder == null) {
                    return fileSystemEntry;
                }
                return this.getEntry(new FileLocation((File)shellFolder));
            }
            catch (FileNotFoundException fileNotFoundException) {}
        } else if (PlatformInfo.isMacintosh() && (string = NativeJava.followIfMacAlias((String)fileSystemEntry.getLocation().toString())) != null) {
            try {
                return this.getEntry(new FileLocation(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return fileSystemEntry;
    }

    public FileList getList(FileLocation fileLocation) throws IOException {
        FileSystemEntry fileSystemEntry = this.getEntry(fileLocation);
        if (!fileSystemEntry.isFolder()) {
            throw new IOException("The location " + fileLocation + " exists but is not a folder.");
        }
        if (PlatformInfo.isWindows() && fileLocation.equals((Object)FileLocation.ROOT)) {
            return new WindowsRootList((FileSystem)this, fileLocation);
        }
        return new RealFileList((FileSystem)this, fileLocation);
    }

    public FileList search(FileLocation fileLocation, SearchCriteria searchCriteria, Predicate<FileSystemEntry> predicate) throws IOException {
        if (searchCriteria.getSimplePattern().equals("*") || searchCriteria.getSimplePattern().equals("*.*")) {
            return this.getList(fileLocation);
        }
        return new DefaultRecursiveSearchList(this, fileLocation, searchCriteria, predicate){

            @Override
            protected FileList openNonRecursiveSearchList(FileLocation fileLocation, SearchCriteria searchCriteria) throws IOException {
                if (PlatformInfo.isWindows()) {
                    return new WindowsNonRecursiveSearchList(RealFileSystem.this, fileLocation, searchCriteria);
                }
                return new DefaultNonRecursiveSearchList(RealFileSystem.this, fileLocation, searchCriteria);
            }
        };
    }

    public boolean isReadOnly(FileLocation fileLocation) {
        return false;
    }

    public FileSystemTransaction createTransaction() {
        return new RealFileSystemTransaction();
    }

    public String encodeName(String string) {
        return string;
    }

    public String decodeName(String string) {
        return string;
    }

    public static FileSystemEntry resolve(FileSystemEntry fileSystemEntry) throws IOException {
        if (!fileSystemEntry.isReal()) {
            return fileSystemEntry;
        }
        File file = new File(fileSystemEntry.getLocation().toString());
        if (PlatformInfo.isWindows() && !file.getAbsolutePath().startsWith("\\\\")) {
            file = NativeJava.resolveMappedDriveToUnc((String)NativeJava.getNormalizedWindowsPath((File)file));
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return RealFileSystem.getInstance().getEntry(new FileLocation(file));
    }

    public static void stopPassiveMonitoring() {
    }

    public static boolean isInRecycleBin(FileLocation fileLocation) {
        return PlatformInfo.isWindows() && (fileLocation.hasToken(1, "recycler") || fileLocation.hasToken(1, "$recycle.bin"));
    }

    public static FileLocation getOriginalLocationOfRecycledFile(final FileLocation fileLocation) {
        try {
            if (fileLocation.hasToken(1, "recycler")) {
                return FileSystemUtils.withInputStream(RealFileSystem.getInstance().getEntry(new FileLocation(fileLocation.getParent(), "INFO2")), new ThrowableClosure<FileLocation, InputStream, IOException>(){

                    public FileLocation run(InputStream inputStream) throws IOException {
                        DataInputStream dataInputStream = new DataInputStream(inputStream);
                        while (dataInputStream.skipBytes(20) == 20) {
                            FileLocation fileLocation3;
                            int n;
                            int n2;
                            StringBuilder stringBuilder = new StringBuilder();
                            for (n2 = 0; n2 < 260 && ((n = dataInputStream.read()) > 0 || n2 <= 0); ++n2) {
                                stringBuilder.append((char)n);
                            }
                            dataInputStream.skipBytes(260 - n2 - 1);
                            n = dataInputStream.readByte() & 0xFF | (dataInputStream.readByte() & 0xFF) << 8;
                            dataInputStream.skipBytes(518);
                            FileLocation fileLocation2 = new FileLocation(stringBuilder.toString());
                            String string = "D" + stringBuilder.charAt(0) + n;
                            if (fileLocation2.getExtension() != null) {
                                string = string + "." + fileLocation2.getExtension();
                            }
                            if (!(fileLocation3 = new FileLocation(fileLocation.getParent(), string)).equals((Object)fileLocation)) continue;
                            return fileLocation2;
                        }
                        return null;
                    }
                });
            }
            FileLocation fileLocation2 = new FileLocation(fileLocation.getParent(), "$I" + fileLocation.getName().substring(2));
            return FileSystemUtils.withInputStream(RealFileSystem.getInstance().getEntry(fileLocation2), new ThrowableClosure<FileLocation, InputStream, IOException>(){

                public FileLocation run(InputStream inputStream) throws IOException {
                    if (inputStream.skip(24L) == 24L) {
                        int n;
                        StringBuilder stringBuilder = new StringBuilder();
                        for (int i = 0; i < 260 && (n = inputStream.read()) > 0; ++i) {
                            stringBuilder.append((char)n);
                            inputStream.read();
                        }
                        return new FileLocation(stringBuilder.toString());
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {
            return fileLocation;
        }
    }
}

