/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.help.helpui.DocRoot;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.html.FileUrl;
import com.mathworks.mlwidgets.help.DocCenterDocConfig;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.help.HelpUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.Map;

public class CSHelpTopicMap {
    private final File fMapFile;
    private Map<String, String> fTopicMap;
    private Map<String, String> fAlternateTopicMap;
    private File fAlternateMapFile;
    private static HelpDependencyProvider sDependencyProvider = new DefaultDocRootProvider();
    private static boolean sTesting = false;
    private static String sHelpPath = null;

    public CSHelpTopicMap(String string) {
        this(new File(string));
    }

    private CSHelpTopicMap(File file) {
        if (file != null) {
            File file2 = HelpUtils.getLocalizedFile(file);
            if (file2 != null && file2.exists()) {
                this.fMapFile = file2;
                BufferedReader bufferedReader = CSHelpTopicMap.getMapReader(this.fMapFile);
                this.fTopicMap = CSHelpTopicMap.readMap(bufferedReader);
                CSHelpTopicMap.closeMapReader(bufferedReader);
            } else {
                this.fMapFile = null;
            }
        } else {
            this.fMapFile = null;
        }
    }

    public CSHelpTopicMap(String string, String string2) {
        this(CSHelpTopicMap.findLocalizedMapFile(string, string2));
    }

    private static BufferedReader getMapReader(File file) {
        if (file == null) {
            return null;
        }
        try {
            return new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Invalid map file: " + file);
            return null;
        }
    }

    private static void closeMapReader(BufferedReader bufferedReader) {
        block3: {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)"Failed to close the topic map reader");
                }
            }
        }
    }

    private static Map<String, String> readMap(BufferedReader bufferedReader) {
        HashMap<String, String> hashMap = null;
        if (bufferedReader != null) {
            try {
                StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
                streamTokenizer.resetSyntax();
                streamTokenizer.commentChar(37);
                streamTokenizer.whitespaceChars(32, 32);
                streamTokenizer.whitespaceChars(9, 9);
                streamTokenizer.wordChars(33, 33);
                streamTokenizer.wordChars(35, 36);
                streamTokenizer.wordChars(38, 38);
                streamTokenizer.wordChars(40, 47);
                streamTokenizer.wordChars(48, 57);
                streamTokenizer.wordChars(58, 64);
                streamTokenizer.wordChars(65, 90);
                streamTokenizer.wordChars(91, 95);
                streamTokenizer.wordChars(97, 122);
                streamTokenizer.wordChars(123, 126);
                streamTokenizer.eolIsSignificant(false);
                hashMap = new HashMap<String, String>();
                while (streamTokenizer.nextToken() != -1) {
                    String string;
                    if (streamTokenizer.ttype != -3) continue;
                    String string2 = streamTokenizer.sval;
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != -3 || (string = streamTokenizer.sval) == null) continue;
                    hashMap.put(string2, string);
                }
            }
            catch (IOException iOException) {
                System.out.println("Map parse error: " + iOException);
            }
        }
        return hashMap;
    }

    private String mapAlternateLanguageID(String string) {
        if (this.fAlternateTopicMap == null) {
            this.fAlternateMapFile = CSHelpTopicMap.findAlternateMapFile(this.fMapFile);
            BufferedReader bufferedReader = CSHelpTopicMap.getMapReader(this.fAlternateMapFile);
            if (bufferedReader == null) {
                this.fAlternateTopicMap = new HashMap<String, String>();
            } else {
                this.fAlternateTopicMap = CSHelpTopicMap.readMap(bufferedReader);
                CSHelpTopicMap.closeMapReader(bufferedReader);
            }
        }
        return this.fAlternateTopicMap.get(string);
    }

    public String mapID(String string) {
        String string2 = null;
        if (this.exists()) {
            String string3 = this.fMapFile.getParent();
            string2 = this.fTopicMap.get(string);
            if (string2 == null && (string2 = this.mapAlternateLanguageID(string)) != null) {
                string3 = this.fAlternateMapFile.getParent();
            }
            if (string2 != null) {
                string2 = string2.replace('/', File.separatorChar);
                File file = new File(string3, string2);
                try {
                    string2 = file.getCanonicalPath();
                    string2 = CSHelpTopicMap.replacePathWithDocCenterRoot(string2);
                }
                catch (IOException iOException) {
                    System.out.println("Invalid topic path: " + string2);
                    string2 = null;
                }
            }
        }
        return string2;
    }

    private static String replacePathWithDocCenterRoot(String string) {
        String string2 = string;
        String string3 = HelpPrefs.getDocCenterRoot();
        if (!HelpPrefs.getDocRoot().equals(HelpPrefs.getDocCenterRoot())) {
            if (string3.endsWith("/")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            string2 = string2.replace(File.separatorChar, '/').replace(HelpPrefs.getDocRoot(), string3);
        }
        return string2;
    }

    public boolean exists() {
        return this.fTopicMap != null;
    }

    public String getFilePath() {
        if (this.fMapFile == null) {
            return "";
        }
        String string = CSHelpTopicMap.getFilePath(this.fMapFile);
        string.replaceAll("\\\\", "/");
        return string;
    }

    private static String getFilePath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }

    private static File findAlternateMapFile(File file) {
        if (!HelpUtils.isEnglish()) {
            String string = HelpUtils.getAlternateLanguagePath(file.getAbsolutePath());
            File file2 = CSHelpTopicMap.findMapFile(new File(string));
            return file2;
        }
        return null;
    }

    private static File findMapFile(File file) {
        return file.exists() ? file : null;
    }

    static String findLocalizedMapFileName(String string, String string2) {
        File file = CSHelpTopicMap.findLocalizedMapFile(string, string2);
        return file != null ? CSHelpTopicMap.getFilePath(file) : null;
    }

    private static File findLocalizedMapFile(String string, String string2) {
        DocProduct docProduct = sDependencyProvider.getDocProductForShortName(string);
        if (docProduct == null) {
            return null;
        }
        DocRoot<FileUrl> docRoot = sDependencyProvider.getDocRoot();
        FileUrl fileUrl = (FileUrl)docRoot.buildHelpLocationUrl((DocSetItem)docProduct);
        return CSHelpTopicMap.findMapFileForProduct(fileUrl.getFile(), string2);
    }

    private static File findMapFileForProduct(File file, String string) {
        String string2 = string + ".map";
        File file2 = new File(file, string2);
        File file3 = HelpUtils.getLocalizedFile(file2);
        if (file3 != null && file3.exists()) {
            return file3;
        }
        string2 = string + "/" + string + ".map";
        file2 = new File(file, string2);
        file3 = HelpUtils.getLocalizedFile(file2);
        return file3 != null && file3.exists() ? file3 : null;
    }

    public static void setDependencyProvider(HelpDependencyProvider helpDependencyProvider) {
        sDependencyProvider = helpDependencyProvider;
    }

    static HelpDependencyProvider getDependencyProvider() {
        return sDependencyProvider;
    }

    public static void setQE(boolean bl) {
        sTesting = bl;
        sHelpPath = null;
    }

    public static boolean isQE() {
        return sTesting;
    }

    public static void setQEHelpPath(String string) {
        sHelpPath = string;
    }

    public static String getQEHelpPath() {
        return sHelpPath;
    }

    public static class DefaultDocRootProvider
    implements HelpDependencyProvider {
        @Override
        public DocProduct getDocProductForShortName(String string) {
            DocumentationSet documentationSet = DocCenterDocConfig.getLocalConfig().getDocumentationSet();
            return documentationSet.getProductByShortName(string);
        }

        @Override
        public DocRoot<FileUrl> getDocRoot() {
            return DocCenterDocConfig.getLocalConfig().getDocRoot();
        }
    }

    public static interface HelpDependencyProvider {
        public DocProduct getDocProductForShortName(String var1);

        public DocRoot<FileUrl> getDocRoot();
    }
}

