/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.mlwidgets.help.HelpTreeItem;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;

abstract class ContainerHelpTreeItem
implements HelpTreeItem,
TreeNode {
    private String fLabel;
    private Icon fIcon;
    private String fProduct;
    private List<TreeNode> fChildren = new ArrayList<TreeNode>();
    private TreeNode fParent;

    ContainerHelpTreeItem(String string, Icon icon, String string2) {
        this.fLabel = string;
        this.fIcon = icon;
        this.fProduct = string2;
    }

    @Override
    public String getLabel() {
        return this.fLabel;
    }

    @Override
    public String getShortLabel() {
        return this.getLabel();
    }

    @Override
    public Icon getIcon() {
        return this.fIcon;
    }

    @Override
    public String getProduct() {
        return this.fProduct;
    }

    @Override
    public TreeNode getTreeNode() {
        return this;
    }

    @Override
    public TreeNode getChildAt(int n) {
        this.populateIfNecessary();
        return this.fChildren.get(n);
    }

    @Override
    public int getChildCount() {
        return this.getChildCount(true);
    }

    protected int getChildCount(boolean bl) {
        if (bl) {
            this.populateIfNecessary();
        }
        return this.fChildren.size();
    }

    @Override
    public TreeNode getParent() {
        this.populateIfNecessary();
        return this.fParent;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        this.populateIfNecessary();
        for (int i = 0; i < this.fChildren.size(); ++i) {
            TreeNode treeNode2 = this.fChildren.get(i);
            if (!treeNode2.equals(treeNode)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public Enumeration<TreeNode> children() {
        this.populateIfNecessary();
        return new TreeNodeEnumeration();
    }

    @Override
    public void addChild(TreeNode treeNode) {
        this.fChildren.add(treeNode);
    }

    protected void addChild(int n, TreeNode treeNode) {
        this.fChildren.add(n, treeNode);
    }

    protected void setParent(TreeNode treeNode) {
        this.fParent = treeNode;
    }

    protected final synchronized void populateIfNecessary() {
        if (!this.isPopulated()) {
            this.populate();
        }
    }

    void clear() {
        if (this.fChildren != null) {
            this.fChildren.clear();
        }
    }

    protected abstract void populate();

    public abstract boolean isPopulated();

    protected void removeChild(int n) {
        this.fChildren.remove(n);
    }

    protected void removeChild(TreeNode treeNode) {
        this.fChildren.remove(treeNode);
    }

    public String toString() {
        return this.getLabel();
    }

    private class TreeNodeEnumeration
    implements Enumeration<TreeNode> {
        private Iterator<TreeNode> iIterator;

        private TreeNodeEnumeration() {
            this.iIterator = new ArrayList(ContainerHelpTreeItem.this.fChildren).iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iIterator.hasNext();
        }

        @Override
        public TreeNode nextElement() {
            return this.iIterator.next();
        }
    }
}

