/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.help.helpui.DocAddOnDocUrlRule;
import com.mathworks.help.helpui.DocConfig;
import com.mathworks.help.helpui.DocLocation;
import com.mathworks.help.helpui.DocRoot;
import com.mathworks.help.helpui.DocUrlNavigationRule;
import com.mathworks.help.helpui.DocUrlParser;
import com.mathworks.help.helpui.LocalDocConfig;
import com.mathworks.help.helpui.LocalizationDocUrlRule;
import com.mathworks.help.helpui.WebDocConfig;
import com.mathworks.help.helpui.WebDocUrlConfig;
import com.mathworks.helpsearch.DocLanguage;
import com.mathworks.helpsearch.SearchConfig;
import com.mathworks.helpsearch.product.DocAddOn;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocSupportPackage;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.product.ProductFilter;
import com.mathworks.html.FileUrl;
import com.mathworks.html.Url;
import com.mathworks.html.WebUrl;
import com.mathworks.mlwidgets.help.DocCenterDocConfigParams;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.help.MLProductFilter;
import com.mathworks.mlwidgets.help.MLProductFilterDocUrlRule;
import com.mathworks.mlwidgets.help.ProductFilterModel;
import com.mathworks.mlwidgets.help.SearchHighlightDocUrlRule;
import com.mathworks.mlwidgets.help.addon.InstalledPackageAccessor;
import com.mathworks.mlwidgets.help.addon.InstalledSupportPackage;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class DocCenterDocConfig<T extends Url>
implements DocConfig<T> {
    private static DocCenterDocConfig<WebUrl> sCurrentWebConfig = null;
    private static DocCenterDocConfig<FileUrl> sCurrentFileConfig = null;
    private final DocCenterBaseConfig<T> fBaseConfig;
    private final DocCenterDocConfigParams fParams;

    private DocCenterDocConfig(DocCenterBaseConfig<T> docCenterBaseConfig, DocCenterDocConfigParams docCenterDocConfigParams) {
        this.fBaseConfig = docCenterBaseConfig;
        this.fParams = docCenterDocConfigParams;
    }

    public static DocCenterDocConfig<? extends Url> getInstance() {
        if (HelpPrefs.getDocCenterLocation() == DocLocation.WEB) {
            try {
                return DocCenterDocConfig.getWebConfig();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return DocCenterDocConfig.getLocalConfig();
    }

    public static synchronized DocCenterDocConfig<WebUrl> getWebConfig() throws MalformedURLException {
        DocCenterDocConfigParams docCenterDocConfigParams = new DocCenterDocConfigParams();
        if (sCurrentWebConfig == null || !super.getParams().equals(docCenterDocConfigParams)) {
            sCurrentWebConfig = new DocCenterDocConfig<WebUrl>(DocCenterWebConfig.newInstance(docCenterDocConfigParams), docCenterDocConfigParams);
        }
        return sCurrentWebConfig;
    }

    public static synchronized DocCenterDocConfig<FileUrl> getLocalConfig() {
        DocCenterDocConfigParams docCenterDocConfigParams = new DocCenterDocConfigParams();
        if (sCurrentFileConfig == null || !super.getParams().equals(docCenterDocConfigParams)) {
            sCurrentFileConfig = new DocCenterDocConfig<FileUrl>(DocCenterFileConfig.newInstance(docCenterDocConfigParams), docCenterDocConfigParams);
        }
        return sCurrentFileConfig;
    }

    public DocRoot<T> getDocRoot() {
        return this.fBaseConfig.getDocRoot();
    }

    public DocUrlParser getDocUrlParser() {
        return this.fBaseConfig.getDocUrlParser();
    }

    public SearchConfig getSearchConfig() {
        return this.fBaseConfig.getSearchConfig();
    }

    public DocumentationSet getDocumentationSet() {
        return this.fBaseConfig.getDocumentationSet();
    }

    public synchronized MLProductFilter getProductFilter() {
        return this.fBaseConfig.getProductFilter();
    }

    public Url.UrlType getUrlType() {
        return this.fBaseConfig.getUrlType();
    }

    public static DocRoot<WebUrl> getSystemBrowserDocUrlBuilder() throws MalformedURLException {
        DocCenterDocConfigParams docCenterDocConfigParams = new DocCenterDocConfigParams();
        WebUrl webUrl = new WebUrl(docCenterDocConfigParams.getDocCenterWebRoot());
        WebDocUrlConfig webDocUrlConfig = DocCenterDocConfig.createWebDocUrlConfig(docCenterDocConfigParams, false);
        return DocRoot.create((WebUrl)webUrl, (WebDocUrlConfig)webDocUrlConfig);
    }

    private static Map<DocAddOn, File> getDocAddOnsForDocSet(DocumentationSet documentationSet) {
        LinkedHashMap<DocAddOn, File> linkedHashMap = new LinkedHashMap<DocAddOn, File>();
        Collection<InstalledSupportPackage> collection = InstalledPackageAccessor.getInstance().getInstalledSupportPackages();
        if (collection != null && !collection.isEmpty()) {
            for (InstalledSupportPackage installedSupportPackage : collection) {
                DocProduct docProduct = documentationSet.getProductByShortName(installedSupportPackage.getBaseProduct());
                DocSupportPackage docSupportPackage = new DocSupportPackage(documentationSet, installedSupportPackage.getShortName(), installedSupportPackage.getDisplayName(), installedSupportPackage.getLegalName(), installedSupportPackage.getHelpLoc(), docProduct);
                linkedHashMap.put((DocAddOn)docSupportPackage, installedSupportPackage.getLocalDocRoot());
            }
        }
        return linkedHashMap;
    }

    private static WebDocUrlConfig createWebDocUrlConfig(DocCenterDocConfigParams docCenterDocConfigParams, boolean bl) {
        DocLanguage docLanguage = docCenterDocConfigParams.getDocLanguage();
        String string = docCenterDocConfigParams.getRelease();
        return new WebDocUrlConfig(docLanguage, string, bl);
    }

    public Collection<DocUrlNavigationRule> getDocUrlNavigationRules() {
        ArrayList<DocUrlNavigationRule> arrayList = new ArrayList<DocUrlNavigationRule>(this.fBaseConfig.getDocUrlNavigationRules());
        Collection<String> collection = this.getProductFilter().getSelectedBaseCodes();
        Collection<DocAddOn> collection2 = DocCenterDocConfig.getSelectedAddOns(this.getProductFilter());
        Collection<DocUrlNavigationRule> collection3 = this.getMLDocUrlNavigationRules(collection, collection2);
        arrayList.addAll(collection3);
        return Collections.unmodifiableCollection(arrayList);
    }

    private static Collection<DocAddOn> getSelectedAddOns(ProductFilter productFilter) {
        Set set = productFilter.getSelectedProducts();
        if (set == null || set.isEmpty()) {
            return null;
        }
        HashSet<DocAddOn> hashSet = new HashSet<DocAddOn>();
        for (DocProduct docProduct : set) {
            Collection collection = docProduct.getDocAddOns();
            if (collection == null || collection.isEmpty()) continue;
            hashSet.addAll(collection);
        }
        return hashSet;
    }

    private Collection<DocUrlNavigationRule> getMLDocUrlNavigationRules(Collection<String> collection, Collection<DocAddOn> collection2) {
        ArrayList<DocUrlNavigationRule> arrayList = new ArrayList<DocUrlNavigationRule>();
        arrayList.add((DocUrlNavigationRule)new MLProductFilterDocUrlRule(collection));
        arrayList.add((DocUrlNavigationRule)new LocalizationDocUrlRule(this.fParams.getDocLanguage().getLocale(), this.fParams.getLandingPageDocLanguage().getLocale()));
        arrayList.add(new SearchHighlightDocUrlRule());
        if (collection2 != null && !collection2.isEmpty()) {
            arrayList.add((DocUrlNavigationRule)new DocAddOnDocUrlRule(collection2));
        }
        return arrayList;
    }

    private DocCenterDocConfigParams getParams() {
        return this.fParams;
    }

    public int hashCode() {
        return this.fParams.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof DocCenterDocConfig) {
            DocCenterDocConfig docCenterDocConfig = (DocCenterDocConfig)object;
            return this.fParams.equals(docCenterDocConfig.getParams());
        }
        return false;
    }

    public static void invalidateSupportPackageCache() {
        InstalledPackageAccessor.invalidateCache();
    }

    private static class DocCenterFileConfig
    extends LocalDocConfig
    implements DocCenterBaseConfig<FileUrl> {
        private final MLProductFilter iProductFilter;

        private DocCenterFileConfig(DocCenterDocConfigParams docCenterDocConfigParams) {
            super(docCenterDocConfigParams.getLocalDocRoot(), docCenterDocConfigParams.getDocLanguage());
            this.iProductFilter = new MLProductFilter(this.getDocumentationSet(), docCenterDocConfigParams.getProductFilterModel());
        }

        private static DocCenterFileConfig newInstance(DocCenterDocConfigParams docCenterDocConfigParams) {
            DocCenterFileConfig docCenterFileConfig = new DocCenterFileConfig(docCenterDocConfigParams);
            Map map = DocCenterDocConfig.getDocAddOnsForDocSet(docCenterFileConfig.getDocumentationSet());
            if (!map.isEmpty()) {
                docCenterFileConfig.addDocAddOns(map);
            }
            return docCenterFileConfig;
        }

        @Override
        public synchronized MLProductFilter getProductFilter() {
            return this.iProductFilter;
        }
    }

    private static class DocCenterWebConfig
    extends WebDocConfig
    implements DocCenterBaseConfig<WebUrl> {
        private final MLProductFilter iProductFilter;

        private DocCenterWebConfig(WebUrl webUrl, WebDocUrlConfig webDocUrlConfig, File file, ProductFilterModel productFilterModel) {
            super(webUrl, webDocUrlConfig, file);
            this.iProductFilter = new MLProductFilter(this.getDocumentationSet(), productFilterModel);
        }

        private static DocCenterWebConfig newInstance(DocCenterDocConfigParams docCenterDocConfigParams) throws MalformedURLException {
            ProductFilterModel productFilterModel;
            File file;
            WebDocUrlConfig webDocUrlConfig;
            WebUrl webUrl = new WebUrl(docCenterDocConfigParams.getDocCenterWebRoot());
            DocCenterWebConfig docCenterWebConfig = new DocCenterWebConfig(webUrl, webDocUrlConfig = DocCenterDocConfig.createWebDocUrlConfig(docCenterDocConfigParams, true), file = docCenterDocConfigParams.getLocalDocRoot(), productFilterModel = docCenterDocConfigParams.getProductFilterModel());
            Map map = DocCenterDocConfig.getDocAddOnsForDocSet(docCenterWebConfig.getDocumentationSet());
            if (!map.isEmpty()) {
                docCenterWebConfig.addDocAddOns(map);
            }
            return docCenterWebConfig;
        }

        @Override
        public MLProductFilter getProductFilter() {
            return this.iProductFilter;
        }
    }

    private static interface DocCenterBaseConfig<T extends Url>
    extends DocConfig<T> {
        public MLProductFilter getProductFilter();
    }
}

