/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.mlwidgets.help.HelpPanelAddressNavigation;
import com.mathworks.mlwidgets.help.HelpPanelAddressObject;
import com.mathworks.mlwidgets.help.HelpPanelSyncEvent;
import com.mathworks.mlwidgets.help.HelpSyncListener;
import com.mathworks.mlwidgets.help.HelpSynchronizer;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJToolBar;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class HelpPanelAddressBox
extends MJToolBar
implements HelpPanelAddressNavigation {
    private MJComboBox fAddressBox;
    private DefaultComboBoxModel fComboModel;
    private AddressActionListener fAddressActionListener;
    private AddressKeyListener fAddressKeyListener = null;
    private MJLabel fAddressLabel;
    private ActionListener fAddressBoxListener;
    private HelpSyncListener fAddressBoxHelpSyncListener;

    public HelpPanelAddressBox(ActionListener actionListener) {
        this.setName("Help Panel Address Box");
        this.getAccessibleContext().setAccessibleName("Help Panel Address Box");
        this.fAddressBoxHelpSyncListener = new AddressBoxHelpSyncListener();
        this.setFloatable(false);
        this.setMargin(new Insets(0, 0, 30, 0));
        this.fAddressBoxListener = actionListener;
        this.fAddressBox = new MJComboBox(new Vector());
        this.fAddressBox.setEditable(false);
        this.fAddressActionListener = new AddressActionListener();
        this.fAddressBox.addActionListener((ActionListener)this.fAddressActionListener);
        this.addAddressBoxKeyListener();
        this.fAddressBox.setName("Title ComboBox");
        this.fAddressBox.getAccessibleContext().setAccessibleName("Address ComboBox");
        this.fComboModel = new DefaultComboBoxModel();
        this.fAddressBox.setModel((ComboBoxModel)this.fComboModel);
        this.fAddressLabel = new MJLabel();
        this.setAddressLabelText();
        this.fAddressLabel.setBorder((Border)new EmptyBorder(0, 3, 0, 3));
        this.add((Component)this.fAddressLabel);
        this.add((Component)this.fAddressBox);
    }

    @Override
    public void setHelpSynchronizer(HelpSynchronizer helpSynchronizer) {
        assert (helpSynchronizer != null) : "setHelpSynchronizer must be called with non-null HelpSynchronizer.";
        helpSynchronizer.addHelpSyncListener(this.fAddressBoxHelpSyncListener);
    }

    @Override
    public MJToolBar getToolBar() {
        return this;
    }

    @Override
    public void addUrlToAddressNavigation(String string, String string2) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.addUrlToComboboxMethod(string, string2);
        } else {
            SwingUtilities.invokeLater(new AddUrlToComboboxThread(string, string2));
        }
    }

    public Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        dimension.height = this.getPreferredSize().height;
        return dimension;
    }

    private void processComboboxActionEvent() {
        String string;
        Object object = this.fAddressBox.getSelectedItem();
        if (object instanceof HelpPanelAddressObject) {
            HelpPanelAddressObject helpPanelAddressObject = (HelpPanelAddressObject)object;
            string = helpPanelAddressObject.getUrl();
            this.addUrlToAddressNavigation(helpPanelAddressObject.getTitle(), string);
        } else {
            string = (String)object;
        }
        if (string == null) {
            return;
        }
        this.fAddressBoxListener.actionPerformed(new ActionEvent(this, 0, string));
    }

    private void addUrlToComboboxMethod(String string, String string2) {
        HelpPanelAddressObject helpPanelAddressObject = new HelpPanelAddressObject(string, string2);
        if (this.fAddressActionListener != null) {
            this.fAddressBox.removeActionListener((ActionListener)this.fAddressActionListener);
        }
        this.fComboModel.removeElement(helpPanelAddressObject);
        this.fComboModel.insertElementAt(helpPanelAddressObject, 0);
        this.fAddressBox.getEditor().setItem(helpPanelAddressObject);
        this.fAddressBox.setSelectedItem((Object)helpPanelAddressObject);
        if (this.fAddressActionListener != null) {
            this.fAddressBox.addActionListener((ActionListener)this.fAddressActionListener);
        }
    }

    private void addAddressBoxKeyListener() {
        if (this.fAddressKeyListener == null) {
            this.fAddressKeyListener = new AddressKeyListener();
        }
        this.fAddressBox.addKeyListener((KeyListener)this.fAddressKeyListener);
    }

    private void setAddressLabelText() {
        this.fAddressLabel.setText(HTMLUtils.sRes.getString("icecontainer.address_label_title"));
        this.fAddressBox.getAccessibleContext().setAccessibleName(HTMLUtils.sRes.getString("icecontainer.acc.address_label_title"));
    }

    private class AddUrlToComboboxThread
    implements Runnable {
        private String fTitle;
        private String fUrl;

        AddUrlToComboboxThread(String string, String string2) {
            this.fTitle = string;
            this.fUrl = string2;
        }

        @Override
        public void run() {
            HelpPanelAddressBox.this.addUrlToComboboxMethod(this.fTitle, this.fUrl);
        }
    }

    private class ComboboxActionPerformedThread
    implements Runnable {
        private ComboboxActionPerformedThread() {
        }

        @Override
        public void run() {
            if (!HelpPanelAddressBox.this.fAddressBox.isPopupVisible()) {
                HelpPanelAddressBox.this.processComboboxActionEvent();
            }
        }
    }

    private class AddressKeyListener
    extends KeyAdapter {
        private AddressKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                HelpPanelAddressBox.this.processComboboxActionEvent();
            }
        }
    }

    private class AddressActionListener
    implements ActionListener {
        private AddressActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("comboBoxChanged")) {
                SwingUtilities.invokeLater(new ComboboxActionPerformedThread());
            }
        }
    }

    private class AddressBoxHelpSyncListener
    implements HelpSyncListener {
        private AddressBoxHelpSyncListener() {
        }

        @Override
        public void syncToHelpPanelSyncEvent(HelpPanelSyncEvent helpPanelSyncEvent) {
            if (helpPanelSyncEvent == null) {
                return;
            }
            if (helpPanelSyncEvent.isHelpItem()) {
                String string = helpPanelSyncEvent.getUnigueIdentifier();
                String string2 = helpPanelSyncEvent.getTitle();
                if (string == null || string2 == null) {
                    return;
                }
                if (string.length() > 0 && string.charAt(string.length() - 1) == '/') {
                    string = string.substring(0, string.length() - 1);
                }
                HelpPanelAddressBox.this.addUrlToAddressNavigation(string2, string);
            }
        }
    }
}

