/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.help.helpui.DocConfig;
import com.mathworks.help.helpui.DocRoot;
import com.mathworks.helpsearch.reference.ReferenceData;
import com.mathworks.html.FileUrl;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.StandardHtmlActionId;
import com.mathworks.html.Url;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.help.DocCenterDocConfig;
import com.mathworks.mlwidgets.help.HelpComponentHelper;
import com.mathworks.mlwidgets.help.HelpDisplayType;
import com.mathworks.mlwidgets.help.HelpPanel;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.help.HelpToolBar;
import com.mathworks.mlwidgets.help.HelpTopic;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.help.functioncall.MFunctionCall;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mlwidgets.html.OpenBrowserStrategies;
import com.mathworks.mlwidgets.html.OpenBrowserStrategy;
import com.mathworks.mlwidgets.html.OpenBrowserStrategyId;
import com.mathworks.mwswing.MInputMap;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJStatusBar;
import com.mathworks.mwswing.TextComponentUtils;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.StringUtils;
import com.mathworks.widgets.HyperlinkTextLabel;
import com.mathworks.widgets.LightweightWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public final class HelpPopup {
    private static final Dimension DEFAULT_SIZE = new Dimension(520, 380);
    private static final Dimension MINIMUM_SIZE = new Dimension(200, 100);
    private static Dimension sLastSize;
    private static final String FOCUS_LISTENER_KEY = "focusBackToParent";
    private static HelpPopup sSingleton;
    private static boolean sTesting;
    private MJPanel fPanel;
    private HelpPanel fHelpPanel;
    private final KeyListener fEscapeListener = this.createEscapeListener();
    private final PrefListener fPrefListener = new DocCenterPrefsListener();
    private Window fWindow;
    private KeyStrokeList fShiftFocusKeyStrokes;
    private String fFunction;
    private String fFunctionUrl;
    private String fOpenBrowserHyperlink;
    private Frame fParentWindow;
    private JComponent fParent;
    private WindowListener fWindowListener;
    private HyperlinkTextLabel fHyperlink;
    private JComponent fContentPane;

    public static void setShowHelpBrowserPreference(boolean bl) {
        HelpPrefs.setShowHelpBrowserPreference(bl);
    }

    public static boolean isShowingHelpBrowser() {
        return HelpPrefs.getShowHelpBrowserPreference();
    }

    public static void showHelp(JTextComponent jTextComponent, KeyStroke keyStroke) {
        HelpPopup.showHelp(jTextComponent, keyStroke, null);
    }

    public static void showHelp(JTextComponent jTextComponent, KeyStroke keyStroke, String string) {
        HelpPopup.showHelp(jTextComponent, keyStroke == null ? null : new KeyStrokeList(new KeyStroke[]{keyStroke}), string);
    }

    public static void showHelp(JTextComponent jTextComponent, KeyStrokeList keyStrokeList) {
        HelpPopup.showHelp(jTextComponent, keyStrokeList, null);
    }

    public static void showHelp(JTextComponent jTextComponent, KeyStrokeList keyStrokeList, String string) {
        if (jTextComponent == null) {
            throw new IllegalArgumentException("'text' cannot be null");
        }
        String string2 = jTextComponent.getSelectedText();
        Rectangle rectangle = HelpPopup.computeBoundsRelativeToCaret(jTextComponent);
        if (string2 != null && !string2.trim().isEmpty()) {
            HelpPopup.showHelp((JComponent)jTextComponent, keyStrokeList, rectangle, HelpPopup.stripSelection(string2));
        } else {
            String string3 = HelpPopup.computeTextAtCaret(jTextComponent);
            try {
                if (string != null && !string.isEmpty()) {
                    MFunctionCall mFunctionCall = MFunctionCall.getInstance(string);
                    HelpPopup.showHelp((JComponent)jTextComponent, keyStrokeList, rectangle, mFunctionCall.getFunctionName());
                } else {
                    HelpPopup.showHelp((JComponent)jTextComponent, keyStrokeList, rectangle, string3);
                }
            }
            catch (ParseException parseException) {
                HelpPopup.showHelp((JComponent)jTextComponent, keyStrokeList, rectangle, string3);
            }
        }
    }

    public static String stripSelection(String string) {
        int n = string.indexOf(40);
        return (n > 0 ? string.substring(0, n) : string).trim();
    }

    private static void closeIfShowingWithDifferentParent(JComponent jComponent) {
        Window window = SwingUtilities.getWindowAncestor(jComponent);
        HelpPopup helpPopup = HelpPopup.getInstance();
        if (helpPopup.getParentWindow() != window) {
            helpPopup.cleanup();
        }
    }

    private Window getParentWindow() {
        return this.fParentWindow;
    }

    private static String computeTextAtCaret(JTextComponent jTextComponent) {
        return TextComponentUtils.getFunctionAtCaret((JTextComponent)jTextComponent, (boolean)true);
    }

    public static void showHelp(JTextComponent jTextComponent, KeyStrokeList keyStrokeList, Point point, String string) {
        SwingUtilities.convertPointToScreen(point, jTextComponent);
        HelpPopup.showHelp((JComponent)jTextComponent, keyStrokeList, WindowUtils.computeTextPopupBounds((Dimension)HelpPopup.getLastSize(), (Dimension)DEFAULT_SIZE, (Point)point, (int)jTextComponent.getFontMetrics(jTextComponent.getFont()).getHeight(), (WindowUtils.TextPopupLocation)WindowUtils.TextPopupLocation.BELOW_PREFERRED), string);
    }

    public static void showHelp(JComponent jComponent, KeyStrokeList keyStrokeList, Rectangle rectangle, String string) {
        if (string != null && string.indexOf(10) != -1) {
            MJOptionPane.showMessageDialog((Component)SwingUtilities.getWindowAncestor(jComponent), (Object)HelpUtils.getLocalizedString("helppopup.noNewlines"), (String)HelpUtils.getLocalizedString("helppopup.title"), (int)2);
            return;
        }
        HelpPopup.showHelp(jComponent, keyStrokeList, rectangle, null, string);
    }

    public static void showHelp(JComponent jComponent, KeyStrokeList keyStrokeList, Rectangle rectangle, URL uRL) {
        HelpPopup.showHelp(jComponent, keyStrokeList, rectangle, uRL, null);
    }

    private static synchronized void showHelp(JComponent jComponent, KeyStrokeList keyStrokeList, Rectangle rectangle, URL uRL, String string) {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("Must be called on the EDT");
        }
        if (jComponent == null) {
            throw new IllegalArgumentException("'parent' cannot be null");
        }
        if (rectangle == null) {
            throw new IllegalArgumentException("'popupLocation' cannot be null");
        }
        HelpPopup.closeIfShowingWithDifferentParent(jComponent);
        HelpPopup helpPopup = HelpPopup.getInstance();
        if (!helpPopup.isVisible()) {
            Window window = SwingUtilities.getWindowAncestor(jComponent);
            if (window == null || !(window instanceof Frame)) {
                throw new IllegalArgumentException("popup must be parented by something that lives in a Frame: " + jComponent);
            }
            helpPopup.reparent((Frame)window, keyStrokeList, rectangle);
        }
        helpPopup.updateFunction(string, uRL);
        helpPopup.populateAndShow(jComponent);
    }

    private void updateFunction(String string, URL uRL) {
        this.fFunctionUrl = uRL == null ? null : uRL.toString();
        this.fFunction = string == null ? null : StringUtils.quoteSingleQuotes((String)string);
    }

    private static Rectangle computeBoundsRelativeToCaret(JTextComponent jTextComponent) {
        return WindowUtils.computeTextPopupBounds((Dimension)HelpPopup.getLastSize(), (Dimension)DEFAULT_SIZE, (JTextComponent)jTextComponent, (WindowUtils.TextPopupLocation)WindowUtils.TextPopupLocation.BELOW_PREFERRED);
    }

    private static synchronized HelpPopup getInstance() {
        if (sSingleton == null) {
            sSingleton = new HelpPopup();
        }
        return sSingleton;
    }

    private HelpPanel getHelpPanel() {
        return this.fHelpPanel;
    }

    private MJPanel getPanel() {
        return this.fPanel;
    }

    private HelpPopup() {
        assert (SwingUtilities.isEventDispatchThread());
        this.createComponents();
    }

    private void createComponents() {
        this.fHelpPanel = this.createHelpPanel();
        HelpToolBar helpToolBar = new HelpToolBar(HelpPopup.getActions(this.fHelpPanel.getHtmlComponent()), new HelpComponentHelper(), null);
        this.fPanel = new MJPanel();
        this.fPanel.setLayout((LayoutManager)new BorderLayout(0, 0));
        this.fPanel.add((Component)helpToolBar.getComponent(), (Object)"North");
        this.fPanel.add((Component)((Object)this.fHelpPanel), (Object)"Center");
        HelpPrefs.addPrefsListeners(this.fPrefListener, "HelpDocCenterLocation");
    }

    private HelpPanel createHelpPanel() {
        HelpPanel helpPanel = new HelpPanel(DocCenterDocConfig.getInstance(), HelpPopup.getOpenBrowserStrategies(), null, HelpDisplayType.CONTEXT_SENSITIVE_HELP);
        helpPanel.setSuppressLoadForCurrentLocation(true);
        HtmlComponent htmlComponent = helpPanel.getHtmlComponent();
        htmlComponent.getComponent().setName("HTMLRenderer");
        htmlComponent.getComponent().addKeyListener(this.fEscapeListener);
        return helpPanel;
    }

    private static OpenBrowserStrategies getOpenBrowserStrategies() {
        OpenBrowserStrategies openBrowserStrategies = new OpenBrowserStrategies();
        openBrowserStrategies.addOpenBrowserStrategy(OpenBrowserStrategyId.CURRENT_BROWSER, new OpenCurrentBrowserStrategy());
        return openBrowserStrategies;
    }

    private static Map<StandardHtmlActionId, ? extends Action> getActions(HtmlComponent htmlComponent) {
        Map map = htmlComponent.getActions().getBasicActions();
        EnumMap enumMap = new EnumMap(StandardHtmlActionId.class);
        enumMap.put(StandardHtmlActionId.GO_BACK, map.get(StandardHtmlActionId.GO_BACK));
        enumMap.put(StandardHtmlActionId.GO_FORWARD, map.get(StandardHtmlActionId.GO_FORWARD));
        enumMap.put(StandardHtmlActionId.RELOAD, map.get(StandardHtmlActionId.RELOAD));
        enumMap.put(StandardHtmlActionId.PRINT, map.get(StandardHtmlActionId.PRINT));
        enumMap.put(StandardHtmlActionId.FIND, map.get(StandardHtmlActionId.FIND));
        return enumMap;
    }

    private void reparent(Frame frame, KeyStrokeList keyStrokeList, Rectangle rectangle) {
        this.fShiftFocusKeyStrokes = keyStrokeList;
        this.fParentWindow = frame;
        this.fWindow = this.buildDialog(rectangle);
    }

    private boolean isVisible() {
        return this.fWindow != null && this.fWindow.isShowing();
    }

    private void setVisible(boolean bl) {
        if (this.fWindow != null) {
            this.fWindow.setVisible(bl);
        }
    }

    private synchronized void dispose() {
        if (this.fWindow != null) {
            this.fWindow.dispose();
        }
        this.disposeComponents();
        sSingleton = null;
    }

    private String computeOpenBrowserHyperlink(boolean bl) {
        if (!bl) {
            return "doc";
        }
        String string = this.fFunctionUrl != null ? HelpPopup.buildWebCommand(this.fFunctionUrl) : HelpPopup.buildDocCommand(this.fFunction);
        return string;
    }

    private static String buildWebCommand(String string) {
        return HelpPopup.isUrlUnderDocroot(string) ? "web('" + string + "', '-helpbrowser')" : "web('" + string + "')";
    }

    private static boolean isUrlUnderDocroot(String string) {
        string = HTMLUtils.getCanonicalUrl(string);
        return HelpUtils.isUnderDocroot(string);
    }

    private static String buildDocCommand(String string) {
        return string == null ? "doc" : "doc ('" + string + "')";
    }

    private KeyListener createEscapeListener() {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    HelpPopup.this.fWindow.dispose();
                    keyEvent.consume();
                }
            }
        };
    }

    private static void setTesting(boolean bl) {
        sTesting = bl;
    }

    public static String getInitialFunction() {
        return HelpPopup.getInstance().getFunction();
    }

    private String getFunction() {
        return this.fFunction;
    }

    private void populateAndShow(JComponent jComponent) {
        Component component;
        if (HelpPopup.isShowingHelpBrowser()) {
            new MatlabMCR().evalConsoleOutput(this.computeOpenBrowserHyperlink(true));
            return;
        }
        this.fOpenBrowserHyperlink = this.computeOpenBrowserHyperlink(true);
        this.fParent = jComponent;
        final HelpPopup helpPopup = HelpPopup.getInstance();
        if (!sTesting) {
            if (this.fFunction == null && this.fFunctionUrl == null) {
                if (!this.fWindow.isVisible()) {
                    component = HelpPopup.buildGlobalLandingPageUrl();
                    HelpPopup.setCurrentLocation((Url)component);
                }
            } else if (this.fFunctionUrl != null) {
                HelpPopup.setCurrentLocation(this.fFunctionUrl);
            } else {
                component = HelpPopup.getReferencePageUrl(this.fFunction);
                if (component == null) {
                    this.populateWithMHelp();
                } else {
                    HelpPopup.setCurrentLocation((Url)component);
                }
            }
        }
        component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
        this.fWindow.setVisible(true);
        HelpPopup.requestFocusInWindow(helpPopup, component);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                HelpPopup.requestFocusInWindow(helpPopup, component);
            }
        });
    }

    private static void requestFocusInWindow(HelpPopup helpPopup, Component component) {
        boolean bl = helpPopup.getHelpPanel().getHtmlComponent().getComponent().requestFocusInWindow();
        if (!bl && component != null) {
            component.requestFocusInWindow();
        }
    }

    private static void setCurrentLocation(String string) {
        HelpPopup.getInstance().getHelpPanel().setCurrentLocation(string);
    }

    private static void setCurrentLocation(Url url) {
        HelpPopup.getInstance().getHelpPanel().setCurrentLocation(url);
    }

    private static Url buildGlobalLandingPageUrl() {
        return HelpPopup.getInstance().getHelpPanel().getDocConfig().getDocRoot().buildGlobalLandingPageUrl();
    }

    private static Url getReferencePageUrl(String string) {
        return HelpPopup.getDocCenterReferencePageUrl(string);
    }

    private static Url getDocCenterReferencePageUrl(String string) {
        DocCenterDocConfig<FileUrl> docCenterDocConfig = DocCenterDocConfig.getLocalConfig();
        List<ReferenceData> list = HelpPopup.getReferenceData(docCenterDocConfig, string);
        Url url = null;
        if (!list.isEmpty()) {
            ReferenceData referenceData = list.get(0);
            DocRoot docRoot = HelpPopup.getInstance().getHelpPanel().getDocConfig().getDocRoot();
            url = docRoot.buildDocSetItemUrl(referenceData.getDocSetItem(), referenceData.getRelativePath());
        }
        return url;
    }

    private static List<ReferenceData> getReferenceData(DocConfig<? extends Url> docConfig, String string) {
        if (string != null && string.endsWith(".m")) {
            string = string.substring(0, string.length() - 2);
        }
        return new HelpTopic(docConfig, string).preferInformalTopics(true).getReferenceData();
    }

    private void populateWithMHelp() {
        assert (Matlab.isMatlabAvailable());
        new MatlabWorker(){

            public Object runOnMatlabThread() {
                Object object;
                try {
                    String string = "";
                    String string2 = "-helpPopup";
                    object = 3.feval((String)"help2html", (Object[])new Object[]{HelpPopup.this.fFunction, string, string2}, (int)2);
                }
                catch (Exception exception) {
                    object = null;
                }
                return object;
            }

            public void runOnAWTEventDispatchThread(Object object) {
                if (object == null) {
                    HelpPopup.this.cleanup();
                    return;
                }
                Object[] objectArray = (Object[])object;
                HelpPopup helpPopup = HelpPopup.getInstance();
                String string = objectArray[0].toString();
                String string2 = helpPopup.getHelpPanel().getHtmlText();
                if (string2 == null || !string2.contains(string)) {
                    helpPopup.getHelpPanel().setHtmlText(string);
                }
                boolean bl = ((boolean[])objectArray[1])[0];
                HelpPopup.this.fOpenBrowserHyperlink = HelpPopup.this.computeOpenBrowserHyperlink(bl);
                helpPopup.getHelpPanel().getHtmlComponent().getComponent().requestFocusInWindow();
            }
        }.start();
    }

    private Window buildDialog(Rectangle rectangle) {
        JDialog jDialog = new LightweightWindow(this.fParentWindow, HelpUtils.getLocalizedString("helppopup.title"), (Component)HelpPopup.getInstance().getPanel(), this.buildStatusBar()).getWindow();
        jDialog.setName("HelpPopup");
        this.fContentPane = (JComponent)jDialog.getContentPane();
        this.addKeyStrokeToShiftFocus(this.fContentPane);
        this.fWindowListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HelpPopup.this.cleanup();
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                HelpPopup.this.cleanup();
            }
        };
        jDialog.addWindowListener(this.fWindowListener);
        if (!PlatformInfo.isMacintosh()) {
            jDialog.setMinimumSize(MINIMUM_SIZE);
        }
        jDialog.setBounds(rectangle);
        return jDialog;
    }

    private void addKeyStrokeToShiftFocus(JComponent jComponent) {
        if (this.fShiftFocusKeyStrokes != null && !this.fShiftFocusKeyStrokes.isEmpty()) {
            InputMap inputMap = jComponent.getInputMap(1);
            MInputMap mInputMap = new MInputMap();
            mInputMap.setParent(inputMap);
            mInputMap.put(this.fShiftFocusKeyStrokes.toKeyStrokeArray(), (Object)FOCUS_LISTENER_KEY);
            jComponent.setInputMap(1, (InputMap)mInputMap);
            ActionMap actionMap = jComponent.getActionMap();
            actionMap.put(FOCUS_LISTENER_KEY, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (HelpPopup.this.fParent != null) {
                        HelpPopup.this.fParent.requestFocus();
                    }
                }
            });
        }
    }

    private MJStatusBar buildStatusBar() {
        String string;
        String string2;
        MJStatusBar mJStatusBar = new MJStatusBar();
        HyperlinkTextLabel.HyperlinkHandler hyperlinkHandler = new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                HelpPopup.this.fWindow.dispose();
                HelpPopup helpPopup = HelpPopup.getInstance();
                if (helpPopup.getHelpPanel().getCurrentLocation() != null && !helpPopup.getHelpPanel().getCurrentLocation().startsWith("text")) {
                    MLHelpServices.setCurrentLocation((String)helpPopup.getHelpPanel().getCurrentLocation());
                } else {
                    new MatlabMCR().evalConsoleOutput(HelpPopup.this.fOpenBrowserHyperlink);
                }
            }
        };
        mJStatusBar.add(Box.createRigidArea(new Dimension(8, 20)), (Object)"West");
        String string3 = HelpUtils.getLocalizedString("helppopup.openHelpBrowser");
        this.fHyperlink = new HyperlinkTextLabel(string3, hyperlinkHandler);
        this.fHyperlink.getComponent().setName("HelpLink");
        this.fHyperlink.setFont(HelpPopup.getReducedFont(new JLabel().getFont()));
        mJStatusBar.add((Component)this.fHyperlink.getComponent(), (Object)"West");
        if (this.fShiftFocusKeyStrokes != null) {
            string2 = KeyStrokeUtils.translateKeyStrokes((KeyStrokeList)this.fShiftFocusKeyStrokes);
            string = MessageFormat.format(HelpUtils.getLocalizedString("helppopup.toggleFocusAndEscape"), string2);
        } else {
            string = HelpUtils.getLocalizedString("helppopup.escape");
        }
        string2 = new MJLabel(string);
        string2.setFont(HelpPopup.getReducedFont(string2.getFont()));
        mJStatusBar.add((Component)((Object)string2));
        return mJStatusBar;
    }

    private static Font getReducedFont(Font font) {
        return font.deriveFont((float)(font.getSize() - 2));
    }

    private static synchronized Dimension getLastSize() {
        return sLastSize == null ? DEFAULT_SIZE : sLastSize;
    }

    private synchronized void cleanup() {
        if (this.fParent != null) {
            sLastSize = this.fWindow.getSize();
            this.fWindow.removeWindowListener(this.fWindowListener);
            this.fContentPane.getActionMap().remove(FOCUS_LISTENER_KEY);
            this.fWindow.dispose();
            this.fHyperlink.cleanup();
            this.fParentWindow = null;
            this.fParent = null;
        }
    }

    private void disposeComponents() {
        HelpPrefs.removePrefsListeners(this.fPrefListener, "HelpDocCenterLocation");
        if (this.fHelpPanel != null) {
            HtmlComponent htmlComponent = this.fHelpPanel.getHtmlComponent();
            if (htmlComponent != null) {
                htmlComponent.getComponent().removeKeyListener(this.fEscapeListener);
            }
            this.fHelpPanel.dispose();
        }
        if (this.fPanel != null) {
            this.fPanel = null;
        }
    }

    static {
        sSingleton = null;
    }

    private class DocCenterPrefsListener
    implements PrefListener {
        private DocCenterPrefsListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (HelpPopup.this.isVisible()) {
                        HelpPopup.this.setVisible(false);
                    }
                    HelpPopup.this.dispose();
                }
            });
        }
    }

    private static class OpenCurrentBrowserStrategy
    implements OpenBrowserStrategy {
        private OpenCurrentBrowserStrategy() {
        }

        @Override
        public void openUrl(Url url) {
            HelpPopup.setCurrentLocation(url);
        }
    }
}

