/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.helpsearch.reference.RefEntityType;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;

public enum RefTypeGroup {
    EXCLUDE_MUPAD(RefTypeGroup.getNonMupadRefEntityTypes()),
    CLASS_ENTITY(EnumSet.of(RefEntityType.FUNCTION, RefEntityType.CLASS, RefEntityType.METHOD, RefEntityType.PROPERTY)),
    MUPAD(RefTypeGroup.getMupadRefEntityTypes()),
    ALL(EnumSet.allOf(RefEntityType.class));

    private final Collection<RefEntityType> fTypes;

    private RefTypeGroup(Collection<RefEntityType> collection) {
        this.fTypes = EnumSet.copyOf(collection);
    }

    public Collection<RefEntityType> getTypes() {
        return Collections.unmodifiableCollection(this.fTypes);
    }

    private static Collection<RefEntityType> getMupadRefEntityTypes() {
        EnumSet<RefEntityType> enumSet = EnumSet.noneOf(RefEntityType.class);
        for (RefEntityType refEntityType : RefEntityType.values()) {
            if (!refEntityType.toString().toLowerCase(Locale.ENGLISH).startsWith("mupad")) continue;
            enumSet.add(refEntityType);
        }
        return enumSet;
    }

    private static Collection<RefEntityType> getNonMupadRefEntityTypes() {
        EnumSet<RefEntityType> enumSet = EnumSet.allOf(RefEntityType.class);
        enumSet.removeAll(RefTypeGroup.getMupadRefEntityTypes());
        return enumSet;
    }
}

