/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search.lucene;

import com.mathworks.mlwidgets.help.search.RefEntityType;
import com.mathworks.mlwidgets.help.search.ResultType;
import com.mathworks.mlwidgets.help.search.SearchUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class DocumentInfo {
    private StringBuilder fTitle;
    private String fSection;
    private String fBody;
    private StringBuilder fRefPageSummary;
    private StringBuilder fSectionHeadings;
    private boolean fReference;
    private String fAnchor;
    private boolean fStudent = false;
    private List<String> fRefEntities;
    private String fFunctionName;
    private ResultType fResultType;
    private String fCharset;

    String getTitle() {
        if (this.fTitle == null) {
            return null;
        }
        return this.fTitle.toString();
    }

    void appendToTitle(String string) {
        if (this.fTitle == null) {
            this.setTitle(string);
        } else {
            this.fTitle.append(string);
        }
    }

    void setTitle(String string) {
        this.fTitle = new StringBuilder(string);
    }

    String getSection() {
        return this.fSection;
    }

    void setSection(String string) {
        this.fSection = string;
    }

    String getBody() {
        return this.fBody;
    }

    void setBody(String string) {
        this.fBody = string;
    }

    public String getRefPageSummary() {
        if (this.fRefPageSummary != null) {
            return this.fRefPageSummary.toString();
        }
        return null;
    }

    void clearRefPageSummary() {
        if (this.fRefPageSummary != null) {
            this.fRefPageSummary = new StringBuilder();
        }
    }

    void appendToRefPageSummary(String string) {
        if (this.fRefPageSummary == null) {
            this.fRefPageSummary = new StringBuilder();
        }
        this.fRefPageSummary.append(string);
    }

    boolean isReferencePage() {
        return this.fReference;
    }

    void setReferencePage(boolean bl) {
        this.fReference = bl;
    }

    List<String> getRefPageEntities() {
        if (this.fRefEntities == null) {
            return null;
        }
        return Collections.unmodifiableList(this.fRefEntities);
    }

    void addRefPageEntity(String string, RefEntityType refEntityType) {
        String string2 = SearchUtils.getIndexString(refEntityType, string);
        if (string2 != null) {
            if (this.fRefEntities == null) {
                this.fRefEntities = new ArrayList<String>();
            }
            this.fRefEntities.add(string2);
            if (refEntityType == RefEntityType.FUNCTION) {
                this.fFunctionName = string;
            }
        }
    }

    String getFunctionName(String string) {
        if (this.fFunctionName != null) {
            return this.fFunctionName;
        }
        if (this.isReferencePage()) {
            String string2 = this.getTitle().trim();
            if (string2.indexOf(44) < 0) {
                String string3 = string.replaceAll("\\.html$", "");
                if (!string2.matches(".*\\b\\s+\\b.*") && string2.replaceAll("[(.)\\s]", "").equalsIgnoreCase(string3.replaceAll("[(.)\\s]", ""))) {
                    return string2;
                }
            } else {
                String[] stringArray;
                for (String string4 : stringArray = string2.split(",")) {
                    if (!string.equalsIgnoreCase((string4 = string4.trim()).toLowerCase(Locale.ENGLISH) + ".html")) continue;
                    return string4;
                }
            }
        }
        return null;
    }

    String getAnchor() {
        return this.fAnchor;
    }

    void setAnchor(String string) {
        this.fAnchor = string;
    }

    boolean isStudent() {
        return this.fStudent;
    }

    void setStudent(boolean bl) {
        this.fStudent = bl;
    }

    void addSectionHeading(String string) {
        if (this.fSectionHeadings == null) {
            this.fSectionHeadings = new StringBuilder(string);
        } else {
            this.fSectionHeadings.append(" ").append(string);
        }
    }

    String getSectionHeadings() {
        if (this.fSectionHeadings != null) {
            return this.fSectionHeadings.toString();
        }
        return "";
    }

    public ResultType getResultType() {
        return this.fResultType;
    }

    void setResultType(ResultType resultType) {
        this.fResultType = resultType;
    }

    public String getCharset() {
        return this.fCharset;
    }

    void setCharset(String string) {
        this.fCharset = string;
    }

    boolean shouldBeIndexed() {
        if (!(DocumentInfo.isFieldPopulated(this.fTitle) && DocumentInfo.isFieldPopulated(this.fBody) && DocumentInfo.isFieldPopulated(this.fSection))) {
            return false;
        }
        return !this.fTitle.toString().trim().equalsIgnoreCase(this.fBody);
    }

    private static boolean isFieldPopulated(StringBuilder stringBuilder) {
        return stringBuilder != null && DocumentInfo.isFieldPopulated(stringBuilder.toString());
    }

    private static boolean isFieldPopulated(String string) {
        return string != null && !string.trim().isEmpty();
    }
}

