/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.GeneratedCode;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.WorksheetCellRenderer;
import com.mathworks.mlwidgets.importtool.WorksheetReplacementRule;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import java.util.List;

public class BlankReplacementRule
extends WorksheetReplacementRule {
    public BlankReplacementRule(WorksheetRule worksheetRule) {
        super(worksheetRule);
    }

    public BlankReplacementRule() {
    }

    public static WorksheetRule.RuleType getRuleType() {
        return WorksheetRule.RuleType.REPLACE;
    }

    @Override
    public Object clone() {
        return new BlankReplacementRule(this);
    }

    @Override
    public String getSummaryComment() {
        return ImportToolUtils.getResourceString("codeGen.blankreplacesummary") + " " + Double.toString(this.getReplacementNumber());
    }

    @Override
    public boolean codeGenUsesDates() {
        return false;
    }

    @Override
    public boolean codeGenNeedsNaNConvert() {
        return true;
    }

    @Override
    public void generateMatlabCode(List<WorksheetRule> list, GeneratedCode generatedCode) {
        generatedCode.addCode("\n%% ");
        generatedCode.addCode(ImportToolUtils.getResourceString("CodeGen.replaceblankcell"));
        generatedCode.addCode(" ");
        generatedCode.addCode(Double.toString(this.fReplacementNumber));
        generatedCode.addCode("\n");
        this.genReplacementCodeForVar(generatedCode, generatedCode.getRawCellArray(), this.fReplacementNumber);
        if (WorksheetRule.isRuleFollowedByDateRule(list, this) && generatedCode.isNumericDatetime()) {
            this.genReplacementCodeForVar(generatedCode, generatedCode.getDateArray(), Double.NaN);
        }
        generatedCode.setBlanksExcluded(true);
    }

    private void genReplacementCodeForVar(GeneratedCode generatedCode, String string, double d) {
        generatedCode.addCode(generatedCode.getReplacementIndex());
        generatedCode.addCode(" = cellfun(@(x) isempty(x) || (ischar(x) && all(x==' ')),");
        generatedCode.addCode(string);
        generatedCode.addCode(");\n ");
        generatedCode.addCode(string);
        generatedCode.addCode("(");
        generatedCode.addCode(generatedCode.getReplacementIndex());
        generatedCode.addCode(") = {");
        if (Double.isInfinite(d)) {
            generatedCode.addCode(WorksheetCellRenderer.formatDouble(d));
        } else {
            generatedCode.addCode(Double.toString(d));
        }
        generatedCode.addCode("}; % ");
        generatedCode.addCode(ImportToolUtils.getResourceString("CodeGen.replaceblankcontent"));
        generatedCode.addCode("\n");
    }

    @Override
    public String getApplyFcn() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(AbstractSpreadsheetPath);
        stringBuilder.append(".");
        stringBuilder.append("blankReplaceFcn");
        return stringBuilder.toString();
    }

    public String toString() {
        return ImportToolUtils.getResourceString("RuleType.blanks");
    }
}

