/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.actionbrowser.ActionBrowserUtils;
import com.mathworks.mlwidgets.actionbrowser.ActionToolTip;
import com.mathworks.mlwidgets.actionbrowser.ActionToolTipPanel;
import com.mathworks.mlwidgets.actionbrowser.HelpOnSelectionProvider;
import com.mathworks.mlwidgets.actionbrowser.HelpPopupLauncher;
import com.mathworks.mlwidgets.importtool.ICustomActionTooltipComponent;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.table.JTableHeader;

public class CustomActionTooltipListener
extends MouseAdapter {
    protected static ActionToolTip sActionTip = null;
    private boolean fActionTipPending = false;
    protected final JComponent[] fComponents;
    protected Point fPt = null;
    protected Component fAdditionalInlineComponent = null;
    private final ICustomActionTooltipComponent fCustomActionTT;
    private final HelpOnSelectionProvider fHelpListener;
    private final Object fActionTipPendingObj = new Object();
    private JTableHeader fHeader;
    private static final int SCROLLBAR_WIDTH = 20;
    public static final int ACTION_TOOLTIP_WIDTH = ActionToolTipPanel.DEFAULT_SIZE.width + 20;
    private static final int ACTION_TOOLTIP_HEIGHT = ActionToolTipPanel.DEFAULT_SIZE.height;
    private static final int SPACE_BUFFER = 10;
    private static final int NUM_CUSTOM_DATE_LINES = 47;

    protected CustomActionTooltipListener(ICustomActionTooltipComponent iCustomActionTooltipComponent, JComponent[] jComponentArray) {
        this.fCustomActionTT = iCustomActionTooltipComponent;
        this.fComponents = (JComponent[])jComponentArray.clone();
        for (JComponent jComponent : jComponentArray) {
            jComponent.setToolTipText(null);
        }
        this.fHelpListener = new HelpOnSelectionProvider(){

            @Override
            public void showHelpOnSelection(URL uRL, Rectangle rectangle) {
                CustomActionTooltipListener.this.fCustomActionTT.hideOtherComponents();
                ActionBrowserUtils.showHelpOnSelection(uRL, rectangle, null, CustomActionTooltipListener.this.fCustomActionTT.getHelpPopupLauncher());
            }

            @Override
            public void showHelpOnSelection(String string, Rectangle rectangle) {
                CustomActionTooltipListener.this.fCustomActionTT.hideOtherComponents();
                HelpPopupLauncher helpPopupLauncher = CustomActionTooltipListener.this.fCustomActionTT.getHelpPopupLauncher();
                Window window = SwingUtilities.getWindowAncestor(helpPopupLauncher.getParentComponent());
                if (window != null) {
                    ActionBrowserUtils.showHelpOnSelection(CustomActionTooltipListener.this.fCustomActionTT.getFunctionName(), rectangle, null, helpPopupLauncher);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        boolean bl;
        Object object = this.fActionTipPendingObj;
        synchronized (object) {
            bl = this.fActionTipPending;
        }
        if (sActionTip == null || !sActionTip.isShowing() && !bl) {
            object = this.fActionTipPendingObj;
            synchronized (object) {
                this.fActionTipPending = true;
            }
            this.showActionToolTip(this.getWidestComponent());
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        try {
            if (sActionTip != null) {
                Cloneable cloneable;
                Cloneable cloneable2;
                Point point = CustomActionTooltipListener.getMouseLocationOnScreen(mouseEvent);
                boolean bl = false;
                if (this.fAdditionalInlineComponent != null && this.fAdditionalInlineComponent.isVisible()) {
                    cloneable2 = this.fAdditionalInlineComponent.getLocationOnScreen();
                    cloneable = new Rectangle(cloneable2.x, cloneable2.y, this.fAdditionalInlineComponent.getSize().width, this.fAdditionalInlineComponent.getSize().height);
                    if (((Rectangle)cloneable).contains(point)) {
                        bl = true;
                    }
                }
                if (!bl) {
                    cloneable2 = null;
                    if (sActionTip.getBalloon() != null) {
                        cloneable = sActionTip.getBalloon().getLocationOnScreen();
                        cloneable2 = CustomActionTooltipListener.getActionTTBounds((Point)cloneable, sActionTip.getBalloon().getBounds());
                    } else if (sActionTip.getDialog() != null && sActionTip.getDialog().isVisible()) {
                        cloneable = sActionTip.getDialog().getLocationOnScreen();
                        cloneable2 = CustomActionTooltipListener.getActionTTBounds((Point)cloneable, sActionTip.getDialog().getBounds());
                    }
                    if (cloneable2 != null && !((Rectangle)cloneable2).contains(point)) {
                        this.hideActionToolTip();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Rectangle getActionTTBounds(Point point, Rectangle rectangle) {
        rectangle.width = ACTION_TOOLTIP_WIDTH;
        rectangle.x = point.x - 10;
        rectangle.y = point.y;
        return rectangle;
    }

    protected static Point getMouseLocationOnScreen(MouseEvent mouseEvent) {
        return mouseEvent.getLocationOnScreen();
    }

    protected static Point getComponentLocation(JComponent jComponent) {
        Point point;
        try {
            point = jComponent.getLocationOnScreen();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            point = new Point();
        }
        return point;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideActionToolTip() {
        Object object = this.fActionTipPendingObj;
        synchronized (object) {
            this.fActionTipPending = false;
        }
        if (sActionTip != null) {
            sActionTip.hide();
            sActionTip = null;
        }
        if (this.fHeader != null) {
            this.fHeader.getTable().repaint();
        }
    }

    protected void showActionToolTip(JComponent jComponent) {
        if (jComponent.isShowing()) {
            this.fPt = jComponent.getLocationOnScreen();
            Timer timer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CustomActionTooltipListener.this.showActionToolTip();
                }
            });
            timer.setRepeats(false);
            timer.start();
        }
    }

    JComponent getWidestComponent() {
        JComponent jComponent = this.fComponents[0];
        for (JComponent jComponent2 : this.fComponents) {
            if (jComponent2.getWidth() <= jComponent.getWidth() && jComponent2.getHeight() <= jComponent.getHeight()) continue;
            jComponent = jComponent2;
        }
        return jComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showActionToolTip() {
        boolean bl;
        Object object = this.fActionTipPendingObj;
        synchronized (object) {
            bl = this.fActionTipPending;
            this.fActionTipPending = false;
        }
        if (!bl) {
            return;
        }
        object = this.getWidestComponent();
        Point point = CustomActionTooltipListener.getComponentLocation((JComponent)object);
        Rectangle rectangle = new Rectangle(point.x, point.y, ((JComponent)object).getWidth(), ACTION_TOOLTIP_HEIGHT);
        if (this.fAdditionalInlineComponent != null && this.fAdditionalInlineComponent.isVisible()) {
            rectangle.width += this.fAdditionalInlineComponent.getWidth();
        }
        if (point.x == 0 || point.y == 0) {
            return;
        }
        if (sActionTip != null) {
            this.hideActionToolTip();
        }
        sActionTip = ActionToolTip.createActionToolTip(this.getParentFrame(), new ActionToolTipPanel(this.fHelpListener, false), rectangle, this.fHelpListener);
        sActionTip.setArrowPointLocation(new Point(this.fPt.x + rectangle.width + 10, this.fPt.y + 10));
        this.fCustomActionTT.setTooltipComponent(sActionTip);
        if (sActionTip.getDialog() != null) {
            sActionTip.getDialog().setMaximumSize(new Dimension(ACTION_TOOLTIP_WIDTH, ACTION_TOOLTIP_HEIGHT));
        }
        CustomActionTooltipListener.openToolTip();
    }

    private static void openToolTip() {
        String string = CustomActionTooltipListener.getCustomText();
        sActionTip.openTooltip(string, ImportToolUtils.getResourceString("customDate.helpTT.Title"), true);
    }

    private static String getCustomText() {
        StringBuilder stringBuilder = new StringBuilder(ImportToolUtils.getResourceString("customDate.helpTT.Header"));
        for (int i = 1; i <= 47; ++i) {
            try {
                stringBuilder.append(ImportToolUtils.getResourceString("customDate.helpTT." + i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringBuilder.toString();
    }

    protected Frame getParentFrame() {
        return (Frame)SwingUtilities.getAncestorOfClass(JFrame.class, this.fComponents[0]);
    }

    protected void setAdditionalCompDisplayed(Component component) {
        this.fAdditionalInlineComponent = component;
    }

    void setTableHeader(JTableHeader jTableHeader) {
        this.fHeader = jTableHeader;
    }
}

