/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlservices.MLWorkspaceServices;
import com.mathworks.mlwidgets.actionbrowser.DragableGripper;
import com.mathworks.mlwidgets.actionbrowser.TearOffAble;
import com.mathworks.mlwidgets.importtool.Fader;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mwswing.ComponentMover;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class FadingAcknowledgementWindow
extends MJDialog
implements TearOffAble {
    private HyperlinkTextLabel fVarNamePanel = new HyperlinkTextLabel("", (HyperlinkTextLabel.HyperlinkHandler)new WorkspaceSelectionHandler());
    private Fader fFader;
    private String[] fVarNames;
    private DragableGripper fGripper;
    private MJPanel fContentPanel;
    private boolean fMousePressed = false;
    private boolean fFading = false;
    private static Color DEFAULT_GRIPPER_COLOR;
    private static Color DEFAULT_BACKGROUND_COLOR;
    private static int MAXVARIABLECOUNT;
    private static ResourceBundle resources;
    private WindowMouseFocusLostListener fWindowFocuslistener = new WindowMouseFocusLostListener();
    static final /* synthetic */ boolean $assertionsDisabled;

    FadingAcknowledgementWindow(Frame frame) {
        super(frame);
        this.initWidgets();
        this.setFocusableWindowState(false);
        this.fFader = new Fader((Window)((Object)this));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                FadingAcknowledgementWindow.this.setVisible(false);
                Toolkit.getDefaultToolkit().removeAWTEventListener(FadingAcknowledgementWindow.this.fWindowFocuslistener);
            }
        });
        this.getContentPane().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                FadingAcknowledgementWindow.this.fMousePressed = true;
                FadingAcknowledgementWindow.this.setFocusableWindowState(true);
                FadingAcknowledgementWindow.this.requestFocus();
                FadingAcknowledgementWindow.this.reset();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (FadingAcknowledgementWindow.this.fFading) {
                    FadingAcknowledgementWindow.this.setFocusableWindowState(true);
                    FadingAcknowledgementWindow.this.requestFocus();
                    FadingAcknowledgementWindow.this.reset();
                    if (!FadingAcknowledgementWindow.this.fMousePressed) {
                        long l = 32L;
                        Toolkit.getDefaultToolkit().addAWTEventListener(FadingAcknowledgementWindow.this.fWindowFocuslistener, l);
                    }
                }
            }
        });
        this.fGripper.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                FadingAcknowledgementWindow.this.fMousePressed = true;
                FadingAcknowledgementWindow.this.setFocusableWindowState(true);
                FadingAcknowledgementWindow.this.requestFocus();
                FadingAcknowledgementWindow.this.reset();
            }
        });
    }

    void fade() {
        this.fFader.fade();
        this.fFading = true;
    }

    void reset() {
        this.fFader.reset();
        this.fFading = false;
    }

    void setVariableContent(String[] stringArray, Object[] objectArray) {
        this.fVarNames = stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        int n = stringArray.length <= MAXVARIABLECOUNT ? stringArray.length : MAXVARIABLECOUNT - 1;
        stringBuilder.append("<html><a href=''>");
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.fVarNames[i]);
            double[] dArray = (double[])objectArray[i];
            stringBuilder.append("&nbsp;(");
            stringBuilder.append(Integer.toString((int)dArray[0]));
            stringBuilder.append("x");
            stringBuilder.append(Integer.toString((int)dArray[1]));
            stringBuilder.append(")<br>");
        }
        if (n < stringArray.length) {
            stringBuilder.append("&amp;&nbsp;");
            stringBuilder.append(Integer.toString(stringArray.length - n));
            stringBuilder.append("&nbsp;");
            stringBuilder.append(ImportToolUtils.getResourceString("fadingacknowledge.more"));
            stringBuilder.append("<br>");
        }
        stringBuilder.append("</a></html>");
        this.fVarNamePanel.setText(stringBuilder.toString());
        this.fContentPanel.invalidate();
        this.pack();
    }

    private void initWidgets() {
        this.setUndecorated(true);
        this.setCloseOnEscapeEnabled(true);
        this.setDefaultCloseOperation(1);
        this.fGripper = new DragableGripper(this, resources.getString("TearOffDialog.ClickPrompt"));
        this.setComponentToMove();
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.setBackground(DEFAULT_GRIPPER_COLOR);
        mJPanel.add((Component)((Object)this.fGripper), (Object)"North");
        this.fContentPanel = new MJPanel((LayoutManager)new BorderLayout());
        this.fContentPanel.setBackground(DEFAULT_BACKGROUND_COLOR);
        this.fContentPanel.setOpaque(true);
        this.fContentPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.fContentPanel.add((Component)new MJLabel(ImportToolUtils.getResourceString("fadingacknowledge.importaction")), (Object)"Center");
        this.fContentPanel.add((Component)this.fVarNamePanel.getComponent(), (Object)"South");
        if (this.getContentPane() instanceof JComponent) {
            ((JComponent)this.getContentPane()).setOpaque(true);
            ((JComponent)this.getContentPane()).setBorder(BorderFactory.createLineBorder(Color.black));
        }
        this.getContentPane().setBackground(DEFAULT_BACKGROUND_COLOR);
        this.getContentPane().add((Component)mJPanel, "North");
        this.getContentPane().add((Component)this.fContentPanel, "Center");
    }

    @Override
    public void makeFloating() {
    }

    @Override
    public void floatingComplete() {
    }

    public void show() {
        WindowUtils.ensureOnScreen((Window)((Object)this));
        super.show();
        if (!$assertionsDisabled && !Fader.isTranslucencySupported()) {
            throw new AssertionError();
        }
        this.fade();
    }

    public boolean isMousePressed() {
        return this.fMousePressed;
    }

    public boolean isFading() {
        return this.fFading;
    }

    public DragableGripper getGripper() {
        return this.fGripper;
    }

    private void setComponentToMove() {
        ComponentMover componentMover = new ComponentMover((Component)((Object)this));
        this.fGripper.addMouseListener((MouseListener)componentMover);
        this.fGripper.addMouseMotionListener((MouseMotionListener)componentMover);
    }

    public void cleanup() {
        if (this.fFader != null) {
            this.fFader.cleanup();
        }
    }

    static {
        boolean bl = $assertionsDisabled = !FadingAcknowledgementWindow.class.desiredAssertionStatus();
        if (MJUtilities.isHighContrast()) {
            DEFAULT_GRIPPER_COLOR = Color.black;
            DEFAULT_BACKGROUND_COLOR = Color.black;
        }
        DEFAULT_GRIPPER_COLOR = new Color(240, 240, 240);
        DEFAULT_BACKGROUND_COLOR = Color.white;
        MAXVARIABLECOUNT = 4;
        resources = ResourceBundle.getBundle("com.mathworks.mlwidgets.actionbrowser.resources.RES_ActionBrowser");
    }

    public class WindowMouseFocusLostListener
    implements AWTEventListener {
        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            try {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                if (mouseEvent.getID() == 503) {
                    Point point = mouseEvent.getLocationOnScreen();
                    Rectangle rectangle = FadingAcknowledgementWindow.this.getBounds();
                    Point point2 = FadingAcknowledgementWindow.this.getLocationOnScreen();
                    rectangle.x = point2.x;
                    rectangle.y = point2.y;
                    if (!rectangle.contains(point)) {
                        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                        if (!FadingAcknowledgementWindow.this.fMousePressed) {
                            FadingAcknowledgementWindow.this.setFocusableWindowState(true);
                            FadingAcknowledgementWindow.this.fade();
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class WorkspaceSelectionHandler
    implements HyperlinkTextLabel.HyperlinkHandler {
        WorkspaceSelectionHandler() {
        }

        public void processHyperlink(String string) {
            MLWorkspaceServices.setSelectedNames((String[])FadingAcknowledgementWindow.this.fVarNames);
            FadingAcknowledgementWindow.this.dispose();
        }
    }
}

