/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexTextParser {
    public static int DEFAULT_CHARACTER_BUFFER_SIZE = 4096;
    public static String TEST_CRNL_REGEX = ".*?(\\r\\n)";
    public static String TEST_CR_REGEX = ".*?(\\r)";
    public static String TEST_NL_REGEX = ".*?(\\n)";
    public static String TEST_TAB_REGEX = ".*?(\\t+).+?";
    public static String TEST_COMMA_REGEX = ".*?(,+).+?";
    public static String TEST_SPACE_REGEX = ".*?( +).+?";
    public static String TEST_SINGLE_QUOTE_REGEX = "(').*?\\1";
    public static String TEST_DOUBLE_QUOTE_REGEX = "(\").*?\\1";
    public static String TEST_ANY_SEPARATOR_REGEX = ".+?([^a-zA-Z0-9]+).+?\\1.*?([^a-zA-Z0-9'\"]+).+?\\2";
    public static String PATTERN_CR = "\\r";
    public static String PATTERN_NL = "\\n";
    public static String PATTERN_CRNL = "\\r\\n";
    public static String PATTERN_TAB = "\\t";
    public static String PATTERN_COMMA = ",";
    public static String PATTERN_SPACE = " ";
    public static String PATTERN_SINGLE_QUOTE = "'";
    public static String PATTERN_DOUBLE_QUOTE = "\"";
    private File fInputFile;
    private String fRowRegex;
    private String fColRegex;
    private String fQuoteRegex;
    private int fNumIgnoreLines;
    private int fNumBufferRows = -1;
    private RandomAccessFile fDataStream = null;
    private ArrayList<ArrayList<String>> fCurrentWindow = null;
    private Stack fRowStack = new Stack();
    private boolean fFixedWidth = false;
    private ArrayList<Integer> fFixedWidthColumnPositions = null;
    private double fFixedWidthRowPercentHit = 0.75;
    private double fFixedWidthColPercentHit = 0.25;

    public RegexTextParser(File file, String string, String string2, String string3, int n, int n2) throws IOException {
        this.fInputFile = file;
        this.fRowRegex = string;
        this.fColRegex = string2;
        this.fQuoteRegex = string3;
        this.fNumIgnoreLines = n;
        this.fNumBufferRows = n2;
        this.reset();
    }

    public RegexTextParser(File file, int n, int n2) throws IOException {
        String string = RegexTextParser.rowSeparatorToRegex("(\r\n)|(\r)|(\n)");
        this.fInputFile = file;
        this.fRowRegex = string;
        this.fColRegex = RegexTextParser.columnSeparatorToRegex("^");
        this.fQuoteRegex = RegexTextParser.quoteSeparatorToRegex("", false);
        this.fNumIgnoreLines = n;
        this.fNumBufferRows = n2;
        this.fFixedWidth = RegexTextParser.isFixedWidth(file, n2);
        this.reset();
    }

    public File getInputFile() {
        return this.fInputFile;
    }

    public void setInputFile(File file) throws IOException {
        this.fInputFile = file;
        this.reset();
    }

    public String getRowRegex() {
        return this.fRowRegex;
    }

    public ArrayList<ArrayList<String>> setRowRegex(String string) throws IOException {
        if (this.fDataStream != null) {
            if (this.fNumBufferRows == -1 || this.fCurrentWindow == null) {
                this.fRowRegex = string;
                this.fCurrentWindow = null;
                this.parseCurrentWindow();
            } else {
                this.rewindCurrentWindow();
                this.fRowRegex = string;
                this.fCurrentWindow = RegexTextParser.parseStream(this.fDataStream, this.fRowRegex, this.fColRegex, this.fQuoteRegex, 0, this.fNumBufferRows, this.fRowStack);
            }
        }
        return this.fCurrentWindow;
    }

    public String getColRegex() {
        return this.fColRegex;
    }

    public ArrayList<ArrayList<String>> setColRegex(String string) throws IOException {
        if (this.fDataStream != null) {
            if (this.fNumBufferRows == -1 || this.fCurrentWindow == null) {
                this.fColRegex = string;
                this.fCurrentWindow = null;
                this.parseCurrentWindow();
            } else {
                this.rewindCurrentWindow();
                this.fColRegex = string;
                this.fCurrentWindow = RegexTextParser.parseStream(this.fDataStream, this.fRowRegex, this.fColRegex, this.fQuoteRegex, 0, this.fNumBufferRows, this.fRowStack);
            }
        }
        return this.fCurrentWindow;
    }

    public String getQuoteRegex() {
        return this.fQuoteRegex;
    }

    public ArrayList<ArrayList<String>> setQuoteRegex(String string) throws IOException {
        if (this.fDataStream != null) {
            if (this.fNumBufferRows == -1 || this.fCurrentWindow == null) {
                this.fQuoteRegex = string;
                this.fCurrentWindow = null;
                this.parseCurrentWindow();
            } else {
                this.rewindCurrentWindow();
                this.fQuoteRegex = string;
                this.fCurrentWindow = RegexTextParser.parseStream(this.fDataStream, this.fRowRegex, this.fColRegex, this.fQuoteRegex, 0, this.fNumBufferRows, this.fRowStack);
            }
        }
        return this.fCurrentWindow;
    }

    private void rewindCurrentWindow() {
        int n = this.fCurrentWindow.size();
        for (int i = 0; i < n; ++i) {
            try {
                this.fDataStream.seek((Long)this.fRowStack.pop());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getNumIgnoreLines() {
        return this.fNumIgnoreLines;
    }

    public ArrayList<ArrayList<String>> setNumIgnoreLines(int n) throws IOException {
        this.fNumIgnoreLines = n;
        this.reset();
        this.fCurrentWindow = null;
        return this.parseCurrentWindow();
    }

    public int getNumBufferRows() {
        return this.fNumBufferRows;
    }

    public ArrayList<ArrayList<String>> setNumBufferRows(int n) throws IOException {
        if (n < -1) {
            throw new IOException("Can't have negative number of buffered rows.");
        }
        if (n == -1) {
            this.fNumBufferRows = n;
            this.reset();
            this.fCurrentWindow = null;
            this.parseCurrentWindow();
        } else if (n < this.fNumBufferRows) {
            for (int i = n; i < this.fNumBufferRows; ++i) {
                RegexTextParser.unreadRow(this.fDataStream, this.fRowRegex, this.fColRegex, this.fQuoteRegex);
                this.fCurrentWindow.remove(this.fCurrentWindow.size() - 1);
            }
        } else if (this.fNumBufferRows == -1) {
            this.fNumBufferRows = n;
            this.fCurrentWindow = null;
            this.parseCurrentWindow();
        } else {
            for (int i = this.fNumBufferRows; i < n; ++i) {
                try {
                    ArrayList<String> arrayList = RegexTextParser.readRow(this.fDataStream, this.fRowRegex, this.fColRegex, this.fQuoteRegex);
                    this.fCurrentWindow.add(arrayList);
                    if (this.fDataStream.getFilePointer() < this.fDataStream.length()) continue;
                }
                catch (EOFException eOFException) {}
                break;
            }
        }
        this.fNumBufferRows = n;
        return this.fCurrentWindow;
    }

    public void reset() throws IOException {
        this.close();
        this.open();
    }

    public void open() throws IOException {
        this.fDataStream = new RandomAccessFile(this.fInputFile, "r");
    }

    public void close() throws IOException {
        if (this.fDataStream != null) {
            this.fDataStream.close();
        }
        this.fDataStream = null;
        this.fCurrentWindow = null;
        this.fRowStack.clear();
    }

    public ArrayList<ArrayList<String>> parseCurrentWindow() throws IOException {
        if (this.fDataStream == null) {
            this.reset();
        }
        if (this.fNumBufferRows == -1) {
            this.fCurrentWindow = this.parseAll();
        }
        if (this.fCurrentWindow == null) {
            this.fCurrentWindow = this.fFixedWidth ? RegexTextParser.parseFixedStream(this.fDataStream, this.fRowRegex, this.getFixedWidthColumnPositions(), this.fNumIgnoreLines, this.fNumBufferRows, this.fRowStack) : RegexTextParser.parseStream(this.fDataStream, this.fRowRegex, this.fColRegex, this.fQuoteRegex, this.fNumIgnoreLines, this.fNumBufferRows, this.fRowStack);
        }
        return this.fCurrentWindow;
    }

    public ArrayList<ArrayList<String>> moveWindow(int n) throws IOException {
        if (this.fDataStream == null) {
            this.reset();
            this.fCurrentWindow = new ArrayList();
        }
        if (n < 0) {
            int n2 = Math.abs(n) + this.fNumBufferRows;
            for (int i = 0; i < n2; ++i) {
                if (this.fRowStack.size() > 0) {
                    this.fDataStream.seek((Long)this.fRowStack.pop());
                    continue;
                }
                ArrayList<String> arrayList = RegexTextParser.unreadRow(this.fDataStream, this.fRowRegex, this.fColRegex, this.fQuoteRegex);
            }
            this.fCurrentWindow = RegexTextParser.parseStream(this.fDataStream, this.fRowRegex, this.fColRegex, this.fQuoteRegex, 0, this.fNumBufferRows, this.fRowStack);
        } else {
            for (int i = 0; i < n; ++i) {
                try {
                    while (this.fCurrentWindow.size() >= this.fNumBufferRows) {
                        this.fCurrentWindow.remove(0);
                        this.fRowStack.removeElementAt(0);
                    }
                    this.fRowStack.add(new Long(this.fDataStream.getFilePointer()));
                    ArrayList<String> arrayList = RegexTextParser.readRow(this.fDataStream, this.fRowRegex, this.fColRegex, this.fQuoteRegex);
                    this.fCurrentWindow.add(arrayList);
                    if (this.fDataStream.getFilePointer() < this.fDataStream.length()) continue;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.fCurrentWindow;
    }

    public ArrayList<ArrayList<String>> parseAll() throws IOException {
        if (this.fFixedWidth) {
            return this.parseAllFixedWidth();
        }
        return RegexTextParser.parseFile(this.fInputFile, this.fRowRegex, this.fColRegex, this.fQuoteRegex, this.fNumIgnoreLines, -1);
    }

    public void setFixedWidthColumnPositions(ArrayList<Integer> arrayList) {
        this.fFixedWidthColumnPositions = arrayList;
    }

    public ArrayList<Integer> getFixedWidthColumnPositions() throws IOException {
        if (this.fFixedWidthColumnPositions != null) {
            return this.fFixedWidthColumnPositions;
        }
        if (this.fFixedWidth) {
            HashMap<String, Integer> hashMap = RegexTextParser.findDelimeters(this.fInputFile, this.fNumBufferRows);
            char c = ' ';
            if (hashMap.containsKey(PATTERN_SPACE)) {
                c = ' ';
            } else if (hashMap.containsKey(".")) {
                c = '.';
            }
            this.fFixedWidthColumnPositions = RegexTextParser.getFixedWidthCharacterPositions(this.fInputFile, this.fRowRegex, c, this.fNumIgnoreLines, this.fNumBufferRows, this.fFixedWidthRowPercentHit, this.fFixedWidthColPercentHit);
        }
        return this.fFixedWidthColumnPositions;
    }

    public void addFixedWidthColumnPosition(int n) throws IOException {
        if (!this.fFixedWidthColumnPositions.contains(new Integer(n))) {
            this.fFixedWidthColumnPositions.add(new Integer(n));
            Collections.sort(this.fFixedWidthColumnPositions, new Comparator(){

                public int compare(Object object, Object object2) {
                    Integer n = (Integer)object;
                    Integer n2 = (Integer)object2;
                    return n - n2;
                }
            });
        }
    }

    public void removeFixedWidthColumnPosition(int n) throws IOException {
        this.fFixedWidthColumnPositions.remove(new Integer(n));
    }

    private ArrayList<ArrayList<String>> parseAllFixedWidth() throws IOException {
        return RegexTextParser.parseFixedFile(this.fInputFile, this.fRowRegex, this.getFixedWidthColumnPositions(), this.fNumIgnoreLines, this.fNumBufferRows);
    }

    public boolean isFixedWidth() {
        return this.fFixedWidth;
    }

    public void setFixedWidth(boolean bl) throws IOException {
        if (bl && this.fFixedWidthColumnPositions == null) {
            this.fFixedWidthColumnPositions = !RegexTextParser.isFixedWidth(this.fInputFile, DEFAULT_CHARACTER_BUFFER_SIZE) ? new ArrayList() : RegexTextParser.getFixedWidthCharacterPositions(this.fInputFile, DEFAULT_CHARACTER_BUFFER_SIZE);
        }
        this.fFixedWidth = bl;
    }

    public double getFixedWidthRowPercentHit() {
        return this.fFixedWidthRowPercentHit;
    }

    public void setFixedWidthRowPercentHit(double d) {
        this.fFixedWidthRowPercentHit = d;
    }

    public double getFixedWidthColPercentHit() {
        return this.fFixedWidthColPercentHit;
    }

    public void setFixedWidthColPercentHit(double d) {
        this.fFixedWidthColPercentHit = d;
    }

    public static ArrayList<ArrayList<String>> parseFile(File file, String string, String string2, String string3, int n) throws IOException {
        return RegexTextParser.parseFile(file, string, string2, string3, n, -1);
    }

    public static ArrayList<ArrayList<String>> parseFile(File file, String string, String string2, String string3, int n, int n2) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        ArrayList<ArrayList<String>> arrayList = RegexTextParser.parseStream(randomAccessFile, string, string2, string3, n, n2, null);
        randomAccessFile.close();
        return arrayList;
    }

    public static ArrayList<ArrayList<String>> parseStream(RandomAccessFile randomAccessFile, String string, String string2, String string3, int n, int n2, Stack stack) throws IOException {
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2 || n2 == -1) {
            ArrayList<String> arrayList2;
            if (stack != null) {
                stack.push(new Long(randomAccessFile.getFilePointer()));
            }
            if ((arrayList2 = RegexTextParser.readRow(randomAccessFile, string, string2, string3)) == null || arrayList2.size() <= 0) break;
            if (++n4 <= n) continue;
            ++n3;
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public static ArrayList<String> readRow(RandomAccessFile randomAccessFile, String string, String string2, String string3) throws IOException {
        Pattern pattern = Pattern.compile(string, 8);
        StringBuilder stringBuilder = new StringBuilder();
        int n = randomAccessFile.read();
        long l = 0L;
        if (n == -1) {
            return null;
        }
        stringBuilder.append((char)n);
        Matcher matcher = pattern.matcher(stringBuilder);
        while (!matcher.matches() && n != -1) {
            n = randomAccessFile.read();
            if (n <= -1) continue;
            stringBuilder.append((char)n);
            matcher = pattern.matcher(stringBuilder);
        }
        while (matcher.matches() && n != -1) {
            l = randomAccessFile.getFilePointer();
            n = randomAccessFile.read();
            if (n <= -1) continue;
            stringBuilder.append((char)n);
            matcher = pattern.matcher(stringBuilder);
        }
        if (n != -1) {
            randomAccessFile.seek(l);
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        ArrayList<String> arrayList = RegexTextParser.extractColumns(string, string2, string3, stringBuilder);
        return arrayList;
    }

    public static ArrayList<String> unreadRow(RandomAccessFile randomAccessFile, String string, String string2, String string3) throws IOException {
        Pattern pattern = Pattern.compile(string, 8);
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        long l = randomAccessFile.getFilePointer();
        if (--l <= 0L) {
            throw new IOException("Already at beginning of file! Can't reverse rows.");
        }
        randomAccessFile.seek(l);
        int n = randomAccessFile.read();
        randomAccessFile.seek(l);
        stringBuilder.append((char)n);
        Matcher matcher = pattern.matcher(stringBuilder);
        while (!matcher.matches() && n != -1 && l > 0L) {
            randomAccessFile.seek(--l);
            n = randomAccessFile.read();
            randomAccessFile.seek(l);
            if (n <= -1) continue;
            stringBuilder.insert(0, (char)n);
            matcher = pattern.matcher(stringBuilder);
        }
        stringBuilder2.append(stringBuilder.toString());
        stringBuilder.setLength(0);
        matcher = pattern.matcher(stringBuilder);
        block1: while (!matcher.matches() && n != -1 && l > 0L) {
            randomAccessFile.seek(--l);
            n = randomAccessFile.read();
            randomAccessFile.seek(l);
            if (n <= -1) continue;
            stringBuilder.insert(0, (char)n);
            matcher = pattern.matcher(stringBuilder);
            for (int i = stringBuilder.length(); i >= 0; --i) {
                String string4 = stringBuilder.substring(0, i);
                if (!pattern.matcher(string4).matches()) continue;
                if (i > 1) {
                    stringBuilder2.insert(0, stringBuilder.substring(i, stringBuilder.length() - 1));
                }
                stringBuilder.setLength(i);
                matcher = pattern.matcher(stringBuilder);
                continue block1;
            }
        }
        if (l > 0L) {
            randomAccessFile.seek(l += (long)stringBuilder.length());
        } else {
            stringBuilder2.insert(0, stringBuilder);
        }
        ArrayList<String> arrayList = RegexTextParser.extractColumns(string, string2, string3, stringBuilder2);
        return arrayList;
    }

    public static ArrayList<String> extractColumns(String string, String string2, String string3, CharSequence charSequence) {
        Pattern pattern = Pattern.compile(string, 8);
        Pattern pattern2 = Pattern.compile(string2, 8);
        Pattern pattern3 = Pattern.compile(string3, 8);
        StringBuilder stringBuilder = new StringBuilder();
        Matcher matcher = pattern.matcher(charSequence);
        if (matcher.find()) {
            if (matcher.group(1) != null) {
                stringBuilder.append(matcher.group(1));
            } else {
                stringBuilder.append(matcher.group());
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher2 = pattern3.matcher(stringBuilder);
        String string4 = "_*_*_COL_PAT_*_*_";
        while (matcher2.find()) {
            if (matcher2.group(1) != null) {
                matcher2.appendReplacement(stringBuffer, matcher2.group(1).replace(string2, string4));
                continue;
            }
            matcher2.appendReplacement(stringBuffer, matcher2.group().replace(string2, string4));
        }
        matcher2.appendTail(stringBuffer);
        String[] stringArray = pattern2.split(stringBuffer);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i].replace(string4, string2));
            }
        }
        return arrayList;
    }

    public static String rowSeparatorToRegex(String string) {
        return RegexTextParser.rowSeparatorToRegex(string, false);
    }

    public static String rowSeparatorToRegex(String string, boolean bl) {
        String string2 = string.replace("\n", PATTERN_NL).replace("\r", PATTERN_CR).replace("\t", PATTERN_TAB);
        return "(." + (bl ? "+" : "*") + ")((" + string2 + ")+)";
    }

    public static String quoteSeparatorToRegex(String string, boolean bl) {
        return RegexTextParser.quoteSeparatorToRegex(string, bl, true);
    }

    public static String quoteSeparatorToRegex(String string, boolean bl, boolean bl2) {
        if (string == null || string.length() == 0) {
            return "()";
        }
        String string2 = string.replace("\n", PATTERN_NL).replace("\r", PATTERN_CR).replace("\t", PATTERN_TAB);
        String string3 = string2 + "(." + (bl2 ? "+" : "*") + "?)" + string2;
        if (bl) {
            string3 = "(" + string2 + "." + (bl2 ? "+" : "*") + "?" + string2 + ")";
        }
        return string3;
    }

    public static String columnSeparatorToRegex(String string) {
        String string2 = string.replace("\n", PATTERN_NL).replace("\r", PATTERN_CR).replace("\t", PATTERN_TAB);
        return string2;
    }

    public static HashMap<String, Integer> findDelimeters(File file, int n) throws IOException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        StringBuilder stringBuilder = RegexTextParser.readPartialFile(file, n);
        Pattern pattern = Pattern.compile(TEST_CRNL_REGEX, 8);
        Pattern pattern2 = Pattern.compile(TEST_CR_REGEX, 8);
        Pattern pattern3 = Pattern.compile(TEST_NL_REGEX, 8);
        Pattern pattern4 = Pattern.compile(TEST_TAB_REGEX, 8);
        Pattern pattern5 = Pattern.compile(TEST_COMMA_REGEX, 8);
        Pattern pattern6 = Pattern.compile(TEST_SPACE_REGEX, 8);
        Pattern pattern7 = Pattern.compile(TEST_SINGLE_QUOTE_REGEX, 8);
        Pattern pattern8 = Pattern.compile(TEST_DOUBLE_QUOTE_REGEX, 8);
        Pattern pattern9 = Pattern.compile(TEST_ANY_SEPARATOR_REGEX, 8);
        boolean bl = RegexTextParser.getMatchCount(hashMap, stringBuilder, pattern, PATTERN_CRNL);
        bl |= RegexTextParser.getMatchCount(hashMap, stringBuilder, pattern2, PATTERN_CR);
        bl |= RegexTextParser.getMatchCount(hashMap, stringBuilder, pattern3, PATTERN_NL);
        boolean bl2 = RegexTextParser.getMatchCount(hashMap, stringBuilder, pattern4, PATTERN_TAB);
        bl2 |= RegexTextParser.getMatchCount(hashMap, stringBuilder, pattern5, PATTERN_COMMA);
        bl2 |= RegexTextParser.getMatchCount(hashMap, stringBuilder, pattern6, PATTERN_SPACE);
        boolean bl3 = RegexTextParser.getMatchCount(hashMap, stringBuilder, pattern7, PATTERN_SINGLE_QUOTE);
        bl3 |= RegexTextParser.getMatchCount(hashMap, stringBuilder, pattern8, PATTERN_DOUBLE_QUOTE);
        Matcher matcher = pattern9.matcher(stringBuilder);
        while (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                if (!hashMap.containsKey(matcher.group(i))) {
                    hashMap.put(matcher.group(i), new Integer(1));
                    continue;
                }
                Integer n2 = hashMap.get(matcher.group(i));
                n2 = n2 + 1;
                hashMap.remove(matcher.group(i));
                hashMap.put(matcher.group(i), n2);
            }
        }
        return hashMap;
    }

    private static boolean getMatchCount(HashMap<String, Integer> hashMap, StringBuilder stringBuilder, Pattern pattern, String string) {
        boolean bl = false;
        Matcher matcher = pattern.matcher(stringBuilder);
        int n = 0;
        boolean bl2 = matcher.find();
        if (bl2) {
            n = 1;
            while (bl2) {
                ++n;
                bl2 = matcher.find();
            }
            hashMap.put(string, new Integer(n));
            bl = true;
        }
        return bl;
    }

    public static ArrayList<Integer> findBlocks(ArrayList<ArrayList<String>> arrayList) {
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        arrayList2.add(new Integer(0));
        for (int i = 1; i < arrayList.size(); ++i) {
            int n;
            int n2 = arrayList.get(i - 1).size();
            if (n2 == (n = arrayList.get(i).size())) continue;
            arrayList2.add(new Integer(i));
        }
        return arrayList2;
    }

    public static boolean isFixedWidth(File file, int n) throws IOException {
        HashMap<String, Integer> hashMap = RegexTextParser.findDelimeters(file, n);
        String string = PATTERN_CRNL;
        if (hashMap.containsKey(PATTERN_CRNL)) {
            string = PATTERN_CRNL;
        } else if (hashMap.containsKey(PATTERN_CR)) {
            string = PATTERN_CR;
        } else if (hashMap.containsKey(PATTERN_NL)) {
            string = PATTERN_NL;
        }
        return RegexTextParser.isFixedWidth(file, n, string);
    }

    public static boolean isFixedWidth(File file, int n, String string) throws IOException {
        boolean bl = false;
        bl = RegexTextParser.getFixedWidthCharacterPositions(file, n) != null;
        return bl;
    }

    public static ArrayList<Integer> getFixedWidthCharacterPositions(File file, int n) throws IOException {
        HashMap<String, Integer> hashMap = RegexTextParser.findDelimeters(file, n > 0 ? n * 80 : -1);
        String string = RegexTextParser.rowSeparatorToRegex("(\r\n)|(\r)|(\n)");
        char c = ' ';
        if (hashMap.containsKey(PATTERN_SPACE)) {
            c = ' ';
        } else if (hashMap.containsKey(".")) {
            c = '.';
        }
        return RegexTextParser.getFixedWidthCharacterPositions(file, string, c, 0, n, 0.75, 0.25);
    }

    public static ArrayList<Integer> getFixedWidthCharacterPositions(File file, String string, char c, int n, int n2, double d, double d2) throws IOException {
        Cloneable cloneable;
        boolean bl = false;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        int n3 = 0;
        ArrayList arrayList2 = new ArrayList();
        if (n2 == -1) {
            while (randomAccessFile.getFilePointer() != randomAccessFile.length()) {
                cloneable = RegexTextParser.readRow(randomAccessFile, string, RegexTextParser.columnSeparatorToRegex("^"), RegexTextParser.quoteSeparatorToRegex("", false));
                if (++n3 <= n) continue;
                arrayList2.add(((ArrayList)cloneable).get(0));
            }
        } else {
            while (n3 < n + n2 && randomAccessFile.getFilePointer() != randomAccessFile.length()) {
                cloneable = RegexTextParser.readRow(randomAccessFile, string, RegexTextParser.columnSeparatorToRegex("$"), RegexTextParser.quoteSeparatorToRegex("", false));
                if (++n3 <= n) continue;
                arrayList2.add(((ArrayList)cloneable).get(0));
            }
        }
        cloneable = new HashMap();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        String string2 = "" + c;
        string2.replace(".", "\\.");
        string2.replace("[", "\\[");
        string2.replace("]", "\\]");
        string2.replace("^", "\\^");
        String string3 = "[^" + c + "][" + string2 + "]";
        Pattern pattern = Pattern.compile(string3);
        for (int i = 0; i < arrayList2.size(); ++i) {
            Integer n4 = new Integer(((String)arrayList2.get(i)).length());
            Integer n5 = new Integer(0);
            if (((HashMap)cloneable).containsKey(n4)) {
                n5 = (Integer)((HashMap)cloneable).get(n4);
                ((HashMap)cloneable).remove(n4);
            }
            n5 = n5 + 1;
            ((HashMap)cloneable).put(n4, n5);
            if ((double)n5.intValue() > (double)arrayList2.size() * d) {
                bl = true;
            }
            Matcher matcher = pattern.matcher((CharSequence)arrayList2.get(i));
            while (matcher.find()) {
                Integer n6 = new Integer(matcher.start() + 1);
                Integer n7 = new Integer(0);
                if (hashMap.containsKey(n6)) {
                    n7 = (Integer)hashMap.get(n6);
                    hashMap.remove(n6);
                }
                n7 = n7 + 1;
                hashMap.put(n6, n7);
                if (!((double)n7.intValue() > (double)arrayList2.size() * d2) || arrayList.contains(n6)) continue;
                arrayList.add(n6);
            }
        }
        if (!bl) {
            return null;
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                Integer n = (Integer)object;
                Integer n2 = (Integer)object2;
                return n - n2;
            }
        });
        return arrayList;
    }

    private static StringBuilder readPartialFile(File file, int n) throws IOException {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        FileReader fileReader = new FileReader(file);
        if (n <= 0) {
            int n2 = fileReader.read();
            while (n2 != -1) {
                stringBuilder.append((char)n2);
                n2 = fileReader.read();
            }
            fileReader.close();
        } else {
            int n3 = fileReader.read();
            for (int i = 0; n3 != -1 && i < n; ++i) {
                stringBuilder.append((char)n3);
                n3 = fileReader.read();
            }
            fileReader.close();
        }
        return stringBuilder;
    }

    public static ArrayList<ArrayList<String>> parseFixedFile(File file, int n, int n2) throws IOException {
        String string = RegexTextParser.rowSeparatorToRegex("(\r\n)|(\r)|(\n)");
        ArrayList<Integer> arrayList = RegexTextParser.getFixedWidthCharacterPositions(file, n2);
        ArrayList<ArrayList<String>> arrayList2 = RegexTextParser.parseFixedFile(file, string, arrayList, n, n2);
        return arrayList2;
    }

    public static ArrayList<ArrayList<String>> parseFixedFile(File file, String string, ArrayList<Integer> arrayList, int n, int n2) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        ArrayList<ArrayList<String>> arrayList2 = RegexTextParser.parseFixedStream(randomAccessFile, string, arrayList, n, n2, null);
        randomAccessFile.close();
        return arrayList2;
    }

    public static ArrayList<ArrayList<String>> parseFixedStream(RandomAccessFile randomAccessFile, String string, ArrayList<Integer> arrayList, int n, int n2, Stack stack) throws IOException {
        ArrayList<ArrayList<String>> arrayList2 = new ArrayList<ArrayList<String>>();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2 || n2 == -1) {
            ArrayList<String> arrayList3;
            if (stack != null) {
                stack.push(new Long(randomAccessFile.getFilePointer()));
            }
            if ((arrayList3 = RegexTextParser.readRow(randomAccessFile, string, RegexTextParser.columnSeparatorToRegex("^"), RegexTextParser.quoteSeparatorToRegex("", false))) == null || arrayList3.size() <= 0) break;
            if (++n4 <= n) continue;
            ++n3;
            if (arrayList3.size() == 1 && arrayList != null && arrayList.size() > 0 && arrayList3.get(0).length() > arrayList.get(0)) {
                String string2 = arrayList3.get(0);
                arrayList3.clear();
                if (arrayList.get(0) != 0) {
                    arrayList3.add(string2.substring(0, arrayList.get(0)));
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    int n5 = arrayList.get(i);
                    int n6 = string2.length();
                    if (i < arrayList.size() - 1 && (n6 = arrayList.get(i + 1).intValue()) >= string2.length()) {
                        n6 = string2.length();
                    }
                    if (n5 > string2.length() || n6 > string2.length()) break;
                    arrayList3.add(string2.substring(n5, n6));
                }
            }
            arrayList2.add(arrayList3);
        }
        return arrayList2;
    }

    public static void main(String[] stringArray) {
        String string = "\\\\infnas-00-ah\\falvarez\\Documents\\current\\datafiles\\";
        String[] stringArray2 = new String[]{"weightLossData.txt", "AlaskaElectricityData.txt", "ERPdata.txt", "ThreeChanData.txt", "autodata2.txt", "datafile.txt", "ImageData.txt"};
        try {
            for (int i = 0; i < stringArray2.length; ++i) {
                System.out.println("**************************************************");
                File file = new File(string + stringArray2[i]);
                boolean bl = RegexTextParser.isFixedWidth(file, -1);
                System.out.println("File " + file.getName() + " is" + (bl ? "" : " not") + " fixed width.");
                if (bl) {
                    int n;
                    RegexTextParser regexTextParser = new RegexTextParser(file, 0, -1);
                    ArrayList<Integer> arrayList = regexTextParser.getFixedWidthColumnPositions();
                    System.out.print("\tColumns: ");
                    for (int j = 0; j < arrayList.size(); ++j) {
                        if (j > 0) {
                            System.out.print(",");
                        }
                        System.out.print(arrayList.get(j));
                    }
                    System.out.println("");
                    ArrayList<ArrayList<String>> arrayList2 = regexTextParser.parseCurrentWindow();
                    int n2 = -1;
                    for (n = 0; n < arrayList2.size(); ++n) {
                        if (arrayList2.get(n).size() <= n2) continue;
                        n2 = arrayList2.get(n).size();
                    }
                    System.out.println("Max Dimensions: " + arrayList2.size() + "x" + n2);
                    System.out.println("******************************");
                    for (n = 0; n < arrayList2.size(); ++n) {
                        for (int j = 0; j < arrayList2.get(n).size(); ++j) {
                            System.out.print("[");
                            System.out.print(arrayList2.get(n).get(j));
                            System.out.print("]");
                        }
                        System.out.println("");
                    }
                    System.out.println("******************************");
                }
                System.out.println("**************************************************");
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }
}

