/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.client.Client;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabException;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.jmi.mdt.MatlabCallable;
import com.mathworks.jmi.mdt.MatlabEventQueue;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.importtool.AbstractFileTableModel;
import com.mathworks.mlwidgets.importtool.ImportClient;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.SpreadsheetImportToolGroup;
import com.mathworks.mlwidgets.importtool.SpreadsheetTabbedPane;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import com.mathworks.mlwidgets.importtool.WorksheetRuleList;
import com.mathworks.mlwidgets.importtool.WorksheetRulePanel;
import com.mathworks.mlwidgets.importtool.WorksheetSelectionListener;
import com.mathworks.mlwidgets.importtool.WorksheetTable;
import com.mathworks.mlwidgets.importtool.WorksheetTableModel;
import com.mathworks.mlwidgets.importtool.WorksheetToolstripTab;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJProgressBar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolstrip.DefaultToolstrip;
import com.mathworks.toolstrip.Toolstrip;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.plaf.TSLookAndFeel;
import com.mathworks.util.Log;
import com.mathworks.widgets.desk.Desktop;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.io.File;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class SpreadsheetImportClient
extends ImportClient {
    private static int WAITBAR_SIZE_THRESHOLD = 1000000;
    private volatile Object fSpreadsheet;
    private MJPanel fTabbedPanePanel;
    private static WaitFrame sWaitFrame;
    static Boolean sBasicMode;

    void setSpreadsheetMCOSObject(Object object) {
        this.fSpreadsheet = object;
    }

    Object getSpreadsheetMCOSObject() {
        return this.fSpreadsheet;
    }

    private SpreadsheetImportClient(File file, String string) {
        super(file, string);
        this.setName("SpreadsheetImportClient");
    }

    public static void open(final String string) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SpreadsheetImportClient.utOpen(string, ImportClient.DEFAULT_DESTINATION_WORKSPACE, ImportClient.getDefaultTargetTypes(), true, SpreadsheetImportToolGroup.DEFAULT_GROUP_NAME);
            }
        });
    }

    public static void open(final String string, final Object object, final ImportClient.TargetType[] targetTypeArray, final boolean bl, final String string2) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SpreadsheetImportClient.utOpen(string, object, targetTypeArray, bl, string2);
            }
        });
    }

    @Override
    protected void reOpen(String string, String string2) {
        SpreadsheetImportClient.utOpen(string, this.getDestinationWorkspace(), this.getTargetTypes(), this.getShowCodeGeneration(), string2);
    }

    @Override
    protected void unregisterFind() {
    }

    @Override
    protected void registerFind() {
    }

    private static void utOpen(final String string, final Object object, final ImportClient.TargetType[] targetTypeArray, final boolean bl, final String string2) {
        SpreadsheetImportClient spreadsheetImportClient;
        assert (targetTypeArray.length >= 0) : "No target types";
        final File file = new File(string);
        final Desktop desktop = MatlabDesktopServices.getDesktop();
        boolean bl2 = desktop.hasGroup(string2);
        if (!bl2) {
            desktop.setGroupDocked(string2, false);
        }
        if (desktop.hasClient(string, string2)) {
            spreadsheetImportClient = (SpreadsheetImportClient)((Object)desktop.getClient(string, string2));
            if (!spreadsheetImportClient.getFile().isFile() || !spreadsheetImportClient.getFile().exists()) {
                MJOptionPane.showMessageDialog((Component)((Object)spreadsheetImportClient), (Object)ImportToolUtils.getResourceString("messages.deletedworkbook"), (String)file.getName(), (int)1);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        desktop.closeClient(string);
                    }
                });
                return;
            }
            if (!spreadsheetImportClient.isLastLoadedFileContentDifferentThanOnDiskFileContent()) {
                desktop.showClient(string);
                return;
            }
            spreadsheetImportClient.setFileHash();
        } else {
            spreadsheetImportClient = null;
        }
        if (file.length() > (long)WAITBAR_SIZE_THRESHOLD) {
            SpreadsheetImportClient.showWaitFrame(desktop);
        }
        MatlabWorker<Object> matlabWorker = new MatlabWorker<Object>(){

            public Object runOnMatlabThread() {
                Object[] objectArray;
                try {
                    Object object2;
                    if (spreadsheetImportClient == null) {
                        object2 = Matlab.mtEval((String)"internal.matlab.importtool.AbstractSpreadsheet.createSpreadsheet", (int)1);
                    } else {
                        object2 = spreadsheetImportClient.getSpreadsheetMCOSObject();
                        Matlab.mtFeval((String)"Reset", (Object[])new Object[]{object2}, (int)0);
                    }
                    if (sBasicMode == null) {
                        boolean[] blArray = (boolean[])Matlab.mtFeval((String)"isa", (Object[])new Object[]{object2, "internal.matlab.importtool.InMemSpreadsheet"}, (int)1);
                        sBasicMode = blArray.length >= 1 && blArray[0];
                    }
                    Matlab.mtFeval((String)"Open", (Object[])new Object[]{object2, string}, (int)0);
                    Matlab.mtFeval((String)"setDstWorkspace", (Object[])new Object[]{object2, object}, (int)0);
                    objectArray = (Object[])Matlab.mtFeval((String)"GetInfo", (Object[])new Object[]{object2}, (int)3);
                    objectArray[0] = object2;
                }
                catch (MatlabException matlabException) {
                    return matlabException;
                }
                catch (Exception exception) {
                    return exception;
                }
                return objectArray;
            }

            public void runOnAWTEventDispatchThread(Object object3) {
                Object object2;
                Object[] objectArray = null;
                if (object3 instanceof MatlabException) {
                    object2 = ImportToolUtils.getResourceString("error.openfailed") + ((MatlabException)((Object)object3)).getLocalizedMessage();
                    MJOptionPane.showMessageDialog((Component)MatlabDesktopServices.getDesktop().getMainFrame(), (Object)object2, (String)ImportToolUtils.getResourceString("error.title"), (int)0);
                    object3 = null;
                } else {
                    if (object3 instanceof Object[]) {
                        objectArray = (Object[])object3;
                    }
                    if (objectArray == null || objectArray.length < 2 || !(objectArray[1] instanceof String[]) || ((String[])objectArray[1]).length == 0) {
                        MJOptionPane.showMessageDialog((Component)MatlabDesktopServices.getDesktop().getMainFrame(), (Object)ImportToolUtils.getResourceString("error.opennonspreadsheet"), (String)ImportToolUtils.getResourceString("error.title"), (int)0);
                        object3 = null;
                    }
                }
                if (object3 == null) {
                    if (sWaitFrame != null) {
                        sWaitFrame.dispose();
                        sWaitFrame = null;
                    }
                    return;
                }
                if (spreadsheetImportClient == null) {
                    object2 = new SpreadsheetImportClient(file, string2);
                    ((SpreadsheetImportClient)((Object)object2)).setSpreadsheetMCOSObject(objectArray[0]);
                    ((ImportClient)((Object)object2)).setTargetTypes(targetTypeArray);
                    ((ImportClient)((Object)object2)).setShowCodeGeneration(bl);
                    ((ImportClient)((Object)object2)).setDestinationWorkspace(object);
                    ((SpreadsheetImportClient)((Object)object2)).build(objectArray[0], string, (String[])objectArray[1], desktop);
                    ((SpreadsheetImportClient)((Object)object2)).setShortTitle(file.getName());
                    ((ImportClient)((Object)object2)).addClient(desktop, string, string2);
                } else {
                    spreadsheetImportClient.setTargetTypes(targetTypeArray);
                    spreadsheetImportClient.setShowCodeGeneration(bl);
                    spreadsheetImportClient.setDestinationWorkspace(object);
                    spreadsheetImportClient.rebuild((String[])objectArray[1]);
                }
            }
        };
        matlabWorker.start();
    }

    private static void showWaitFrame(Desktop desktop) {
        Rectangle rectangle = desktop.getMainFrame().getBounds();
        rectangle = new Rectangle(rectangle.x + rectangle.width / 2 - 100, rectangle.y + rectangle.height / 2 - 25, 200, 50);
        if (sWaitFrame == null) {
            sWaitFrame = new WaitFrame();
        }
        sWaitFrame.setBounds(rectangle);
        sWaitFrame.show();
    }

    public static boolean isBasicMode() {
        return sBasicMode == null ? true : sBasicMode;
    }

    public static void setBasicMode(boolean bl) {
        sBasicMode = bl;
    }

    public void rebuild(String[] stringArray) {
        if (this.fImportComponent != null) {
            ((SpreadsheetTabbedPane)((Object)this.fImportComponent)).rebuild(stringArray);
        }
    }

    private void build(Object object, String string, String[] stringArray, Desktop desktop) {
        Object object3;
        ImportClient.Target[] targetArray;
        ImportClient.TargetType[] targetTypeArray;
        TSLookAndFeel.install();
        this.fImportToolstripTab = new WorksheetToolstripTab(string, this.getShowCodeGeneration());
        if (this.fImportToolstripTab.getShowCodeGeneration()) {
            this.fImportToolstripTab.getFunctionGenerationAction().setEnabled(!SpreadsheetImportClient.isBasicMode());
        }
        if (desktop != null && desktop.useToolstrip()) {
            this.setToolstripTabs(new ToolstripTab[]{this.fImportToolstripTab});
        } else {
            targetTypeArray = new MJPanel((LayoutManager)new BorderLayout());
            targetTypeArray.setFocusCycleRoot(false);
            targetArray = new DefaultToolstrip();
            object3 = targetArray.getModel();
            object3.add((Client)this.fImportToolstripTab);
            targetTypeArray.add((Component)targetArray.getComponent(), (Object)"North");
            targetArray.setCurrentTab("importData");
            targetArray.setAttribute((Attribute)Toolstrip.COLLAPSABLE, (Object)false);
            targetArray.setAttribute((Attribute)Toolstrip.NO_TABS, (Object)true);
            this.add((Component)targetTypeArray, "North");
        }
        targetTypeArray = this.getTargetTypes();
        targetArray = new ImportClient.Target[targetTypeArray.length];
        object3 = this.fImportToolstripTab.getTargetList();
        ((JList)object3).setCellRenderer(new ImportClient.TargetRenderer());
        for (int i = 0; i < targetTypeArray.length; ++i) {
            targetArray[i] = new ImportClient.Target(targetTypeArray[i]);
            ((DefaultListModel)((JList)object3).getModel()).add(i, targetArray[i]);
        }
        final WorksheetRuleList worksheetRuleList = this.fImportToolstripTab.getWorksheetRuleList();
        for (WorksheetRule object22 : targetArray[0].getWorksheetRules()) {
            worksheetRuleList.addWorksheetRulePanel(new WorksheetRulePanel(worksheetRuleList, object22, SpreadsheetImportClient.getRulePrototypes()));
        }
        final SpreadsheetTabbedPane spreadsheetTabbedPane = new SpreadsheetTabbedPane(object, string, stringArray, worksheetRuleList.getRules(), targetTypeArray[0]);
        this.fImportToolstripTab.setImporter(spreadsheetTabbedPane);
        spreadsheetTabbedPane.addWorksheetSelectionListener(this.fImportToolstripTab.getRangeEditBox());
        this.fImportToolstripTab.getRangeEditBox().addWorksheetSelectionListener(spreadsheetTabbedPane);
        spreadsheetTabbedPane.addWorksheetSelectionListener(new WorksheetSelectionListener((JList)object3){
            final /* synthetic */ JList val$targetList;
            {
                this.val$targetList = jList;
            }

            @Override
            public void selectedDataChanged(String string) {
                boolean bl = spreadsheetTabbedPane.isImportableData();
                SpreadsheetImportClient.this.fImportToolstripTab.setImportButtonEnabled(bl);
                SpreadsheetImportClient.this.fImportToolstripTab.getTargetList().setEnabled(true);
                WorksheetTable worksheetTable = ((SpreadsheetTabbedPane)((Object)SpreadsheetImportClient.this.fImportComponent)).getCurrentTabContentPanel().getWorksheetTable();
                worksheetTable.setImportContextMenuEnabled(bl);
                if (this.val$targetList.getSelectedValue() instanceof ImportClient.Target && !((ImportClient.Target)this.val$targetList.getSelectedValue()).getTargetType().isCellArray()) {
                    SpreadsheetImportClient.this.fImportToolstripTab.setPromptLabelText(ImportToolUtils.getResourceString("ruletooltip.addruleunimportable"));
                } else {
                    SpreadsheetImportClient.this.fImportToolstripTab.setPromptLabelText(ImportToolUtils.getResourceString("ruletooltip.addruleempty"));
                }
                SpreadsheetImportClient.this.fImportToolstripTab.getWorksheetRuleList().setColumnExcludeRulesTransparent(!worksheetTable.allowColumnExcludeRuleEvaluation());
                SpreadsheetImportClient.this.fImportToolstripTab.updateUnimportableSection();
            }

            @Override
            public void selectedDataChanged(String string, boolean bl) {
                this.selectedDataChanged(string);
            }

            @Override
            public void temporarySelectionDataChanged(String string) {
            }
        });
        this.fImportToolstripTab.getTargetList().setSelectedIndex(0);
        this.fImportToolstripTab.getTargetList().addListSelectionListener(new ListSelectionListener((JList)object3, spreadsheetTabbedPane){
            private int iLastSelection = -1;
            final /* synthetic */ JList val$targetList;
            final /* synthetic */ SpreadsheetTabbedPane val$tabbedPane;
            {
                this.val$targetList = jList;
                this.val$tabbedPane = spreadsheetTabbedPane;
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ImportClient.Target target;
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (this.iLastSelection >= 0) {
                    target = (ImportClient.Target)((DefaultListModel)SpreadsheetImportClient.this.fImportToolstripTab.getTargetList().getModel()).get(this.iLastSelection);
                    target.setWorksheetRules(worksheetRuleList.getRules());
                    worksheetRuleList.removeAllWorksheetRulePanels();
                }
                this.iLastSelection = this.val$targetList.getSelectedIndex();
                target = (ImportClient.Target)((DefaultListModel)SpreadsheetImportClient.this.fImportToolstripTab.getTargetList().getModel()).get(this.iLastSelection);
                worksheetRuleList.setWorksheetRuleList(target.getWorksheetRules(), SpreadsheetImportClient.getRulePrototypes());
                this.val$tabbedPane.setTargetType(target.getTargetType());
                SpreadsheetImportClient.this.fImportToolstripTab.getHeaderSpinner().setEnabled(target.getTargetType().usesColumnNames());
                worksheetRuleList.fireWorksheetRuleChanged();
            }
        });
        this.fImportComponent = spreadsheetTabbedPane;
        this.fTabbedPanePanel = new MJPanel((LayoutManager)new BorderLayout());
        this.fTabbedPanePanel.add((Component)this.fImportComponent, (Object)"Center");
        this.add((Component)this.fTabbedPanePanel, "Center");
        this.fImportToolstripTab.getWorksheetRuleList().addWorksheetRuleListener(spreadsheetTabbedPane);
        this.addHeaderRowListener((JSpinner)this.fImportToolstripTab.getHeaderSpinner(), (SpreadsheetTabbedPane)((Object)this.fImportComponent));
        final WorksheetTable worksheetTable = ((SpreadsheetTabbedPane)((Object)this.fImportComponent)).getWorksheetTableAtIndex(0);
        if (worksheetTable != null) {
            worksheetTable.getWorksheetTableModel().addWorksheetCachedDataListener(new AbstractFileTableModel.WorksheetCachedDataListener(){

                @Override
                public void worksheetCachedDataChanged(EventObject eventObject) {
                    final WorksheetTableModel worksheetTableModel = (WorksheetTableModel)eventObject.getSource();
                    List<WorksheetRule> list = worksheetTableModel.getDefaultWorksheetRuleList();
                    ImportClient.TargetType[] targetTypeArray = SpreadsheetImportClient.this.getTargetTypes();
                    for (int i = 0; i < targetArray.length; ++i) {
                        if (targetTypeArray[i].isCellArray()) continue;
                        targetArray[i].setWorksheetRules(list);
                    }
                    worksheetRuleList.setWorksheetRuleList(list, SpreadsheetImportClient.getRulePrototypes());
                    worksheetRuleList.fireWorksheetRuleChanged();
                    worksheetTableModel.removeWorksheetCachedDataListener(this);
                    worksheetTable.getWorksheetTableModel().addWorksheetCachedDataListener(new AbstractFileTableModel.WorksheetCachedDataListener(){

                        @Override
                        public void worksheetCachedDataChanged(EventObject eventObject) {
                            worksheetTable.setInitialSelection();
                            worksheetTableModel.removeWorksheetCachedDataListener(this);
                            SpreadsheetImportClient.closeWaitFrame();
                        }
                    });
                }
            });
        }
        if (desktop != null) {
            ((SpreadsheetTabbedPane)((Object)this.fImportComponent)).addSpreadsheetTabSelectionListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    SpreadsheetImportClient.this.setMenuBar((JMenuBar)((Object)new ImportClient.ImportToolMenuBar(((SpreadsheetTabbedPane)((Object)SpreadsheetImportClient.this.fImportComponent)).getCurrentTabContentPanel().getWorksheetTable())));
                    SpreadsheetImportClient.this.resetRowheaderSpinnerForCurrentTab();
                }
            });
            this.setMenuBar((JMenuBar)((Object)new ImportClient.ImportToolMenuBar(worksheetTable)));
        }
        this.resetRowheaderSpinnerForCurrentTab();
    }

    private static void closeWaitFrame() {
        if (sWaitFrame != null && sWaitFrame.isShowing()) {
            sWaitFrame.dispose();
            sWaitFrame = null;
        }
    }

    static List<WorksheetRule> getRulePrototypes() {
        return ImportClient.getRulePrototypes();
    }

    private void resetRowheaderSpinnerForCurrentTab() {
        final WorksheetTableModel worksheetTableModel = (WorksheetTableModel)((SpreadsheetTabbedPane)((Object)this.fImportComponent)).getCurrentTabContentPanel().getWorksheetTable().getWorksheetTableModel();
        if (worksheetTableModel.getRowCount() > 0) {
            this.setHeaderRowSpinnerDefaultValue((JSpinner)this.fImportToolstripTab.getHeaderSpinner(), worksheetTableModel.getTopHeaderRow(), worksheetTableModel.getRowCount());
        } else {
            worksheetTableModel.addWorksheetCachedDataListener(new AbstractFileTableModel.WorksheetCachedDataListener(){

                @Override
                public void worksheetCachedDataChanged(EventObject eventObject) {
                    if (SpreadsheetImportClient.this.fImportToolstripTab != null) {
                        SpreadsheetImportClient.this.setHeaderRowSpinnerDefaultValue((JSpinner)SpreadsheetImportClient.this.fImportToolstripTab.getHeaderSpinner(), worksheetTableModel.getTopHeaderRow(), worksheetTableModel.getRowCount());
                    }
                    worksheetTableModel.removeWorksheetCachedDataListener(this);
                }
            });
        }
    }

    @Override
    public void cleanup(boolean bl) {
        SpreadsheetImportClient.closeWaitFrame();
        if (Matlab.isMatlabAvailable()) {
            if (bl) {
                Future future = MatlabEventQueue.invoke((MatlabCallable)new MatlabCallable<Object>(){

                    public void callOnEdt(Object object, boolean bl) {
                    }

                    public Object call() {
                        try {
                            boolean[] blArray = (boolean[])Matlab.mtFeval((String)"isvalid", (Object[])new Object[]{SpreadsheetImportClient.this.fSpreadsheet}, (int)1);
                            if (blArray != null && blArray.length >= 1 && blArray[0]) {
                                Matlab.mtFeval((String)"delete", (Object[])new Object[]{SpreadsheetImportClient.this.fSpreadsheet}, (int)0);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }
                });
                try {
                    future.get(500L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.fSpreadsheet = null;
            } else {
                MatlabWorker matlabWorker = new MatlabWorker(){

                    public Object runOnMatlabThread() {
                        try {
                            boolean[] blArray = (boolean[])Matlab.mtFeval((String)"isvalid", (Object[])new Object[]{SpreadsheetImportClient.this.fSpreadsheet}, (int)1);
                            if (blArray != null && blArray.length >= 1 && blArray[0]) {
                                Matlab.mtFeval((String)"delete", (Object[])new Object[]{SpreadsheetImportClient.this.fSpreadsheet}, (int)0);
                            }
                        }
                        catch (Exception exception) {
                            Log.log((String)exception.toString());
                        }
                        SpreadsheetImportClient.this.fSpreadsheet = null;
                        return null;
                    }

                    public void runOnAWTEventDispatchThread(Object object) {
                    }
                };
                matlabWorker.start();
            }
        }
        if (this.fImportComponent != null) {
            ((SpreadsheetTabbedPane)((Object)this.fImportComponent)).cleanup();
            this.fImportComponent = null;
        }
        this.cleanupToolstrip();
        this.setParentDesktop(null);
    }

    static {
        sBasicMode = null;
    }

    private static class WaitFrame
    extends MJFrame {
        private WaitFrame() {
            this.setUndecorated(true);
            this.setAlwaysOnTop(true);
            MJProgressBar mJProgressBar = new MJProgressBar(0, 100);
            if (MJUtilities.isHighContrast()) {
                mJProgressBar.setBorder(BorderFactory.createLineBorder(Color.white, 3));
            } else {
                mJProgressBar.setBorder(BorderFactory.createLineBorder(Color.black, 3));
            }
            mJProgressBar.setStringPainted(true);
            mJProgressBar.setString(ImportToolUtils.getResourceString("spreadsheetimport.wait"));
            mJProgressBar.setIndeterminate(true);
            this.getContentPane().add((Component)mJProgressBar);
        }
    }
}

