/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.WorksheetRule;
import com.mathworks.mlwidgets.importtool.WorksheetRuleListener;
import com.mathworks.mlwidgets.importtool.WorksheetRulePanel;
import com.mathworks.mwswing.MJPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

class WorksheetRuleList
extends MJPanel {
    private List<WorksheetRulePanel> fWorksheetRulePanels = new ArrayList<WorksheetRulePanel>();
    private List<WorksheetRuleListener> fWorksheetRuleListeners = new ArrayList<WorksheetRuleListener>();
    private WorksheetRulePanel.PromptPanel fPromptPanel;

    void addWorksheetRuleListener(WorksheetRuleListener worksheetRuleListener) {
        this.fWorksheetRuleListeners.remove(worksheetRuleListener);
        this.fWorksheetRuleListeners.add(worksheetRuleListener);
    }

    void removeWorksheetRuleListener(WorksheetRuleListener worksheetRuleListener) {
        this.fWorksheetRuleListeners.remove(worksheetRuleListener);
    }

    WorksheetRuleList() {
        super((LayoutManager)new ListLayout());
        this.setName("WorksheetRuleList");
        this.setAutoscrolls(true);
    }

    void setWorksheetRuleList(List<WorksheetRule> list, List<WorksheetRule> list2) {
        this.removeAllWorksheetRulePanels();
        for (WorksheetRule worksheetRule : list) {
            this.addWorksheetRulePanel(new WorksheetRulePanel(this, worksheetRule, list2));
        }
        if (list.isEmpty()) {
            if (this.fPromptPanel == null) {
                this.createPromptPanel(null, list2);
            }
            this.add((Component)((Object)this.fPromptPanel));
        } else if (this.fPromptPanel == null) {
            this.createPromptPanel(this.fWorksheetRulePanels.get(0), list2);
        }
        this.revalidate();
        this.repaint();
    }

    void setColumnExcludeRulesTransparent(boolean bl) {
        if (this.fWorksheetRulePanels == null) {
            return;
        }
        for (WorksheetRulePanel worksheetRulePanel : this.fWorksheetRulePanels) {
            worksheetRulePanel.setColumnExcludeRulesTransparent(bl);
        }
    }

    void removeWorksheetRulePanelWithPrompt(WorksheetRulePanel worksheetRulePanel) {
        this.removeWorksheetRulePanel(worksheetRulePanel);
        if (this.fWorksheetRulePanels.size() == 0) {
            this.add((Component)((Object)this.fPromptPanel));
        }
        this.revalidate();
        this.repaint();
    }

    void setPromptLabelText(String string) {
        if (this.fPromptPanel != null) {
            this.fPromptPanel.setPromptLabelText(string);
        }
        this.revalidate();
        this.repaint();
    }

    void removeAllWorksheetRulePanelsWithPrompt() {
        this.removeAllWorksheetRulePanels();
        this.add((Component)((Object)this.fPromptPanel));
        this.revalidate();
        this.repaint();
    }

    void commit() {
        for (WorksheetRulePanel worksheetRulePanel : this.fWorksheetRulePanels) {
            worksheetRulePanel.commit();
        }
    }

    void synchronizePreferredSizes() {
        int n = 0;
        for (WorksheetRulePanel worksheetRulePanel : this.fWorksheetRulePanels) {
            n = n < worksheetRulePanel.getRuleTargetCombo().getPreferredSize().width ? worksheetRulePanel.getRuleTargetCombo().getPreferredSize().width : n;
        }
        for (WorksheetRulePanel worksheetRulePanel : this.fWorksheetRulePanels) {
            worksheetRulePanel.getRuleTargetCombo().setPreferredSize(new Dimension(n, worksheetRulePanel.getRuleTargetCombo().getPreferredSize().height));
            worksheetRulePanel.getRuleTargetCombo().invalidate();
        }
    }

    void addWorksheetRulePanel(WorksheetRulePanel worksheetRulePanel) {
        this.add((Component)((Object)worksheetRulePanel));
        this.fWorksheetRulePanels.add(worksheetRulePanel);
        this.synchronizePreferredSizes();
        int n = 1;
        for (WorksheetRulePanel worksheetRulePanel2 : this.fWorksheetRulePanels) {
            worksheetRulePanel2.setName("WorksheetRulePanel" + Integer.toString(n));
            ++n;
        }
        this.revalidate();
        this.repaint();
    }

    void moveWorksheetRulePanel(WorksheetRulePanel worksheetRulePanel, int n) {
        int n2 = -1;
        for (int i = 0; i < this.fWorksheetRulePanels.size(); ++i) {
            if (this.fWorksheetRulePanels.get(i) != worksheetRulePanel) continue;
            n2 = i;
            break;
        }
        if (n == n2 || n == n2 + 1) {
            return;
        }
        int n3 = n > n2 ? n - 1 : n;
        this.removeWorksheetRulePanel(worksheetRulePanel);
        this.add((Component)((Object)worksheetRulePanel), n3);
        this.fWorksheetRulePanels.add(n3, worksheetRulePanel);
        this.fireWorksheetRuleChanged();
        this.revalidate();
        this.repaint();
    }

    private void createPromptPanel(WorksheetRulePanel worksheetRulePanel, List<WorksheetRule> list) {
        this.fPromptPanel = new WorksheetRulePanel.PromptPanel(this, list);
        if (worksheetRulePanel != null) {
            this.fPromptPanel.setMinimumSize(worksheetRulePanel.getPreferredSize());
            this.fPromptPanel.getPlusButton().setPreferredSize(new Dimension(worksheetRulePanel.getPreferredSize().height, worksheetRulePanel.getPreferredSize().height));
        }
    }

    void removeWorksheetRulePanel(WorksheetRulePanel worksheetRulePanel) {
        if (this.fPromptPanel == null && worksheetRulePanel != null) {
            this.createPromptPanel(worksheetRulePanel, worksheetRulePanel.getRulePrototypes());
        }
        this.remove((Component)((Object)worksheetRulePanel));
        this.fWorksheetRulePanels.remove(worksheetRulePanel);
        this.revalidate();
        this.repaint();
    }

    void removeAllWorksheetRulePanels() {
        if (this.fPromptPanel == null && !this.fWorksheetRulePanels.isEmpty()) {
            this.createPromptPanel(this.fWorksheetRulePanels.get(0), this.fWorksheetRulePanels.get(0).getRulePrototypes());
        }
        this.removeAll();
        this.fWorksheetRulePanels.clear();
        this.revalidate();
        this.repaint();
    }

    int getWorksheetRulePanelCount() {
        return this.fWorksheetRulePanels.size();
    }

    int getHoverWorksheetRulePanelEdge(Point point) {
        if (this.fWorksheetRulePanels == null || this.fWorksheetRulePanels.isEmpty()) {
            return -1;
        }
        if (this.fWorksheetRulePanels.get((int)0).getBounds().y + this.fWorksheetRulePanels.get((int)0).getBounds().height / 2 > point.y) {
            return 0;
        }
        for (int i = 1; i < this.fWorksheetRulePanels.size(); ++i) {
            if (this.fWorksheetRulePanels.get((int)i).getBounds().y + this.fWorksheetRulePanels.get((int)i).getBounds().height / 2 <= point.y) continue;
            return i;
        }
        return this.fWorksheetRulePanels.size();
    }

    void scrollEdgeToVisible(int n) {
        if (this.fWorksheetRulePanels == null || this.fWorksheetRulePanels.isEmpty() || n < 0) {
            return;
        }
        if (n < this.fWorksheetRulePanels.size()) {
            Rectangle rectangle = this.fWorksheetRulePanels.get(n).getBounds();
            this.scrollRectToVisible(new Rectangle(rectangle.x, rectangle.y, 1, 1));
            return;
        }
        Rectangle rectangle = this.fWorksheetRulePanels.get(this.fWorksheetRulePanels.size() - 1).getBounds();
        this.scrollRectToVisible(new Rectangle(rectangle.x, rectangle.y + rectangle.height, 1, 1));
    }

    void setHighlightedEdge(int n) {
        for (WorksheetRulePanel worksheetRulePanel : this.fWorksheetRulePanels) {
            worksheetRulePanel.setHighlightedEdge(WorksheetRulePanel.HighlightedEdge.NONE);
        }
        if (this.fWorksheetRulePanels == null || this.fWorksheetRulePanels.isEmpty() || n < 0) {
            return;
        }
        if (n == 0) {
            this.fWorksheetRulePanels.get(0).setHighlightedEdge(WorksheetRulePanel.HighlightedEdge.UPPER);
        } else if (n < this.fWorksheetRulePanels.size()) {
            this.fWorksheetRulePanels.get(n - 1).setHighlightedEdge(WorksheetRulePanel.HighlightedEdge.LOWER);
        } else if (n == this.fWorksheetRulePanels.size()) {
            this.fWorksheetRulePanels.get(n - 1).setHighlightedEdge(WorksheetRulePanel.HighlightedEdge.LOWER);
        }
    }

    void fireWorksheetRuleChanged() {
        ArrayList<WorksheetRuleListener> arrayList = new ArrayList<WorksheetRuleListener>(this.fWorksheetRuleListeners);
        for (WorksheetRuleListener worksheetRuleListener : arrayList) {
            worksheetRuleListener.ruleChanged(this.getRules());
        }
    }

    List<WorksheetRule> getRules() {
        ArrayList<WorksheetRule> arrayList = new ArrayList<WorksheetRule>();
        for (WorksheetRulePanel worksheetRulePanel : this.fWorksheetRulePanels) {
            WorksheetRule worksheetRule = worksheetRulePanel.getWorksheetRule();
            if (worksheetRule == null) continue;
            arrayList.add(worksheetRule);
        }
        return arrayList;
    }

    static class ListLayout
    implements LayoutManager {
        ListLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void layoutContainer(Container container) {
            int n = 0;
            for (Component component : container.getComponents()) {
                component.setBounds(0, n, container.getWidth(), component.getPreferredSize().height);
                n += component.getPreferredSize().height;
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            for (Component component : container.getComponents()) {
                n3 = n3 < component.getMinimumSize().height ? component.getMinimumSize().height : n3;
                n += component.getMinimumSize().height;
                n2 = n2 < component.getMinimumSize().width ? component.getMinimumSize().width : n2;
            }
            n = n < 3 * n3 ? 3 * n3 : n;
            return new Dimension(n2, n);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = this.minimumLayoutSize(container);
            int n = 0;
            int n2 = dimension.width;
            int n3 = 0;
            for (Component component : container.getComponents()) {
                n3 = n3 < component.getPreferredSize().height ? component.getPreferredSize().height : n3;
                n += component.getPreferredSize().height;
                n2 = n2 < component.getPreferredSize().width ? component.getPreferredSize().width : n2;
            }
            n = n < 3 * n3 ? 3 * n3 : n;
            n = n < dimension.height ? dimension.height : n;
            return new Dimension(n2, n);
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }
    }
}

