/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.inspector.celleditors.color;

import com.jidesoft.combobox.ColorChooserPanel;
import com.jidesoft.swing.JideButton;
import com.mathworks.util.StyledColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import org.apache.commons.lang.StringUtils;

class MLColorChooserPanel
extends ColorChooserPanel {
    private static final List<String> tmpStylesList = new ArrayList<String>();
    private List<String> allowedStyles;

    MLColorChooserPanel(int n, boolean bl, boolean bl2) {
        super(n, bl, bl2);
    }

    static synchronized ColorChooserPanel newInstance(int n, boolean bl, List<String> list) {
        if (list != null) {
            tmpStylesList.addAll(list);
        }
        MLColorChooserPanel mLColorChooserPanel = new MLColorChooserPanel(n, bl, false);
        tmpStylesList.clear();
        return mLColorChooserPanel;
    }

    protected void initComponent() {
        super.initComponent();
        if (tmpStylesList.isEmpty()) {
            return;
        }
        this.allowedStyles = new ArrayList<String>(tmpStylesList);
        assert (this._defaultColor == null);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(this.allowedStyles.size(), 1));
        jPanel.setOpaque(false);
        SelectStyleAction selectStyleAction = new SelectStyleAction();
        for (String string : this.allowedStyles) {
            JideButton jideButton = new JideButton((Action)selectStyleAction);
            jideButton.setAction((Action)selectStyleAction);
            jideButton.setText(string);
            jideButton.setActionCommand(string);
            jideButton.setMargin(new Insets(2, jideButton.getMargin().left, 2, jideButton.getMargin().right));
            jideButton.setHorizontalAlignment(10);
            jPanel.add((Component)jideButton);
        }
        this.add(jPanel, "First");
    }

    public void setSelectedColor(Color color) {
        if (color == null || this.allowedStyles == null) {
            super.setSelectedColor(color);
            return;
        }
        float[] fArray = color.getRGBColorComponents(null);
        super.setSelectedColor((Color)new StyledColor((double)fArray[0], (double)fArray[1], (double)fArray[2], this.allowedStyles));
    }

    private final class SelectStyleAction
    extends AbstractAction {
        private SelectStyleAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            assert (StringUtils.isNotBlank((String)string));
            MLColorChooserPanel.super.setSelectedColor((Color)new StyledColor(string, MLColorChooserPanel.this.allowedStyles));
        }
    }
}

